SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;


DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE IF NOT EXISTS `#__assets` (
`id` int(10) unsigned NOT NULL COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.'
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=242 ;

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 0, 353, 0, 'root.1', 'Root Asset', '{"core.login.site":{"6":1,"2":1},"core.login.admin":{"6":1},"core.login.offline":{"6":1},"core.admin":{"8":1},"core.manage":{"7":1},"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(2, 1, 1, 2, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 3, 6, 1, 'com_banners', 'com_banners', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(4, 1, 7, 8, 1, 'com_cache', 'com_cache', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(5, 1, 9, 10, 1, 'com_checkin', 'com_checkin', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(6, 1, 11, 12, 1, 'com_config', 'com_config', '{}'),
(7, 1, 13, 18, 1, 'com_contact', 'com_contact', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(8, 1, 19, 96, 1, 'com_content', 'com_content', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(9, 1, 97, 98, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 99, 100, 1, 'com_installer', 'com_installer', '{"core.admin":[],"core.manage":{"7":0},"core.delete":{"7":0},"core.edit.state":{"7":0}}'),
(11, 1, 101, 102, 1, 'com_languages', 'com_languages', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(12, 1, 103, 104, 1, 'com_login', 'com_login', '{}'),
(13, 1, 105, 106, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 107, 108, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 109, 110, 1, 'com_media', 'com_media', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":{"5":1}}'),
(16, 1, 111, 112, 1, 'com_menus', 'com_menus', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(17, 1, 113, 114, 1, 'com_messages', 'com_messages', '{"core.admin":{"7":1},"core.manage":{"7":1}}'),
(18, 1, 115, 260, 1, 'com_modules', 'com_modules', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(19, 1, 261, 264, 1, 'com_newsfeeds', 'com_newsfeeds', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(20, 1, 265, 266, 1, 'com_plugins', 'com_plugins', '{"core.admin":{"7":1},"core.manage":[],"core.edit":[],"core.edit.state":[]}'),
(21, 1, 267, 268, 1, 'com_redirect', 'com_redirect', '{"core.admin":{"7":1},"core.manage":[]}'),
(22, 1, 269, 270, 1, 'com_search', 'com_search', '{"core.admin":{"7":1},"core.manage":{"6":1}}'),
(23, 1, 271, 272, 1, 'com_templates', 'com_templates', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(24, 1, 273, 276, 1, 'com_users', 'com_users', '{"core.admin":{"7":1},"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(25, 1, 277, 280, 1, 'com_weblinks', 'com_weblinks', '{"core.admin":{"7":1},"core.manage":{"6":1},"core.create":{"3":1},"core.delete":[],"core.edit":{"4":1},"core.edit.state":{"5":1},"core.edit.own":[]}'),
(26, 1, 281, 282, 1, 'com_wrapper', 'com_wrapper', '{}'),
(27, 8, 20, 31, 2, 'com_content.category.2', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(28, 3, 4, 5, 2, 'com_banners.category.3', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(29, 7, 14, 15, 2, 'com_contact.category.4', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(30, 19, 262, 263, 2, 'com_newsfeeds.category.5', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(31, 25, 278, 279, 2, 'com_weblinks.category.6', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(32, 24, 274, 275, 1, 'com_users.category.7', 'Uncategorised', '{"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(33, 1, 283, 284, 1, 'com_finder', 'com_finder', '{"core.admin":{"7":1},"core.manage":{"6":1}}'),
(34, 1, 285, 286, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{"core.admin":[],"core.manage":[],"core.delete":[],"core.edit.state":[]}'),
(35, 1, 287, 288, 1, 'com_tags', 'com_tags', '{"core.admin":[],"core.manage":[],"core.manage":[],"core.delete":[],"core.edit.state":[]}'),
(36, 1, 289, 290, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(37, 1, 291, 292, 1, 'com_ajax', 'com_ajax', '{}'),
(38, 1, 293, 294, 1, 'com_postinstall', 'com_postinstall', '{}'),
(40, 18, 116, 117, 2, 'com_modules.module.2', 'Login', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(41, 18, 118, 119, 2, 'com_modules.module.3', 'Popular Articles', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(42, 18, 120, 121, 2, 'com_modules.module.4', 'Recently Added Articles', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(43, 18, 122, 123, 2, 'com_modules.module.8', 'Toolbar', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(44, 18, 124, 125, 2, 'com_modules.module.9', 'Quick Icons', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(45, 18, 126, 127, 2, 'com_modules.module.10', 'Logged-in Users', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(46, 18, 128, 129, 2, 'com_modules.module.12', 'Admin Menu', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(47, 18, 130, 131, 2, 'com_modules.module.13', 'Admin Submenu', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(48, 18, 132, 133, 2, 'com_modules.module.14', 'User Status', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(49, 18, 134, 135, 2, 'com_modules.module.15', 'Title', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(52, 18, 136, 137, 2, 'com_modules.module.79', 'Multilanguage status', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(53, 18, 138, 139, 2, 'com_modules.module.86', 'Joomla Version', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(54, 1, 295, 296, 1, 'com_k2', 'com_k2', '{"core.admin":[],"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(60, 18, 140, 141, 2, 'com_modules.module.92', 'K2 Quick Icons (admin)', ''),
(61, 18, 142, 143, 2, 'com_modules.module.93', 'K2 Stats (admin)', ''),
(62, 8, 32, 81, 2, 'com_content.category.8', 'Articles', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(63, 62, 33, 46, 3, 'com_content.category.9', 'Commercial Services', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(64, 62, 47, 56, 3, 'com_content.category.10', 'Audio Solutions', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(65, 8, 82, 85, 2, 'com_content.category.11', 'FAQ', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(66, 63, 34, 35, 4, 'com_content.article.1', 'The Breathing Commercial', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(67, 63, 36, 37, 4, 'com_content.article.2', 'Make Your Red Background Work Better', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(68, 63, 38, 39, 4, 'com_content.article.3', 'Eastern Reverence', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(69, 63, 40, 41, 4, 'com_content.article.4', 'City Photography and Direction', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(70, 65, 83, 84, 3, 'com_content.article.5', 'FAQ', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(71, 27, 21, 22, 3, 'com_content.article.6', 'About us', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(72, 27, 23, 24, 3, 'com_content.article.7', 'Page Breaks', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(73, 75, 89, 90, 3, 'com_content.article.8', 'Typography', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(74, 75, 91, 92, 3, 'com_content.article.9', 'Module variations', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(75, 8, 86, 95, 2, 'com_content.category.12', 'Explore', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(76, 75, 87, 88, 3, 'com_content.category.13', 'Template themes', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(77, 75, 93, 94, 3, 'com_content.article.10', 'Module positions', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(78, 7, 16, 17, 2, 'com_contact.category.14', 'Contacts category I', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(79, 27, 25, 26, 3, 'com_content.article.11', 'Archived Article I', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(80, 27, 27, 28, 3, 'com_content.article.12', 'Archived Article II', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(81, 27, 29, 30, 3, 'com_content.article.13', 'Archived Article III', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(82, 18, 144, 145, 2, 'com_modules.module.94', 'Off Canvas Menu', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(89, 64, 48, 49, 4, 'com_content.article.20', 'Colors and Melodies', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(90, 64, 50, 51, 4, 'com_content.article.21', 'A Modern Sound Approach', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(91, 18, 146, 147, 2, 'com_modules.module.95', 'Latest Articles', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(92, 18, 148, 149, 2, 'com_modules.module.96', 'Copyright', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(93, 18, 150, 151, 2, 'com_modules.module.97', 'Our Services', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(94, 18, 152, 153, 2, 'com_modules.module.98', 'About us', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(95, 18, 154, 155, 2, 'com_modules.module.99', 'Cameras', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(96, 18, 156, 157, 2, 'com_modules.module.100', 'Interviews', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(99, 18, 158, 159, 2, 'com_modules.module.103', 'Responsive Scroller position-1', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(100, 18, 160, 161, 2, 'com_modules.module.104', 'Responsive Scroller position-8', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(101, 18, 162, 163, 2, 'com_modules.module.105', 'Computing position-14', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(102, 18, 164, 165, 2, 'com_modules.module.106', 'Responsive Scroller position-13 2', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(115, 18, 166, 167, 2, 'com_modules.module.119', 'Login', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(116, 18, 168, 169, 2, 'com_modules.module.120', 'Search', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(117, 18, 170, 171, 2, 'com_modules.module.121', 'Categories', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(118, 18, 172, 173, 2, 'com_modules.module.122', 'Tags', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(119, 18, 174, 175, 2, 'com_modules.module.123', 'Latest Comments', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(121, 18, 176, 177, 2, 'com_modules.module.124', 'Minitek Wall', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(122, 1, 297, 298, 1, 'com_minitekwall.instance.34', 'Frontpage Main Slider', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(123, 1, 299, 300, 1, '#__minitek_wall_modules.9', '#__minitek_wall_modules.9', ''),
(124, 1, 301, 302, 1, 'com_minitekwall.instance.35', 'Computing', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(125, 1, 303, 304, 1, 'com_minitekwall.instance.36', 'Mobile', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(126, 1, 305, 306, 1, '#__minitek_wall_modules.10', '#__minitek_wall_modules.10', ''),
(127, 1, 307, 308, 1, '#__minitek_wall_modules.11', '#__minitek_wall_modules.11', ''),
(128, 18, 178, 179, 2, 'com_modules.module.125', 'Computing', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(129, 18, 180, 181, 2, 'com_modules.module.126', 'MOBILE', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(130, 1, 309, 310, 1, 'com_minitekwall.instance.37', 'Tech Trends', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(131, 1, 311, 312, 1, '#__minitek_wall_modules.12', '#__minitek_wall_modules.12', ''),
(132, 18, 182, 183, 2, 'com_modules.module.127', 'Tech Trends', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(134, 18, 184, 185, 2, 'com_modules.module.129', 'Cameras', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(137, 18, 186, 187, 2, 'com_modules.module.132', 'INTERVIEWS', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(138, 18, 188, 189, 2, 'com_modules.module.133', 'Off-canvas Social', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(139, 1, 313, 314, 1, 'com_minitekwall.instance.38', 'Cameras', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(140, 1, 315, 316, 1, 'com_minitekwall.instance.39', 'Interviews', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(141, 1, 317, 318, 1, '#__minitek_wall_modules.13', '#__minitek_wall_modules.13', ''),
(142, 1, 319, 320, 1, '#__minitek_wall_modules.14', '#__minitek_wall_modules.14', ''),
(143, 1, 321, 322, 1, 'com_minitekwall.instance.40', 'Minitek Wall Page', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(144, 1, 323, 324, 1, '#__minitek_wall_modules.15', '#__minitek_wall_modules.15', ''),
(145, 1, 325, 326, 1, 'com_minitekwall.instance.41', 'Minitek Wall Page 2', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(146, 1, 327, 328, 1, '#__minitek_wall_modules.16', '#__minitek_wall_modules.16', ''),
(147, 18, 190, 191, 2, 'com_modules.module.134', 'Blog Categories', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(148, 18, 192, 193, 2, 'com_modules.module.135', 'Category Articles', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(149, 18, 194, 195, 2, 'com_modules.module.136', 'mod_dark', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(150, 18, 196, 197, 2, 'com_modules.module.137', 'mod_blue', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(151, 18, 198, 199, 2, 'com_modules.module.138', 'mod_orange', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(152, 18, 200, 201, 2, 'com_modules.module.139', 'mod_red', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(156, 18, 202, 203, 2, 'com_modules.module.142', 'mod_green', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(157, 18, 204, 205, 2, 'com_modules.module.143', 'mn-module-light', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(160, 18, 206, 207, 2, 'com_modules.module.146', 'Our Services', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(161, 18, 208, 209, 2, 'com_modules.module.147', 'Our Facilities', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(162, 18, 210, 211, 2, 'com_modules.module.148', 'Our Comprehensive Stuff', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(164, 18, 212, 213, 2, 'com_modules.module.150', 'More Features', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(165, 18, 214, 215, 2, 'com_modules.module.151', 'Footer Logo', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(167, 1, 329, 330, 1, 'com_minitekwall', 'minitekwall', '{"core.admin":[],"core.manage":[],"core.create":[],"core.delete":[],"core.edit":[],"core.edit.state":[],"core.edit.own":[]}'),
(169, 1, 331, 332, 1, 'com_minitekwall.instance.1', 'Our Work - Business', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(170, 1, 333, 334, 1, '#__minitek_wall_modules.1', '#__minitek_wall_modules.1', ''),
(171, 18, 216, 217, 2, 'com_modules.module.153', 'Our Work', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(172, 18, 218, 219, 2, 'com_modules.module.154', 'Our Work Title', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(179, 18, 220, 221, 2, 'com_modules.module.156', 'This is Our Portfolio Title', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(184, 1, 335, 336, 1, 'com_minitekwall.instance.2', 'This is Our Portfolio', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(185, 1, 337, 338, 1, '#__minitek_wall_modules.2', '#__minitek_wall_modules.2', ''),
(186, 18, 222, 223, 2, 'com_modules.module.157', 'This is Our Portfolio', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(192, 18, 224, 225, 2, 'com_modules.module.159', 'Innovative Ideas', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(193, 18, 226, 227, 2, 'com_modules.module.160', 'Testimonials', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(194, 1, 339, 340, 1, 'com_minitekwall.instance.4', 'Magazine Categories', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(195, 1, 341, 342, 1, '#__minitek_wall_modules.4', '#__minitek_wall_modules.4', ''),
(196, 18, 228, 229, 2, 'com_modules.module.161', 'Magazine Categories', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(198, 62, 57, 66, 3, 'com_content.category.18', 'Event Management', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(199, 18, 230, 231, 2, 'com_modules.module.162', 'AUDIO SOLUTIONS', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(200, 62, 67, 80, 3, 'com_content.category.19', 'Video And Music Production', '{"core.create":{"6":1,"3":1},"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1},"core.edit.own":{"6":1,"3":1}}'),
(203, 64, 52, 53, 4, 'com_content.article.33', 'Old School Audio', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(204, 64, 54, 55, 4, 'com_content.article.34', 'The Mysterious Man', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(205, 1, 343, 344, 1, 'com_minitekwall.instance.5', 'Audio Solutions - Magazine', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(208, 18, 232, 233, 2, 'com_modules.module.164', 'POPULAR POSTS', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(209, 18, 234, 235, 2, 'com_modules.module.165', 'COMMERCIAL SERVICES', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(211, 18, 236, 237, 2, 'com_modules.module.167', 'LATEST REVIEWS', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(212, 18, 238, 239, 2, 'com_modules.module.168', 'VIDEO AND MUSIC PRODUCTION', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(213, 18, 240, 241, 2, 'com_modules.module.169', 'Tags', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(214, 18, 242, 243, 2, 'com_modules.module.170', 'Categories', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(215, 18, 244, 245, 2, 'com_modules.module.171', 'Latest Comments', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(217, 18, 246, 247, 2, 'com_modules.module.173', 'Login', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(219, 18, 248, 249, 2, 'com_modules.module.175', 'Article Categories', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(220, 18, 250, 251, 2, 'com_modules.module.176', 'Article Categories', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(221, 18, 252, 253, 2, 'com_modules.module.177', 'Login', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(223, 18, 254, 255, 2, 'com_modules.module.179', 'Scroll Button', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(224, 63, 42, 43, 4, 'com_content.article.35', 'Why This Commercial Became so Successful', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(225, 63, 44, 45, 4, 'com_content.article.36', 'University Luggage', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(226, 198, 58, 59, 4, 'com_content.article.37', 'The Amazing Balloons Event', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(227, 198, 60, 61, 4, 'com_content.article.38', 'Managing the Next Success', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(228, 198, 62, 63, 4, 'com_content.article.39', 'Creating an Event Experience', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(229, 198, 64, 65, 4, 'com_content.article.40', 'Communication is Always Important', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(230, 200, 68, 69, 4, 'com_content.article.41', 'The Strange Formations Music Clip', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(231, 200, 70, 71, 4, 'com_content.article.42', 'The Shipwreck Documentary', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(232, 200, 72, 73, 4, 'com_content.article.43', 'The City in Motion', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(233, 200, 74, 75, 4, 'com_content.article.44', 'Lost in Music Land', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(234, 200, 76, 77, 4, 'com_content.article.45', 'Flying On Cloudy Weather', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(235, 200, 78, 79, 4, 'com_content.article.46', 'Cloudy and Impressive', '{"core.delete":[],"core.edit":[],"core.edit.state":[]}'),
(236, 1, 345, 346, 1, 'com_minitekwall.instance.6', 'Minitek Wall 1', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(237, 1, 347, 348, 1, 'com_minitekwall.instance.7', 'Minitek Wall 2', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(238, 1, 349, 350, 1, '#__minitek_wall_modules.6', '#__minitek_wall_modules.6', ''),
(239, 1, 351, 352, 1, '#__minitek_wall_modules.7', '#__minitek_wall_modules.7', ''),
(240, 18, 256, 257, 2, 'com_modules.module.180', 'Minitek Wall Page', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}'),
(241, 18, 258, 259, 2, 'com_modules.module.181', 'Breadcrumbs', '{"core.delete":{"6":1},"core.edit":{"6":1,"4":1},"core.edit.state":{"6":1,"5":1}}');

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE IF NOT EXISTS `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE IF NOT EXISTS `#__banners` (
`id` int(11) NOT NULL,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `custombannercode` varchar(2048) NOT NULL,
  `sticky` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `params` text NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `reset` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `language` char(7) NOT NULL DEFAULT '',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `version` int(10) unsigned NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE IF NOT EXISTS `#__banner_clients` (
`id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `extrainfo` text NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `metakey` text NOT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(255) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE IF NOT EXISTS `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE IF NOT EXISTS `#__categories` (
`id` int(11) NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `extension` varchar(50) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1'
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 31, 0, '', 'system', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{}', '', '', '{}', 400, '2011-01-01 00:00:01', 0, '0000-00-00 00:00:00', 0, '*', 1),
(2, 27, 1, 1, 2, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 400, '2011-01-01 00:00:01', 0, '0000-00-00 00:00:00', 0, '*', 1),
(3, 28, 1, 3, 4, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 400, '2011-01-01 00:00:01', 0, '0000-00-00 00:00:00', 0, '*', 1),
(4, 29, 1, 5, 6, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 400, '2011-01-01 00:00:01', 0, '0000-00-00 00:00:00', 0, '*', 1),
(5, 30, 1, 7, 8, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 400, '2011-01-01 00:00:01', 0, '0000-00-00 00:00:00', 0, '*', 1),
(6, 31, 1, 9, 10, 1, 'uncategorised', 'com_weblinks', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 400, '2011-01-01 00:00:01', 0, '0000-00-00 00:00:00', 0, '*', 1),
(7, 32, 1, 11, 12, 1, 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 400, '2011-01-01 00:00:01', 0, '0000-00-00 00:00:00', 0, '*', 1),
(8, 62, 1, 13, 22, 1, 'articles', 'com_content', 'Articles', 'articles', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 400, '2014-07-28 13:17:41', 444, '2014-07-28 13:18:19', 0, '*', 1),
(9, 63, 8, 14, 15, 2, 'articles/commercial-services', 'com_content', 'Commercial Services', 'commercial-services', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"images\\/echo\\/articles\\/categories\\/categories.jpg"}', '', '', '{"author":"","robots":""}', 400, '2014-07-28 13:18:52', 445, '2014-09-21 19:59:43', 0, '*', 1),
(10, 64, 8, 16, 17, 2, 'articles/audio-solutions', 'com_content', 'Audio Solutions', 'audio-solutions', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"images\\/echo\\/articles\\/categories\\/categories.jpg"}', '', '', '{"author":"","robots":""}', 400, '2014-07-28 13:19:24', 445, '2014-09-21 19:59:53', 0, '*', 1),
(11, 65, 1, 23, 24, 1, 'faq', 'com_content', 'FAQ', 'faq', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 400, '2014-07-28 13:19:40', 444, '2014-07-28 13:19:44', 0, '*', 1),
(12, 75, 1, 25, 28, 1, 'explore', 'com_content', 'Explore', 'explore', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 400, '2014-07-28 13:25:19', 0, '0000-00-00 00:00:00', 0, '*', 1),
(13, 76, 12, 26, 27, 2, 'explore/template-themes', 'com_content', 'Template themes', 'template-themes', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 400, '2014-07-28 13:25:40', 0, '0000-00-00 00:00:00', 0, '*', 1),
(14, 78, 1, 29, 30, 1, 'contacts-category-i', 'com_contact', 'Contacts category I', 'contacts-category-i', '', '', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":""}', '', '', '{"author":"","robots":""}', 400, '2014-07-28 13:29:17', 444, '2014-07-28 13:29:21', 0, '*', 1),
(18, 198, 8, 18, 19, 2, 'articles/event-management', 'com_content', 'Event Management', 'event-management', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"images\\/echo\\/articles\\/categories\\/categories.jpg"}', '', '', '{"author":"","robots":""}', 400, '2014-09-12 12:39:43', 445, '2014-09-21 20:00:05', 0, '*', 1),
(19, 200, 8, 20, 21, 2, 'articles/video-and-music-production', 'com_content', 'Video And Music Production', 'video-and-music-production', '', '<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.</p>', 1, 0, '0000-00-00 00:00:00', 1, '{"category_layout":"","image":"images\\/echo\\/articles\\/categories\\/categories.jpg"}', '', '', '{"author":"","robots":""}', 400, '2014-09-14 19:01:40', 445, '2014-09-21 20:00:22', 0, '*', 1);

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE IF NOT EXISTS `#__contact_details` (
`id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `con_position` varchar(255) DEFAULT NULL,
  `address` text,
  `suburb` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `postcode` varchar(100) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `misc` mediumtext,
  `image` varchar(255) DEFAULT NULL,
  `email_to` varchar(255) DEFAULT NULL,
  `default_con` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `mobile` varchar(255) NOT NULL DEFAULT '',
  `webpage` varchar(255) NOT NULL DEFAULT '',
  `sortname1` varchar(255) NOT NULL,
  `sortname2` varchar(255) NOT NULL,
  `sortname3` varchar(255) NOT NULL,
  `language` char(7) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `xreference`, `publish_up`, `publish_down`, `version`, `hits`) VALUES
(1, 'John Doe', 'john-doe', '', '2411 Any Street', 'Any Town', '', 'United Kingdom', '', 'Q+123 456 7890', 'fax', 'If you have any enquiry then you may simply get in touch<br>\r\nand we will get back to you as soon as possible ', 'images/echo/contact/contact.jpg', 'info@youremail.you', 0, 1, 0, '0000-00-00 00:00:00', 1, '{"show_contact_category":"","show_contact_list":"","presentation_style":"","show_tags":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_profile":"","show_links":"","linka_name":"","linka":false,"linkb_name":"","linkb":false,"linkc_name":"","linkc":false,"linkd_name":"","linkd":false,"linke_name":"","linke":"","contact_layout":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":""}', 445, 14, 1, 'Q+999 456 7890', '', '', '', '', '*', '2014-07-28 13:30:42', 400, '', '2014-09-16 14:01:08', 400, '', '', '{"robots":"","rights":""}', 1, '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 10, 110);

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE IF NOT EXISTS `#__content` (
`id` int(10) unsigned NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `attribs` varchar(5120) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `metadata` text NOT NULL,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) NOT NULL COMMENT 'The language code for the article.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.'
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=47 ;

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(1, 66, 'The Breathing Commercial', 'the-breathing-commercial', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 9, '2014-07-28 13:20:56', 400, '', '2014-09-21 20:05:05', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:20:56', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/commercial_services\\/commercial_services.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/commercial_services\\/commercial_services.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 10, 1, '', '', 1, 54, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(2, 67, 'Make Your Red Background Work Better', 'make-your-red-background-work-better', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 9, '2014-07-28 13:21:13', 400, '', '2014-09-21 20:04:30', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:21:13', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/commercial_services\\/commercial_services.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/commercial_services\\/commercial_services.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 11, 0, '', '', 1, 21, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(3, 68, 'Eastern Reverence', 'eastern-reverence', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 9, '2014-07-28 13:21:34', 400, '', '2014-09-21 20:04:12', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:21:34', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/commercial_services\\/commercial_services.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/commercial_services\\/commercial_services.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 8, 1, '', '', 1, 5, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(4, 69, 'City Photography and Direction', 'city-photography-and-direction', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 9, '2014-07-28 13:21:47', 400, '', '2014-09-21 20:03:51', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:21:47', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/commercial_services\\/commercial_services.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/commercial_services\\/commercial_services.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 7, 0, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(5, 70, 'FAQ', 'faq', '  <div class="mn-mod-header">\r\n    <div class="mn-title">\r\n      <h2>Frequently Asked Questions</h2>\r\n    </div>\r\n    <div class="mn-description">\r\n      <h4>Welcome to our FAQ section. Below you will find a selection<br>of the questions we get asked most. Simply click the question to reveal the answer.</h4>\r\n    </div>\r\n  </div>\r\n\r\n\r\n<div class="panel-group" id="accordion">\r\n  <div class="panel panel-default">\r\n    <div class="panel-heading">\r\n      <h4 class="panel-title">\r\n        <a data-toggle="collapse" data-parent="#accordion" href="#collapse1">\r\n            Lorem ipsum dolor sit amet consectetur adipiscing elit?\r\n        </a>\r\n      </h4>\r\n    </div>\r\n    <div id="collapse1" class="panel-collapse collapse in">\r\n      <div class="panel-body">\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \r\n      </div>\r\n    </div>\r\n  </div>\r\n  <div class="panel panel-default">\r\n    <div class="panel-heading">\r\n      <h4 class="panel-title">\r\n        <a data-toggle="collapse" data-parent="#accordion" href="#collapse2">\r\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\r\n        </a>\r\n      </h4>\r\n    </div>\r\n    <div id="collapse2" class="panel-collapse collapse">\r\n      <div class="panel-body">\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \r\n      </div>\r\n    </div>\r\n  </div>\r\n  <div class="panel panel-default">\r\n    <div class="panel-heading">\r\n      <h4 class="panel-title">\r\n        <a data-toggle="collapse" data-parent="#accordion" href="#collapse3">\r\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\r\n        </a>\r\n      </h4>\r\n    </div>\r\n    <div id="collapse3" class="panel-collapse collapse">\r\n      <div class="panel-body">\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \r\n      </div>\r\n    </div>\r\n  </div>\r\n    <div class="panel panel-default">\r\n    <div class="panel-heading">\r\n      <h4 class="panel-title">\r\n        <a data-toggle="collapse" data-parent="#accordion" href="#collapse4">\r\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\r\n        </a>\r\n      </h4>\r\n    </div>\r\n    <div id="collapse4" class="panel-collapse collapse">\r\n      <div class="panel-body">\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \r\n      </div>\r\n    </div>\r\n  </div>\r\n  <div class="panel panel-default">\r\n    <div class="panel-heading">\r\n      <h4 class="panel-title">\r\n        <a data-toggle="collapse" data-parent="#accordion" href="#collapse5">\r\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\r\n        </a>\r\n      </h4>\r\n    </div>\r\n    <div id="collapse5" class="panel-collapse collapse">\r\n      <div class="panel-body">\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \r\n      </div>\r\n    </div>\r\n  </div>\r\n  <div class="panel panel-default">\r\n    <div class="panel-heading">\r\n      <h4 class="panel-title">\r\n        <a data-toggle="collapse" data-parent="#accordion" href="#collapse6">\r\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\r\n        </a>\r\n      </h4>\r\n    </div>\r\n    <div id="collapse6" class="panel-collapse collapse">\r\n      <div class="panel-body">\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \r\n      </div>\r\n    </div>\r\n  </div>\r\n  <div class="panel panel-default">\r\n    <div class="panel-heading">\r\n      <h4 class="panel-title">\r\n        <a data-toggle="collapse" data-parent="#accordion" href="#collapse7">\r\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\r\n        </a>\r\n      </h4>\r\n    </div>\r\n    <div id="collapse7" class="panel-collapse collapse">\r\n      <div class="panel-body">\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \r\n      </div>\r\n    </div>\r\n  </div>\r\n  <div class="panel panel-default">\r\n    <div class="panel-heading">\r\n      <h4 class="panel-title">\r\n        <a data-toggle="collapse" data-parent="#accordion" href="#collapse8">\r\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\r\n        </a>\r\n      </h4>\r\n    </div>\r\n    <div id="collapse8" class="panel-collapse collapse">\r\n      <div class="panel-body">\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \r\n      </div>\r\n    </div>\r\n  </div>\r\n  <div class="panel panel-default">\r\n    <div class="panel-heading">\r\n      <h4 class="panel-title">\r\n        <a data-toggle="collapse" data-parent="#accordion" href="#collapse9">\r\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\r\n        </a>\r\n      </h4>\r\n    </div>\r\n    <div id="collapse9" class="panel-collapse collapse">\r\n      <div class="panel-body">\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \r\n      </div>\r\n    </div>\r\n  </div>\r\n  <div class="panel panel-default">\r\n    <div class="panel-heading">\r\n      <h4 class="panel-title">\r\n        <a data-toggle="collapse" data-parent="#accordion" href="#collapse10">\r\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\r\n        </a>\r\n      </h4>\r\n    </div>\r\n    <div id="collapse10" class="panel-collapse collapse">\r\n      <div class="panel-body">\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \r\n      </div>\r\n    </div>\r\n  </div>\r\n  <div class="panel panel-default">\r\n    <div class="panel-heading">\r\n      <h4 class="panel-title">\r\n        <a data-toggle="collapse" data-parent="#accordion" href="#collapse11">\r\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\r\n        </a>\r\n      </h4>\r\n    </div>\r\n    <div id="collapse11" class="panel-collapse collapse">\r\n      <div class="panel-body">\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \r\n      </div>\r\n    </div>\r\n  </div>\r\n  <div class="panel panel-default">\r\n    <div class="panel-heading">\r\n      <h4 class="panel-title">\r\n        <a data-toggle="collapse" data-parent="#accordion" href="#collapse12">\r\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\r\n        </a>\r\n      </h4>\r\n    </div>\r\n    <div id="collapse12" class="panel-collapse collapse">\r\n      <div class="panel-body">\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \r\n      </div>\r\n    </div>\r\n  </div>\r\n    <div class="panel panel-default">\r\n    <div class="panel-heading">\r\n      <h4 class="panel-title">\r\n        <a data-toggle="collapse" data-parent="#accordion" href="#collapse13">\r\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\r\n        </a>\r\n      </h4>\r\n    </div>\r\n    <div id="collapse13" class="panel-collapse collapse">\r\n      <div class="panel-body">\r\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \r\n      </div>\r\n    </div>\r\n  </div>\r\n\r\n\r\n</div>\r\n', '', 1, 11, '2014-07-28 13:22:20', 400, '', '2014-07-28 13:22:24', 444, 0, '0000-00-00 00:00:00', '2014-07-28 13:22:20', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 34, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(6, 71, 'About us', 'about-us', '        <div class="row">\r\n        \r\n            <div class="mn-mod-header">\r\n                <div class="mn-title">\r\n                    <h2>A Little About Us</h2>\r\n                </div>\r\n                <div class="mn-description">\r\n                    <h4>We are a world class company specialized in audio,<br>video and general media production</h4>\r\n                </div>\r\n\r\n            </div>\r\n                        \r\n             <div class="col-xs-12 col-md-4 mn-about text-center">\r\n                <div class="mn-about-inner">\r\n                \r\n                    <div class="mn-about-img">\r\n                        <img src="images/echo/aboutus/aboutus.jpg" alt="about1" class="img-circle">\r\n                    </div>\r\n                    \r\n                    <div class="mn-about-title">\r\n                        <p>John Doe</p>\r\n                    </div>\r\n                    \r\n                    <div class="mn-about-desc">\r\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n                    </div>\r\n\r\n                    <div class="mn-about-social">\r\n                    \r\n                        <ul class="social-media-icons">\r\n                            <li class="facebook">\r\n                                <a class="facebook" href="#"><i class="fa fa-facebook"></i></a>\r\n                            </li>\r\n                            <li class="twitter">\r\n                                <a class="twitter" href="#"><i class="fa fa-twitter"></i></a>\r\n                            </li>\r\n                            <li class="google-plus">\r\n                                <a class="google-plus" href="#"><i class="fa fa-google-plus"></i></a>\r\n                            </li>\r\n                        </ul>                    \r\n                    \r\n                    </div>\r\n                    \r\n                </div>\r\n            </div>\r\n             <div class="col-xs-12 col-md-4 mn-about text-center">\r\n                <div class="mn-about-inner">\r\n                \r\n                    <div class="mn-about-img">\r\n                        <img src="images/echo/aboutus/aboutus.jpg" alt="about1" class="img-circle">\r\n                    </div>\r\n                    \r\n                    <div class="mn-about-title">\r\n                        <p>Jane Doe</p>\r\n                    </div>\r\n                    \r\n                    <div class="mn-about-desc">\r\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n                    </div>\r\n\r\n                    <div class="mn-about-social">\r\n                    \r\n                        <ul class="social-media-icons">\r\n                            <li class="facebook">\r\n                                <a class="facebook" href="#"><i class="fa fa-facebook"></i></a>\r\n                            </li>\r\n                            <li class="twitter">\r\n                                <a class="twitter" href="#"><i class="fa fa-twitter"></i></a>\r\n                            </li>\r\n                            <li class="google-plus">\r\n                                <a class="google-plus" href="#"><i class="fa fa-google-plus"></i></a>\r\n                            </li>\r\n                        </ul>                    \r\n                    \r\n                    </div>\r\n                    \r\n                </div>\r\n            </div>\r\n             <div class="col-xs-12 col-md-4 mn-about text-center">\r\n                <div class="mn-about-inner">\r\n                \r\n                    <div class="mn-about-img">\r\n                        <img src="images/echo/aboutus/aboutus.jpg" alt="about1" class="img-circle">\r\n                    </div>\r\n                    \r\n                    <div class="mn-about-title">\r\n                        <p>Nick Doe</p>\r\n                    </div>\r\n                    \r\n                    <div class="mn-about-desc">\r\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n                    </div>\r\n\r\n                    <div class="mn-about-social">\r\n                    \r\n                        <ul class="social-media-icons">\r\n                            <li class="facebook">\r\n                                <a class="facebook" href="#"><i class="fa fa-facebook"></i></a>\r\n                            </li>\r\n                            <li class="twitter">\r\n                                <a class="twitter" href="#"><i class="fa fa-twitter"></i></a>\r\n                            </li>\r\n                            <li class="google-plus">\r\n                                <a class="google-plus" href="#"><i class="fa fa-google-plus"></i></a>\r\n                            </li>\r\n                        </ul>                    \r\n                    \r\n                    </div>\r\n                    \r\n                </div>\r\n            </div>\r\n            \r\n             <div class="col-xs-12 col-md-4 mn-about text-center">\r\n                <div class="mn-about-inner">\r\n                \r\n                    <div class="mn-about-img">\r\n                        <img src="images/echo/aboutus/aboutus.jpg" alt="about1" class="img-circle">\r\n                    </div>\r\n                    \r\n                    <div class="mn-about-title">\r\n                        <p>Susan Doe</p>\r\n                    </div>\r\n                    \r\n                    <div class="mn-about-desc">\r\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n                    </div>\r\n\r\n                    <div class="mn-about-social">\r\n                    \r\n                        <ul class="social-media-icons">\r\n                            <li class="facebook">\r\n                                <a class="facebook" href="#"><i class="fa fa-facebook"></i></a>\r\n                            </li>\r\n                            <li class="twitter">\r\n                                <a class="twitter" href="#"><i class="fa fa-twitter"></i></a>\r\n                            </li>\r\n                            <li class="google-plus">\r\n                                <a class="google-plus" href="#"><i class="fa fa-google-plus"></i></a>\r\n                            </li>\r\n                        </ul>                    \r\n                    \r\n                    </div>\r\n                    \r\n                </div>\r\n            </div>\r\n\r\n             <div class="col-xs-12 col-md-4 mn-about text-center">\r\n                <div class="mn-about-inner">\r\n                \r\n                    <div class="mn-about-img">\r\n                        <img src="images/echo/aboutus/aboutus.jpg" alt="about1" class="img-circle">\r\n                    </div>\r\n                    \r\n                    <div class="mn-about-title">\r\n                        <p>Mike Doe</p>\r\n                    </div>\r\n                    \r\n                    <div class="mn-about-desc">\r\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n                    </div>\r\n\r\n                    <div class="mn-about-social">\r\n                    \r\n                        <ul class="social-media-icons">\r\n                            <li class="facebook">\r\n                                <a class="facebook" href="#"><i class="fa fa-facebook"></i></a>\r\n                            </li>\r\n                            <li class="twitter">\r\n                                <a class="twitter" href="#"><i class="fa fa-twitter"></i></a>\r\n                            </li>\r\n                            <li class="google-plus">\r\n                                <a class="google-plus" href="#"><i class="fa fa-google-plus"></i></a>\r\n                            </li>\r\n                        </ul>                    \r\n                    \r\n                    </div>\r\n                    \r\n                </div>\r\n            </div>\r\n\r\n             <div class="col-xs-12 col-md-4 mn-about text-center">\r\n                <div class="mn-about-inner">\r\n                \r\n                    <div class="mn-about-img">\r\n                        <img src="images/echo/aboutus/aboutus.jpg" alt="about1" class="img-circle">\r\n                    </div>\r\n                    \r\n                    <div class="mn-about-title">\r\n                        <p>Helen Doe</p>\r\n                    </div>\r\n                    \r\n                    <div class="mn-about-desc">\r\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n                    </div>\r\n\r\n                    <div class="mn-about-social">\r\n                    \r\n                        <ul class="social-media-icons">\r\n                            <li class="facebook">\r\n                                <a class="facebook" href="#"><i class="fa fa-facebook"></i></a>\r\n                            </li>\r\n                            <li class="twitter">\r\n                                <a class="twitter" href="#"><i class="fa fa-twitter"></i></a>\r\n                            </li>\r\n                            <li class="google-plus">\r\n                                <a class="google-plus" href="#"><i class="fa fa-google-plus"></i></a>\r\n                            </li>\r\n                        </ul>                    \r\n                    \r\n                    </div>\r\n                    \r\n                </div>\r\n            </div>\r\n\r\n        </div>\r\n   \r\n', '', 1, 2, '2014-07-28 13:23:15', 400, '', '2014-09-21 19:46:58', 400, 0, '0000-00-00 00:00:00', '2014-07-28 13:23:15', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 21, 4, '', '', 1, 129, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(7, 72, 'Page Breaks', 'page-breaks', '', '\r\n<p>Ut dignissim aliquet nibh tristique hendrerit. Donec ullamcorper nulla quis metus vulputate id placerat augue eleifend. Aenean venenatis consectetur orci, sit amet ultricies magna sagittis vel. Nulla non diam nisi, ut ultrices massa. Pellentesque sed nisl metus. Praesent a mi vel ante molestie venenatis.</p>\r\n<p>Donec sed odio dui. Cras mattis consectetur purus sit amet fermentum. Nullam quis risus eget urna mollis ornare vel eu leo. Donec id elit non mi porta gravida at eget metus. Etiam porta sem malesuada magna mollis euismod. Cras justo odio, dapibus ac facilisis in, egestas eget quam.</p>\r\n<p>Mauris justo metus, ultrices id lobortis et, euismod sit amet metus. Maecenas sed nisl a arcu ultricies consectetur. Integer ut mollis elit. Nulla ultrices scelerisque mauris id commodo. Integer congue lectus et justo pellentesque sed semper lacus facilisis. Nunc tristique placerat odio eget rutrum.</p>\r\n<p>Ut viverra erat id augue bibendum rutrum. Nam aliquet feugiat molestie. Maecenas tempus scelerisque tellus eu mattis. Aliquam dignissim aliquam posuere. Sed dignissim, ipsum sed sodales aliquam, erat dolor varius eros, in semper sem metus vel metus. Nullam est mauris, laoreet condimentum hendrerit et, euismod quis dolor. Nunc eleifend lacinia libero eget scelerisque. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae.</p>\r\n<p>Nulla vitae elit libero, a pharetra augue. Donec ullamcorper nulla non metus auctor fringilla. Nulla vitae elit libero, a pharetra augue. Aenean lacinia bibendum nulla sed consectetur. Donec id elit non mi porta gravida at eget metus.</p>\r\n<p>Vivamus eget est urna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vivamus mauris justo, fermentum quis mattis vel, auctor vitae metus. Maecenas non dolor ac risus faucibus luctus non id turpis. Morbi ante nibh, suscipit non adipiscing in, ornare in ipsum.</p>\r\n<hr title="Second page" alt="second-page" class="system-pagebreak" />\r\n<p>Nullam ac odio orci, sed pretium velit. Integer sit amet justo faucibus lorem imperdiet sagittis. Proin egestas, risus in faucibus sodales, tortor turpis feugiat risus, varius laoreet dui turpis ac dolor. Nullam suscipit fringilla augue non rhoncus. Nullam ac nibh eu ipsum tristique ullamcorper. Nunc porttitor lorem id orci dapibus lacinia. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed posuere consectetur est at lobortis. Vestibulum id ligula porta felis euismod semper. Donec id elit non mi porta gravida at eget metus. Integer posuere erat a ante venenatis dapibus posuere velit aliquet.</p>\r\n<p>Etiam porta sem malesuada magna mollis euismod. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Maecenas sed diam eget risus varius blandit sit amet non magna. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.</p>\r\n<hr title="Third page" alt="third-page" class="system-pagebreak" />\r\n<p> </p>\r\n<p>Donec sed odio dui. Cras mattis consectetur purus sit amet fermentum. Nullam quis risus eget urna mollis ornare vel eu leo. Donec id elit non mi porta gravida at eget metus. Etiam porta sem malesuada magna mollis euismod. Cras justo odio, dapibus ac facilisis in, egestas eget quam.</p>\r\n<p>Etiam porta sem malesuada magna mollis euismod. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Maecenas sed diam eget risus varius blandit sit amet non magna. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.</p>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed posuere consectetur est at lobortis. Vestibulum id ligula porta felis euismod semper. Donec id elit non mi porta gravida at eget metus. Integer posuere erat a ante venenatis dapibus posuere velit aliquet.</p>\r\n<p>Nulla vitae elit libero, a pharetra augue. Donec ullamcorper nulla non metus auctor fringilla. Nulla vitae elit libero, a pharetra augue. Aenean lacinia bibendum nulla sed consectetur. Donec id elit non mi porta gravida at eget metus.</p>\r\n<hr title="Fourth page" alt="fourth-page" class="system-pagebreak" />\r\n<p>Maecenas faucibus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Donec id elit non mi porta gravida at eget metus. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Praesent commodo cursus magna, vel scelerisque nisl consectetur et.</p>\r\n<p>Fusce id enim id erat sodales auctor. Duis tortor nisl, condimentum vel feugiat vel, venenatis ut dolor. Donec interdum ornare ligula, vitae adipiscing diam imperdiet at. Donec facilisis, nunc sit amet ultricies adipiscing, ligula justo congue lectus, sit amet vehicula enim lorem in neque. In ultrices bibendum justo ac vehicula. Nam tincidunt blandit consequat.</p>\r\n<p>Vestibulum id ligula porta felis euismod semper. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Donec id elit non mi porta gravida at eget metus.</p>\r\n<hr title="Fifth page" alt="fifth-page" class="system-pagebreak" />\r\n<p>Nullam quis risus eget urna mollis ornare vel eu leo. Sed posuere consectetur est at lobortis. Aenean lacinia bibendum nulla sed consectetur. Maecenas sed diam eget risus varius blandit sit amet non magna. Etiam porta sem malesuada magna mollis euismod.</p>\r\n<p>Nullam quis risus eget urna mollis ornare vel eu leo. Donec id elit non mi porta gravida at eget metus. Aenean lacinia bibendum nulla sed consectetur.</p>\r\n<p>Vestibulum id ligula porta felis euismod semper. Donec ullamcorper nulla non metus auctor fringilla. Curabitur blandit tempus porttitor. Donec id elit non mi porta gravida at eget metus. Cras justo odio, dapibus ac facilisis in, egestas eget quam.</p>\r\n<p> </p>', 1, 2, '2014-07-28 13:23:49', 400, '', '2014-07-28 13:23:53', 444, 0, '0000-00-00 00:00:00', '2014-07-28 13:23:49', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 3, '', '', 1, 27, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(8, 73, 'Typography', 'typography', '     <div class="page-header col-xs-12">\r\n        <h2 id="headings">ALERTS</h2>\r\n    </div>\r\n\r\n  <div class="col-xs-12 col-sm-6">  \r\n        <div class="alert alert-success">\r\n            <strong>Success!</strong> You successfully read this important alert message.\r\n            <button class="close" type="button" data-dismiss="alert">×</button>\r\n        </div>\r\n        \r\n        <div class="alert alert-info">\r\n            <strong>Info!</strong> This alert needs your attention, but it''s not super important.\r\n            <button class="close" type="button" data-dismiss="alert">×</button>\r\n        </div>\r\n  </div>\r\n    \r\n  <div class="col-xs-12 col-sm-6"> \r\n        <div class="alert alert-warning">\r\n            <strong>Warning!</strong> Best check yo self, you''re not looking too good.\r\n            <button class="close" type="button" data-dismiss="alert">×</button>\r\n        </div>\r\n        \r\n        <div class="alert alert-error fade in">\r\n            <button class="close" type="button" data-dismiss="alert">×</button>\r\n            <strong>Error!</strong> Empty password not allowed\r\n        </div>\r\n  </div>\r\n\r\n<div class="col-xs-12 col-sm-12">\r\n    <div class="page-header">\r\n        <h2 id="headings">HEADINGS</h2>\r\n    </div>\r\n    \r\n    <div class="bs-example bs-example-type">\r\n          <table class="table">\r\n            <tbody>\r\n              <tr>\r\n                <td><h1>h1. Heading <small>Secondary text</small></h1></td>\r\n              </tr>\r\n              <tr>\r\n                <td><h2>h2. Heading <small>Secondary text</small></h2></td>\r\n              </tr>\r\n              <tr>\r\n                <td><h3>h3. Heading <small>Secondary text</small></h3></td>\r\n              </tr>\r\n              <tr>\r\n                <td><h4>h4. Heading <small>Secondary text</small></h4></td>\r\n              </tr>\r\n              <tr>\r\n                <td><h5>h5. Heading <small>Secondary text</small></h5></td>\r\n              </tr>\r\n              <tr>\r\n                <td><h6>h6. Heading <small>Secondary text</small></h6></td>\r\n              </tr>\r\n            </tbody>\r\n          </table>\r\n    </div>\r\n<div class="highlight"><pre><code class="html"><span class="nt">&lt;h1&gt;</span>h1. Bootstrap heading <span class="nt">&lt;small&gt;</span>Secondary text<span class="nt">&lt;/small&gt;&lt;/h1&gt;</span>\r\n<span class="nt">&lt;h2&gt;</span>h2. heading <span class="nt">&lt;small&gt;</span>Secondary text<span class="nt">&lt;/small&gt;&lt;/h2&gt;</span>\r\n<span class="nt">&lt;h3&gt;</span>h3. heading <span class="nt">&lt;small&gt;</span>Secondary text<span class="nt">&lt;/small&gt;&lt;/h3&gt;</span>\r\n<span class="nt">&lt;h4&gt;</span>h4. heading <span class="nt">&lt;small&gt;</span>Secondary text<span class="nt">&lt;/small&gt;&lt;/h4&gt;</span>\r\n<span class="nt">&lt;h5&gt;</span>h5. heading <span class="nt">&lt;small&gt;</span>Secondary text<span class="nt">&lt;/small&gt;&lt;/h5&gt;</span>\r\n<span class="nt">&lt;h6&gt;</span>h6. heading <span class="nt">&lt;small&gt;</span>Secondary text<span class="nt">&lt;/small&gt;&lt;/h6&gt;</span>\r\n</code></pre></div>\r\n</div>\r\n\r\n<div class="col-xs-12 col-md-6">\r\n    <div class="page-header">\r\n        <h2 id="headings">Body Text</h2>\r\n    </div>\r\n    \r\n    <div class="bs-example">\r\n        <p>Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nullam id dolor id nibh ultricies vehicula.</p>\r\n    </div>\r\n    \r\n<div class="highlight"><pre><code class="html"><span class="nt">&lt;p&gt;</span>...<span class="nt">&lt;/p&gt;</span>\r\n</code></pre></div>\r\n\r\n</div>\r\n\r\n<div class="col-xs-12 col-md-6">\r\n    <div class="page-header">\r\n        <h2 id="headings">Lead Body Text</h2>\r\n    </div>\r\n\r\n    <div class="bs-example">\r\n          <p class="lead">Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Duis mollis, est non commodo luctus.</p>\r\n    </div>\r\n<div class="highlight"><pre><code class="html"><span class="nt">&lt;p</span> <span class="na">class=</span><span class="s">"lead"</span><span class="nt">&gt;</span>...<span class="nt">&lt;/p&gt;</span>\r\n</code></pre></div>\r\n</div>\r\n\r\n<div class="clearfix"></div>\r\n\r\n<div class="col-xs-12 col-md-6">\r\n    <div class="page-header">\r\n        <h2 id="headings">Abbreviations</h2>\r\n    </div>\r\n    \r\n    <div class="bs-example">\r\n      <p>An abbreviation of the word attribute is <abbr title="attribute">attr</abbr>.</p>\r\n    </div>\r\n    <div class="highlight"><pre><code class="html"><span class="nt">&lt;abbr</span> <span class="na">title=</span><span class="s">"attribute"</span><span class="nt">&gt;</span>attr<span class="nt">&lt;/abbr&gt;</span>\r\n</code></pre></div>\r\n</div>\r\n\r\n<div class="col-xs-12 col-md-6">\r\n    <div class="page-header">\r\n        <h2 id="headings">Initialism</h2>\r\n    </div>\r\n    \r\n    <div class="bs-example">\r\n      <p><abbr title="HyperText Markup Language" class="initialism">HTML</abbr> is the best thing since sliced bread.</p>\r\n    </div>\r\n    <div class="highlight"><pre><code class="html"><span class="nt">&lt;abbr</span> <span class="na">title=</span><span class="s">"HyperText Markup Language"</span> <span class="na">class=</span><span class="s">"initialism"</span><span class="nt">&gt;</span>HTML<span class="nt">&lt;/abbr&gt;</span>\r\n</code></pre></div>\r\n</div>\r\n\r\n<div class="clearfix"></div>\r\n\r\n<div class="col-xs-12 col-md-6">\r\n    <div class="page-header">\r\n        <h2 id="headings">Labels</h2>\r\n    </div>\r\n\r\n        <div class="bs-example">\r\n          <span class="label label-default">Default</span>\r\n          <span class="label label-primary">Primary</span>\r\n          <span class="label label-success">Success</span>\r\n          <span class="label label-info">Info</span>\r\n          <span class="label label-warning">Warning</span>\r\n          <span class="label label-danger">Danger</span>\r\n        </div>\r\n        \r\n        <div class="highlight"><pre><code class="html"><span class="nt">&lt;span</span> <span class="na">class=</span><span class="s">"label label-default"</span><span class="nt">&gt;</span>Default<span class="nt">&lt;/span&gt;</span>\r\n<span class="nt">&lt;span</span> <span class="na">class=</span><span class="s">"label label-primary"</span><span class="nt">&gt;</span>Primary<span class="nt">&lt;/span&gt;</span>\r\n<span class="nt">&lt;span</span> <span class="na">class=</span><span class="s">"label label-success"</span><span class="nt">&gt;</span>Success<span class="nt">&lt;/span&gt;</span>\r\n<span class="nt">&lt;span</span> <span class="na">class=</span><span class="s">"label label-info"</span><span class="nt">&gt;</span>Info<span class="nt">&lt;/span&gt;</span>\r\n<span class="nt">&lt;span</span> <span class="na">class=</span><span class="s">"label label-warning"</span><span class="nt">&gt;</span>Warning<span class="nt">&lt;/span&gt;</span>\r\n<span class="nt">&lt;span</span> <span class="na">class=</span><span class="s">"label label-danger"</span><span class="nt">&gt;</span>Danger<span class="nt">&lt;/span&gt;</span>\r\n</code></pre></div>\r\n\r\n</div>\r\n\r\n<div class="col-xs-12 col-md-6">\r\n    <div class="page-header">\r\n        <h2 id="headings">Badges</h2>\r\n    </div>\r\n    \r\n    <div class="bs-example">\r\n      <a href="#">Inbox <span class="badge">42</span></a>\r\n    </div>\r\n    \r\n    <div class="highlight"><pre><code class="html"><span class="nt">&lt;a</span> <span class="na">href=</span><span class="s">"#"</span><span class="nt">&gt;</span>Inbox <span class="nt">&lt;span</span> <span class="na">class=</span><span class="s">"badge"</span><span class="nt">&gt;</span>42<span class="nt">&lt;/span&gt;&lt;/a&gt;</span>\r\n</code></pre></div>\r\n\r\n</div>\r\n\r\n<div class="clearfix"></div>\r\n\r\n\r\n\r\n<div class="page-header col-xs-12">\r\n    <h2 id="headings">BLOCKQUOTES</h2>\r\n</div>\r\n\r\n\r\n<div class="col-xs-12 col-md-6">\r\n    <div class="page-header">\r\n        <h2 id="headings">Default blockquote</h2>\r\n    </div>\r\n    <div class="bs-example">\r\n      <blockquote>\r\n        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</p>\r\n      </blockquote>\r\n    </div> \r\n    <div class="highlight"><pre><code class="html"><span class="nt">&lt;blockquote&gt;</span>\r\n  <span class="nt">&lt;p&gt;</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.<span class="nt">&lt;/p&gt;</span>\r\n<span class="nt">&lt;/blockquote&gt;</span>\r\n</code></pre></div>   \r\n</div>\r\n\r\n\r\n<div class="col-xs-12 col-md-6">\r\n    <div class="page-header">\r\n        <h2 id="headings">Blockquote options</h2>\r\n    </div>\r\n    <div class="bs-example">\r\n      <blockquote>\r\n        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</p>\r\n        <small>Someone famous in <cite title="Source Title">Source Title</cite></small>\r\n      </blockquote>\r\n    </div>\r\n    \r\n    <div class="highlight"><pre><code class="html"><span class="nt">&lt;blockquote&gt;</span>\r\n  <span class="nt">&lt;p&gt;</span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.<span class="nt">&lt;/p&gt;</span>\r\n  <span class="nt">&lt;small&gt;</span>Someone famous in <span class="nt">&lt;cite</span> <span class="na">title=</span><span class="s">"Source Title"</span><span class="nt">&gt;</span>Source Title<span class="nt">&lt;/cite&gt;&lt;/small&gt;</span>\r\n<span class="nt">&lt;/blockquote&gt;</span>\r\n</code></pre></div>    \r\n    \r\n</div>\r\n\r\n\r\n<div class="clearfix"></div>\r\n\r\n\r\n<div class="col-xs-12">\r\n    <div class="page-header">\r\n        <h2 id="headings">Alternate blockquote display</h2>\r\n    </div>\r\n    <div class="bs-example" style="overflow: hidden;">\r\n      <blockquote class="pull-right">\r\n        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</p>\r\n        <small>Someone famous in <cite title="Source Title">Source Title</cite></small>\r\n      </blockquote>\r\n    </div> \r\n    \r\n    <div class="highlight"><pre><code class="html"><span class="nt">&lt;blockquote</span> <span class="na">class=</span><span class="s">"pull-right"</span><span class="nt">&gt;</span>\r\n  ...\r\n<span class="nt">&lt;/blockquote&gt;</span>\r\n</code></pre></div>   \r\n</div>\r\n\r\n\r\n<div class="page-header col-xs-12">\r\n    <h2 id="headings">LISTS</h2>\r\n</div>\r\n\r\n<div class="col-xs-12 col-md-6">\r\n    <div class="page-header">\r\n        <h2 id="headings">Unordered</h2>\r\n    </div>\r\n    <div class="bs-example">\r\n      <ul>\r\n        <li>Lorem ipsum dolor sit amet</li>\r\n        <li>Consectetur adipiscing elit</li>\r\n        <li>Nulla volutpat aliquam velit\r\n          <ul>\r\n            <li>Phasellus iaculis neque</li>\r\n            <li>Purus sodales ultricies</li>\r\n            <li>Vestibulum laoreet porttitor sem</li>\r\n            <li>Ac tristique libero volutpat at</li>\r\n          </ul>\r\n        </li>\r\n        <li>Faucibus porta lacus fringilla vel</li>\r\n      </ul>\r\n    </div>\r\n<div class="highlight"><pre><code class="html"><span class="nt">&lt;ul&gt;</span>\r\n  <span class="nt">&lt;li&gt;</span>...<span class="nt">&lt;/li&gt;</span>\r\n<span class="nt">&lt;/ul&gt;</span>\r\n</code></pre></div>    \r\n</div>\r\n\r\n<div class="col-xs-12 col-md-6">\r\n    <div class="page-header">\r\n        <h2 id="headings">Ordered</h2>\r\n    </div>\r\n    <div class="bs-example">\r\n      <ol>\r\n        <li>Lorem ipsum dolor sit amet</li>\r\n        <li>Consectetur adipiscing elit</li>\r\n        <li>Integer molestie lorem at massa</li>\r\n        <li>Facilisis in pretium nisl aliquet</li>\r\n        <li>Nulla volutpat aliquam velit</li>\r\n        <li>Faucibus porta lacus fringilla vel</li>\r\n        <li>Aenean sit amet erat nunc</li>\r\n        <li>Eget porttitor lorem</li>\r\n      </ol>\r\n    </div>\r\n    <div class="highlight"><pre><code class="html"><span class="nt">&lt;ol&gt;</span>\r\n  <span class="nt">&lt;li&gt;</span>...<span class="nt">&lt;/li&gt;</span>\r\n<span class="nt">&lt;/ol&gt;</span>\r\n</code></pre></div>\r\n    \r\n</div>\r\n\r\n<div class="clearfix"></div>\r\n\r\n<div class="col-xs-12 col-md-6">\r\n    <div class="page-header">\r\n        <h2 id="headings">Unstyled</h2>\r\n    </div>\r\n    <div class="bs-example">\r\n      <ul class="list-unstyled">\r\n        <li>Lorem ipsum dolor sit amet</li>          \r\n        <li>Nulla volutpat aliquam velit\r\n          <ul>\r\n            <li>Phasellus iaculis neque</li>\r\n            <li>Purus sodales ultricies</li>\r\n            <li>Vestibulum laoreet porttitor sem</li>\r\n            <li>Ac tristique libero volutpat at</li>\r\n          </ul>\r\n        </li>\r\n        <li>Faucibus porta lacus fringilla vel</li>\r\n      </ul>\r\n    </div>\r\n    <div class="highlight"><pre><code class="html"><span class="nt">&lt;ul</span> <span class="na">class=</span><span class="s">"list-unstyled"</span><span class="nt">&gt;</span>\r\n  <span class="nt">&lt;li&gt;</span>...<span class="nt">&lt;/li&gt;</span>\r\n<span class="nt">&lt;/ul&gt;</span>\r\n</code></pre></div>\r\n    \r\n</div>\r\n\r\n<div class="col-xs-12 col-md-6">\r\n    <div class="page-header">\r\n        <h2 id="headings">Inline</h2>\r\n    </div>\r\n    <div class="bs-example">\r\n      <ul class="list-inline">\r\n        <li>Lorem ipsum</li>\r\n        <li>Phasellus iaculis</li>\r\n        <li>Nulla volutpat</li>\r\n      </ul>\r\n    </div>\r\n    <div class="highlight"><pre><code class="html"><span class="nt">&lt;ul</span> <span class="na">class=</span><span class="s">"list-inline"</span><span class="nt">&gt;</span>\r\n  <span class="nt">&lt;li&gt;</span>...<span class="nt">&lt;/li&gt;</span>\r\n<span class="nt">&lt;/ul&gt;</span>\r\n</code></pre></div>\r\n    \r\n</div>\r\n\r\n<div class="clearfix"></div>\r\n\r\n\r\n<div class="col-xs-12 col-md-6">\r\n    <div class="page-header">\r\n        <h2 id="headings">Description</h2>\r\n    </div>\r\n    <div class="bs-example">\r\n      <dl>\r\n        <dt>Description lists</dt>\r\n        <dd>A description list is perfect for defining terms.</dd>\r\n        <dt>Euismod</dt>\r\n        <dd>Vestibulum id ligula porta felis euismod semper eget lacinia odio sem nec elit.</dd>\r\n        <dd>Donec id elit non mi porta gravida at eget metus.</dd>\r\n        <dt>Malesuada porta</dt>\r\n        <dd>Etiam porta sem malesuada magna mollis euismod.</dd>\r\n      </dl>\r\n    </div>\r\n    <div class="highlight"><pre><code class="html"><span class="nt">&lt;dl&gt;</span>\r\n  <span class="nt">&lt;dt&gt;</span>...<span class="nt">&lt;/dt&gt;</span>\r\n  <span class="nt">&lt;dd&gt;</span>...<span class="nt">&lt;/dd&gt;</span>\r\n<span class="nt">&lt;/dl&gt;</span>\r\n</code></pre></div>\r\n    \r\n</div>\r\n\r\n<div class="col-xs-12 col-md-6">\r\n    <div class="page-header">\r\n        <h2 id="headings">Horizontal description</h2>\r\n    </div>\r\n    <div class="bs-example">\r\n      <dl class="dl-horizontal">\r\n        <dt>Description lists</dt>\r\n        <dd>A description list is perfect for defining terms.</dd>\r\n        <dt>Euismod</dt>\r\n        <dd>Vestibulum id ligula porta felis euismod semper eget lacinia odio sem nec elit.</dd>\r\n        <dt>Malesuada porta</dt>\r\n        <dd>Etiam porta sem malesuada magna mollis euismod.</dd>\r\n        <dt>Felis euismod semper eget lacinia</dt>\r\n        <dd>Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.</dd>\r\n      </dl>\r\n    </div>\r\n    \r\n    <div class="highlight"><pre><code class="html"><span class="nt">&lt;dl</span> <span class="na">class=</span><span class="s">"dl-horizontal"</span><span class="nt">&gt;</span>\r\n  <span class="nt">&lt;dt&gt;</span>...<span class="nt">&lt;/dt&gt;</span>\r\n  <span class="nt">&lt;dd&gt;</span>...<span class="nt">&lt;/dd&gt;</span>\r\n<span class="nt">&lt;/dl&gt;</span>\r\n</code></pre></div>\r\n    \r\n</div>\r\n\r\n<div class="clearfix"></div>\r\n\r\n<div class="col-xs-12">\r\n    <div class="page-header">\r\n        <h2 id="headings">BUTTONS</h2>\r\n    </div>\r\n    <div class="bs-example">\r\n      <button type="button" class="btn btn-default">Default</button>\r\n      <button type="button" class="btn btn-primary">Primary</button>\r\n      <button type="button" class="btn btn-success">Success</button>\r\n      <button type="button" class="btn btn-info">Info</button>\r\n      <button type="button" class="btn btn-warning">Warning</button>\r\n      <button type="button" class="btn btn-danger">Danger</button>\r\n      <button type="button" class="btn btn-link">Link</button>\r\n    </div>\r\n    \r\n    <div class="highlight"><pre><code class="html"><span class="c">&lt;!-- Standard button --&gt;</span>\r\n<span class="nt">&lt;button</span> <span class="na">type=</span><span class="s">"button"</span> <span class="na">class=</span><span class="s">"btn btn-default"</span><span class="nt">&gt;</span>Default<span class="nt">&lt;/button&gt;</span>\r\n\r\n<span class="c">&lt;!-- Provides extra visual weight and identifies the primary action in a set of buttons --&gt;</span>\r\n<span class="nt">&lt;button</span> <span class="na">type=</span><span class="s">"button"</span> <span class="na">class=</span><span class="s">"btn btn-primary"</span><span class="nt">&gt;</span>Primary<span class="nt">&lt;/button&gt;</span>\r\n\r\n<span class="c">&lt;!-- Indicates a successful or positive action --&gt;</span>\r\n<span class="nt">&lt;button</span> <span class="na">type=</span><span class="s">"button"</span> <span class="na">class=</span><span class="s">"btn btn-success"</span><span class="nt">&gt;</span>Success<span class="nt">&lt;/button&gt;</span>\r\n\r\n<span class="c">&lt;!-- Contextual button for informational alert messages --&gt;</span>\r\n<span class="nt">&lt;button</span> <span class="na">type=</span><span class="s">"button"</span> <span class="na">class=</span><span class="s">"btn btn-info"</span><span class="nt">&gt;</span>Info<span class="nt">&lt;/button&gt;</span>\r\n\r\n<span class="c">&lt;!-- Indicates caution should be taken with this action --&gt;</span>\r\n<span class="nt">&lt;button</span> <span class="na">type=</span><span class="s">"button"</span> <span class="na">class=</span><span class="s">"btn btn-warning"</span><span class="nt">&gt;</span>Warning<span class="nt">&lt;/button&gt;</span>\r\n\r\n<span class="c">&lt;!-- Indicates a dangerous or potentially negative action --&gt;</span>\r\n<span class="nt">&lt;button</span> <span class="na">type=</span><span class="s">"button"</span> <span class="na">class=</span><span class="s">"btn btn-danger"</span><span class="nt">&gt;</span>Danger<span class="nt">&lt;/button&gt;</span>\r\n\r\n<span class="c">&lt;!-- Deemphasize a button by making it look like a link while maintaining button behavior --&gt;</span>\r\n<span class="nt">&lt;button</span> <span class="na">type=</span><span class="s">"button"</span> <span class="na">class=</span><span class="s">"btn btn-link"</span><span class="nt">&gt;</span>Link<span class="nt">&lt;/button&gt;</span>\r\n</code></pre></div>\r\n\r\n</div>\r\n\r\n<div class="clearfix"></div>\r\n\r\n<div class="col-xs-12">\r\n    <div class="page-header">\r\n        <h2 id="headings">Sizes</h2>\r\n    </div>\r\n    <div class="bs-example">\r\n      <p>\r\n        <button type="button" class="btn btn-primary btn-lg">Large button</button>\r\n        <button type="button" class="btn btn-default btn-lg">Large button</button>\r\n      </p>\r\n      <p>\r\n        <button type="button" class="btn btn-primary">Default button</button>\r\n        <button type="button" class="btn btn-default">Default button</button>\r\n      </p>\r\n      <p>\r\n        <button type="button" class="btn btn-primary btn-sm">Small button</button>\r\n        <button type="button" class="btn btn-default btn-sm">Small button</button>\r\n      </p>\r\n      <p>\r\n        <button type="button" class="btn btn-primary btn-xs">Extra small button</button>\r\n        <button type="button" class="btn btn-default btn-xs">Extra small button</button>\r\n      </p>\r\n    </div>    \r\n<div class="highlight"><pre><code class="html"><span class="nt">&lt;p&gt;</span>\r\n  <span class="nt">&lt;button</span> <span class="na">type=</span><span class="s">"button"</span> <span class="na">class=</span><span class="s">"btn btn-primary btn-lg"</span><span class="nt">&gt;</span>Large button<span class="nt">&lt;/button&gt;</span>\r\n  <span class="nt">&lt;button</span> <span class="na">type=</span><span class="s">"button"</span> <span class="na">class=</span><span class="s">"btn btn-default btn-lg"</span><span class="nt">&gt;</span>Large button<span class="nt">&lt;/button&gt;</span>\r\n<span class="nt">&lt;/p&gt;</span>\r\n<span class="nt">&lt;p&gt;</span>\r\n  <span class="nt">&lt;button</span> <span class="na">type=</span><span class="s">"button"</span> <span class="na">class=</span><span class="s">"btn btn-primary"</span><span class="nt">&gt;</span>Default button<span class="nt">&lt;/button&gt;</span>\r\n  <span class="nt">&lt;button</span> <span class="na">type=</span><span class="s">"button"</span> <span class="na">class=</span><span class="s">"btn btn-default"</span><span class="nt">&gt;</span>Default button<span class="nt">&lt;/button&gt;</span>\r\n<span class="nt">&lt;/p&gt;</span>\r\n<span class="nt">&lt;p&gt;</span>\r\n  <span class="nt">&lt;button</span> <span class="na">type=</span><span class="s">"button"</span> <span class="na">class=</span><span class="s">"btn btn-primary btn-sm"</span><span class="nt">&gt;</span>Small button<span class="nt">&lt;/button&gt;</span>\r\n  <span class="nt">&lt;button</span> <span class="na">type=</span><span class="s">"button"</span> <span class="na">class=</span><span class="s">"btn btn-default btn-sm"</span><span class="nt">&gt;</span>Small button<span class="nt">&lt;/button&gt;</span>\r\n<span class="nt">&lt;/p&gt;</span>\r\n<span class="nt">&lt;p&gt;</span>\r\n  <span class="nt">&lt;button</span> <span class="na">type=</span><span class="s">"button"</span> <span class="na">class=</span><span class="s">"btn btn-primary btn-xs"</span><span class="nt">&gt;</span>Extra small button<span class="nt">&lt;/button&gt;</span>\r\n  <span class="nt">&lt;button</span> <span class="na">type=</span><span class="s">"button"</span> <span class="na">class=</span><span class="s">"btn btn-default btn-xs"</span><span class="nt">&gt;</span>Extra small button<span class="nt">&lt;/button&gt;</span>\r\n<span class="nt">&lt;/p&gt;</span>\r\n</code></pre></div>    \r\n</div>\r\n\r\n\r\n<div class="clearfix"></div>\r\n\r\n<div class="col-xs-12">\r\n    <div class="page-header">\r\n        <h2 id="headings">JUMBOTRON</h2>\r\n    </div>\r\n    \r\n    <div class="bs-example">\r\n      <div class="jumbotron">\r\n        <h1>Hello, world!</h1>\r\n        <p>This is a simple hero unit, a simple jumbotron-style component for calling extra attention to featured content or information.</p>\r\n        <p><a class="btn btn-primary btn-lg" role="button">Learn more</a></p>\r\n      </div>\r\n    </div>   \r\n    \r\n    <div class="highlight"><pre><code class="html"><span class="nt">&lt;div</span> <span class="na">class=</span><span class="s">"jumbotron"</span><span class="nt">&gt;</span>\r\n  <span class="nt">&lt;h1&gt;</span>Hello, world!<span class="nt">&lt;/h1&gt;</span>\r\n  <span class="nt">&lt;p&gt;</span>...<span class="nt">&lt;/p&gt;</span>\r\n  <span class="nt">&lt;p&gt;&lt;a</span> <span class="na">class=</span><span class="s">"btn btn-primary btn-lg"</span> <span class="na">role=</span><span class="s">"button"</span><span class="nt">&gt;</span>Learn more<span class="nt">&lt;/a&gt;&lt;/p&gt;</span>\r\n<span class="nt">&lt;/div&gt;</span>\r\n</code></pre></div> \r\n    \r\n    \r\n</div>\r\n\r\n\r\n\r\n\r\n  <div class="page-header col-xs-12">\r\n    <h2 id="headings">ICONS</h2>\r\n    </div>\r\n\r\n\r\n<div class="col-xs-12">\r\n\r\n\r\n  <div id="new">\r\n  \r\n  <div class="page-header">\r\n    <h2 id="headings">New Icons</h2>\r\n</div>\r\n\r\n  \r\n\r\n  <div class="row fontawesome-icon-list">\r\n    \r\n\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-rub"></i> fa-rub</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-ruble"></i> fa-ruble</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-rouble"></i> fa-rouble</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-pagelines"></i> fa-pagelines</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-stack-exchange"></i> fa-stack-exchange</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrow-circle-o-right"></i> fa-arrow-circle-o-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrow-circle-o-left"></i> fa-arrow-circle-o-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-caret-square-o-left"></i> fa-caret-square-o-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-toggle-left"></i> fa-toggle-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-dot-circle-o"></i> fa-dot-circle-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-wheelchair"></i> fa-wheelchair</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-vimeo-square"></i> fa-vimeo-square></div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-try"></i> fa-try</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-turkish-lira"></i> fa-turkish-lira</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-plus-square-o"></i> fa-plus-square-o</div>\r\n    \r\n  </div>\r\n\r\n</div>\r\n<br>\r\n  <section id="web-application">\r\n  \r\n    <div class="page-header">\r\n    <h2 id="headings">Web Application Icons</h2>\r\n</div>\r\n\r\n\r\n  <div class="row fontawesome-icon-list">\r\n    \r\n\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-adjust"></i> fa-adjust</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-anchor"></i> fa-anchor</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-archive"></i> fa-archive</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrows"></i> fa-arrows</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrows-h"></i> fa-arrows-h</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrows-v"></i> fa-arrows-v</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-asterisk"></i> fa-asterisk</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-ban"></i> fa-ban</a></div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-bar-chart-o"></i> fa-bar-chart-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-barcode"></i> fa-barcode</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-bars"></i> fa-bars</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-beer"></i> fa-beer</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-bell"></i> fa-bell</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-bell-o"></i> fa-bell-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-bolt"></i> fa-bolt</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-book"></i> fa-book</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-bookmark"></i> fa-bookmark</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-bookmark-o"></i> fa-bookmark-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-briefcase"></i> fa-briefcase</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-bug"></i> fa-bug</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-building-o"></i> fa-building-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-bullhorn"></i> fa-bullhorn</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-bullseye"></i> fa-bullseye</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-calendar"></i> fa-calendar</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-calendar-o"></i> fa-calendar-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-camera"></i> fa-camera</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-camera-retro"></i> fa-camera-retro</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-caret-square-o-down"></i> fa-caret-square-o-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-caret-square-o-left"></i> fa-caret-square-o-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-caret-square-o-right"></i> fa-caret-square-o-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-caret-square-o-up"></i> fa-caret-square-o-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-certificate"></i> fa-certificate</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-check"></i> fa-check</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-check-circle"></i> fa-check-circle</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-check-circle-o"></i> fa-check-circle-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-check-square"></i> fa-check-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-check-square-o"></i> fa-check-square-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-circle"></i> fa-circle</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-circle-o"></i> fa-circle-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-clock-o"></i> fa-clock-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-cloud"></i> fa-cloud</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-cloud-download"></i> fa-cloud-download</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-cloud-upload"></i> fa-cloud-upload</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-code"></i> fa-code</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-code-fork"></i> fa-code-fork</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-coffee"></i> fa-coffee</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-cog"></i> fa-cog</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-cogs"></i> fa-cogs</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-comment"></i> fa-comment</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-comment-o"></i> fa-comment-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-comments"></i> fa-comments</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-comments-o"></i> fa-comments-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-compass"></i> fa-compass</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-credit-card"></i> fa-credit-card</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-crop"></i> fa-crop</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-crosshairs"></i> fa-crosshairs</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-cutlery"></i> fa-cutlery</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-dashboard"></i> fa-dashboard</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-desktop"></i> fa-desktop</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-dot-circle-o"></i> fa-dot-circle-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-download"></i> fa-download</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-edit"></i> fa-edit</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-ellipsis-h"></i> fa-ellipsis-h</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-ellipsis-v"></i> fa-ellipsis-v</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-envelope"></i> fa-envelope</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-envelope-o"></i> fa-envelope-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-eraser"></i> fa-eraser</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-exchange"></i> fa-exchange</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-exclamation"></i> fa-exclamation</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-exclamation-circle"></i> fa-exclamation-circle</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-exclamation-triangle"></i> fa-exclamation-triangle</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-external-link"></i> fa-external-link</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-external-link-square"></i> fa-external-link-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-eye"></i> fa-eye</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-eye-slash"></i> fa-eye-slash</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-female"></i> fa-female</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-fighter-jet"></i> fa-fighter-jet</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-film"></i> fa-film</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-filter"></i> fa-filter</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-fire"></i> fa-fire</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-fire-extinguisher"></i> fa-fire-extinguisher</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-flag"></i> fa-flag</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-flag-checkered"></i> fa-flag-checkered</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-flag-o"></i> fa-flag-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-flash"></i> fa-flash</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-flask"></i> fa-flask</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-folder"></i> fa-folder</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-folder-o"></i> fa-folder-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-folder-open"></i> fa-folder-open</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-folder-open-o"></i> fa-folder-open-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-frown-o"></i> fa-frown-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-gamepad"></i> fa-gamepad</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-gavel"></i> fa-gavel</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-gear"></i> fa-gear</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-gears"></i> fa-gears</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-gift"></i> fa-gift</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-glass"></i> fa-glass</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-globe"></i> fa-globe</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-group"></i> fa-group</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-hdd-o"></i> fa-hdd-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-headphones"></i> fa-headphones</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-heart"></i> fa-heart</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-heart-o"></i> fa-heart-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-home"></i> fa-home</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-inbox"></i> fa-inbox</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-info"></i> fa-info</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-info-circle"></i> fa-info-circle</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-key"></i> fa-key</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-keyboard-o"></i> fa-keyboard-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-laptop"></i> fa-laptop</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-leaf"></i> fa-leaf</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-legal"></i> fa-legal</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-lemon-o"></i> fa-lemon-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-level-down"></i> fa-level-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-level-up"></i> fa-level-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-lightbulb-o"></i> fa-lightbulb-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-location-arrow"></i> fa-location-arrow</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-lock"></i> fa-lock</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-magic"></i> fa-magic</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-magnet"></i> fa-magnet</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-mail-forward"></i> fa-mail-forward</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-mail-reply"></i> fa-mail-reply</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-mail-reply-all"></i> fa-mail-reply-all</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-male"></i> fa-male</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-map-marker"></i> fa-map-marker</a></div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-meh-o"></i> fa-meh-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-microphone"></i> fa-microphone</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-microphone-slash"></i> fa-microphone-slash</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-minus"></i> fa-minus</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-minus-circle"></i> fa-minus-circle</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-minus-square"></i> fa-minus-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-minus-square-o"></i> fa-minus-square-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-mobile"></i> fa-mobile</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-mobile-phone"></i> fa-mobile-phone</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-money"></i> fa-money</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-moon-o"></i> fa-moon-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-music"></i> fa-music</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-pencil"></i> fa-pencil</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-pencil-square"></i> fa-pencil-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-pencil-square-o"></i> fa-pencil-square-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-phone"></i> fa-phone</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-phone-square"></i> fa-phone-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-picture-o"></i> fa-picture-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-plane"></i> fa-plane</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-plus"></i> fa-plus</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-plus-circle"></i> fa-plus-circle</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-plus-square"></i> fa-plus-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-plus-square-o"></i> fa-plus-square-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-power-off"></i> fa-power-off</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-print"></i> fa-print</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-puzzle-piece"></i> fa-puzzle-piece</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-qrcode"></i> fa-qrcode</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-question"></i> fa-question</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-question-circle"></i> fa-question-circle</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-quote-left"></i> fa-quote-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-quote-right"></i> fa-quote-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-random"></i> fa-random</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-refresh"></i> fa-refresh</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-reply"></i> fa-reply</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-reply-all"></i> fa-reply-all</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-retweet"></i> fa-retweet</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-road"></i> fa-road</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-rocket"></i> fa-rocket</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-rss"></i> fa-rss</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-rss-square"></i> fa-rss-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-search"></i> fa-search</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-search-minus"></i> fa-search-minus</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-search-plus"></i> fa-search-plus</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-share"></i> fa-share</a></div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-share-square"></i> fa-share-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-share-square-o"></i> fa-share-square-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-shield"></i> fa-shield</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-shopping-cart"></i> fa-shopping-cart</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-sign-in"></i> fa-sign-in</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-sign-out"></i> fa-sign-out</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-signal"></i> fa-signal</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-sitemap"></i> fa-sitemap</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-smile-o"></i> fa-smile-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-sort"></i> fa-sort</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-sort-alpha-asc"></i> fa-sort-alpha-asc</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-sort-alpha-desc"></i> fa-sort-alpha-desc</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-sort-amount-asc"></i> fa-sort-amount-asc</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-sort-amount-desc"></i> fa-sort-amount-desc</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-sort-asc"></i> fa-sort-asc</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-sort-desc"></i> fa-sort-desc</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-sort-down"></i> fa-sort-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-sort-numeric-asc"></i> fa-sort-numeric-asc</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-sort-numeric-desc"></i> fa-sort-numeric-desc</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-sort-up"></i> fa-sort-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-spinner"></i> fa-spinner</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-square"></i> fa-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-square-o"></i> fa-square-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-star"></i> fa-star</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-star-half"></i> fa-star-half</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-star-half-empty"></i> fa-star-half-empty</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-star-half-full"></i> fa-star-half-full</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-star-half-o"></i> fa-star-half-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-star-o"></i> fa-star-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-subscript"></i> fa-subscript</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-suitcase"></i> fa-suitcase</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-sun-o"></i> fa-sun-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-superscript"></i> fa-superscript</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-tablet"></i> fa-tablet</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-tachometer"></i> fa-tachometer</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-tag"></i> fa-tag</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-tags"></i> fa-tags</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-tasks"></i> fa-tasks</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-terminal"></i> fa-terminal</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-thumb-tack"></i> fa-thumb-tack</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-thumbs-down"></i> fa-thumbs-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-thumbs-o-down"></i> fa-thumbs-o-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-thumbs-o-up"></i> fa-thumbs-o-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-thumbs-up"></i> fa-thumbs-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-ticket"></i> fa-ticket</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-times"></i> fa-times</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-times-circle"></i> fa-times-circle</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-times-circle-o"></i> fa-times-circle-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-tint"></i> fa-tint</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-toggle-down"></i> fa-toggle-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-toggle-left"></i> fa-toggle-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-toggle-right"></i> fa-toggle-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-toggle-up"></i> fa-toggle-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-trash-o"></i> fa-trash-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-trophy"></i> fa-trophy</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-truck"></i> fa-truck</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-umbrella"></i> fa-umbrella</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-unlock"></i> fa-unlock</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-unlock-alt"></i> fa-unlock-alt</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-unsorted"></i> fa-unsorted</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-upload"></i> fa-upload</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-user"></i> fa-user</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-users"></i> fa-users</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-video-camera"></i> fa-video-camera</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-volume-down"></i> fa-volume-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-volume-off"></i> fa-volume-off</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-volume-up"></i> fa-volume-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-warning"></i> fa-warning</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-wheelchair"></i> fa-wheelchair</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-wrench"></i> fa-wrench</div>\r\n    \r\n  </div>\r\n\r\n</section>\r\n<br>\r\n  <section id="form-control">\r\n  \r\n      <div class="page-header">\r\n    <h2 id="headings">Form Control Icons</h2>\r\n</div>\r\n\r\n\r\n  <div class="row fontawesome-icon-list">\r\n    \r\n\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-check-square"></i> fa-check-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-check-square-o"></i> fa-check-square-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-circle"></i> fa-circle</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-circle-o"></i> fa-circle-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-dot-circle-o"></i> fa-dot-circle-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-minus-square"></i> fa-minus-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-minus-square-o"></i> fa-minus-square-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-plus-square"></i> fa-plus-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-plus-square-o"></i> fa-plus-square-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-square"></i> fa-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-square-o"></i> fa-square-o</div>\r\n    \r\n  </div>\r\n</section>\r\n<br>\r\n  <section id="currency">\r\n  \r\n    <div class="page-header">\r\n        <h2 id="headings">Currency Icons</h2>\r\n    </div>\r\n  \r\n\r\n  <div class="row fontawesome-icon-list">\r\n    \r\n\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-bitcoin"></i> fa-bitcoin</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-btc"></i> fa-btc</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-cny"></i> fa-cny</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-dollar"></i> fa-dollar</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-eur"></i> fa-eur</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-euro"></i> fa-euro</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-gbp"></i> fa-gbp</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-inr"></i> fa-inr</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-jpy"></i> fa-jpy</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-krw"></i> fa-krw</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-money"></i> fa-money</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-rmb"></i> fa-rmb</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-rouble"></i> fa-rouble</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-rub"></i> fa-rub</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-ruble"></i> fa-ruble</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-rupee"></i> fa-rupee</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-try"></i> fa-try</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-turkish-lira"></i> fa-turkish-lira</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-usd"></i> fa-usd</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-won"></i> fa-won</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-yen"></i> fa-yen</div>\r\n    \r\n  </div>\r\n\r\n</section>\r\n<br>\r\n  <section id="text-editor">\r\n      <div class="page-header">\r\n        <h2 id="headings">Text Editor Icons</h2>\r\n    </div>\r\n\r\n  \r\n\r\n  <div class="row fontawesome-icon-list">\r\n    \r\n\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-align-center"></i> fa-align-center</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-align-justify"></i> fa-align-justify</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-align-left"></i> fa-align-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-align-right"></i> fa-align-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-bold"></i> fa-bold</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-chain"></i> fa-chain</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-chain-broken"></i> fa-chain-broken</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-clipboard"></i> fa-clipboard</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-columns"></i> fa-columns</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-copy"></i> fa-copy</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-cut"></i> fa-cut</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-dedent"></i> fa-dedent</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-eraser"></i> fa-eraser</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-file"></i> fa-file</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-file-o"></i> fa-file-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-file-text"></i> fa-file-text</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-file-text-o"></i> fa-file-text-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-files-o"></i> fa-files-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-floppy-o"></i> fa-floppy-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-font"></i> fa-font</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-indent"></i> fa-indent</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-italic"></i> fa-italic</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-link"></i> fa-link</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-list"></i> fa-list</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-list-alt"></i> fa-list-alt</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-list-ol"></i> fa-list-ol</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-list-ul"></i> fa-list-ul</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-outdent"></i> fa-outdent</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-paperclip"></i> fa-paperclip</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-paste"></i> fa-paste</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-repeat"></i> fa-repeat</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-rotate-left"></i> fa-rotate-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-rotate-right"></i> fa-rotate-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-save"></i> fa-save</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-scissors"></i> fa-scissors</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-strikethrough"></i> fa-strikethrough</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-table"></i> fa-table</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-text-height"></i> fa-text-height</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-text-width"></i> fa-text-width</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-th"></i> fa-th</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-th-large"></i> fa-th-large</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-th-list"></i> fa-th-list</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-underline"></i> fa-underline</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-undo"></i> fa-undo</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-unlink"></i> fa-unlink</div>\r\n    \r\n  </div>\r\n\r\n</section>\r\n<br>\r\n  <section id="directional">\r\n  \r\n        <div class="page-header">\r\n        <h2 id="headings">Directional Icons</h2>\r\n    </div>\r\n\r\n\r\n  <div class="row fontawesome-icon-list">\r\n    \r\n\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-angle-double-down"></i> fa-angle-double-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-angle-double-left"></i> fa-angle-double-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-angle-double-right"></i> fa-angle-double-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-angle-double-up"></i> fa-angle-double-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-angle-down"></i> fa-angle-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-angle-left"></i> fa-angle-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-angle-right"></i> fa-angle-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-angle-up"></i> fa-angle-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrow-circle-down"></i> fa-arrow-circle-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrow-circle-left"></i> fa-arrow-circle-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrow-circle-o-down"></i> fa-arrow-circle-o-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrow-circle-o-left"></i> fa-arrow-circle-o-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrow-circle-o-right"></i> fa-arrow-circle-o-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrow-circle-o-up"></i> fa-arrow-circle-o-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrow-circle-right"></i> fa-arrow-circle-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrow-circle-up"></i> fa-arrow-circle-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrow-down"></i> fa-arrow-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrow-left"></i> fa-arrow-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrow-right"></i> fa-arrow-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrow-up"></i> fa-arrow-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrows"></i> fa-arrows</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrows-alt"></i> fa-arrows-alt</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrows-h"></i> fa-arrows-h</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrows-v"></i> fa-arrows-v</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-caret-down"></i> fa-caret-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-caret-left"></i> fa-caret-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-caret-right"></i> fa-caret-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-caret-square-o-down"></i> fa-caret-square-o-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-caret-square-o-left"></i> fa-caret-square-o-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-caret-square-o-right"></i> fa-caret-square-o-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-caret-square-o-up"></i> fa-caret-square-o-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-caret-up"></i> fa-caret-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-chevron-circle-down"></i> fa-chevron-circle-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-chevron-circle-left"></i> fa-chevron-circle-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-chevron-circle-right"></i> fa-chevron-circle-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-chevron-circle-up"></i> fa-chevron-circle-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-chevron-down"></i> fa-chevron-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-chevron-left"></i> fa-chevron-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-chevron-right"></i> fa-chevron-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-chevron-up"></i> fa-chevron-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-hand-o-down"></i> fa-hand-o-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-hand-o-left"></i> fa-hand-o-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-hand-o-right"></i> fa-hand-o-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-hand-o-up"></i> fa-hand-o-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-long-arrow-down"></i> fa-long-arrow-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-long-arrow-left"></i> fa-long-arrow-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-long-arrow-right"></i> fa-long-arrow-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-long-arrow-up"></i> fa-long-arrow-up</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-toggle-down"></i> fa-toggle-down</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-toggle-left"></i> fa-toggle-left</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-toggle-right"></i> fa-toggle-right</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-toggle-up"></i> fa-toggle-up</div>\r\n    \r\n  </div>\r\n\r\n</section>\r\n\r\n<br>\r\n  <section id="video-player">\r\n  \r\n          <div class="page-header">\r\n        <h2 id="headings">Video Player Icons</h2>\r\n    </div>\r\n\r\n\r\n  <div class="row fontawesome-icon-list">\r\n    \r\n\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-arrows-alt"></i> fa-arrows-alt</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-backward"></i> fa-backward</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-compress"></i> fa-compress</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-eject"></i> fa-eject</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-expand"></i> fa-expand</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-fast-backward"></i> fa-fast-backward</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-fast-forward"></i> fa-fast-forward</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-forward"></i> fa-forward</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-pause"></i> fa-pause</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-play"></i> fa-play</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-play-circle"></i> fa-play-circle</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-play-circle-o"></i> fa-play-circle-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-step-backward"></i> fa-step-backward</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-step-forward"></i> fa-step-forward</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-stop"></i> fa-stop</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-youtube-play"></i> fa-youtube-play</div>\r\n    \r\n  </div>\r\n\r\n</section>\r\n<br>\r\n  <section id="brand">\r\n  \r\n    <div class="page-header">\r\n        <h2 id="headings">Brand Icons</h2>\r\n    </div>\r\n\r\n\r\n\r\n  <div class="row fontawesome-icon-list">\r\n    \r\n\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-adn"></i> fa-adn</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-android"></i> fa-android</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-apple"></i> fa-apple</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-bitbucket"></i> fa-bitbucket</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-bitbucket-square"></i> fa-bitbucket-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-bitcoin"></i> fa-bitcoin</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-btc"></i> fa-btc</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-css3"></i> fa-css3</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-dribbble"></i> fa-dribbble</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-dropbox"></i> fa-dropbox</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-facebook"></i> fa-facebook</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-facebook-square"></i> fa-facebook-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-flickr"></i> fa-flickr</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-foursquare"></i> fa-foursquare</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-github"></i> fa-github</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-github-alt"></i> fa-github-alt</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-github-square"></i> fa-github-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-gittip"></i> fa-gittip</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-google-plus"></i> fa-google-plus</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-google-plus-square"></i> fa-google-plus-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-html5"></i> fa-html5</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-instagram"></i> fa-instagram</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-linkedin"></i> fa-linkedin</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-linkedin-square"></i> fa-linkedin-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-linux"></i> fa-linux</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-maxcdn"></i> fa-maxcdn</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-pagelines"></i> fa-pagelines</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-pinterest"></i> fa-pinterest</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-pinterest-square"></i> fa-pinterest-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-renren"></i> fa-renren</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-skype"></i> fa-skype</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-stack-exchange"></i> fa-stack-exchange</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-stack-overflow"></i> fa-stack-overflow</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-trello"></i> fa-trello</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-tumblr"></i> fa-tumblr</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-tumblr-square"></i> fa-tumblr-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-twitter"></i> fa-twitter</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-twitter-square"></i> fa-twitter-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-vimeo-square"></i> fa-vimeo-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-vk"></i> fa-vk</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-weibo"></i> fa-weibo</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-windows"></i> fa-windows</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-xing"></i> fa-xing</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-xing-square"></i> fa-xing-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-youtube"></i> fa-youtube</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-youtube-play"></i> fa-youtube-play</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-youtube-square"></i> fa-youtube-square</div>\r\n    \r\n  </div>\r\n</section>\r\n<br>\r\n  <section id="medical">\r\n    <div class="page-header">\r\n        <h2 id="headings">Medical Icons</h2>\r\n    </div>\r\n  \r\n\r\n  <div class="row fontawesome-icon-list">\r\n    \r\n\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-ambulance"></i> fa-ambulance</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-h-square"></i> fa-h-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-hospital-o"></i> fa-hospital-o</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-medkit"></i> fa-medkit</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-plus-square"></i> fa-plus-square</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-stethoscope"></i> fa-stethoscope</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-user-md"></i> fa-user-md</div>\r\n    \r\n      <div class="fa-hover col-md-3 col-sm-4"><i class="fa fa-wheelchair"></i> fa-wheelchair</div>\r\n    \r\n  </div>\r\n\r\n</section>\r\n\r\n</div>', '', 1, 12, '2014-07-28 13:24:18', 400, '', '2014-07-28 13:26:40', 444, 0, '0000-00-00 00:00:00', '2014-07-28 13:24:18', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 2, '', '', 1, 47, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(9, 74, 'Module variations', 'module-variations', '<p> </p>\r\n<div class="page-header">\r\n<h2>How to use</h2>\r\n</div>\r\n<blockquote>\r\n  <p>Module Class Suffix is a parameter in Joomla! modules. Setting this parameter causes Joomla! to either add a new CSS class or modify the existing CSS class for the div element for this specific module.</p>\r\n  <p>To use a module variation, just enter one of the following suffixes in the <strong>Module Class Suffix</strong> field of the module parameters:</p>\r\n</blockquote>\r\n<p> </p>\r\n<blockquote>\r\n  <p>mod_dark</p>\r\n</blockquote>\r\n<blockquote>\r\n  <p>mod_blue</p>\r\n</blockquote>\r\n<blockquote>\r\n  <p>mod_orange</p>\r\n</blockquote>\r\n<blockquote>\r\n  <p>mod_green</p>\r\n</blockquote>\r\n<blockquote>\r\n  <p>mod_red</p>\r\n</blockquote>\r\n<blockquote>\r\n  <p>mod_purple</p>\r\n</blockquote>\r\n<blockquote>\r\n  <p>mn-module-light</p>\r\n</blockquote>\r\n\r\n\r\n<p> </p>\r\n<p><span class="label label-info">Heads up!</span> Make sure that you enter the suffix with a <strong>leading space</strong> otherwise the module styling will not be applied correctly.</p>\r\n<p> </p>\r\n<br>\r\n<div class="page-header">\r\n<h2>Extra suffixes</h2>\r\n</div>\r\n\r\n<blockquote>\r\n<p>no-component</p>\r\n<small>Use this suffix in a menu item to hide the component area.</small>\r\n</blockquote>\r\n<blockquote>\r\n<p>no-padding</p>\r\n<small>Use this suffix in a module to apply a padding of 0 pixels.</small>\r\n</blockquote>\r\n<blockquote>\r\n<p>no-margin</p>\r\n<small>Use this suffix in a module to apply a margin of 0 pixels.</small>\r\n</blockquote>\r\n<blockquote>\r\n<p>mn-big-header</p>\r\n<small>Use this suffix in a module to format the module title.</small>\r\n</blockquote>\r\n<blockquote>\r\n<p>formatModule</p>\r\n<small>Use this suffix to apply the default module style to a module in a spotlight position.</small>\r\n</blockquote>\r\n<blockquote>\r\n<p>mn-aboutus</p>\r\n<small>Use this suffix in a menu item to apply zero padding to the ''About us'' page.</small>\r\n</blockquote>\r\n<blockquote>\r\n<p>padding15</p>\r\n<small>Use this suffix to apply a padding of 15 pixels to a module in a sidebar position.</small>\r\n</blockquote>\r\n<p> </p>', '', 1, 12, '2014-07-28 13:24:37', 400, '', '2014-09-19 15:42:27', 400, 0, '0000-00-00 00:00:00', '2014-07-28 13:24:37', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 1, '', '', 1, 80, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(10, 77, 'Module positions', 'module-positions', '<div>\r\n	<div class="col-sm-6 bordered">\r\n		<p class="alert-info">Logo</p>\r\n	</div>\r\n		<div class="col-sm-2 bordered">\r\n		<p>search-popup</p>\r\n	</div>\r\n	<div class="col-sm-2 bordered">\r\n		<p>login-popup</p>\r\n	</div>\r\n	<div class="col-sm-2 bordered">\r\n		<p>languageswitcherload</p>\r\n	</div>\r\n</div>\r\n\r\n\r\n\r\n<div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-1</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-2</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-3</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-4</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-5</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-6</p>\r\n	</div>\r\n</div>\r\n\r\n<div>\r\n	<div class="col-xs-12 col-sm-12 bordered">\r\n		<p>mn-parallax1</p>\r\n	</div>\r\n</div>\r\n\r\n<div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-7</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-8</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-9</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-10</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-11</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-12</p>\r\n	</div>\r\n</div>\r\n\r\n<div>\r\n	<div class="col-xs-12 col-sm-12 bordered">\r\n		<p>mn-parallax2</p>\r\n	</div>\r\n</div>\r\n\r\n<div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-13</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-14</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-15</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-16</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-17</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-18</p>\r\n	</div>\r\n</div>\r\n\r\n\r\n<div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-19</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-20</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-21</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-22</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-23</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-24</p>\r\n	</div>\r\n</div>\r\n\r\n<div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-25</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-26</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-27</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-28</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-29</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-30</p>\r\n	</div>\r\n</div>\r\n\r\n<div>\r\n	<div class="col-xs-12 bordered">\r\n		<p>mn-parallax1</p>\r\n	</div>\r\n</div>\r\n\r\n<div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-31</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-32</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-33</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-34</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-35</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-36</p>\r\n	</div>\r\n</div>\r\n\r\n\r\n<div>\r\n	<div class="col-xs-12 col-sm-3 no-padding">\r\n		<div class="bordered">\r\n			<p>sidebar-1</p>\r\n		</div>\r\n	</div>\r\n\r\n	<div class="col-xs-12 col-sm-6 no-padding">\r\n		<div class="bordered">\r\n			<p>message</p>\r\n		</div>\r\n		<div class="bordered">\r\n			<p class="alert-info">component</p>\r\n		</div>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-3 no-padding">\r\n		<div class="bordered">\r\n			<p>sidebar-2</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class="clearfix"></div>\r\n\r\n<div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-37</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-38</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-39</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-40</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-41</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>position-42</p>\r\n	</div>\r\n</div>\r\n\r\n<div>\r\n	<div class="col-xs-12 bordered">\r\n		<p>navhelper</p>\r\n	</div>\r\n</div>\r\n\r\n\r\n\r\n<div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>footer-1</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>footer-2</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>footer-3</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>footer-4</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>footer-5</p>\r\n	</div>\r\n	<div class="col-xs-12 col-sm-2 bordered">\r\n		<p>footer-6</p>\r\n	</div>\r\n</div>\r\n\r\n\r\n\r\n<div>\r\n	<div class="col-xs-12 bordered">\r\n		<p>Copyright</p>\r\n	</div>\r\n</div>\r\n\r\n', '', 1, 12, '2014-07-28 13:27:54', 400, '', '2014-09-21 19:12:41', 400, 0, '0000-00-00 00:00:00', '2014-07-28 13:27:54', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 10, 0, '', '', 1, 83, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(11, 79, 'Archived Article I', 'archived-article-i', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 2, 2, '2014-07-28 14:19:45', 400, '', '2014-07-28 14:20:09', 444, 0, '0000-00-00 00:00:00', '2014-07-28 14:19:45', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 2, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(12, 80, 'Archived Article II', 'archived-article-ii', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 2, 2, '2014-07-28 14:19:45', 400, '', '2014-07-28 14:20:34', 444, 0, '0000-00-00 00:00:00', '2014-07-28 14:19:45', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 3, 1, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(13, 81, 'Archived Article III', 'archived-article-iii', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 2, 2, '2014-07-28 14:19:45', 400, '', '2014-07-28 14:21:08', 444, 0, '0000-00-00 00:00:00', '2014-07-28 14:19:45', '0000-00-00 00:00:00', '{"image_intro":"","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 2, 0, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(20, 89, 'Colors and Melodies', 'colors-and-melodies', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 10, '2014-07-28 13:21:13', 400, '', '2014-09-21 20:01:58', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:21:13', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/audio_solution\\/audio_solution.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/audio_solution\\/audio_solution.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 0, '', '', 1, 14, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(21, 90, 'A Modern Sound Approach', 'a-modern-sound-approach', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 10, '2014-07-28 13:20:56', 400, '', '2014-09-21 20:01:49', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:20:56', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/audio_solution\\/audio_solution.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/audio_solution\\/audio_solution.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 1, '', '', 1, 21, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(33, 203, 'Old School Audio', 'old-school-audio', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 10, '2014-07-28 13:20:56', 400, '', '2014-09-21 20:01:39', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:20:56', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/audio_solution\\/audio_solution.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/audio_solution\\/audio_solution.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 11, 1, '', '', 1, 19, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(34, 204, 'The Mysterious Man', 'the-mysterious-man', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 10, '2014-07-28 13:21:13', 400, '', '2014-09-21 20:01:29', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:21:13', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/audio_solution\\/audio_solution.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/audio_solution\\/audio_solution.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 12, 0, '', '', 1, 13, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(35, 224, 'Why This Commercial Became so Successful', 'why-this-commercial-became-so-successful', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 9, '2014-07-28 13:21:47', 400, '', '2014-09-21 20:03:43', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:21:47', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/commercial_services\\/commercial_services.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/commercial_services\\/commercial_services.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 0, '', '', 1, 2, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(36, 225, 'University Luggage', 'university-luggage', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 9, '2014-07-28 13:21:34', 400, '', '2014-09-21 20:03:29', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:21:34', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/commercial_services\\/commercial_services.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/commercial_services\\/commercial_services.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 10, 1, '', '', 1, 5, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(37, 226, 'The Amazing Balloons Event', 'the-amazing-balloons-event', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 18, '2014-07-28 13:21:13', 400, '', '2014-09-21 20:06:21', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:21:13', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/eventmanagment\\/eventmanagment.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/eventmanagment\\/eventmanagment.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 12, 0, '', '', 1, 12, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(38, 227, 'Managing the Next Success', 'managing-the-next-success', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 18, '2014-07-28 13:20:56', 400, '', '2014-09-21 20:06:13', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:20:56', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/eventmanagment\\/eventmanagment.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/eventmanagment\\/eventmanagment.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 13, 1, '', '', 1, 19, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(39, 228, 'Creating an Event Experience', 'creating-an-event-experience', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 18, '2014-07-28 13:20:56', 400, '', '2014-09-21 20:06:02', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:20:56', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/eventmanagment\\/eventmanagment.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/eventmanagment\\/eventmanagment.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 12, 1, '', '', 1, 20, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(40, 229, 'Communication is Always Important', 'colors-and-melodies', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 18, '2014-07-28 13:21:13', 400, '', '2014-09-21 20:05:52', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:21:13', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/eventmanagment\\/eventmanagment.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/eventmanagment\\/eventmanagment.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 10, 0, '', '', 1, 14, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(41, 230, 'The Strange Formations Music Clip', 'the-strange-formations-music-clip', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 19, '2014-07-28 13:21:34', 400, '', '2014-09-21 20:08:35', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:21:34', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/videoandmusicproduction\\/videoandmusicproduction.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/videoandmusicproduction\\/videoandmusicproduction.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 11, 1, '', '', 1, 4, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(42, 231, 'The Shipwreck Documentary', 'the-shipwreck-documentary', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 19, '2014-07-28 13:21:47', 400, '', '2014-09-21 20:08:25', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:21:47', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/videoandmusicproduction\\/videoandmusicproduction.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/videoandmusicproduction\\/videoandmusicproduction.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 11, 0, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(43, 232, 'The City in Motion', 'the-city-in-motion', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 19, '2014-07-28 13:21:47', 400, '', '2014-09-21 20:08:14', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:21:47', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/videoandmusicproduction\\/videoandmusicproduction.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/videoandmusicproduction\\/videoandmusicproduction.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 9, 0, '', '', 1, 1, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', ''),
(44, 233, 'Lost in Music Land', 'lost-in-music-land', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 19, '2014-07-28 13:21:34', 400, '', '2014-09-21 20:08:02', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:21:34', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/videoandmusicproduction\\/videoandmusicproduction.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/videoandmusicproduction\\/videoandmusicproduction.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 10, 1, '', '', 1, 5, '{"robots":"","author":"","rights":"","xreference":""}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `xreference`) VALUES
(45, 234, 'Flying On Cloudy Weather', 'flying-on-cloudy-weather', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 19, '2014-07-28 13:21:13', 400, '', '2014-09-21 20:07:50', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:21:13', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/videoandmusicproduction\\/videoandmusicproduction.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/videoandmusicproduction\\/videoandmusicproduction.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 11, 0, '', '', 1, 21, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', ''),
(46, 235, 'Cloudy and Impressive', 'cloudy-and-impressive', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', 1, 19, '2014-07-28 13:20:56', 400, '', '2014-09-21 20:07:19', 445, 0, '0000-00-00 00:00:00', '2014-07-28 13:20:56', '0000-00-00 00:00:00', '{"image_intro":"images\\/echo\\/articles\\/videoandmusicproduction\\/videoandmusicproduction.jpg","float_intro":"","image_intro_alt":"","image_intro_caption":"","image_fulltext":"images\\/echo\\/articles\\/videoandmusicproduction\\/videoandmusicproduction.jpg","float_fulltext":"","image_fulltext_alt":"","image_fulltext_caption":""}', '{"urla":false,"urlatext":"","targeta":"","urlb":false,"urlbtext":"","targetb":"","urlc":false,"urlctext":"","targetc":""}', '{"show_title":"","link_titles":"","show_tags":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_vote":"","show_hits":"","show_noauth":"","urls_position":"","alternative_readmore":"","article_layout":"","show_publishing_options":"","show_article_options":"","show_urls_images_backend":"","show_urls_images_frontend":""}', 10, 1, '', '', 1, 56, '{"robots":"","author":"","rights":"","xreference":""}', 1, '*', '');

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE IF NOT EXISTS `#__contentitem_tag_map` (
  `type_alias` varchar(255) NOT NULL DEFAULT '',
  `core_content_id` int(10) unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Maps items from content tables to tags';

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE IF NOT EXISTS `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__content_frontpage` (`content_id`, `ordering`) VALUES
(1, 8),
(2, 7),
(16, 5),
(17, 6),
(24, 3),
(25, 4),
(45, 1),
(46, 2);

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE IF NOT EXISTS `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(10) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE IF NOT EXISTS `#__content_types` (
`type_id` int(10) unsigned NOT NULL,
  `type_title` varchar(255) NOT NULL DEFAULT '',
  `type_alias` varchar(255) NOT NULL DEFAULT '',
  `table` varchar(255) NOT NULL DEFAULT '',
  `rules` text NOT NULL,
  `field_mappings` text NOT NULL,
  `router` varchar(255) NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) DEFAULT NULL COMMENT 'JSON string for com_contenthistory options'
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=16 ;

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
(1, 'Article', 'com_content.article', '{"special":{"dbtable":"#__content","key":"id","type":"Content","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"introtext", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"attribs", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"asset_id"}, "special":{"fulltext":"fulltext"}}', 'ContentHelperRoute::getArticleRoute', '{"formFile":"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml", "hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(2, 'Weblink', 'com_weblinks.weblink', '{"special":{"dbtable":"#__weblinks","key":"id","type":"Weblink","prefix":"WeblinksTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"state","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special":{}}', 'WeblinksHelperRoute::getWeblinkRoute', '{"formFile":"administrator\\/components\\/com_weblinks\\/models\\/forms\\/weblink.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","featured","images"], "ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"], "convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(3, 'Contact', 'com_contact.contact', '{"special":{"dbtable":"#__contact_details","key":"id","type":"Contact","prefix":"ContactTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"address", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"image", "core_urls":"webpage", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special":{"con_position":"con_position","suburb":"suburb","state":"state","country":"country","postcode":"postcode","telephone":"telephone","fax":"fax","misc":"misc","email_to":"email_to","default_con":"default_con","user_id":"user_id","mobile":"mobile","sortname1":"sortname1","sortname2":"sortname2","sortname3":"sortname3"}}', 'ContactHelperRoute::getContactRoute', '{"formFile":"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml","hideFields":["default_con","checked_out","checked_out_time","version","xreference"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"], "displayLookup":[ {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ] }'),
(4, 'Newsfeed', 'com_newsfeeds.newsfeed', '{"special":{"dbtable":"#__newsfeeds","key":"id","type":"Newsfeed","prefix":"NewsfeedsTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"hits","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"xreference", "asset_id":"null"}, "special":{"numarticles":"numarticles","cache_time":"cache_time","rtl":"rtl"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{"formFile":"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml","hideFields":["asset_id","checked_out","checked_out_time","version"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "hits"],"convertToInt":["publish_up", "publish_down", "featured", "ordering"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(5, 'User', 'com_users.user', '{"special":{"dbtable":"#__users","key":"id","type":"User","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"null","core_alias":"username","core_created_time":"registerdate","core_modified_time":"lastvisitDate","core_body":"null", "core_hits":"null","core_publish_up":"null","core_publish_down":"null","access":"null", "core_params":"params", "core_featured":"null", "core_metadata":"null", "core_language":"null", "core_images":"null", "core_urls":"null", "core_version":"null", "core_ordering":"null", "core_metakey":"null", "core_metadesc":"null", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}, "special":{}}', 'UsersHelperRoute::getUserRoute', ''),
(6, 'Article Category', 'com_content.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'ContentHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(7, 'Contact Category', 'com_contact.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'ContactHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(8, 'Newsfeeds Category', 'com_newsfeeds.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(9, 'Weblinks Category', 'com_weblinks.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', 'WeblinksHelperRoute::getCategoryRoute', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(10, 'Tag', 'com_tags.tag', '{"special":{"dbtable":"#__tags","key":"tag_id","type":"Tag","prefix":"TagsTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"featured", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"urls", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"null", "core_xreference":"null", "asset_id":"null"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path"}}', 'TagsHelperRoute::getTagRoute', '{"formFile":"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml", "hideFields":["checked_out","checked_out_time","version", "lft", "rgt", "level", "path", "urls", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"],"convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(11, 'Banner', 'com_banners.banner', '{"special":{"dbtable":"#__banners","key":"id","type":"Banner","prefix":"BannersTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"name","core_state":"published","core_alias":"alias","core_created_time":"created","core_modified_time":"modified","core_body":"description", "core_hits":"null","core_publish_up":"publish_up","core_publish_down":"publish_down","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"images", "core_urls":"link", "core_version":"version", "core_ordering":"ordering", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"catid", "core_xreference":"null", "asset_id":"null"}, "special":{"imptotal":"imptotal", "impmade":"impmade", "clicks":"clicks", "clickurl":"clickurl", "custombannercode":"custombannercode", "cid":"cid", "purchase_type":"purchase_type", "track_impressions":"track_impressions", "track_clicks":"track_clicks"}}', '', '{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml", "hideFields":["checked_out","checked_out_time","version", "reset"],"ignoreChanges":["modified_by", "modified", "checked_out", "checked_out_time", "version", "imptotal", "impmade", "reset"], "convertToInt":["publish_up", "publish_down", "ordering"], "displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"cid","targetTable":"#__banner_clients","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"created_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"modified_by","targetTable":"#__users","targetColumn":"id","displayColumn":"name"} ]}'),
(12, 'Banners Category', 'com_banners.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special": {"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', '', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["asset_id","checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}'),
(13, 'Banner Client', 'com_banners.client', '{"special":{"dbtable":"#__banner_clients","key":"id","type":"Client","prefix":"BannersTable"}}', '', '', '', '{"formFile":"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml", "hideFields":["checked_out","checked_out_time"], "ignoreChanges":["checked_out", "checked_out_time"], "convertToInt":[], "displayLookup":[]}'),
(14, 'User Notes', 'com_users.note', '{"special":{"dbtable":"#__user_notes","key":"id","type":"Note","prefix":"UsersTable"}}', '', '', '', '{"formFile":"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml", "hideFields":["checked_out","checked_out_time", "publish_up", "publish_down"],"ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time"], "convertToInt":["publish_up", "publish_down"],"displayLookup":[{"sourceColumn":"catid","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}, {"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}]}'),
(15, 'User Notes Category', 'com_users.category', '{"special":{"dbtable":"#__categories","key":"id","type":"Category","prefix":"JTable","config":"array()"},"common":{"dbtable":"#__ucm_content","key":"ucm_id","type":"Corecontent","prefix":"JTable","config":"array()"}}', '', '{"common":{"core_content_item_id":"id","core_title":"title","core_state":"published","core_alias":"alias","core_created_time":"created_time","core_modified_time":"modified_time","core_body":"description", "core_hits":"hits","core_publish_up":"null","core_publish_down":"null","core_access":"access", "core_params":"params", "core_featured":"null", "core_metadata":"metadata", "core_language":"language", "core_images":"null", "core_urls":"null", "core_version":"version", "core_ordering":"null", "core_metakey":"metakey", "core_metadesc":"metadesc", "core_catid":"parent_id", "core_xreference":"null", "asset_id":"asset_id"}, "special":{"parent_id":"parent_id","lft":"lft","rgt":"rgt","level":"level","path":"path","extension":"extension","note":"note"}}', '', '{"formFile":"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml", "hideFields":["checked_out","checked_out_time","version","lft","rgt","level","path","extension"], "ignoreChanges":["modified_user_id", "modified_time", "checked_out", "checked_out_time", "version", "hits", "path"], "convertToInt":["publish_up", "publish_down"], "displayLookup":[{"sourceColumn":"created_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"}, {"sourceColumn":"access","targetTable":"#__viewlevels","targetColumn":"id","displayColumn":"title"},{"sourceColumn":"modified_user_id","targetTable":"#__users","targetColumn":"id","displayColumn":"name"},{"sourceColumn":"parent_id","targetTable":"#__categories","targetColumn":"id","displayColumn":"title"}]}');

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE IF NOT EXISTS `#__core_log_searches` (
  `search_term` varchar(128) NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE IF NOT EXISTS `#__extensions` (
`extension_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `type` varchar(20) NOT NULL,
  `element` varchar(100) NOT NULL,
  `folder` varchar(100) NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '1',
  `access` int(10) unsigned NOT NULL DEFAULT '1',
  `protected` tinyint(3) NOT NULL DEFAULT '0',
  `manifest_cache` text NOT NULL,
  `params` text NOT NULL,
  `custom_data` text NOT NULL,
  `system_data` text NOT NULL,
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0'
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10030 ;

INSERT INTO `#__extensions` (`extension_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(1, 'com_mailto', 'component', 'com_mailto', '', 0, 1, 1, 1, '{"name":"com_mailto","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MAILTO_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(2, 'com_wrapper', 'component', 'com_wrapper', '', 0, 1, 1, 1, '{"name":"com_wrapper","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_WRAPPER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(3, 'com_admin', 'component', 'com_admin', '', 1, 1, 1, 1, '{"name":"com_admin","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_ADMIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(4, 'com_banners', 'component', 'com_banners', '', 1, 1, 1, 0, '{"name":"com_banners","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_BANNERS_XML_DESCRIPTION","group":""}', '{"purchase_type":"3","track_impressions":"0","track_clicks":"0","metakey_prefix":"","save_history":"1","history_limit":10}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(5, 'com_cache', 'component', 'com_cache', '', 1, 1, 1, 1, '{"name":"com_cache","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CACHE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(6, 'com_categories', 'component', 'com_categories', '', 1, 1, 1, 1, '{"name":"com_categories","type":"component","creationDate":"December 2007","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CATEGORIES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(7, 'com_checkin', 'component', 'com_checkin', '', 1, 1, 1, 1, '{"name":"com_checkin","type":"component","creationDate":"Unknown","author":"Joomla! Project","copyright":"(C) 2005 - 2008 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CHECKIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(8, 'com_contact', 'component', 'com_contact', '', 1, 1, 1, 0, '{"name":"com_contact","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTACT_XML_DESCRIPTION","group":""}', '{"show_contact_category":"hide","save_history":"1","history_limit":10,"show_contact_list":"0","presentation_style":"sliders","show_name":"1","show_position":"1","show_email":"0","show_street_address":"1","show_suburb":"1","show_state":"1","show_postcode":"1","show_country":"1","show_telephone":"1","show_mobile":"1","show_fax":"1","show_webpage":"1","show_misc":"1","show_image":"1","image":"","allow_vcard":"0","show_articles":"0","show_profile":"0","show_links":"0","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","contact_icons":"0","icon_address":"","icon_email":"","icon_telephone":"","icon_mobile":"","icon_fax":"","icon_misc":"","show_headings":"1","show_position_headings":"1","show_email_headings":"0","show_telephone_headings":"1","show_mobile_headings":"0","show_fax_headings":"0","allow_vcard_headings":"0","show_suburb_headings":"1","show_state_headings":"1","show_country_headings":"1","show_email_form":"1","show_email_copy":"1","banned_email":"","banned_subject":"","banned_text":"","validate_session":"1","custom_reply":"0","redirect":"","show_category_crumb":"0","metakey":"","metadesc":"","robots":"","author":"","rights":"","xreference":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(9, 'com_cpanel', 'component', 'com_cpanel', '', 1, 1, 1, 1, '{"name":"com_cpanel","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CPANEL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10, 'com_installer', 'component', 'com_installer', '', 1, 1, 1, 1, '{"name":"com_installer","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_INSTALLER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(11, 'com_languages', 'component', 'com_languages', '', 1, 1, 1, 1, '{"name":"com_languages","type":"component","creationDate":"2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LANGUAGES_XML_DESCRIPTION","group":""}', '{"administrator":"en-GB","site":"en-GB"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(12, 'com_login', 'component', 'com_login', '', 1, 1, 1, 1, '{"name":"com_login","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(13, 'com_media', 'component', 'com_media', '', 1, 1, 0, 1, '{"name":"com_media","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MEDIA_XML_DESCRIPTION","group":""}', '{"upload_extensions":"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,swf,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,SWF,TXT,XCF,XLS","upload_maxsize":"10","file_path":"images","image_path":"images","restrict_uploads":"1","allowed_media_usergroup":"3","check_mime":"1","image_extensions":"bmp,gif,jpg,png","ignore_extensions":"","upload_mime":"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/x-shockwave-flash,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip","upload_mime_illegal":"text\\/html"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(14, 'com_menus', 'component', 'com_menus', '', 1, 1, 1, 1, '{"name":"com_menus","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MENUS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(15, 'com_messages', 'component', 'com_messages', '', 1, 1, 1, 1, '{"name":"com_messages","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MESSAGES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(16, 'com_modules', 'component', 'com_modules', '', 1, 1, 1, 1, '{"name":"com_modules","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_MODULES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(17, 'com_newsfeeds', 'component', 'com_newsfeeds', '', 1, 1, 1, 0, '{"name":"com_newsfeeds","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_NEWSFEEDS_XML_DESCRIPTION","group":""}', '{"newsfeed_layout":"_:default","save_history":"1","history_limit":5,"show_feed_image":"1","show_feed_description":"1","show_item_description":"1","feed_character_count":"0","feed_display_order":"des","float_first":"right","float_second":"right","show_tags":"1","category_layout":"_:default","show_category_title":"1","show_description":"1","show_description_image":"1","maxLevel":"-1","show_empty_categories":"0","show_subcat_desc":"1","show_cat_items":"1","show_cat_tags":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_items_cat":"1","filter_field":"1","show_pagination_limit":"1","show_headings":"1","show_articles":"0","show_link":"1","show_pagination":"1","show_pagination_results":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(18, 'com_plugins', 'component', 'com_plugins', '', 1, 1, 1, 1, '{"name":"com_plugins","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_PLUGINS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(19, 'com_search', 'component', 'com_search', '', 1, 1, 1, 0, '{"name":"com_search","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_SEARCH_XML_DESCRIPTION","group":""}', '{"enabled":"0","show_date":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(20, 'com_templates', 'component', 'com_templates', '', 1, 1, 1, 1, '{"name":"com_templates","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_TEMPLATES_XML_DESCRIPTION","group":""}', '{"template_positions_display":"1","upload_limit":"2","image_formats":"gif,bmp,jpg,jpeg,png","source_formats":"txt,less,ini,xml,js,php,css","font_formats":"woff,ttf,otf","compressed_formats":"zip"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(21, 'com_weblinks', 'component', 'com_weblinks', '', 1, 1, 1, 0, '{"name":"com_weblinks","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\n\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_WEBLINKS_XML_DESCRIPTION","group":""}', '{"target":"0","save_history":"1","history_limit":5,"count_clicks":"1","icons":1,"link_icons":"","float_first":"right","float_second":"right","show_tags":"1","category_layout":"_:default","show_category_title":"1","show_description":"1","show_description_image":"1","maxLevel":"-1","show_empty_categories":"0","show_subcat_desc":"1","show_cat_num_links":"1","show_cat_tags":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_num_links_cat":"1","filter_field":"1","show_pagination_limit":"1","show_headings":"0","show_link_description":"1","show_link_hits":"1","show_pagination":"2","show_pagination_results":"1","show_feed_link":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(22, 'com_content', 'component', 'com_content', '', 1, 1, 0, 1, '{"name":"com_content","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONTENT_XML_DESCRIPTION","group":""}', '{"article_layout":"_:default","show_title":"1","link_titles":"1","show_intro":"1","info_block_position":"0","show_category":"1","link_category":"1","show_parent_category":"0","link_parent_category":"0","show_author":"1","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"1","show_item_navigation":"1","show_vote":"0","show_readmore":"1","show_readmore_title":"1","readmore_limit":"100","show_tags":"1","show_icons":"1","show_print_icon":"1","show_email_icon":"1","show_hits":"1","show_noauth":"0","urls_position":"0","show_publishing_options":"1","show_article_options":"1","save_history":"1","history_limit":0,"show_urls_images_frontend":"0","show_urls_images_backend":"1","targeta":0,"targetb":0,"targetc":0,"float_intro":"left","float_fulltext":"left","category_layout":"_:blog","show_category_heading_title_text":"1","show_category_title":"0","show_description":"0","show_description_image":"0","maxLevel":"1","show_empty_categories":"0","show_no_articles":"1","show_subcat_desc":"1","show_cat_num_articles":"0","show_cat_tags":"1","show_base_description":"1","maxLevelcat":"-1","show_empty_categories_cat":"0","show_subcat_desc_cat":"1","show_cat_num_articles_cat":"1","num_leading_articles":"1","num_intro_articles":"4","num_columns":"2","num_links":"4","multi_column_order":"0","show_subcategory_content":"0","show_pagination_limit":"1","filter_field":"hide","show_headings":"1","list_show_date":"0","date_format":"","list_show_hits":"1","list_show_author":"1","orderby_pri":"order","orderby_sec":"rdate","order_date":"published","show_pagination":"2","show_pagination_results":"1","show_feed_link":"1","feed_summary":"0","feed_show_readmore":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(23, 'com_config', 'component', 'com_config', '', 1, 1, 0, 1, '{"name":"com_config","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_CONFIG_XML_DESCRIPTION","group":""}', '{"filters":{"1":{"filter_type":"NH","filter_tags":"","filter_attributes":""},"9":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"6":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"7":{"filter_type":"NONE","filter_tags":"","filter_attributes":""},"2":{"filter_type":"NH","filter_tags":"","filter_attributes":""},"3":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"4":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"5":{"filter_type":"BL","filter_tags":"","filter_attributes":""},"8":{"filter_type":"NONE","filter_tags":"","filter_attributes":""}}}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(24, 'com_redirect', 'component', 'com_redirect', '', 1, 1, 0, 1, '{"name":"com_redirect","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_REDIRECT_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(25, 'com_users', 'component', 'com_users', '', 1, 1, 0, 1, '{"name":"com_users","type":"component","creationDate":"April 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_USERS_XML_DESCRIPTION","group":""}', '{"allowUserRegistration":"1","new_usertype":"2","guest_usergroup":"9","sendpassword":"1","useractivation":"1","mail_to_admin":"0","captcha":"","frontend_userparams":"1","site_language":"0","change_login_name":"0","reset_count":"10","reset_time":"1","minimum_length":"4","minimum_integers":"0","minimum_symbols":"0","minimum_uppercase":"0","save_history":"1","history_limit":5,"mailSubjectPrefix":"","mailBodySuffix":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(27, 'com_finder', 'component', 'com_finder', '', 1, 1, 0, 0, '{"name":"com_finder","type":"component","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_FINDER_XML_DESCRIPTION","group":""}', '{"show_description":"1","description_length":255,"allow_empty_query":"0","show_url":"1","show_advanced":"1","expand_advanced":"0","show_date_filters":"0","highlight_terms":"1","opensearch_name":"","opensearch_description":"","batch_size":"50","memory_table_limit":30000,"title_multiplier":"1.7","text_multiplier":"0.7","meta_multiplier":"1.2","path_multiplier":"2.0","misc_multiplier":"0.3","stemmer":"snowball"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(28, 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', 1, 1, 0, 1, '{"name":"com_joomlaupdate","type":"component","creationDate":"February 2012","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.\\t","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"COM_JOOMLAUPDATE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(29, 'com_tags', 'component', 'com_tags', '', 1, 1, 1, 1, '{"name":"com_tags","type":"component","creationDate":"December 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"COM_TAGS_XML_DESCRIPTION","group":""}', '{"tag_layout":"_:default","save_history":"1","history_limit":5,"show_tag_title":"0","tag_list_show_tag_image":"0","tag_list_show_tag_description":"0","tag_list_image":"","show_tag_num_items":"0","tag_list_orderby":"title","tag_list_orderby_direction":"ASC","show_headings":"0","tag_list_show_date":"0","tag_list_show_item_image":"0","tag_list_show_item_description":"0","tag_list_item_maximum_characters":0,"return_any_or_all":"1","include_children":"0","maximum":200,"tag_list_language_filter":"all","tags_layout":"_:default","all_tags_orderby":"title","all_tags_orderby_direction":"ASC","all_tags_show_tag_image":"0","all_tags_show_tag_descripion":"0","all_tags_tag_maximum_characters":20,"all_tags_show_tag_hits":"0","filter_field":"1","show_pagination_limit":"1","show_pagination":"2","show_pagination_results":"1","tag_field_ajax_mode":"1","show_feed_link":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(30, 'com_contenthistory', 'component', 'com_contenthistory', '', 1, 1, 1, 0, '{"name":"com_contenthistory","type":"component","creationDate":"May 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_CONTENTHISTORY_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(31, 'com_ajax', 'component', 'com_ajax', '', 1, 1, 1, 0, '{"name":"com_ajax","type":"component","creationDate":"August 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_AJAX_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(32, 'com_postinstall', 'component', 'com_postinstall', '', 1, 1, 1, 1, '{"name":"com_postinstall","type":"component","creationDate":"September 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"COM_POSTINSTALL_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(100, 'PHPMailer', 'library', 'phpmailer', '', 0, 1, 1, 1, '{"name":"PHPMailer","type":"library","creationDate":"2001","author":"PHPMailer","copyright":"(c) 2001-2003, Brent R. Matzelle, (c) 2004-2009, Andy Prevost. All Rights Reserved., (c) 2010-2013, Jim Jagielski. All Rights Reserved.","authorEmail":"jimjag@gmail.com","authorUrl":"https:\\/\\/github.com\\/PHPMailer\\/PHPMailer","version":"5.2.6","description":"LIB_PHPMAILER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(101, 'SimplePie', 'library', 'simplepie', '', 0, 1, 1, 1, '{"name":"SimplePie","type":"library","creationDate":"2004","author":"SimplePie","copyright":"Copyright (c) 2004-2009, Ryan Parman and Geoffrey Sneddon","authorEmail":"","authorUrl":"http:\\/\\/simplepie.org\\/","version":"1.2","description":"LIB_SIMPLEPIE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(102, 'phputf8', 'library', 'phputf8', '', 0, 1, 1, 1, '{"name":"phputf8","type":"library","creationDate":"2006","author":"Harry Fuecks","copyright":"Copyright various authors","authorEmail":"hfuecks@gmail.com","authorUrl":"http:\\/\\/sourceforge.net\\/projects\\/phputf8","version":"0.5","description":"LIB_PHPUTF8_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(103, 'Joomla! Platform', 'library', 'joomla', '', 0, 1, 1, 1, '{"name":"Joomla! Platform","type":"library","creationDate":"2008","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"http:\\/\\/www.joomla.org","version":"13.1","description":"LIB_JOOMLA_XML_DESCRIPTION","group":""}', '{"mediaversion":"c8c68607b8c861e0cae1f8898be16b79"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(104, 'IDNA Convert', 'library', 'idna_convert', '', 0, 1, 1, 1, '{"name":"IDNA Convert","type":"library","creationDate":"2004","author":"phlyLabs","copyright":"2004-2011 phlyLabs Berlin, http:\\/\\/phlylabs.de","authorEmail":"phlymail@phlylabs.de","authorUrl":"http:\\/\\/phlylabs.de","version":"0.8.0","description":"LIB_IDNA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(105, 'FOF', 'library', 'fof', '', 0, 1, 1, 1, '{"name":"FOF","type":"library","creationDate":"2014-03-09 12:54:48","author":"Nicholas K. Dionysopoulos \\/ Akeeba Ltd","copyright":"(C)2011-2014 Nicholas K. Dionysopoulos","authorEmail":"nicholas@akeebabackup.com","authorUrl":"https:\\/\\/www.akeebabackup.com","version":"2.2.1","description":"LIB_FOF_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(106, 'PHPass', 'library', 'phpass', '', 0, 1, 1, 1, '{"name":"PHPass","type":"library","creationDate":"2004-2006","author":"Solar Designer","copyright":"","authorEmail":"solar@openwall.com","authorUrl":"http:\\/\\/www.openwall.com\\/phpass\\/","version":"0.3","description":"LIB_PHPASS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(200, 'mod_articles_archive', 'module', 'mod_articles_archive', '', 0, 1, 1, 0, '{"name":"mod_articles_archive","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters.\\n\\t\\tAll rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(201, 'mod_articles_latest', 'module', 'mod_articles_latest', '', 0, 1, 1, 0, '{"name":"mod_articles_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_NEWS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(202, 'mod_articles_popular', 'module', 'mod_articles_popular', '', 0, 1, 1, 0, '{"name":"mod_articles_popular","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(203, 'mod_banners', 'module', 'mod_banners', '', 0, 1, 1, 0, '{"name":"mod_banners","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BANNERS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(204, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', 0, 1, 1, 1, '{"name":"mod_breadcrumbs","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_BREADCRUMBS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(205, 'mod_custom', 'module', 'mod_custom', '', 0, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(206, 'mod_feed', 'module', 'mod_feed', '', 0, 1, 1, 0, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(207, 'mod_footer', 'module', 'mod_footer', '', 0, 1, 1, 0, '{"name":"mod_footer","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FOOTER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(208, 'mod_login', 'module', 'mod_login', '', 0, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(209, 'mod_menu', 'module', 'mod_menu', '', 0, 1, 1, 1, '{"name":"mod_menu","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(210, 'mod_articles_news', 'module', 'mod_articles_news', '', 0, 1, 1, 0, '{"name":"mod_articles_news","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_NEWS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(211, 'mod_random_image', 'module', 'mod_random_image', '', 0, 1, 1, 0, '{"name":"mod_random_image","type":"module","creationDate":"July 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RANDOM_IMAGE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(212, 'mod_related_items', 'module', 'mod_related_items', '', 0, 1, 1, 0, '{"name":"mod_related_items","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_RELATED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(213, 'mod_search', 'module', 'mod_search', '', 0, 1, 1, 0, '{"name":"mod_search","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SEARCH_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(214, 'mod_stats', 'module', 'mod_stats', '', 0, 1, 1, 0, '{"name":"mod_stats","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(215, 'mod_syndicate', 'module', 'mod_syndicate', '', 0, 1, 1, 1, '{"name":"mod_syndicate","type":"module","creationDate":"May 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SYNDICATE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(216, 'mod_users_latest', 'module', 'mod_users_latest', '', 0, 1, 1, 0, '{"name":"mod_users_latest","type":"module","creationDate":"December 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_USERS_LATEST_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(217, 'mod_weblinks', 'module', 'mod_weblinks', '', 0, 1, 1, 0, '{"name":"mod_weblinks","type":"module","creationDate":"July 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WEBLINKS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(218, 'mod_whosonline', 'module', 'mod_whosonline', '', 0, 1, 1, 0, '{"name":"mod_whosonline","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WHOSONLINE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(219, 'mod_wrapper', 'module', 'mod_wrapper', '', 0, 1, 1, 0, '{"name":"mod_wrapper","type":"module","creationDate":"October 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_WRAPPER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(220, 'mod_articles_category', 'module', 'mod_articles_category', '', 0, 1, 1, 0, '{"name":"mod_articles_category","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(221, 'mod_articles_categories', 'module', 'mod_articles_categories', '', 0, 1, 1, 0, '{"name":"mod_articles_categories","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(222, 'mod_languages', 'module', 'mod_languages', '', 0, 1, 1, 1, '{"name":"mod_languages","type":"module","creationDate":"February 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LANGUAGES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(223, 'mod_finder', 'module', 'mod_finder', '', 0, 1, 0, 0, '{"name":"mod_finder","type":"module","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FINDER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(300, 'mod_custom', 'module', 'mod_custom', '', 1, 1, 1, 1, '{"name":"mod_custom","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_CUSTOM_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(301, 'mod_feed', 'module', 'mod_feed', '', 1, 1, 1, 0, '{"name":"mod_feed","type":"module","creationDate":"July 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_FEED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(302, 'mod_latest', 'module', 'mod_latest', '', 1, 1, 1, 0, '{"name":"mod_latest","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LATEST_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(303, 'mod_logged', 'module', 'mod_logged', '', 1, 1, 1, 0, '{"name":"mod_logged","type":"module","creationDate":"January 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGGED_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(304, 'mod_login', 'module', 'mod_login', '', 1, 1, 1, 1, '{"name":"mod_login","type":"module","creationDate":"March 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_LOGIN_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(305, 'mod_menu', 'module', 'mod_menu', '', 1, 1, 1, 0, '{"name":"mod_menu","type":"module","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MENU_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(307, 'mod_popular', 'module', 'mod_popular', '', 1, 1, 1, 0, '{"name":"mod_popular","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_POPULAR_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(308, 'mod_quickicon', 'module', 'mod_quickicon', '', 1, 1, 1, 1, '{"name":"mod_quickicon","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_QUICKICON_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(309, 'mod_status', 'module', 'mod_status', '', 1, 1, 1, 0, '{"name":"mod_status","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATUS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(310, 'mod_submenu', 'module', 'mod_submenu', '', 1, 1, 1, 0, '{"name":"mod_submenu","type":"module","creationDate":"Feb 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_SUBMENU_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(311, 'mod_title', 'module', 'mod_title', '', 1, 1, 1, 0, '{"name":"mod_title","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TITLE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(312, 'mod_toolbar', 'module', 'mod_toolbar', '', 1, 1, 1, 1, '{"name":"mod_toolbar","type":"module","creationDate":"Nov 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_TOOLBAR_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(313, 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', 1, 1, 1, 0, '{"name":"mod_multilangstatus","type":"module","creationDate":"September 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_MULTILANGSTATUS_XML_DESCRIPTION","group":""}', '{"cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(314, 'mod_version', 'module', 'mod_version', '', 1, 1, 1, 0, '{"name":"mod_version","type":"module","creationDate":"January 2012","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_VERSION_XML_DESCRIPTION","group":""}', '{"format":"short","product":"1","cache":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(315, 'mod_stats_admin', 'module', 'mod_stats_admin', '', 1, 1, 1, 0, '{"name":"mod_stats_admin","type":"module","creationDate":"July 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"MOD_STATS_XML_DESCRIPTION","group":""}', '{"serverinfo":"0","siteinfo":"0","counter":"0","increase":"0","cache":"1","cache_time":"900","cachemode":"static"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(316, 'mod_tags_popular', 'module', 'mod_tags_popular', '', 0, 1, 1, 0, '{"name":"mod_tags_popular","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_POPULAR_XML_DESCRIPTION","group":""}', '{"maximum":"5","timeframe":"alltime","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(317, 'mod_tags_similar', 'module', 'mod_tags_similar', '', 0, 1, 1, 0, '{"name":"mod_tags_similar","type":"module","creationDate":"January 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.1.0","description":"MOD_TAGS_SIMILAR_XML_DESCRIPTION","group":""}', '{"maximum":"5","matchtype":"any","owncache":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(400, 'plg_authentication_gmail', 'plugin', 'gmail', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_gmail","type":"plugin","creationDate":"February 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_GMAIL_XML_DESCRIPTION","group":""}', '{"applysuffix":"0","suffix":"","verifypeer":"1","user_blacklist":""}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(401, 'plg_authentication_joomla', 'plugin', 'joomla', 'authentication', 0, 1, 1, 1, '{"name":"plg_authentication_joomla","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(402, 'plg_authentication_ldap', 'plugin', 'ldap', 'authentication', 0, 0, 1, 0, '{"name":"plg_authentication_ldap","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LDAP_XML_DESCRIPTION","group":""}', '{"host":"","port":"389","use_ldapV3":"0","negotiate_tls":"0","no_referrals":"0","auth_method":"bind","base_dn":"","search_string":"","users_dn":"","username":"admin","password":"bobby7","ldap_fullname":"fullName","ldap_email":"mail","ldap_uid":"uid"}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(403, 'plg_content_contact', 'plugin', 'contact', 'content', 0, 1, 1, 0, '{"name":"plg_content_contact","type":"plugin","creationDate":"January 2014","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.2","description":"PLG_CONTENT_CONTACT_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(404, 'plg_content_emailcloak', 'plugin', 'emailcloak', 'content', 0, 1, 1, 0, '{"name":"plg_content_emailcloak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION","group":""}', '{"mode":"1"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(406, 'plg_content_loadmodule', 'plugin', 'loadmodule', 'content', 0, 1, 1, 0, '{"name":"plg_content_loadmodule","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOADMODULE_XML_DESCRIPTION","group":""}', '{"style":"xhtml"}', '', '', 0, '2011-09-18 15:22:50', 0, 0),
(407, 'plg_content_pagebreak', 'plugin', 'pagebreak', 'content', 0, 1, 1, 0, '{"name":"plg_content_pagebreak","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION","group":""}', '{"title":"1","multipage_toc":"1","showall":"1"}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(408, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', 'content', 0, 1, 1, 0, '{"name":"plg_content_pagenavigation","type":"plugin","creationDate":"January 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_PAGENAVIGATION_XML_DESCRIPTION","group":""}', '{"position":"1"}', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(409, 'plg_content_vote', 'plugin', 'vote', 'content', 0, 1, 1, 0, '{"name":"plg_content_vote","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_VOTE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(410, 'plg_editors_codemirror', 'plugin', 'codemirror', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_codemirror","type":"plugin","creationDate":"28 March 2011","author":"Marijn Haverbeke","copyright":"","authorEmail":"N\\/A","authorUrl":"","version":"3.15","description":"PLG_CODEMIRROR_XML_DESCRIPTION","group":""}', '{"lineNumbers":"1","lineWrapping":"1","matchTags":"1","matchBrackets":"1","marker-gutter":"1","autoCloseTags":"1","autoCloseBrackets":"1","autoFocus":"1","theme":"default","tabmode":"indent"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(411, 'plg_editors_none', 'plugin', 'none', 'editors', 0, 1, 1, 1, '{"name":"plg_editors_none","type":"plugin","creationDate":"August 2004","author":"Unknown","copyright":"","authorEmail":"N\\/A","authorUrl":"","version":"3.0.0","description":"PLG_NONE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(412, 'plg_editors_tinymce', 'plugin', 'tinymce', 'editors', 0, 1, 1, 0, '{"name":"plg_editors_tinymce","type":"plugin","creationDate":"2005-2014","author":"Moxiecode Systems AB","copyright":"Moxiecode Systems AB","authorEmail":"N\\/A","authorUrl":"tinymce.moxiecode.com","version":"4.1.2","description":"PLG_TINY_XML_DESCRIPTION","group":""}', '{"mode":"1","skin":"0","mobile":"0","entity_encoding":"raw","lang_mode":"1","text_direction":"ltr","content_css":"1","content_css_custom":"","relative_urls":"1","newlines":"0","invalid_elements":"script,applet,iframe","extended_elements":"","html_height":"550","html_width":"750","resizing":"1","element_path":"1","fonts":"1","paste":"1","searchreplace":"1","insertdate":"1","colors":"1","table":"1","smilies":"1","hr":"1","link":"1","media":"1","print":"1","directionality":"1","fullscreen":"1","alignment":"1","visualchars":"1","visualblocks":"1","nonbreaking":"1","template":"1","blockquote":"1","wordcount":"1","advlist":"1","autosave":"1","contextmenu":"1","inlinepopups":"1","custom_plugin":"","custom_button":""}', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(413, 'plg_editors-xtd_article', 'plugin', 'article', 'editors-xtd', 0, 1, 1, 1, '{"name":"plg_editors-xtd_article","type":"plugin","creationDate":"October 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_ARTICLE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(414, 'plg_editors-xtd_image', 'plugin', 'image', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_image","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_IMAGE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(415, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_pagebreak","type":"plugin","creationDate":"August 2004","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(416, 'plg_editors-xtd_readmore', 'plugin', 'readmore', 'editors-xtd', 0, 1, 1, 0, '{"name":"plg_editors-xtd_readmore","type":"plugin","creationDate":"March 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_READMORE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0);
INSERT INTO `#__extensions` (`extension_id`, `name`, `type`, `element`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `system_data`, `checked_out`, `checked_out_time`, `ordering`, `state`) VALUES
(417, 'plg_search_categories', 'plugin', 'categories', 'search', 0, 1, 1, 0, '{"name":"plg_search_categories","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(418, 'plg_search_contacts', 'plugin', 'contacts', 'search', 0, 1, 1, 0, '{"name":"plg_search_contacts","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTACTS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(419, 'plg_search_content', 'plugin', 'content', 'search', 0, 1, 1, 0, '{"name":"plg_search_content","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_CONTENT_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(420, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', 'search', 0, 1, 1, 0, '{"name":"plg_search_newsfeeds","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_NEWSFEEDS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(421, 'plg_search_weblinks', 'plugin', 'weblinks', 'search', 0, 1, 1, 0, '{"name":"plg_search_weblinks","type":"plugin","creationDate":"November 2005","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_WEBLINKS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","search_content":"1","search_archived":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(422, 'plg_system_languagefilter', 'plugin', 'languagefilter', 'system', 0, 0, 1, 1, '{"name":"plg_system_languagefilter","type":"plugin","creationDate":"July 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(423, 'plg_system_p3p', 'plugin', 'p3p', 'system', 0, 1, 1, 0, '{"name":"plg_system_p3p","type":"plugin","creationDate":"September 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_P3P_XML_DESCRIPTION","group":""}', '{"headers":"NOI ADM DEV PSAi COM NAV OUR OTRo STP IND DEM"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(424, 'plg_system_cache', 'plugin', 'cache', 'system', 0, 0, 1, 1, '{"name":"plg_system_cache","type":"plugin","creationDate":"February 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CACHE_XML_DESCRIPTION","group":""}', '{"browsercache":"0","cachetime":"15"}', '', '', 0, '0000-00-00 00:00:00', 9, 0),
(425, 'plg_system_debug', 'plugin', 'debug', 'system', 0, 1, 1, 0, '{"name":"plg_system_debug","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_DEBUG_XML_DESCRIPTION","group":""}', '{"profile":"1","queries":"1","memory":"1","language_files":"1","language_strings":"1","strip-first":"1","strip-prefix":"","strip-suffix":""}', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(426, 'plg_system_log', 'plugin', 'log', 'system', 0, 1, 1, 1, '{"name":"plg_system_log","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_LOG_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(427, 'plg_system_redirect', 'plugin', 'redirect', 'system', 0, 0, 1, 1, '{"name":"plg_system_redirect","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_REDIRECT_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 6, 0),
(428, 'plg_system_remember', 'plugin', 'remember', 'system', 0, 1, 1, 1, '{"name":"plg_system_remember","type":"plugin","creationDate":"April 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_REMEMBER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(429, 'plg_system_sef', 'plugin', 'sef', 'system', 0, 1, 1, 0, '{"name":"plg_system_sef","type":"plugin","creationDate":"December 2007","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEF_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 8, 0),
(430, 'plg_system_logout', 'plugin', 'logout', 'system', 0, 1, 1, 1, '{"name":"plg_system_logout","type":"plugin","creationDate":"April 2009","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(431, 'plg_user_contactcreator', 'plugin', 'contactcreator', 'user', 0, 0, 1, 0, '{"name":"plg_user_contactcreator","type":"plugin","creationDate":"August 2009","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTACTCREATOR_XML_DESCRIPTION","group":""}', '{"autowebpage":"","category":"34","autopublish":"0"}', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(432, 'plg_user_joomla', 'plugin', 'joomla', 'user', 0, 1, 1, 0, '{"name":"plg_user_joomla","type":"plugin","creationDate":"December 2006","author":"Joomla! Project","copyright":"(C) 2005 - 2009 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_JOOMLA_XML_DESCRIPTION","group":""}', '{"strong_passwords":"1","autoregister":"1"}', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(433, 'plg_user_profile', 'plugin', 'profile', 'user', 0, 0, 1, 0, '{"name":"plg_user_profile","type":"plugin","creationDate":"January 2008","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_USER_PROFILE_XML_DESCRIPTION","group":""}', '{"register-require_address1":"1","register-require_address2":"1","register-require_city":"1","register-require_region":"1","register-require_country":"1","register-require_postal_code":"1","register-require_phone":"1","register-require_website":"1","register-require_favoritebook":"1","register-require_aboutme":"1","register-require_tos":"1","register-require_dob":"1","profile-require_address1":"1","profile-require_address2":"1","profile-require_city":"1","profile-require_region":"1","profile-require_country":"1","profile-require_postal_code":"1","profile-require_phone":"1","profile-require_website":"1","profile-require_favoritebook":"1","profile-require_aboutme":"1","profile-require_tos":"1","profile-require_dob":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(434, 'plg_extension_joomla', 'plugin', 'joomla', 'extension', 0, 1, 1, 1, '{"name":"plg_extension_joomla","type":"plugin","creationDate":"May 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(435, 'plg_content_joomla', 'plugin', 'joomla', 'content', 0, 1, 1, 0, '{"name":"plg_content_joomla","type":"plugin","creationDate":"November 2010","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(436, 'plg_system_languagecode', 'plugin', 'languagecode', 'system', 0, 0, 1, 0, '{"name":"plg_system_languagecode","type":"plugin","creationDate":"November 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 10, 0),
(437, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', 'quickicon', 0, 1, 1, 1, '{"name":"plg_quickicon_joomlaupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(438, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', 'quickicon', 0, 1, 1, 1, '{"name":"plg_quickicon_extensionupdate","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(439, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', 'captcha', 0, 0, 1, 0, '{"name":"plg_captcha_recaptcha","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION","group":""}', '{"public_key":"","private_key":"","theme":"clean"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(440, 'plg_system_highlight', 'plugin', 'highlight', 'system', 0, 1, 1, 0, '{"name":"plg_system_highlight","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 7, 0),
(441, 'plg_content_finder', 'plugin', 'finder', 'content', 0, 0, 1, 0, '{"name":"plg_content_finder","type":"plugin","creationDate":"December 2011","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_CONTENT_FINDER_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(442, 'plg_finder_categories', 'plugin', 'categories', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_categories","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CATEGORIES_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 1, 0),
(443, 'plg_finder_contacts', 'plugin', 'contacts', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_contacts","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTACTS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 2, 0),
(444, 'plg_finder_content', 'plugin', 'content', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_content","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_CONTENT_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 3, 0),
(445, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_newsfeeds","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 4, 0),
(446, 'plg_finder_weblinks', 'plugin', 'weblinks', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_weblinks","type":"plugin","creationDate":"August 2011","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_WEBLINKS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 5, 0),
(447, 'plg_finder_tags', 'plugin', 'tags', 'finder', 0, 1, 1, 0, '{"name":"plg_finder_tags","type":"plugin","creationDate":"February 2013","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_FINDER_TAGS_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(448, 'plg_twofactorauth_totp', 'plugin', 'totp', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_totp","type":"plugin","creationDate":"August 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(449, 'plg_authentication_cookie', 'plugin', 'cookie', 'authentication', 0, 1, 1, 0, '{"name":"plg_authentication_cookie","type":"plugin","creationDate":"July 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_AUTH_COOKIE_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(450, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', 'twofactorauth', 0, 0, 1, 0, '{"name":"plg_twofactorauth_yubikey","type":"plugin","creationDate":"September 2013","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.2.0","description":"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(451, 'plg_search_tags', 'plugin', 'tags', 'search', 0, 1, 1, 0, '{"name":"plg_search_tags","type":"plugin","creationDate":"March 2014","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.0.0","description":"PLG_SEARCH_TAGS_XML_DESCRIPTION","group":""}', '{"search_limit":"50","show_tagged_items":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(503, 'beez3', 'template', 'beez3', '', 0, 1, 1, 0, '{"name":"beez3","type":"template","creationDate":"25 November 2009","author":"Angie Radtke","copyright":"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.","authorEmail":"a.radtke@derauftritt.de","authorUrl":"http:\\/\\/www.der-auftritt.de","version":"3.1.0","description":"TPL_BEEZ3_XML_DESCRIPTION","group":""}', '{"wrapperSmall":"53","wrapperLarge":"72","sitetitle":"","sitedescription":"","navposition":"center","templatecolor":"nature"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(504, 'hathor', 'template', 'hathor', '', 1, 1, 1, 0, '{"name":"hathor","type":"template","creationDate":"May 2010","author":"Andrea Tarr","copyright":"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.","authorEmail":"hathor@tarrconsulting.com","authorUrl":"http:\\/\\/www.tarrconsulting.com","version":"3.0.0","description":"TPL_HATHOR_XML_DESCRIPTION","group":""}', '{"showSiteName":"0","colourChoice":"0","boldText":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(506, 'protostar', 'template', 'protostar', '', 0, 1, 1, 0, '{"name":"protostar","type":"template","creationDate":"4\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_PROTOSTAR_XML_DESCRIPTION","group":""}', '{"templateColor":"","logoFile":"","googleFont":"1","googleFontName":"Open+Sans","fluidContainer":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(507, 'isis', 'template', 'isis', '', 1, 1, 1, 0, '{"name":"isis","type":"template","creationDate":"3\\/30\\/2012","author":"Kyle Ledbetter","copyright":"Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"","version":"1.0","description":"TPL_ISIS_XML_DESCRIPTION","group":""}', '{"templateColor":"","logoFile":""}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(600, 'English (United Kingdom)', 'language', 'en-GB', '', 0, 1, 1, 1, '{"name":"English (United Kingdom)","type":"language","creationDate":"2013-03-07","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.3.1","description":"en-GB site language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(601, 'English (United Kingdom)', 'language', 'en-GB', '', 1, 1, 1, 1, '{"name":"English (United Kingdom)","type":"language","creationDate":"2013-03-07","author":"Joomla! Project","copyright":"Copyright (C) 2005 - 2014 Open Source Matters. All rights reserved.","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.3.1","description":"en-GB administrator language","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(700, 'files_joomla', 'file', 'joomla', '', 0, 1, 1, 1, '{"name":"files_joomla","type":"file","creationDate":"July 2014","author":"Joomla! Project","copyright":"(C) 2005 - 2014 Open Source Matters. All rights reserved","authorEmail":"admin@joomla.org","authorUrl":"www.joomla.org","version":"3.3.3","description":"FILES_JOOMLA_XML_DESCRIPTION","group":""}', '', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10000, 'T3 Framework', 'plugin', 't3', 'system', 0, 1, 1, 0, '{"name":"T3 Framework","type":"plugin","creationDate":"Sep 05, 2014","author":"JoomlArt.com","copyright":"Copyright (C) 2005 - 2013 Open Source Matters. All rights reserved.","authorEmail":"info@joomlart.com","authorUrl":"http:\\/\\/www.t3-framework.org","version":"2.3.2","description":"\\n\\t\\n\\t<div align=\\"center\\">\\n\\t\\t<div class=\\"alert alert-success\\" style=\\"background-color:#DFF0D8;border-color:#D6E9C6;color: #468847;padding: 1px 0;\\">\\n\\t\\t\\t\\t<a href=\\"http:\\/\\/t3-framework.org\\/\\"><img src=\\"http:\\/\\/joomlart.s3.amazonaws.com\\/images\\/jat3v3-documents\\/message-installation\\/logo.png\\" alt=\\"some_text\\" width=\\"300\\" height=\\"99\\"><\\/a>\\n\\t\\t\\t\\t<h4><a href=\\"http:\\/\\/t3-framework.org\\/\\" title=\\"\\">Home<\\/a> | <a href=\\"http:\\/\\/demo.t3-framework.org\\/\\" title=\\"\\">Demo<\\/a> | <a href=\\"http:\\/\\/t3-framework.org\\/documentation\\" title=\\"\\">Document<\\/a> | <a href=\\"https:\\/\\/github.com\\/t3framework\\/t3\\/blob\\/master\\/CHANGELOG.md\\" title=\\"\\">Changelog<\\/a><\\/h4>\\n\\t\\t<p> <\\/p>\\n\\t\\t<p>Copyright 2004 - 2014 <a href=''http:\\/\\/www.joomlart.com\\/'' title=''Visit Joomlart.com!''>JoomlArt.com<\\/a>.<\\/p>\\n\\t\\t<\\/div>\\n     <style>table.adminform{width: 100%;}<\\/style>\\n\\t <\\/div>\\n\\t\\t\\n\\t","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10002, 'com_k2', 'component', 'com_k2', '', 1, 1, 0, 0, '{"name":"COM_K2","type":"component","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"Thank you for installing K2 by JoomlaWorks, the powerful content extension for Joomla!","group":""}', '{"enable_css":"1","jQueryHandling":"1.8remote","backendJQueryHandling":"remote","userName":"1","userImage":"1","userDescription":"1","userURL":"1","userEmail":"0","userFeedLink":"1","userFeedIcon":"1","userItemCount":"10","userItemTitle":"1","userItemTitleLinked":"1","userItemDateCreated":"1","userItemImage":"1","userItemIntroText":"1","userItemCategory":"1","userItemTags":"1","userItemCommentsAnchor":"1","userItemReadMore":"1","userItemK2Plugins":"1","tagItemCount":"10","tagItemTitle":"1","tagItemTitleLinked":"1","tagItemDateCreated":"1","tagItemImage":"1","tagItemIntroText":"1","tagItemCategory":"1","tagItemReadMore":"1","tagItemExtraFields":"0","tagOrdering":"","tagFeedLink":"1","tagFeedIcon":"1","genericItemCount":"10","genericItemTitle":"1","genericItemTitleLinked":"1","genericItemDateCreated":"1","genericItemImage":"1","genericItemIntroText":"1","genericItemCategory":"1","genericItemReadMore":"1","genericItemExtraFields":"0","genericFeedLink":"1","genericFeedIcon":"1","feedLimit":"10","feedItemImage":"1","feedImgSize":"S","feedItemIntroText":"1","feedTextWordLimit":"","feedItemFullText":"1","feedItemTags":"0","feedItemVideo":"0","feedItemGallery":"0","feedItemAttachments":"0","feedBogusEmail":"","introTextCleanup":"0","introTextCleanupExcludeTags":"","introTextCleanupTagAttr":"","fullTextCleanup":"0","fullTextCleanupExcludeTags":"","fullTextCleanupTagAttr":"","xssFiltering":"0","linkPopupWidth":"900","linkPopupHeight":"600","imagesQuality":"100","itemImageXS":"120","itemImageS":"365","itemImageM":"550","itemImageL":"828","itemImageXL":"1120","itemImageGeneric":"848","catImageWidth":"538","catImageDefault":"1","userImageWidth":"100","userImageDefault":"1","commenterImgWidth":"48","onlineImageEditor":"splashup","imageTimestamp":"0","imageMemoryLimit":"","socialButtonCode":"","twitterUsername":"","facebookImage":"Medium","comments":"1","commentsOrdering":"DESC","commentsLimit":"10","commentsFormPosition":"below","commentsPublishing":"1","commentsReporting":"2","commentsReportRecipient":"","inlineCommentsModeration":"0","gravatar":"1","antispam":"0","recaptchaForRegistered":"1","akismetForRegistered":"1","commentsFormNotes":"1","commentsFormNotesText":"","frontendEditing":"1","showImageTab":"1","showImageGalleryTab":"1","showVideoTab":"1","showExtraFieldsTab":"1","showAttachmentsTab":"1","showK2Plugins":"1","sideBarDisplayFrontend":"0","mergeEditors":"1","sideBarDisplay":"1","attachmentsFolder":"","hideImportButton":"0","googleSearch":"0","googleSearchContainer":"k2GoogleSearchContainer","K2UserProfile":"0","redirect":"101","adminSearch":"simple","cookieDomain":"","taggingSystem":"1","lockTags":"0","showTagFilter":"0","k2TagNorm":"0","k2TagNormCase":"lower","k2TagNormAdditionalReplacements":"","recaptcha_public_key":"admin","recaptcha_private_key":"4683","recaptcha_theme":"clean","recaptchaOnRegistration":"0","akismetApiKey":"","stopForumSpam":"0","stopForumSpamApiKey":"","showItemsCounterAdmin":"1","showChildCatItems":"1","disableCompactOrdering":"0","metaDescLimit":"150","enforceSEFReplacements":"0","SEFReplacements":"\\u00c0|A, \\u00c1|A, \\u00c2|A, \\u00c3|A, \\u00c4|A, \\u00c5|A, \\u00e0|a, \\u00e1|a, \\u00e2|a, \\u00e3|a, \\u00e4|a, \\u00e5|a, \\u0100|A, \\u0101|a, \\u0102|A, \\u0103|a, \\u0104|A, \\u0105|a, \\u00c7|C, \\u00e7|c, \\u0106|C, \\u0107|c, \\u0108|C, \\u0109|c, \\u010a|C, \\u010b|c, \\u010c|C, \\u010d|c, \\u00d0|D, \\u00f0|d, \\u010e|D, \\u010f|d, \\u0110|D, \\u0111|d, \\u00c8|E, \\u00c9|E, \\u00ca|E, \\u00cb|E, \\u00e8|e, \\u00e9|e, \\u00ea|e, \\u00eb|e, \\u0112|E, \\u0113|e, \\u0114|E, \\u0115|e, \\u0116|E, \\u0117|e, \\u0118|E, \\u0119|e, \\u011a|E, \\u011b|e, \\u011c|G, \\u011d|g, \\u011e|G, \\u011f|g, \\u0120|G, \\u0121|g, \\u0122|G, \\u0123|g, \\u0124|H, \\u0125|h, \\u0126|H, \\u0127|h, \\u00cc|I, \\u00cd|I, \\u00ce|I, \\u00cf|I, \\u00ec|i, \\u00ed|i, \\u00ee|i, \\u00ef|i, \\u0128|I, \\u0129|i, \\u012a|I, \\u012b|i, \\u012c|I, \\u012d|i, \\u012e|I, \\u012f|i, \\u0130|I, \\u0131|i, \\u0134|J, \\u0135|j, \\u0136|K, \\u0137|k, \\u0138|k, \\u0139|L, \\u013a|l, \\u013b|L, \\u013c|l, \\u013d|L, \\u013e|l, \\u013f|L, \\u0140|l, \\u0141|L, \\u0142|l, \\u00d1|N, \\u00f1|n, \\u0143|N, \\u0144|n, \\u0145|N, \\u0146|n, \\u0147|N, \\u0148|n, \\u0149|n, \\u014a|N, \\u014b|n, \\u00d2|O, \\u00d3|O, \\u00d4|O, \\u00d5|O, \\u00d6|O, \\u00d8|O, \\u00f2|o, \\u00f3|o, \\u00f4|o, \\u00f5|o, \\u00f6|o, \\u00f8|o, \\u014c|O, \\u014d|o, \\u014e|O, \\u014f|o, \\u0150|O, \\u0151|o, \\u0154|R, \\u0155|r, \\u0156|R, \\u0157|r, \\u0158|R, \\u0159|r, \\u015a|S, \\u015b|s, \\u015c|S, \\u015d|s, \\u015e|S, \\u015f|s, \\u0160|S, \\u0161|s, \\u017f|s, \\u0162|T, \\u0163|t, \\u0164|T, \\u0165|t, \\u0166|T, \\u0167|t, \\u00d9|U, \\u00da|U, \\u00db|U, \\u00dc|U, \\u00f9|u, \\u00fa|u, \\u00fb|u, \\u00fc|u, \\u0168|U, \\u0169|u, \\u016a|U, \\u016b|u, \\u016c|U, \\u016d|u, \\u016e|U, \\u016f|u, \\u0170|U, \\u0171|u, \\u0172|U, \\u0173|u, \\u0174|W, \\u0175|w, \\u00dd|Y, \\u00fd|y, \\u00ff|y, \\u0176|Y, \\u0177|y, \\u0178|Y, \\u0179|Z, \\u017a|z, \\u017b|Z, \\u017c|z, \\u017d|Z, \\u017e|z, \\u03b1|a, \\u03b2|b, \\u03b3|g, \\u03b4|d, \\u03b5|e, \\u03b6|z, \\u03b7|h, \\u03b8|th, \\u03b9|i, \\u03ba|k, \\u03bb|l, \\u03bc|m, \\u03bd|n, \\u03be|x, \\u03bf|o, \\u03c0|p, \\u03c1|r, \\u03c3|s, \\u03c4|t, \\u03c5|y, \\u03c6|f, \\u03c7|ch, \\u03c8|ps, \\u03c9|w, \\u0391|A, \\u0392|B, \\u0393|G, \\u0394|D, \\u0395|E, \\u0396|Z, \\u0397|H, \\u0398|Th, \\u0399|I, \\u039a|K, \\u039b|L, \\u039c|M, \\u039e|X, \\u039f|O, \\u03a0|P, \\u03a1|R, \\u03a3|S, \\u03a4|T, \\u03a5|Y, \\u03a6|F, \\u03a7|Ch, \\u03a8|Ps, \\u03a9|W, \\u03ac|a, \\u03ad|e, \\u03ae|h, \\u03af|i, \\u03cc|o, \\u03cd|y, \\u03ce|w, \\u0386|A, \\u0388|E, \\u0389|H, \\u038a|I, \\u038c|O, \\u038e|Y, \\u038f|W, \\u03ca|i, \\u0390|i, \\u03cb|y, \\u03c2|s, \\u0410|A, \\u04d0|A, \\u04d2|A, \\u04d8|E, \\u04da|E, \\u04d4|E, \\u0411|B, \\u0412|V, \\u0413|G, \\u0490|G, \\u0403|G, \\u0492|G, \\u04f6|G, y|Y, \\u0414|D, \\u0415|E, \\u0400|E, \\u0401|YO, \\u04d6|E, \\u04bc|E, \\u04be|E, \\u0404|YE, \\u0416|ZH, \\u04c1|DZH, \\u0496|ZH, \\u04dc|DZH, \\u0417|Z, \\u0498|Z, \\u04de|DZ, \\u04e0|DZ, \\u0405|DZ, \\u0418|I, \\u040d|I, \\u04e4|I, \\u04e2|I, \\u0406|I, \\u0407|JI, \\u04c0|I, \\u0419|Y, \\u048a|Y, \\u0408|J, \\u041a|K, \\u049a|Q, \\u049e|Q, \\u04a0|K, \\u04c3|Q, \\u049c|K, \\u041b|L, \\u04c5|L, \\u0409|L, \\u041c|M, \\u04cd|M, \\u041d|N, \\u04c9|N, \\u04a2|N, \\u04c7|N, \\u04a4|N, \\u040a|N, \\u041e|O, \\u04e6|O, \\u04e8|O, \\u04ea|O, \\u04a8|O, \\u041f|P, \\u04a6|PF, \\u0420|P, \\u048e|P, \\u0421|S, \\u04aa|S, \\u0422|T, \\u04ac|TH, \\u040b|T, \\u040c|K, \\u0423|U, \\u040e|U, \\u04f2|U, \\u04f0|U, \\u04ee|U, \\u04ae|U, \\u04b0|U, \\u0424|F, \\u0425|H, \\u04b2|H, \\u04ba|H, \\u0426|TS, \\u04b4|TS, \\u0427|CH, \\u04f4|CH, \\u04b6|CH, \\u04cb|CH, \\u04b8|CH, \\u040f|DZ, \\u0428|SH, \\u0429|SHT, \\u042a|A, \\u042b|Y, \\u04f8|Y, \\u042c|Y, \\u048c|Y, \\u042d|E, \\u04ec|E, \\u042e|YU, \\u042f|YA, \\u0430|a, \\u04d1|a, \\u04d3|a, \\u04d9|e, \\u04db|e, \\u04d5|e, \\u0431|b, \\u0432|v, \\u0433|g, \\u0491|g, \\u0453|g, \\u0493|g, \\u04f7|g, y|y, \\u0434|d, \\u0435|e, \\u0450|e, \\u0451|yo, \\u04d7|e, \\u04bd|e, \\u04bf|e, \\u0454|ye, \\u0436|zh, \\u04c2|dzh, \\u0497|zh, \\u04dd|dzh, \\u0437|z, \\u0499|z, \\u04df|dz, \\u04e1|dz, \\u0455|dz, \\u0438|i, \\u045d|i, \\u04e5|i, \\u04e3|i, \\u0456|i, \\u0457|ji, \\u04c0|i, \\u0439|y, \\u048b|y, \\u0458|j, \\u043a|k, \\u049b|q, \\u049f|q, \\u04a1|k, \\u04c4|q, \\u049d|k, \\u043b|l, \\u04c6|l, \\u0459|l, \\u043c|m, \\u04ce|m, \\u043d|n, \\u04ca|n, \\u04a3|n, \\u04c8|n, \\u04a5|n, \\u045a|n, \\u043e|o, \\u04e7|o, \\u04e9|o, \\u04eb|o, \\u04a9|o, \\u043f|p, \\u04a7|pf, \\u0440|p, \\u048f|p, \\u0441|s, \\u04ab|s, \\u0442|t, \\u04ad|th, \\u045b|t, \\u045c|k, \\u0443|u, \\u045e|u, \\u04f3|u, \\u04f1|u, \\u04ef|u, \\u04af|u, \\u04b1|u, \\u0444|f, \\u0445|h, \\u04b3|h, \\u04bb|h, \\u0446|ts, \\u04b5|ts, \\u0447|ch, \\u04f5|ch, \\u04b7|ch, \\u04cc|ch, \\u04b9|ch, \\u045f|dz, \\u0448|sh, \\u0449|sht, \\u044a|a, \\u044b|y, \\u04f9|y, \\u044c|y, \\u048d|y, \\u044d|e, \\u04ed|e, \\u044e|yu, \\u044f|ya","k2Sef":"0","k2SefLabelCat":"content","k2SefLabelTag":"tag","k2SefLabelUser":"author","k2SefLabelSearch":"search","k2SefLabelDate":"date","k2SefLabelItem":"0","k2SefLabelItemCustomPrefix":"","k2SefInsertItemId":"1","k2SefItemIdTitleAliasSep":"dash","k2SefUseItemTitleAlias":"1","k2SefInsertCatId":"1","k2SefCatIdTitleAliasSep":"dash","k2SefUseCatTitleAlias":"1","sh404SefLabelCat":"","sh404SefLabelUser":"blog","sh404SefLabelItem":"2","sh404SefTitleAlias":"alias","sh404SefModK2ContentFeedAlias":"feed","sh404SefInsertItemId":"0","sh404SefInsertUniqueItemId":"0","cbIntegration":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10003, 'plg_finder_k2', 'plugin', 'k2', 'finder', 0, 0, 1, 0, '{"name":"plg_finder_k2","type":"plugin","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"PLG_FINDER_K2_DESCRIPTION","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10004, 'Search - K2', 'plugin', 'k2', 'search', 0, 1, 1, 0, '{"name":"Search - K2","type":"plugin","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_THIS_PLUGIN_EXTENDS_THE_DEFAULT_JOOMLA_SEARCH_FUNCTIONALITY_TO_K2_CONTENT","group":""}', '{"search_limit":"50","search_tags":"0"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10005, 'System - K2', 'plugin', 'k2', 'system', 0, 1, 1, 0, '{"name":"System - K2","type":"plugin","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_THE_K2_SYSTEM_PLUGIN_IS_USED_TO_ASSIST_THE_PROPER_FUNCTIONALITY_OF_THE_K2_COMPONENT_SITE_WIDE_MAKE_SURE_ITS_ALWAYS_PUBLISHED_WHEN_THE_K2_COMPONENT_IS_INSTALLED","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10006, 'User - K2', 'plugin', 'k2', 'user', 0, 1, 1, 0, '{"name":"User - K2","type":"plugin","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_A_USER_SYNCHRONIZATION_PLUGIN_FOR_K2","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10007, 'Josetta - K2 Categories', 'plugin', 'k2category', 'josetta_ext', 0, 1, 1, 0, '{"name":"Josetta - K2 Categories","type":"plugin","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10008, 'Josetta - K2 Items', 'plugin', 'k2item', 'josetta_ext', 0, 1, 1, 0, '{"name":"Josetta - K2 Items","type":"plugin","creationDate":"June 7th, 2012","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10009, 'K2 Comments', 'module', 'mod_k2_comments', '', 0, 1, 0, 0, '{"name":"K2 Comments","type":"module","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"MOD_K2_COMMENTS_DESCRIPTION","group":""}', '{"moduleclass_sfx":"","module_usage":"","":"K2_TOP_COMMENTERS","catfilter":"0","category_id":"","comments_limit":"5","comments_word_limit":"10","commenterName":"1","commentAvatar":"1","commentAvatarWidthSelect":"custom","commentAvatarWidth":"50","commentDate":"1","commentDateFormat":"absolute","commentLink":"1","itemTitle":"1","itemCategory":"1","feed":"1","commenters_limit":"5","commenterNameOrUsername":"1","commenterAvatar":"1","commenterAvatarWidthSelect":"custom","commenterAvatarWidth":"50","commenterLink":"1","commenterCommentsCounter":"1","commenterLatestComment":"1","cache":"1","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10010, 'K2 Content', 'module', 'mod_k2_content', '', 0, 1, 0, 0, '{"name":"K2 Content","type":"module","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_MOD_K2_CONTENT_DESCRIPTION","group":""}', '{"moduleclass_sfx":"","getTemplate":"Default","source":"filter","":"K2_OTHER_OPTIONS","catfilter":"0","category_id":"","getChildren":"0","itemCount":"5","itemsOrdering":"","FeaturedItems":"1","popularityRange":"","videosOnly":"0","item":"","items":"","itemTitle":"1","itemAuthor":"1","itemAuthorAvatar":"1","itemAuthorAvatarWidthSelect":"custom","itemAuthorAvatarWidth":"50","userDescription":"1","itemIntroText":"1","itemIntroTextWordLimit":"","itemImage":"1","itemImgSize":"Small","itemVideo":"1","itemVideoCaption":"1","itemVideoCredits":"1","itemAttachments":"1","itemTags":"1","itemCategory":"1","itemDateCreated":"1","itemHits":"1","itemReadMore":"1","itemExtraFields":"0","itemCommentsCounter":"1","feed":"1","itemPreText":"","itemCustomLink":"0","itemCustomLinkTitle":"","itemCustomLinkURL":"http:\\/\\/","itemCustomLinkMenuItem":"","K2Plugins":"1","JPlugins":"1","cache":"1","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10011, 'K2 Tools', 'module', 'mod_k2_tools', '', 0, 1, 0, 0, '{"name":"K2 Tools","type":"module","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_TOOLS","group":""}', '{"moduleclass_sfx":"","module_usage":"0","":"K2_CUSTOM_CODE_SETTINGS","archiveItemsCounter":"1","archiveCategory":"","authors_module_category":"","authorItemsCounter":"1","authorAvatar":"1","authorAvatarWidthSelect":"custom","authorAvatarWidth":"50","authorLatestItem":"1","calendarCategory":"","home":"","seperator":"","root_id":"","end_level":"","categoriesListOrdering":"","categoriesListItemsCounter":"1","root_id2":"","catfilter":"0","category_id":"","getChildren":"0","liveSearch":"","width":"20","text":"","button":"","imagebutton":"","button_text":"","min_size":"75","max_size":"300","cloud_limit":"30","cloud_category":"0","cloud_category_recursive":"0","customCode":"","parsePhp":"0","K2Plugins":"0","JPlugins":"0","cache":"1","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10012, 'K2 Users', 'module', 'mod_k2_users', '', 0, 1, 0, 0, '{"name":"K2 Users","type":"module","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_MOD_K2_USERS_DESCRTIPTION","group":""}', '{"moduleclass_sfx":"","getTemplate":"Default","source":"0","":"K2_DISPLAY_OPTIONS","filter":"1","K2UserGroup":"","ordering":"1","limit":"4","userIDs":"","userName":"1","userAvatar":"1","userAvatarWidthSelect":"custom","userAvatarWidth":"50","userDescription":"1","userDescriptionWordLimit":"","userURL":"1","userEmail":"0","userFeed":"1","userItemCount":"1","cache":"1","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10013, 'K2 User', 'module', 'mod_k2_user', '', 0, 1, 0, 0, '{"name":"K2 User","type":"module","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_MOD_K2_USER_DESCRIPTION","group":""}', '{"moduleclass_sfx":"","pretext":"","":"K2_LOGIN_LOGOUT_REDIRECTION","name":"1","userAvatar":"1","userAvatarWidthSelect":"custom","userAvatarWidth":"50","menu":"","login":"","logout":"","usesecure":"0","cache":"0","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10014, 'K2 Quick Icons (admin)', 'module', 'mod_k2_quickicons', '', 1, 1, 2, 0, '{"name":"K2 Quick Icons (admin)","type":"module","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_QUICKICONS_FOR_USE_IN_THE_JOOMLA_CONTROL_PANEL_DASHBOARD_PAGE","group":""}', '{"modCSSStyling":"1","modLogo":"1","cache":"0","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10015, 'K2 Stats (admin)', 'module', 'mod_k2_stats', '', 1, 1, 2, 0, '{"name":"K2 Stats (admin)","type":"module","creationDate":"February 28th, 2014","author":"JoomlaWorks","copyright":"Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.","authorEmail":"please-use-the-contact-form@joomlaworks.net","authorUrl":"www.joomlaworks.net","version":"2.6.8","description":"K2_STATS_FOR_USE_IN_THE_K2_DASHBOARD_PAGE","group":""}', '{"latestItems":"1","popularItems":"1","mostCommentedItems":"1","latestComments":"1","statistics":"1","cache":"0","cache_time":"900"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10018, 'Newsticker for K2', 'module', 'mod_newsticker_for_k2', '', 0, 1, 0, 0, '{"name":"Newsticker for K2","type":"module","creationDate":"February 2014","author":"Minitek.gr","copyright":"Copyright (C) 2011-2014 Minitek.gr. All rights reserved.","authorEmail":"info@minitek.gr","authorUrl":"www.minitek.gr","version":"3.0.1","description":"\\n\\t\\n\\t\\t<div style=''text-align: left;''>\\n\\t\\t  \\t<h1>Newsticker for K2<\\/h1>\\n\\t\\t\\n\\t\\t  \\t<h3>Features<\\/h3>\\n\\t\\t\\t\\n\\t\\t\\t<ul class=\\"list-style\\">\\n\\t\\t\\t\\t<li>Compatible with Joomla! 2.5 & 3.x and K2 2.6+<\\/li>\\n\\t\\t\\t\\t<li>Cross-browser support<\\/li>\\t\\n\\t\\t\\t<\\/ul>\\n\\t\\t\\t\\n\\t\\t\\t<h3>Version<\\/h3>\\n\\t\\t\\t\\n\\t\\t\\t<p>Your current version is 3.0.1. Check out the <a target=\\"_blank\\" href=\\"http:\\/\\/www.minitek.gr\\/joomla-extensions\\/k2\\/newsticker-for-k2\\">latest version<\\/a>.<\\/p>\\n\\t\\t\\t\\n\\t\\t\\t<h3>Support<\\/h3>\\n\\t\\t\\t\\n\\t\\t\\t<p>If you need support just head to our forum: <a target=\\"_blank\\" href=\\"http:\\/\\/www.minitek.gr\\/support\\/forum.html\\">Minitek Support Forum<\\/a>.<\\/p>\\n\\t\\t\\t\\n\\t\\t\\t<br>\\t\\n\\t\\t<\\/div>\\n\\t\\t\\n\\t\\t\\n  ","group":""}', '{"moduleclass_sfx":"","auto_module_id":"1","custom_module_id":"","slider_count":"12","data_source":"k2_categories","catfilter":"1","category_id":"","getChildren":"0","add_k2_items":"","k2_items":"","k2_tags":"","exclude_k2_items":"","FeaturedItems":"featured_show","popularityRange":"","videosOnly":"0","items_order":"","title_limit":"10","titleText":"Breaking News","displayType":"reveal","speed":"0.10","pauseOnItems":"2000","fadeInSpeed":"600","fadeOutSpeed":"300","load_jquery":"0","enable_cache":"0","cache_time":"30"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10024, 'Echo', 'template', 'echo', '', 0, 1, 1, 0, '{"name":"Echo","type":"template","creationDate":"22 September 2014","author":"minitek.gr","copyright":"Copyright (C), Minitek. All Rights Reserved.","authorEmail":"info@minitek.gr","authorUrl":"http:\\/\\/www.minitek.gr","version":"3.0.1","description":"\\n\\t\\t<div align=\\"center\\">\\n\\t\\t\\t<div class=\\"alert alert-success\\" style=\\"background-color:#edf4ff;border-color:#a0c7ff;color: #468847;padding: 10px;\\">\\n\\t\\t\\t<h4><a href=\\"http:\\/\\/www.minitek.gr\\/\\" title=\\"\\">Home<\\/a> | <a href=\\"http:\\/\\/demo.minitek.gr\\/joomla-templates\\/echo\\" title=\\"\\">Demo<\\/a> | <a href=\\"http:\\/\\/www.minitek.gr\\/support\\/documentation\\/joomla-templates\\" title=\\"\\">Documentation<\\/a><\\/h4>\\n\\t\\t\\t<p> <\\/p>\\n\\t\\t\\t<span style=\\"color:#FF0000\\">Note: Echo requires T3 plugin to be installed and enabled.<\\/span><p><\\/p>\\n\\t\\t\\t<p>Copyright 2011 - 2013 <a href=''http:\\/\\/www.minitek.gr\\/'' title=''Visit minitek.gr!''>Minitek.gr<\\/a>.<\\/p>\\n\\t\\t\\t<\\/div>\\n\\t\\t\\t<style>table.adminform{width: 100%;}<\\/style>\\n\\t\\t\\t<\\/div>\\n\\t","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10027, 'minitekwall', 'component', 'com_minitekwall', '', 1, 1, 0, 0, '{"name":"Minitek Wall","type":"component","creationDate":"April 2014","author":"Minitek","copyright":"Copyright (c) 2011-2014 Minitek. All rights reserved.","authorEmail":"","authorUrl":"http:\\/\\/www.minitek.gr\\/","version":"3.0.2","description":"\\n\\t\\n\\t\\t<h1>Minitek Wall<\\/h1>\\n\\t\\t<p>Minitek Wall is the most powerful and robust Grid system for Joomla!<\\/p>\\n\\t\\t\\n\\t","group":""}', '{"load_fontawesome":"1","load_fancybox":"1"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10028, 'Minitek Wall module', 'module', 'mod_minitekwall', '', 0, 1, 0, 0, '{"name":"Minitek Wall module","type":"module","creationDate":"August 2014","author":"Minitek.gr","copyright":"Copyright (C) 2011-2014 Minitek.gr. All rights reserved.","authorEmail":"","authorUrl":"www.minitek.gr","version":"3.0.2","description":"\\n\\t\\n\\t\\t<h1>Minitek Wall module<\\/h1>\\n\\t\\t<p>Minitek Wall is the most powerful and robust grid system for Joomla!<\\/p>\\n\\t\\t\\n  ","group":""}', '{"moduleclass_sfx":"","auto_module_id":"1","custom_module_id":"","module_id":"","load_jquery":"0","load_fontawesome":"1","load_fancybox":"1","enable_cache":"0","cache_time":"30"}', '', '', 0, '0000-00-00 00:00:00', 0, 0),
(10029, 'F0F (NEW) DO NOT REMOVE', 'library', 'lib_f0f', '', 0, 1, 1, 0, '{"name":"F0F (NEW) DO NOT REMOVE","type":"library","creationDate":"2014-09-11 16:58:22","author":"Nicholas K. Dionysopoulos \\/ Akeeba Ltd","copyright":"(C)2011-2014 Nicholas K. Dionysopoulos","authorEmail":"nicholas@akeebabackup.com","authorUrl":"https:\\/\\/www.akeebabackup.com","version":"rev844F136-1410443902","description":"Framework-on-Framework (FOF) newer version - DO NOT REMOVE - The rapid component development framework for Joomla!. This package is the newer version of FOF, not the one shipped with Joomla! as the official Joomla! RAD Layer. The Joomla! RAD Layer has ceased development in March 2014. DO NOT UNINSTALL THIS PACKAGE, IT IS *** N O T *** A DUPLICATE OF THE ''FOF'' PACKAGE. REMOVING EITHER FOF PACKAGE WILL BREAK YOUR SITE.","group":""}', '{}', '', '', 0, '0000-00-00 00:00:00', 0, 0);

DROP TABLE IF EXISTS `#__finder_filters`;
CREATE TABLE IF NOT EXISTS `#__finder_filters` (
`filter_id` int(10) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL,
  `created_by_alias` varchar(255) NOT NULL,
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `map_count` int(10) unsigned NOT NULL DEFAULT '0',
  `data` text NOT NULL,
  `params` mediumtext
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__finder_links`;
CREATE TABLE IF NOT EXISTS `#__finder_links` (
`link_id` int(10) unsigned NOT NULL,
  `url` varchar(255) NOT NULL,
  `route` varchar(255) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `indexdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `md5sum` varchar(32) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `state` int(5) DEFAULT '1',
  `access` int(5) DEFAULT '0',
  `language` varchar(8) NOT NULL,
  `publish_start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `list_price` double unsigned NOT NULL DEFAULT '0',
  `sale_price` double unsigned NOT NULL DEFAULT '0',
  `type_id` int(11) NOT NULL,
  `object` mediumblob NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__finder_links_terms0`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms0` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms1`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms1` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms2`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms2` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms3`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms3` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms4`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms4` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms5`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms5` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms6`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms6` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms7`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms7` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms8`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms8` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_terms9`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms9` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termsa`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsa` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termsb`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsb` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termsc`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsc` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termsd`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsd` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termse`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termse` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_links_termsf`;
CREATE TABLE IF NOT EXISTS `#__finder_links_termsf` (
  `link_id` int(10) unsigned NOT NULL,
  `term_id` int(10) unsigned NOT NULL,
  `weight` float unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_taxonomy`;
CREATE TABLE IF NOT EXISTS `#__finder_taxonomy` (
`id` int(10) unsigned NOT NULL,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL,
  `state` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `access` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ordering` tinyint(1) unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__finder_taxonomy_map`;
CREATE TABLE IF NOT EXISTS `#__finder_taxonomy_map` (
  `link_id` int(10) unsigned NOT NULL,
  `node_id` int(10) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_terms`;
CREATE TABLE IF NOT EXISTS `#__finder_terms` (
`term_id` int(10) unsigned NOT NULL,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `weight` float unsigned NOT NULL DEFAULT '0',
  `soundex` varchar(75) NOT NULL,
  `links` int(10) NOT NULL DEFAULT '0',
  `language` char(3) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__finder_terms_common`;
CREATE TABLE IF NOT EXISTS `#__finder_terms_common` (
  `term` varchar(75) NOT NULL,
  `language` varchar(3) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__finder_terms_common` (`term`, `language`) VALUES
('a', 'en'),
('about', 'en'),
('after', 'en'),
('ago', 'en'),
('all', 'en'),
('am', 'en'),
('an', 'en'),
('and', 'en'),
('ani', 'en'),
('any', 'en'),
('are', 'en'),
('aren''t', 'en'),
('as', 'en'),
('at', 'en'),
('be', 'en'),
('but', 'en'),
('by', 'en'),
('for', 'en'),
('from', 'en'),
('get', 'en'),
('go', 'en'),
('how', 'en'),
('if', 'en'),
('in', 'en'),
('into', 'en'),
('is', 'en'),
('isn''t', 'en'),
('it', 'en'),
('its', 'en'),
('me', 'en'),
('more', 'en'),
('most', 'en'),
('must', 'en'),
('my', 'en'),
('new', 'en'),
('no', 'en'),
('none', 'en'),
('not', 'en'),
('noth', 'en'),
('nothing', 'en'),
('of', 'en'),
('off', 'en'),
('often', 'en'),
('old', 'en'),
('on', 'en'),
('onc', 'en'),
('once', 'en'),
('onli', 'en'),
('only', 'en'),
('or', 'en'),
('other', 'en'),
('our', 'en'),
('ours', 'en'),
('out', 'en'),
('over', 'en'),
('page', 'en'),
('she', 'en'),
('should', 'en'),
('small', 'en'),
('so', 'en'),
('some', 'en'),
('than', 'en'),
('thank', 'en'),
('that', 'en'),
('the', 'en'),
('their', 'en'),
('theirs', 'en'),
('them', 'en'),
('then', 'en'),
('there', 'en'),
('these', 'en'),
('they', 'en'),
('this', 'en'),
('those', 'en'),
('thus', 'en'),
('time', 'en'),
('times', 'en'),
('to', 'en'),
('too', 'en'),
('true', 'en'),
('under', 'en'),
('until', 'en'),
('up', 'en'),
('upon', 'en'),
('use', 'en'),
('user', 'en'),
('users', 'en'),
('veri', 'en'),
('version', 'en'),
('very', 'en'),
('via', 'en'),
('want', 'en'),
('was', 'en'),
('way', 'en'),
('were', 'en'),
('what', 'en'),
('when', 'en'),
('where', 'en'),
('whi', 'en'),
('which', 'en'),
('who', 'en'),
('whom', 'en'),
('whose', 'en'),
('why', 'en'),
('wide', 'en'),
('will', 'en'),
('with', 'en'),
('within', 'en'),
('without', 'en'),
('would', 'en'),
('yes', 'en'),
('yet', 'en'),
('you', 'en'),
('your', 'en'),
('yours', 'en');

DROP TABLE IF EXISTS `#__finder_tokens`;
CREATE TABLE IF NOT EXISTS `#__finder_tokens` (
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `weight` float unsigned NOT NULL DEFAULT '1',
  `context` tinyint(1) unsigned NOT NULL DEFAULT '2',
  `language` char(3) NOT NULL DEFAULT ''
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_tokens_aggregate`;
CREATE TABLE IF NOT EXISTS `#__finder_tokens_aggregate` (
  `term_id` int(10) unsigned NOT NULL,
  `map_suffix` char(1) NOT NULL,
  `term` varchar(75) NOT NULL,
  `stem` varchar(75) NOT NULL,
  `common` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `phrase` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `term_weight` float unsigned NOT NULL,
  `context` tinyint(1) unsigned NOT NULL DEFAULT '2',
  `context_weight` float unsigned NOT NULL,
  `total_weight` float unsigned NOT NULL,
  `language` char(3) NOT NULL DEFAULT ''
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__finder_types`;
CREATE TABLE IF NOT EXISTS `#__finder_types` (
`id` int(10) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `mime` varchar(100) NOT NULL
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

INSERT INTO `#__finder_types` (`id`, `title`, `mime`) VALUES
(1, 'Tag', ''),
(2, 'Category', ''),
(3, 'Contact', ''),
(4, 'Article', ''),
(5, 'News Feed', ''),
(6, 'Web Link', '');

DROP TABLE IF EXISTS `#__k2_attachments`;
CREATE TABLE IF NOT EXISTS `#__k2_attachments` (
`id` int(11) NOT NULL,
  `itemID` int(11) NOT NULL,
  `filename` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `titleAttribute` text NOT NULL,
  `hits` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__k2_categories`;
CREATE TABLE IF NOT EXISTS `#__k2_categories` (
`id` int(11) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `alias` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `parent` int(11) DEFAULT '0',
  `extraFieldsGroup` int(11) NOT NULL,
  `published` smallint(6) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `image` varchar(255) NOT NULL,
  `params` text NOT NULL,
  `trash` smallint(6) NOT NULL DEFAULT '0',
  `plugins` text NOT NULL,
  `language` char(7) NOT NULL
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

INSERT INTO `#__k2_categories` (`id`, `name`, `alias`, `description`, `parent`, `extraFieldsGroup`, `published`, `access`, `ordering`, `image`, `params`, `trash`, `plugins`, `language`) VALUES
(1, 'Echo', 'echo', '<div class="mn-mod-header">\r\n	<div class="mn-title">\r\n		<h2>Our Services by Category</h2>\r\n  	</div>\r\n</div>', 0, 0, 1, 1, 1, '', '{"inheritFrom":"0","theme":"","num_leading_items":"0","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"0","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"0","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"0","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"1","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"0","catTitleItemCounter":"0","catDescription":"1","catImage":"0","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"0","subCatDescription":"0","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"0","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"1","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 0, '', '*'),
(2, 'Audio Solutions', 'audio-solutions', '', 1, 0, 1, 1, 1, '2.jpg', '{"inheritFrom":"0","theme":"","num_leading_items":"0","num_leading_columns":"1","leadingImgSize":"XLarge","num_primary_items":"4","num_primary_columns":"1","primaryImgSize":"Large","num_secondary_items":"0","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"0","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"0","catDescription":"1","catImage":"0","catFeedLink":"1","catFeedIcon":"1","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"0","subCatTitleItemCounter":"0","subCatDescription":"0","subCatImage":"0","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"1","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"1","catItemAttachments":"1","catItemAttachmentsCounter":"1","catItemVideo":"1","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"1","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"0","itemVideoAnchor":"0","itemImageGalleryAnchor":"0","itemCommentsAnchor":"0","itemRating":"0","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"0","itemImageMainCredits":"0","itemIntroText":"1","itemFullText":"1","itemExtraFields":"0","itemDateModified":"0","itemHits":"0","itemCategory":"1","itemTags":"1","itemAttachments":"0","itemAttachmentsCounter":"0","itemVideo":"0","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"0","itemVideoCredits":"0","itemImageGallery":"0","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"1","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"2","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 0, '', '*'),
(3, 'Commercial Services', 'commercial-services', '', 1, 0, 1, 1, 2, '3.jpg', '{"inheritFrom":"0","theme":"minitek2","num_leading_items":"0","num_leading_columns":"1","leadingImgSize":"XLarge","num_primary_items":"8","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"0","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"0","num_links_columns":"1","linksImgSize":"none","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"0","catDescription":"1","catImage":"0","catFeedLink":"0","catFeedIcon":"0","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"1","catItemAuthor":"0","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"0","catItemIntroTextWordLimit":"15","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"0","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"0","catItemCommentsAnchor":"0","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"0","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"0","itemImage":"1","itemImgSize":"XLarge","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"1","itemDateModified":"0","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"0","itemFacebookButton":"0","itemGooglePlusOneButton":"0","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"0","itemAuthorLatestLimit":"5","itemRelated":"0","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 0, '', '*'),
(4, 'Event Management', 'event-management', '', 1, 0, 1, 1, 3, '4.jpg', '{"inheritFrom":"0","theme":"minitek1","num_leading_items":"0","num_leading_columns":"1","leadingImgSize":"Large","num_primary_items":"4","num_primary_columns":"1","primaryImgSize":"Small","num_secondary_items":"0","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"0","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"0","catDescription":"1","catImage":"0","catFeedLink":"0","catFeedIcon":"0","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"0","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"1","catItemAuthor":"0","catItemDateCreated":"0","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"45","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"0","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"0","catItemCommentsAnchor":"0","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"1","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"1","itemVideoAnchor":"1","itemImageGalleryAnchor":"1","itemCommentsAnchor":"1","itemRating":"0","itemImage":"1","itemImgSize":"Large","itemImageMainCaption":"1","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"0","itemDateModified":"1","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"1","itemAttachmentsCounter":"1","itemVideo":"1","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"1","itemVideoCredits":"1","itemImageGallery":"1","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"1","itemAuthorEmail":"0","itemAuthorLatest":"1","itemAuthorLatestLimit":"5","itemRelated":"0","itemRelatedLimit":"5","itemRelatedTitle":"1","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 0, '', '*'),
(5, 'Video And Music Production', 'video-and-music-production', '', 1, 0, 1, 1, 4, '5.jpg', '{"inheritFrom":"0","theme":"","num_leading_items":"0","num_leading_columns":"1","leadingImgSize":"XLarge","num_primary_items":"4","num_primary_columns":"2","primaryImgSize":"Medium","num_secondary_items":"0","num_secondary_columns":"1","secondaryImgSize":"Small","num_links":"0","num_links_columns":"1","linksImgSize":"XSmall","catCatalogMode":"0","catFeaturedItems":"1","catOrdering":"","catPagination":"2","catPaginationResults":"1","catTitle":"1","catTitleItemCounter":"0","catDescription":"1","catImage":"0","catFeedLink":"0","catFeedIcon":"0","subCategories":"1","subCatColumns":"2","subCatOrdering":"","subCatTitle":"1","subCatTitleItemCounter":"1","subCatDescription":"1","subCatImage":"1","itemImageXS":"","itemImageS":"","itemImageM":"","itemImageL":"","itemImageXL":"","catItemTitle":"1","catItemTitleLinked":"1","catItemFeaturedNotice":"1","catItemAuthor":"1","catItemDateCreated":"1","catItemRating":"0","catItemImage":"1","catItemIntroText":"1","catItemIntroTextWordLimit":"44","catItemExtraFields":"0","catItemHits":"0","catItemCategory":"1","catItemTags":"0","catItemAttachments":"0","catItemAttachmentsCounter":"0","catItemVideo":"0","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"0","catItemImageGallery":"0","catItemDateModified":"0","catItemReadMore":"0","catItemCommentsAnchor":"1","catItemK2Plugins":"1","itemDateCreated":"1","itemTitle":"1","itemFeaturedNotice":"1","itemAuthor":"1","itemFontResizer":"0","itemPrintButton":"1","itemEmailButton":"1","itemSocialButton":"0","itemVideoAnchor":"0","itemImageGalleryAnchor":"0","itemCommentsAnchor":"1","itemRating":"0","itemImage":"1","itemImgSize":"XLarge","itemImageMainCaption":"0","itemImageMainCredits":"1","itemIntroText":"1","itemFullText":"1","itemExtraFields":"0","itemDateModified":"0","itemHits":"1","itemCategory":"1","itemTags":"1","itemAttachments":"0","itemAttachmentsCounter":"0","itemVideo":"0","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"0","itemVideoCaption":"0","itemVideoCredits":"0","itemImageGallery":"0","itemNavigation":"1","itemComments":"1","itemTwitterButton":"1","itemFacebookButton":"1","itemGooglePlusOneButton":"1","itemAuthorBlock":"1","itemAuthorImage":"1","itemAuthorDescription":"1","itemAuthorURL":"0","itemAuthorEmail":"0","itemAuthorLatest":"0","itemAuthorLatestLimit":"5","itemRelated":"1","itemRelatedLimit":"5","itemRelatedTitle":"0","itemRelatedCategory":"0","itemRelatedImageSize":"0","itemRelatedIntrotext":"0","itemRelatedFulltext":"0","itemRelatedAuthor":"0","itemRelatedMedia":"0","itemRelatedImageGallery":"0","itemK2Plugins":"1","catMetaDesc":"","catMetaKey":"","catMetaRobots":"","catMetaAuthor":""}', 0, '', '*');

DROP TABLE IF EXISTS `#__k2_comments`;
CREATE TABLE IF NOT EXISTS `#__k2_comments` (
`id` int(11) NOT NULL,
  `itemID` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `userName` varchar(255) NOT NULL,
  `commentDate` datetime NOT NULL,
  `commentText` text NOT NULL,
  `commentEmail` varchar(255) NOT NULL,
  `commentURL` varchar(255) NOT NULL,
  `published` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

INSERT INTO `#__k2_comments` (`id`, `itemID`, `userID`, `userName`, `commentDate`, `commentText`, `commentEmail`, `commentURL`, `published`) VALUES
(1, 7, 445, 'John Doe', '2014-08-10 13:22:10', 'Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque.', 'JohnDoe@minitek.gr', '', 1),
(2, 7, 446, 'Susan Fox', '2014-08-10 13:22:45', 'Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis.', 'SusanFox@minitek.gr', '', 1);

DROP TABLE IF EXISTS `#__k2_extra_fields`;
CREATE TABLE IF NOT EXISTS `#__k2_extra_fields` (
`id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `type` varchar(255) NOT NULL,
  `group` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL,
  `ordering` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__k2_extra_fields_groups`;
CREATE TABLE IF NOT EXISTS `#__k2_extra_fields_groups` (
`id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__k2_items`;
CREATE TABLE IF NOT EXISTS `#__k2_items` (
`id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `catid` int(11) NOT NULL,
  `published` smallint(6) NOT NULL DEFAULT '0',
  `introtext` mediumtext NOT NULL,
  `fulltext` mediumtext NOT NULL,
  `video` text,
  `gallery` varchar(255) DEFAULT NULL,
  `extra_fields` text CHARACTER SET utf8 COLLATE utf8_unicode_ci,
  `extra_fields_search` text NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(11) NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL,
  `checked_out` int(10) unsigned NOT NULL,
  `checked_out_time` datetime NOT NULL,
  `modified` datetime NOT NULL,
  `modified_by` int(11) NOT NULL DEFAULT '0',
  `publish_up` datetime NOT NULL,
  `publish_down` datetime NOT NULL,
  `trash` smallint(6) NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `featured` smallint(6) NOT NULL DEFAULT '0',
  `featured_ordering` int(11) NOT NULL DEFAULT '0',
  `image_caption` text NOT NULL,
  `image_credits` varchar(255) NOT NULL,
  `video_caption` text NOT NULL,
  `video_credits` varchar(255) NOT NULL,
  `hits` int(10) unsigned NOT NULL,
  `params` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `metakey` text NOT NULL,
  `plugins` text NOT NULL,
  `language` char(7) NOT NULL
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=32 ;

INSERT INTO `#__k2_items` (`id`, `title`, `alias`, `catid`, `published`, `introtext`, `fulltext`, `video`, `gallery`, `extra_fields`, `extra_fields_search`, `created`, `created_by`, `created_by_alias`, `checked_out`, `checked_out_time`, `modified`, `modified_by`, `publish_up`, `publish_down`, `trash`, `access`, `ordering`, `featured`, `featured_ordering`, `image_caption`, `image_credits`, `video_caption`, `video_credits`, `hits`, `params`, `metadesc`, `metadata`, `metakey`, `plugins`, `language`) VALUES
(4, 'The Mysterious Man', 'the-mysterious-man', 2, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:49:44', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', '', '', 4, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(5, 'Old School Audio', 'old-school-audio', 2, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:49:38', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 2, 0, 0, '', '', '', '', 1, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(6, 'Colors and Melodies', 'colors-and-melodies', 2, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:49:32', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 3, 0, 0, '', '', '', '', 3, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(7, 'A Modern Sound Approach', 'a-modern-sound-approach', 2, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:49:25', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 4, 0, 0, '', '', '', '', 85, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(14, 'Why This Commercial Became so Successful', 'why-this-commercial-became-so-successful', 3, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:50:52', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', '', '', 2, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(15, 'University Luggage', 'university-luggage', 3, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:50:47', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 2, 0, 0, '', '', '', '', 3, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(16, 'The Breathing Commercial', 'the-breathing-commercial', 3, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:50:42', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 3, 0, 0, '', '', '', '', 1, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(17, 'Make Your Red Background Work Better', 'make-your-red-background-work-better', 3, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:50:37', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 4, 0, 0, '', '', '', '', 1, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(18, 'Eastern Reverence', 'eastern-reverence', 3, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:50:33', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 5, 0, 0, '', '', '', '', 52, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(19, 'City Photography and Direction', 'city-photography-and-direction', 3, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:50:28', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 6, 0, 0, '', '', '', '', 9, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(22, 'The Amazing Balloons Event', 'the-amazing-balloons-event', 4, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:51:38', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 2, 0, 0, '', '', '', '', 1, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(23, 'Managing the Next Success', 'managing-the-next-success', 4, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:51:34', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 3, 0, 0, '', '', '', '', 8, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(24, 'Creating an Event Experience', 'creating-an-event-experience', 4, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:51:28', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', '', '', 3, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(25, 'Communication is Always Important', 'communication-is-always-important', 4, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:51:23', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 4, 0, 0, '', '', '', '', 15, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(26, 'The Strange Formations Music Clip', 'the-strange-formations-music-clip', 5, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:52:39', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 1, 0, 0, '', '', '', '', 75, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(27, 'The Shipwreck Documentary', 'the-shipwreck-documentary', 5, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:52:33', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 2, 0, 0, '', '', '', '', 3, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*');
INSERT INTO `#__k2_items` (`id`, `title`, `alias`, `catid`, `published`, `introtext`, `fulltext`, `video`, `gallery`, `extra_fields`, `extra_fields_search`, `created`, `created_by`, `created_by_alias`, `checked_out`, `checked_out_time`, `modified`, `modified_by`, `publish_up`, `publish_down`, `trash`, `access`, `ordering`, `featured`, `featured_ordering`, `image_caption`, `image_credits`, `video_caption`, `video_credits`, `hits`, `params`, `metadesc`, `metadata`, `metakey`, `plugins`, `language`) VALUES
(28, 'The City in Motion', 'the-city-in-motion', 5, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:52:28', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 3, 0, 0, '', '', '', '', 2, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(29, 'Lost in Music Land', 'lost-in-music-land', 5, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:52:22', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 4, 0, 0, '', '', '', '', 2, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(30, 'Flying On Cloudy Weather', 'flying-on-cloudy-weather', 5, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:52:17', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 5, 0, 0, '', '', '', '', 2, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*'),
(31, 'Cloudy and Impressive', 'cloudy-and-impressive', 5, 1, '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n', '\r\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.</p>', NULL, NULL, '[]', '', '2014-08-05 00:00:00', 445, '', 0, '0000-00-00 00:00:00', '2014-09-21 19:52:12', 445, '2014-08-05 00:00:00', '0000-00-00 00:00:00', 0, 1, 6, 0, 0, '', '', '', '', 9, '{"catItemTitle":"","catItemTitleLinked":"","catItemFeaturedNotice":"","catItemAuthor":"","catItemDateCreated":"","catItemRating":"","catItemImage":"","catItemIntroText":"","catItemExtraFields":"","catItemHits":"","catItemCategory":"","catItemTags":"","catItemAttachments":"","catItemAttachmentsCounter":"","catItemVideo":"","catItemVideoWidth":"","catItemVideoHeight":"","catItemAudioWidth":"","catItemAudioHeight":"","catItemVideoAutoPlay":"","catItemImageGallery":"","catItemDateModified":"","catItemReadMore":"","catItemCommentsAnchor":"","catItemK2Plugins":"","itemDateCreated":"","itemTitle":"","itemFeaturedNotice":"","itemAuthor":"","itemFontResizer":"","itemPrintButton":"","itemEmailButton":"","itemSocialButton":"","itemVideoAnchor":"","itemImageGalleryAnchor":"","itemCommentsAnchor":"","itemRating":"","itemImage":"","itemImgSize":"","itemImageMainCaption":"","itemImageMainCredits":"","itemIntroText":"","itemFullText":"","itemExtraFields":"","itemDateModified":"","itemHits":"","itemCategory":"","itemTags":"","itemAttachments":"","itemAttachmentsCounter":"","itemVideo":"","itemVideoWidth":"","itemVideoHeight":"","itemAudioWidth":"","itemAudioHeight":"","itemVideoAutoPlay":"","itemVideoCaption":"","itemVideoCredits":"","itemImageGallery":"","itemNavigation":"","itemComments":"","itemTwitterButton":"","itemFacebookButton":"","itemGooglePlusOneButton":"","itemAuthorBlock":"","itemAuthorImage":"","itemAuthorDescription":"","itemAuthorURL":"","itemAuthorEmail":"","itemAuthorLatest":"","itemAuthorLatestLimit":"","itemRelated":"","itemRelatedLimit":"","itemRelatedTitle":"","itemRelatedCategory":"","itemRelatedImageSize":"","itemRelatedIntrotext":"","itemRelatedFulltext":"","itemRelatedAuthor":"","itemRelatedMedia":"","itemRelatedImageGallery":"","itemK2Plugins":""}', '', 'robots=\nauthor=', '', '', '*');

DROP TABLE IF EXISTS `#__k2_rating`;
CREATE TABLE IF NOT EXISTS `#__k2_rating` (
  `itemID` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(11) unsigned NOT NULL DEFAULT '0',
  `rating_count` int(11) unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__k2_tags`;
CREATE TABLE IF NOT EXISTS `#__k2_tags` (
`id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `published` smallint(6) NOT NULL DEFAULT '0'
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=54 ;

INSERT INTO `#__k2_tags` (`id`, `name`, `published`) VALUES
(22, 'company', 1),
(23, 'interviews', 1),
(25, 'camera', 1),
(28, 'photo', 1),
(30, 'photographer', 1),
(33, 'audio', 1),
(34, 'sound', 1),
(35, 'color', 1),
(36, 'melody', 1),
(37, 'school', 1),
(38, 'guitar', 1),
(39, 'drums', 1),
(40, 'ancient', 1),
(41, 'east', 1),
(42, 'red', 1),
(43, 'work', 1),
(44, 'commercial', 1),
(45, 'art', 1),
(46, 'communication', 1),
(47, 'mobile', 1),
(48, 'experience', 1),
(49, 'event', 1),
(50, 'flying', 1),
(51, 'music', 1),
(52, 'city', 1),
(53, 'movie', 1);

DROP TABLE IF EXISTS `#__k2_tags_xref`;
CREATE TABLE IF NOT EXISTS `#__k2_tags_xref` (
`id` int(11) NOT NULL,
  `tagID` int(11) NOT NULL,
  `itemID` int(11) NOT NULL
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=631 ;

INSERT INTO `#__k2_tags_xref` (`id`, `tagID`, `itemID`) VALUES
(574, 33, 7),
(575, 34, 7),
(576, 35, 6),
(577, 34, 6),
(578, 36, 6),
(579, 33, 5),
(580, 34, 5),
(581, 37, 5),
(582, 33, 4),
(583, 38, 4),
(584, 39, 4),
(585, 25, 19),
(586, 30, 19),
(587, 25, 18),
(588, 28, 18),
(589, 40, 18),
(590, 41, 18),
(591, 35, 17),
(592, 42, 17),
(593, 43, 17),
(594, 43, 16),
(595, 28, 16),
(596, 44, 16),
(597, 43, 15),
(598, 35, 15),
(599, 22, 15),
(600, 44, 15),
(601, 44, 14),
(602, 45, 14),
(603, 22, 14),
(604, 22, 25),
(605, 43, 25),
(606, 46, 25),
(607, 47, 25),
(608, 23, 24),
(609, 34, 24),
(610, 48, 23),
(611, 43, 23),
(612, 22, 23),
(613, 49, 22),
(614, 35, 22),
(615, 34, 31),
(616, 49, 31),
(617, 50, 30),
(618, 43, 30),
(619, 22, 30),
(620, 51, 29),
(621, 34, 29),
(622, 52, 28),
(623, 43, 28),
(624, 45, 28),
(625, 34, 28),
(626, 53, 27),
(627, 36, 27),
(628, 34, 26),
(629, 51, 26),
(630, 36, 26);

DROP TABLE IF EXISTS `#__k2_users`;
CREATE TABLE IF NOT EXISTS `#__k2_users` (
`id` int(11) NOT NULL,
  `userID` int(11) NOT NULL,
  `userName` varchar(255) DEFAULT NULL,
  `gender` enum('m','f') NOT NULL DEFAULT 'm',
  `description` text NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `group` int(11) NOT NULL DEFAULT '0',
  `plugins` text NOT NULL,
  `ip` varchar(15) NOT NULL,
  `hostname` varchar(255) NOT NULL,
  `notes` text NOT NULL
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

INSERT INTO `#__k2_users` (`id`, `userID`, `userName`, `gender`, `description`, `image`, `url`, `group`, `plugins`, `ip`, `hostname`, `notes`) VALUES
(2, 445, 'John Doe', 'm', '', NULL, NULL, 1, '', '78.87.136.79', '78-136-79.adsl.cyta.gr', ''),
(3, 446, 'Susan Fox', 'm', '', NULL, NULL, 1, '', '78.87.136.79', '78-136-79.adsl.cyta.gr', '');

DROP TABLE IF EXISTS `#__k2_user_groups`;
CREATE TABLE IF NOT EXISTS `#__k2_user_groups` (
`id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `permissions` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__languages`;
CREATE TABLE IF NOT EXISTS `#__languages` (
`lang_id` int(11) unsigned NOT NULL,
  `lang_code` char(7) NOT NULL,
  `title` varchar(50) NOT NULL,
  `title_native` varchar(50) NOT NULL,
  `sef` varchar(50) NOT NULL,
  `image` varchar(50) NOT NULL,
  `description` varchar(512) NOT NULL,
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `sitename` varchar(1024) NOT NULL DEFAULT '',
  `published` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `#__languages` (`lang_id`, `lang_code`, `title`, `title_native`, `sef`, `image`, `description`, `metakey`, `metadesc`, `sitename`, `published`, `access`, `ordering`) VALUES
(1, 'en-GB', 'English (UK)', 'English (UK)', 'en', 'en', '', '', '', '', 1, 1, 1);

DROP TABLE IF EXISTS `#__menu`;
CREATE TABLE IF NOT EXISTS `#__menu` (
`id` int(11) NOT NULL,
  `menutype` varchar(24) NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(1024) NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '1' COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to #__users.id',
  `checked_out_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT '0'
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=321 ;

INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(1, '', 'Menu_Item_Root', 'root', '', '', '', '', 1, 0, 0, 0, 0, '0000-00-00 00:00:00', 0, 0, '', 0, '', 0, 227, 0, '*', 0),
(2, 'menu', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', 0, 1, 1, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 1, 10, 0, '*', 1),
(3, 'menu', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners', 'component', 0, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners', 0, '', 2, 3, 0, '*', 1),
(4, 'menu', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&extension=com_banners', 'component', 0, 2, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-cat', 0, '', 4, 5, 0, '*', 1),
(5, 'menu', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', 0, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-clients', 0, '', 6, 7, 0, '*', 1),
(6, 'menu', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', 0, 2, 2, 4, 0, '0000-00-00 00:00:00', 0, 0, 'class:banners-tracks', 0, '', 8, 9, 0, '*', 1),
(7, 'menu', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', 0, 1, 1, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 11, 16, 0, '*', 1),
(8, 'menu', 'com_contact', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact', 'component', 0, 7, 2, 8, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact', 0, '', 12, 13, 0, '*', 1),
(9, 'menu', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&extension=com_contact', 'component', 0, 7, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:contact-cat', 0, '', 14, 15, 0, '*', 1),
(10, 'menu', 'com_messages', 'Messaging', '', 'Messaging', 'index.php?option=com_messages', 'component', 0, 1, 1, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages', 0, '', 17, 22, 0, '*', 1),
(11, 'menu', 'com_messages_add', 'New Private Message', '', 'Messaging/New Private Message', 'index.php?option=com_messages&task=message.add', 'component', 0, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-add', 0, '', 18, 19, 0, '*', 1),
(12, 'menu', 'com_messages_read', 'Read Private Message', '', 'Messaging/Read Private Message', 'index.php?option=com_messages', 'component', 0, 10, 2, 15, 0, '0000-00-00 00:00:00', 0, 0, 'class:messages-read', 0, '', 20, 21, 0, '*', 1),
(13, 'menu', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', 0, 1, 1, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 23, 28, 0, '*', 1),
(14, 'menu', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds', 'component', 0, 13, 2, 17, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds', 0, '', 24, 25, 0, '*', 1),
(15, 'menu', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&extension=com_newsfeeds', 'component', 0, 13, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:newsfeeds-cat', 0, '', 26, 27, 0, '*', 1),
(16, 'menu', 'com_redirect', 'Redirect', '', 'Redirect', 'index.php?option=com_redirect', 'component', 0, 1, 1, 24, 0, '0000-00-00 00:00:00', 0, 0, 'class:redirect', 0, '', 29, 30, 0, '*', 1),
(17, 'menu', 'com_search', 'Basic Search', '', 'Basic Search', 'index.php?option=com_search', 'component', 0, 1, 1, 19, 0, '0000-00-00 00:00:00', 0, 0, 'class:search', 0, '', 31, 32, 0, '*', 1),
(18, 'menu', 'com_weblinks', 'Weblinks', '', 'Weblinks', 'index.php?option=com_weblinks', 'component', 0, 1, 1, 21, 0, '0000-00-00 00:00:00', 0, 0, 'class:weblinks', 0, '', 33, 38, 0, '*', 1),
(19, 'menu', 'com_weblinks_links', 'Links', '', 'Weblinks/Links', 'index.php?option=com_weblinks', 'component', 0, 18, 2, 21, 0, '0000-00-00 00:00:00', 0, 0, 'class:weblinks', 0, '', 34, 35, 0, '*', 1),
(20, 'menu', 'com_weblinks_categories', 'Categories', '', 'Weblinks/Categories', 'index.php?option=com_categories&extension=com_weblinks', 'component', 0, 18, 2, 6, 0, '0000-00-00 00:00:00', 0, 0, 'class:weblinks-cat', 0, '', 36, 37, 0, '*', 1),
(21, 'menu', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', 0, 1, 1, 27, 0, '0000-00-00 00:00:00', 0, 0, 'class:finder', 0, '', 39, 40, 0, '*', 1),
(22, 'menu', 'com_joomlaupdate', 'Joomla! Update', '', 'Joomla! Update', 'index.php?option=com_joomlaupdate', 'component', 1, 1, 1, 28, 0, '0000-00-00 00:00:00', 0, 0, 'class:joomlaupdate', 0, '', 41, 42, 0, '*', 1),
(23, 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags', 'component', 0, 1, 1, 29, 0, '0000-00-00 00:00:00', 0, 1, 'class:tags', 0, '', 43, 44, 0, '', 1),
(24, 'main', 'com_postinstall', 'Post-installation messages', '', 'Post-installation messages', 'index.php?option=com_postinstall', 'component', 0, 1, 1, 32, 0, '0000-00-00 00:00:00', 0, 1, 'class:postinstall', 0, '', 45, 46, 0, '*', 1),
(101, 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 15, '{"featured_categories":[""],"layout_type":"blog","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"Home - Echo","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 47, 66, 1, '*', 0),
(102, 'main', 'COM_K2', 'com-k2', '', 'com-k2', 'index.php?option=com_k2', 'component', 0, 1, 1, 10002, 0, '0000-00-00 00:00:00', 0, 1, '../media/k2/assets/images/system/k2_16x16.png', 0, '', 67, 88, 0, '', 1),
(103, 'main', 'K2_ITEMS', 'k2-items', '', 'com-k2/k2-items', 'index.php?option=com_k2&view=items', 'component', 0, 102, 2, 10002, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 68, 69, 0, '', 1),
(104, 'main', 'K2_CATEGORIES', 'k2-categories', '', 'com-k2/k2-categories', 'index.php?option=com_k2&view=categories', 'component', 0, 102, 2, 10002, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 70, 71, 0, '', 1),
(105, 'main', 'K2_TAGS', 'k2-tags', '', 'com-k2/k2-tags', 'index.php?option=com_k2&view=tags', 'component', 0, 102, 2, 10002, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 72, 73, 0, '', 1),
(106, 'main', 'K2_COMMENTS', 'k2-comments', '', 'com-k2/k2-comments', 'index.php?option=com_k2&view=comments', 'component', 0, 102, 2, 10002, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 74, 75, 0, '', 1),
(107, 'main', 'K2_USERS', 'k2-users', '', 'com-k2/k2-users', 'index.php?option=com_k2&view=users', 'component', 0, 102, 2, 10002, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 76, 77, 0, '', 1),
(108, 'main', 'K2_USER_GROUPS', 'k2-user-groups', '', 'com-k2/k2-user-groups', 'index.php?option=com_k2&view=usergroups', 'component', 0, 102, 2, 10002, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 78, 79, 0, '', 1),
(109, 'main', 'K2_EXTRA_FIELDS', 'k2-extra-fields', '', 'com-k2/k2-extra-fields', 'index.php?option=com_k2&view=extrafields', 'component', 0, 102, 2, 10002, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 80, 81, 0, '', 1),
(110, 'main', 'K2_EXTRA_FIELD_GROUPS', 'k2-extra-field-groups', '', 'com-k2/k2-extra-field-groups', 'index.php?option=com_k2&view=extrafieldsgroups', 'component', 0, 102, 2, 10002, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 82, 83, 0, '', 1),
(111, 'main', 'K2_MEDIA_MANAGER', 'k2-media-manager', '', 'com-k2/k2-media-manager', 'index.php?option=com_k2&view=media', 'component', 0, 102, 2, 10002, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 84, 85, 0, '', 1),
(112, 'main', 'K2_INFORMATION', 'k2-information', '', 'com-k2/k2-information', 'index.php?option=com_k2&view=info', 'component', 0, 102, 2, 10002, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 86, 87, 0, '', 1),
(113, 'mainmenu', 'Pages', 'pages', '', 'pages', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"261","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 89, 100, 0, '*', 0),
(114, 'mainmenu', 'About us', 'about-us', '', 'pages/about-us', 'index.php?option=com_content&view=article&id=6', 'component', 1, 113, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"0","show_intro":"","info_block_position":"","show_category":"0","link_category":"0","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_tags":"","show_noauth":"0","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 94, 95, 0, '*', 0),
(115, 'mainmenu', 'Contact Page', 'contact-page', '', 'pages/contact-page', 'index.php?option=com_contact&view=contact&id=1', 'component', 1, 113, 2, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"presentation_style":"plain","show_contact_category":"hide","show_contact_list":"0","show_tags":"","show_name":"0","show_position":"","show_email":"1","show_street_address":"","show_suburb":"","show_state":"0","show_postcode":"0","show_country":"","show_telephone":"","show_mobile":"","show_fax":"0","show_webpage":"0","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_links":"","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"Get in Touch","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 96, 97, 0, '*', 0),
(116, 'mainmenu', 'FAQ', 'faq', '', 'pages/faq', 'index.php?option=com_content&view=article&id=5', 'component', 1, 113, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"0","show_intro":"","info_block_position":"","show_category":"0","link_category":"0","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_tags":"","show_noauth":"0","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"Frequently Asked Questions","pageclass_sfx":" faq","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 98, 99, 0, '*', 0),
(117, 'mainmenu', 'Categories', 'categories', '', 'k2/categories', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=1', 'component', 1, 118, 2, 10002, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"categories":["1"],"singleCatOrdering":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"Categories","pageclass_sfx":" light-grey-bg","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 102, 111, 0, '*', 0),
(118, 'mainmenu', 'K2', 'k2', '', 'k2', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"117","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 101, 120, 0, '*', 0),
(119, 'mainmenu', 'Typography', 'typography', '', 'typography', 'index.php?option=com_content&view=article&id=8', 'component', 1, 1, 1, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"0","show_intro":"","info_block_position":"","show_category":"0","link_category":"","show_parent_category":"0","link_parent_category":"","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":" typography","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 121, 122, 0, '*', 0),
(120, 'mainmenu', 'Module positions', 'module-positions', '', 'explore/module-positions', 'index.php?option=com_content&view=article&id=10', 'component', 1, 121, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"0","show_intro":"","info_block_position":"","show_category":"0","link_category":"0","show_parent_category":"0","link_parent_category":"0","show_author":"0","link_author":"0","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_tags":"","show_noauth":"0","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":" mod-pos","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 124, 125, 0, '*', 0),
(121, 'mainmenu', 'Explore', 'explore', '', 'explore', 'index.php?Itemid=', 'alias', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"120","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 123, 144, 0, '*', 0),
(122, 'mainmenu', 'Module variations', 'module-variations', '', 'explore/module-variations', 'index.php?option=com_content&view=article&id=9', 'component', 1, 121, 2, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"0","link_titles":"","show_intro":"","info_block_position":"","show_category":"0","link_category":"","show_parent_category":"0","link_parent_category":"","show_author":"0","link_author":"","show_create_date":"0","show_modify_date":"0","show_publish_date":"0","show_item_navigation":"0","show_vote":"0","show_icons":"0","show_print_icon":"0","show_email_icon":"0","show_hits":"0","show_tags":"0","show_noauth":"0","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"Module variations and Suffixes","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 126, 127, 0, '*', 0),
(123, 'mainmenu', 'Extra features', '2014-07-28-13-57-52', '', 'explore/2014-07-28-13-57-52', 'http://getbootstrap.com/components/', 'url', 1, 121, 2, 0, 0, '0000-00-00 00:00:00', 2, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 128, 129, 0, '*', 0),
(124, 'mainmenu', 'Responsive design', '2014-07-28-14-04-54', '', 'explore/2014-07-28-14-04-54', 'http://getbootstrap.com/css/#responsive-utilities', 'url', 1, 121, 2, 0, 0, '0000-00-00 00:00:00', 2, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 130, 131, 0, '*', 0),
(125, 'mainmenu', 'Template themes', 'template-themes', '', 'explore/template-themes', 'index.php?Itemid=', 'alias', 0, 121, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"101","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 132, 143, 0, '*', 0),
(126, 'mainmenu', 'Default theme', 'default-theme', '', 'explore/template-themes/default-theme', 'index.php?Itemid=', 'alias', 0, 125, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"101","menu-anchor_title":"","menu-anchor_css":"","menu_image":"images\\/orange-th.jpg","menu_text":1}', 133, 134, 0, '*', 0),
(127, 'mainmenu', 'Joomla', 'joomla', '', 'joomla', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 145, 200, 0, '*', 0),
(128, 'mainmenu', 'Category blog', 'category-blog', '', 'joomla/content/category-blog', 'index.php?option=com_content&view=category&layout=blog&id=9', 'component', 1, 129, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"1","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"date","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 147, 148, 0, '*', 0),
(129, 'mainmenu', 'Content', 'content', '', 'joomla/content', 'index.php?Itemid=', 'alias', 1, 127, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"128","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 146, 169, 0, '*', 0),
(130, 'mainmenu', 'Single article', 'single-article', '', 'joomla/content/single-article', 'index.php?option=com_content&view=article&id=1', 'component', 1, 129, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 149, 150, 0, '*', 0),
(131, 'mainmenu', 'List all categories', 'list-all-categories', '', 'joomla/content/list-all-categories', 'index.php?option=com_content&view=categories&id=8', 'component', 1, 129, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_base_description":"","categories_description":"","maxLevelcat":"","show_empty_categories_cat":"","show_subcat_desc_cat":"","show_cat_num_articles_cat":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","num_leading_articles":"1","num_intro_articles":"6","num_columns":"2","num_links":"6","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_pagination_limit":"","filter_field":"","show_headings":"","list_show_date":"","date_format":"","list_show_hits":"","list_show_author":"","display_num":"10","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 151, 152, 0, '*', 0),
(132, 'mainmenu', 'Category list', 'category-list', '', 'joomla/content/category-list', 'index.php?option=com_content&view=category&id=10', 'component', 1, 129, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_category_heading_title":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","show_pagination_limit":"","filter_field":"","show_headings":"","list_show_date":"","date_format":"","list_show_hits":"","list_show_author":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","display_num":"10","show_title":"","link_titles":"","show_intro":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 153, 154, 0, '*', 0),
(133, 'mainmenu', 'Featured articles', 'featured-articles', '', 'joomla/content/featured-articles', 'index.php?option=com_content&view=featured', 'component', 1, 129, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"featured_categories":[""],"layout_type":"blog","num_leading_articles":"","num_intro_articles":"","num_columns":"1","num_links":"","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 155, 156, 0, '*', 0),
(134, 'mainmenu', 'Archived articles', 'archived-articles', '', 'joomla/content/archived-articles', 'index.php?option=com_content&view=archive', 'component', 1, 129, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"orderby_sec":"alpha","order_date":"created","display_num":"5","filter_field":"","introtext_limit":"100","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","link_titles":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_hits":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 157, 158, 0, '*', 0),
(135, 'mainmenu', 'Login form', 'login-form', '', 'joomla/users/login-form', 'index.php?option=com_users&view=login', 'component', 1, 136, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"login_redirect_url":"","logindescription_show":"1","login_description":"","login_image":"","logout_redirect_url":"","logoutdescription_show":"1","logout_description":"","logout_image":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 171, 172, 0, '*', 0),
(136, 'mainmenu', 'Users', 'users', '', 'joomla/users', 'index.php?Itemid=', 'alias', 1, 127, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"135","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 170, 179, 0, '*', 0),
(137, 'mainmenu', 'Registration form', 'registration-form', '', 'joomla/users/registration-form', 'index.php?option=com_users&view=registration', 'component', 1, 136, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 173, 174, 0, '*', 0),
(138, 'mainmenu', 'Username reminder request', 'username-reminder-request', '', 'joomla/users/username-reminder-request', 'index.php?option=com_users&view=remind', 'component', 1, 136, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 175, 176, 0, '*', 0),
(139, 'mainmenu', 'Password reset', 'password-reset', '', 'joomla/users/password-reset', 'index.php?option=com_users&view=reset', 'component', 1, 136, 3, 25, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 177, 178, 0, '*', 0),
(140, 'mainmenu', 'Search', 'search', '', 'joomla/search', 'index.php?option=com_search&view=search', 'component', 1, 127, 2, 19, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"search_areas":"","show_date":"","searchphrase":"0","ordering":"newest","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 180, 181, 0, '*', 0),
(141, 'mainmenu', 'Contacts', 'contacts', '', 'joomla/contacts', 'index.php?Itemid=', 'alias', 1, 127, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"142","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 182, 191, 0, '*', 0),
(142, 'mainmenu', 'List all contacts categories', 'list-all-contacts-categories', '', 'joomla/contacts/list-all-contacts-categories', 'index.php?option=com_contact&view=categories&id=0', 'component', 1, 141, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_base_description":"","categories_description":"","maxLevelcat":"","show_empty_categories_cat":"","show_subcat_desc_cat":"","show_cat_items_cat":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_subcat_desc":"","show_cat_items":"","filter_field":"","show_pagination_limit":"","show_headings":"","show_position_headings":"","show_email_headings":"","show_telephone_headings":"","show_mobile_headings":"","show_fax_headings":"","show_suburb_headings":"","show_state_headings":"","show_country_headings":"","show_pagination":"","show_pagination_results":"","presentation_style":"","show_contact_category":"","show_contact_list":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_links":"","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 183, 184, 0, '*', 0),
(143, 'mainmenu', 'List contacts in a category', 'list-contacts-in-a-category', '', 'joomla/contacts/list-contacts-in-a-category', 'index.php?option=com_contact&view=category&id=14', 'component', 1, 141, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_subcat_desc":"","show_cat_items":"","filter_field":"","show_pagination_limit":"","show_headings":"","show_position_headings":"","show_email_headings":"","show_telephone_headings":"","show_mobile_headings":"","show_fax_headings":"","show_suburb_headings":"","show_state_headings":"","show_country_headings":"","show_pagination":"","show_pagination_results":"","initial_sort":"","presentation_style":"","show_contact_category":"","show_contact_list":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_links":"","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","show_feed_link":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 185, 186, 0, '*', 0),
(144, 'mainmenu', 'Single contact', 'single-contact', '', 'joomla/contacts/single-contact', 'index.php?option=com_contact&view=contact&id=1', 'component', 1, 141, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"presentation_style":"","show_contact_category":"","show_contact_list":"","show_tags":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_links":"","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"Get in Touch","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 187, 188, 0, '*', 0),
(145, 'mainmenu', 'Featured contacts', 'featured-contacts', '', 'joomla/contacts/featured-contacts', 'index.php?option=com_contact&view=featured', 'component', 1, 141, 3, 8, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_pagination_limit":"","show_headings":"","show_position_headings":"","show_email_headings":"","show_telephone_headings":"","show_mobile_headings":"","show_fax_headings":"","show_suburb_headings":"","show_state_headings":"","show_country_headings":"","show_pagination":"","show_pagination_results":"","presentation_style":"","show_name":"","show_position":"","show_email":"","show_street_address":"","show_suburb":"","show_state":"","show_postcode":"","show_country":"","show_telephone":"","show_mobile":"","show_fax":"","show_webpage":"","show_misc":"","show_image":"","allow_vcard":"","show_articles":"","show_links":"","linka_name":"","linkb_name":"","linkc_name":"","linkd_name":"","linke_name":"","show_email_form":"","show_email_copy":"","banned_email":"","banned_subject":"","banned_text":"","validate_session":"","custom_reply":"","redirect":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 189, 190, 0, '*', 0),
(146, 'mainmenu', 'Template pages', 'template-pages', '', 'joomla/template-pages', 'index.php?Itemid=', 'alias', 1, 127, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"147","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 192, 199, 0, '*', 0),
(147, 'mainmenu', 'Iframe wrapper', 'iframe-wrapper', '', 'joomla/template-pages/iframe-wrapper', 'index.php?option=com_wrapper&view=wrapper', 'component', 1, 146, 3, 2, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"url":"http:\\/\\/www.minitek.gr\\/","scrolling":"auto","width":"100%","height":"500","height_auto":"0","add_scheme":"1","frameborder":"1","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 193, 194, 0, '*', 0),
(148, 'mainmenu', '404 error page', '2014-07-28-15-45-00', '', 'joomla/template-pages/2014-07-28-15-45-00', '404-error-page', 'url', 1, 146, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 195, 196, 0, '*', 0),
(149, 'mainmenu', 'Page breaks', 'page-breaks', '', 'joomla/template-pages/page-breaks', 'index.php?option=com_content&view=article&id=7', 'component', 1, 146, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"0","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","urls_position":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 197, 198, 0, '*', 0),
(150, 'mainmenu', 'Audio Solutions - Style 1', 'audio-solutions-style-1', '', 'k2/categories/audio-solutions-style-1', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=2', 'component', 1, 117, 3, 10002, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"categories":["2"],"singleCatOrdering":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 103, 104, 0, '*', 0),
(151, 'mainmenu', 'Commercial Services - Style 2', 'commercial-services-style-2', '', 'k2/categories/commercial-services-style-2', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=3', 'component', 1, 117, 3, 10002, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"categories":["3"],"singleCatOrdering":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 105, 106, 0, '*', 0),
(152, 'mainmenu', 'Event Management - Style 3', 'event-management-style-3', '', 'k2/categories/event-management-style-3', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=4', 'component', 1, 117, 3, 10002, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"categories":["4"],"singleCatOrdering":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 107, 108, 0, '*', 0),
(153, 'mainmenu', 'Video And Music Production - Style 4', 'video-and-music-production-style-4', '', 'k2/categories/video-and-music-production-style-4', 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id=5', 'component', 1, 117, 3, 10002, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"categories":["5"],"singleCatOrdering":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 109, 110, 0, '*', 0),
(154, 'mainmenu', 'Item', 'item', '', 'k2/item', 'index.php?option=com_k2&view=item&layout=item&id=7', 'component', 1, 118, 2, 10002, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 112, 113, 0, '*', 0),
(155, 'mainmenu', 'Tag', 'tag', '', 'k2/tag', 'index.php?option=com_k2&view=itemlist&layout=tag&tag=sound&task=tag', 'component', 1, 118, 2, 10002, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"theme":"default","tagOrdering":"","tagFeedLink":"1","tagFeedIcon":"1","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 114, 115, 0, '*', 0),
(156, 'mainmenu', 'User page', 'user-page', '', 'k2/user-page', 'index.php?option=com_k2&view=itemlist&layout=user&id=445&task=user', 'component', 1, 118, 2, 10002, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"theme":"default","userCategoriesFilter":["1","2","3","4","5"],"userOrdering":"","userFeedLink":"1","userFeedIcon":"1","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":1,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 116, 117, 0, '*', 0),
(157, 'mainmenu', 'Latest items (2 columns)', 'latest-items-2-columns', '', 'k2/latest-items-2-columns', 'index.php?option=com_k2&view=latest&layout=latest', 'component', 1, 118, 2, 10002, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"theme":"default","source":"1","latestItemsCols":"2","latestItemsLimit":"4","latestItemsDisplayEffect":"first","userName":"1","userImage":"1","userDescription":"1","userURL":"1","userEmail":"0","userFeed":"1","categoryIDs":["2","3","4","5"],"categoryTitle":"1","categoryDescription":"0","categoryImage":"0","categoryFeed":"0","latestItemTitle":"1","latestItemTitleLinked":"1","latestItemDateCreated":"0","latestItemImage":"1","latestItemImageSize":"Large","latestItemVideo":"0","latestItemVideoWidth":"","latestItemVideoHeight":"","latestItemAudioWidth":"","latestItemAudioHeight":"","latestItemVideoAutoPlay":"0","latestItemIntroText":"0","latestItemCategory":"0","latestItemTags":"0","latestItemReadMore":"0","latestItemCommentsAnchor":"0","feedLink":"1","latestItemK2Plugins":"0","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 118, 119, 0, '*', 0),
(158, 'our-services', 'Audio Solutions', '2014-08-05-13-30-39', '', '2014-08-05-13-30-39', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 201, 202, 0, '*', 0),
(160, 'our-services', 'Commercial Services', '2014-08-05-13-31-26', '', '2014-08-05-13-31-26', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 203, 204, 0, '*', 0),
(161, 'our-services', 'Music Production', '2014-08-05-13-31-50', '', '2014-08-05-13-31-50', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 205, 206, 0, '*', 0),
(162, 'about-us', 'Audio Solutions', '2014-08-05-13-32-13', '', '2014-08-05-13-32-13', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 207, 208, 0, '*', 0),
(163, 'about-us', 'Commercial Services', '2014-08-05-13-32-29', '', '2014-08-05-13-32-29', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 209, 210, 0, '*', 0),
(164, 'about-us', 'Music Production', '2014-08-05-13-32-45', '', '2014-08-05-13-32-45', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 211, 212, 0, '*', 0),
(267, 'mainmenu', 'Blue Theme', 'blue-theme', '', 'explore/template-themes/blue-theme', 'index.php?option=com_content&view=featured', 'component', 0, 125, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 10, '{"featured_categories":[""],"layout_type":"blog","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"images\\/blue-th.jpg","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":" home no-component","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 135, 136, 0, '*', 0),
(268, 'mainmenu', 'Red Theme', 'red-theme', '', 'explore/template-themes/red-theme', 'index.php?option=com_content&view=featured', 'component', 0, 125, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"featured_categories":[""],"layout_type":"blog","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"images\\/red-th.jpg","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":" home no-component","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 137, 138, 0, '*', 0),
(269, 'mainmenu', 'Green Theme', 'green-theme', '', 'explore/template-themes/green-theme', 'index.php?option=com_content&view=featured', 'component', 0, 125, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 11, '{"featured_categories":[""],"layout_type":"blog","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"images\\/green-th.jpg","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":" home no-component","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 139, 140, 0, '*', 0),
(270, 'mainmenu', 'Purple Theme', 'purple-theme', '', 'explore/template-themes/purple-theme', 'index.php?option=com_content&view=featured', 'component', 0, 125, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 12, '{"featured_categories":[""],"layout_type":"blog","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"images\\/purple-th.jpg","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":" home no-component","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 141, 142, 0, '*', 0),
(282, 'our-services', 'Event Management', '2014-09-11-10-16-38', '', '2014-09-11-10-16-38', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 213, 214, 0, '*', 0),
(283, 'about-us', 'Event Management', '2014-09-11-10-17-43', '', '2014-09-11-10-17-43', '#', 'url', 1, 1, 1, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 215, 216, 0, '*', 0),
(286, 'mainmenu', 'Home - Portfolio', 'portfolio', '', 'home/home-pages/portfolio', 'index.php?option=com_content&view=featured', 'component', 1, 299, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 16, '{"featured_categories":[""],"layout_type":"blog","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"Echo  - Portfolio","show_page_heading":0,"page_heading":"","pageclass_sfx":" no-component","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 51, 52, 0, '*', 0);
INSERT INTO `#__menu` (`id`, `menutype`, `title`, `alias`, `note`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `checked_out`, `checked_out_time`, `browserNav`, `access`, `img`, `template_style_id`, `params`, `lft`, `rgt`, `home`, `language`, `client_id`) VALUES
(287, 'mainmenu', 'Home - Magazine', 'magazine', '', 'home/home-pages/magazine', 'index.php?option=com_content&view=featured', 'component', 1, 299, 3, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 17, '{"featured_categories":[""],"layout_type":"blog","num_leading_articles":"","num_intro_articles":"","num_columns":"","num_links":"","multi_column_order":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_tags":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"Echo - Magazine","show_page_heading":0,"page_heading":"","pageclass_sfx":" no-component ","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 53, 54, 0, '*', 0),
(288, 'mainmenu', 'Home - Business', 'home-business-alias', '', 'home/home-pages/home-business-alias', 'index.php?Itemid=', 'alias', 1, 299, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"101","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 49, 50, 0, '*', 0),
(296, 'mainmenu', 'Layouts', 'layouts', '', 'home/layouts', 'index.php?Itemid=', 'alias', 1, 101, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"298","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 56, 65, 0, '*', 0),
(297, 'mainmenu', 'Content 1 Sidebar Right', 'content-1-sidebar-right', '', 'home/layouts/content-1-sidebar-right', 'index.php?option=com_k2&view=item&layout=item&id=26', 'component', 1, 296, 3, 10002, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 57, 58, 0, '*', 0),
(298, 'mainmenu', 'Content 1 Sidebar Left', 'content-1-sidebar-left', '', 'home/layouts/content-1-sidebar-left', 'index.php?option=com_k2&view=item&layout=item&id=18', 'component', 1, 296, 3, 10002, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 59, 60, 0, '*', 0),
(299, 'mainmenu', 'Home Pages', 'home-pages', '', 'home/home-pages', 'index.php?Itemid=', 'alias', 1, 101, 2, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"101","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 48, 55, 0, '*', 0),
(300, 'mainmenu', 'Content 2 Sidebar Left', 'content-2-sidebar-left', '', 'home/layouts/content-2-sidebar-left', 'index.php?option=com_k2&view=item&layout=item&id=26', 'component', 1, 296, 3, 10002, 0, '0000-00-00 00:00:00', 0, 1, '', 19, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 61, 62, 0, '*', 0),
(301, 'mainmenu', 'Content 2 Sidebar Right', 'content-2-sidebar-right', '', 'home/layouts/content-2-sidebar-right', 'index.php?option=com_k2&view=item&layout=item&id=18', 'component', 1, 296, 3, 10002, 0, '0000-00-00 00:00:00', 0, 1, '', 18, '{"menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 63, 64, 0, '*', 0),
(302, 'mainmenu', 'Joomla Categories', 'joomla-categories', '', 'joomla/content/joomla-categories', 'index.php?Itemid=', 'alias', 1, 129, 3, 0, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"aliasoptions":"306","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1}', 159, 168, 0, '*', 0),
(305, 'mainmenu', 'Commercial Services', 'commercial-services', '', 'joomla/content/joomla-categories/commercial-services', 'index.php?option=com_content&view=category&layout=blog&id=9', 'component', 1, 302, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"1","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 162, 163, 0, '*', 0),
(306, 'mainmenu', 'Audio Solutions', 'audio-solutions', '', 'joomla/content/joomla-categories/audio-solutions', 'index.php?option=com_content&view=category&layout=blog&id=10', 'component', 1, 302, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"1","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 160, 161, 0, '*', 0),
(307, 'mainmenu', 'Event Management', 'event-management', '', 'joomla/content/joomla-categories/event-management', 'index.php?option=com_content&view=category&layout=blog&id=18', 'component', 1, 302, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"1","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 164, 165, 0, '*', 0),
(308, 'mainmenu', 'Video And Music Production', 'video-and-music-production', '', 'joomla/content/joomla-categories/video-and-music-production', 'index.php?option=com_content&view=category&layout=blog&id=19', 'component', 1, 302, 4, 22, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"layout_type":"blog","show_category_heading_title_text":"","show_category_title":"","show_description":"","show_description_image":"","maxLevel":"","show_empty_categories":"","show_no_articles":"","show_subcat_desc":"","show_cat_num_articles":"","show_cat_tags":"","page_subheading":"","num_leading_articles":"","num_intro_articles":"","num_columns":"1","num_links":"","multi_column_order":"","show_subcategory_content":"","orderby_pri":"","orderby_sec":"","order_date":"","show_pagination":"","show_pagination_results":"","show_title":"","link_titles":"","show_intro":"","info_block_position":"","show_category":"","link_category":"","show_parent_category":"","link_parent_category":"","show_author":"","link_author":"","show_create_date":"","show_modify_date":"","show_publish_date":"","show_item_navigation":"","show_vote":"","show_readmore":"","show_readmore_title":"","show_icons":"","show_print_icon":"","show_email_icon":"","show_hits":"","show_noauth":"","show_feed_link":"","feed_summary":"","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 166, 167, 0, '*', 0),
(309, 'mainmenu', 'Minitek Wall 1', 'minitek-wall-1', '', 'pages/minitek-wall-1', 'index.php?option=com_minitekwall&view=wall', 'component', 1, 113, 2, 10027, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"module_id":"6","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 90, 91, 0, '*', 0),
(310, 'mainmenu', 'Minitek Wall 2', 'minitek-wall-2', '', 'pages/minitek-wall-2', 'index.php?option=com_minitekwall&view=wall', 'component', 1, 113, 2, 10027, 0, '0000-00-00 00:00:00', 0, 1, '', 0, '{"module_id":"7","menu-anchor_title":"","menu-anchor_css":"","menu_image":"","menu_text":1,"page_title":"","show_page_heading":0,"page_heading":"","pageclass_sfx":"","menu-meta_description":"","menu-meta_keywords":"","robots":"","secure":0}', 92, 93, 0, '*', 0),
(316, 'main', 'COM_MINITEKWALL_ADMIN_MENU', 'com-minitekwall-admin-menu', '', 'com-minitekwall-admin-menu', 'index.php?option=com_minitekwall', 'component', 0, 1, 1, 10027, 0, '0000-00-00 00:00:00', 0, 1, 'components/com_minitekwall/assets/images/dashboard/icons/icon-16-mls.png', 0, '', 217, 226, 0, '', 1),
(317, 'main', 'COM_MINITEKWALL_DASHBOARD', 'com-minitekwall-dashboard', '', 'com-minitekwall-admin-menu/com-minitekwall-dashboard', 'index.php?option=com_minitekwall', 'component', 0, 316, 2, 10027, 0, '0000-00-00 00:00:00', 0, 1, 'class:component', 0, '', 218, 219, 0, '', 1),
(318, 'main', 'COM_MINITEKWALL_MODULE_INSTANCES', 'com-minitekwall-module-instances', '', 'com-minitekwall-admin-menu/com-minitekwall-module-instances', 'index.php?option=com_minitekwall&view=instances', 'component', 0, 316, 2, 10027, 0, '0000-00-00 00:00:00', 0, 1, 'class:instance', 0, '', 220, 221, 0, '', 1),
(319, 'main', 'COM_MINITEKWALL_MODULES', 'com-minitekwall-modules', '', 'com-minitekwall-admin-menu/com-minitekwall-modules', 'index.php?option=com_minitekwall&view=modules', 'component', 0, 316, 2, 10027, 0, '0000-00-00 00:00:00', 0, 1, 'class:module', 0, '', 222, 223, 0, '', 1),
(320, 'main', 'COM_MINITEKWALL_ABOUT', 'com-minitekwall-about', '', 'com-minitekwall-admin-menu/com-minitekwall-about', 'index.php?option=com_minitekwall&view=about', 'component', 0, 316, 2, 10027, 0, '0000-00-00 00:00:00', 0, 1, 'class:info', 0, '', 224, 225, 0, '', 1);

DROP TABLE IF EXISTS `#__menu_types`;
CREATE TABLE IF NOT EXISTS `#__menu_types` (
`id` int(10) unsigned NOT NULL,
  `menutype` varchar(24) NOT NULL,
  `title` varchar(48) NOT NULL,
  `description` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

INSERT INTO `#__menu_types` (`id`, `menutype`, `title`, `description`) VALUES
(1, 'mainmenu', 'Main Menu', 'The main menu for the site'),
(2, 'our-services', 'Our Services', 'Our Services'),
(3, 'about-us', 'About us', 'About us');

DROP TABLE IF EXISTS `#__messages`;
CREATE TABLE IF NOT EXISTS `#__messages` (
`message_id` int(10) unsigned NOT NULL,
  `user_id_from` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id_to` int(10) unsigned NOT NULL DEFAULT '0',
  `folder_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `priority` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__messages_cfg`;
CREATE TABLE IF NOT EXISTS `#__messages_cfg` (
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cfg_name` varchar(100) NOT NULL DEFAULT '',
  `cfg_value` varchar(255) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__minitek_wall_instances`;
CREATE TABLE IF NOT EXISTS `#__minitek_wall_instances` (
`id` int(10) unsigned NOT NULL,
  `type_id` int(10) unsigned NOT NULL DEFAULT '0',
  `joomla_type` text NOT NULL,
  `jomsocial_type` text NOT NULL,
  `k2_type` text NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `attribs` varchar(5120) NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL COMMENT 'The language code for the instance.',
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.'
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

INSERT INTO `#__minitek_wall_instances` (`id`, `type_id`, `joomla_type`, `jomsocial_type`, `k2_type`, `asset_id`, `title`, `alias`, `description`, `state`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `attribs`, `ordering`, `access`, `language`, `xreference`) VALUES
(1, 1, '{"joomla_mode":"ja","joomla_articles_mode":"normal","joomla_articles_title":"JOOMLA_ARTICLES","enable_joomla_articles_title":"1","joomla_articles_category_filtering_type":"1","joomla_articles_catid":["9","10","18","19"],"joomla_articles_show_child_category_articles":"1","joomla_articles_levels":"1","joomla_articles_author_filtering_type":"1","joomla_articles_created_by":[""],"joomla_articles_author_alias_filtering_type":"1","joomla_articles_created_by_alias":[""],"joomla_articles_date_filtering":"off","joomla_articles_date_field":"a.created","joomla_articles_start_date_range":"","joomla_articles_end_date_range":"","joomla_articles_relative_date":"30","joomla_articles_show_front":"show","joomla_articles_excluded_articles":"","joomla_articles_article_ordering":"a.title","joomla_articles_article_ordering_direction":"ASC","enable_joomla_article_photo":"1","joomla_article_image_type":"fulltext","joomla_article_crop_images":"0","joomla_article_crop_width":"400","joomla_article_crop_height":"300","enable_joomla_article_introtext":"1","joomla_article_introtext_limit":"15","enable_joomla_article_category":"1","enable_joomla_article_author":"1","enable_joomla_article_date":"1","joomla_article_date_field":"created","joomla_article_date_format":"F d, Y","joomla_categories_title":"JOOMLA_CATEGORIES","enable_joomla_categories_title":"1","joomla_categories_include_categories":"2","joomla_categories_search_categories_children":"1","enable_joomla_category_photo":"1","joomla_category_crop_images":"0","joomla_category_crop_width":"400","joomla_category_crop_height":"300","enable_joomla_category_description":"1","joomla_category_description_limit":"15","enable_joomla_category_items_count":"1","joomla_categories_ordering":"alpha"}', '', '', 169, 'Our Work - Business', 'our-work', 'Our Work', 1, '2014-09-12 10:35:08', 400, '', '2014-09-17 13:47:45', 400, 0, '0000-00-00 00:00:00', '2014-09-12 10:35:08', '0000-00-00 00:00:00', '', 0, 1, '', ''),
(2, 1, '{"joomla_mode":"ja","joomla_articles_mode":"normal","joomla_articles_title":"JOOMLA_ARTICLES","enable_joomla_articles_title":"1","joomla_articles_category_filtering_type":"1","joomla_articles_catid":["9","10","18","19"],"joomla_articles_show_child_category_articles":"1","joomla_articles_levels":"1","joomla_articles_author_filtering_type":"1","joomla_articles_created_by":[""],"joomla_articles_author_alias_filtering_type":"1","joomla_articles_created_by_alias":[""],"joomla_articles_date_filtering":"off","joomla_articles_date_field":"a.created","joomla_articles_start_date_range":"","joomla_articles_end_date_range":"","joomla_articles_relative_date":"30","joomla_articles_show_front":"show","joomla_articles_excluded_articles":"29\\r\\n30","joomla_articles_article_ordering":"a.title","joomla_articles_article_ordering_direction":"ASC","enable_joomla_article_photo":"1","joomla_article_image_type":"introtext","joomla_article_crop_images":"0","joomla_article_crop_width":"400","joomla_article_crop_height":"300","enable_joomla_article_introtext":"1","joomla_article_introtext_limit":"15","enable_joomla_article_category":"1","enable_joomla_article_author":"1","enable_joomla_article_date":"1","joomla_article_date_field":"created","joomla_article_date_format":"F d, Y","joomla_categories_title":"JOOMLA_CATEGORIES","enable_joomla_categories_title":"1","joomla_categories_include_categories":"2","joomla_categories_search_categories_children":"1","enable_joomla_category_photo":"1","joomla_category_crop_images":"0","joomla_category_crop_width":"400","joomla_category_crop_height":"300","enable_joomla_category_description":"1","joomla_category_description_limit":"15","enable_joomla_category_items_count":"1","joomla_categories_ordering":"alpha"}', '', '', 184, 'This is Our Portfolio', 'this-is-our-portfolio-portfolio', '', 1, '2014-09-12 11:19:01', 400, '', '2014-09-17 13:48:36', 400, 0, '0000-00-00 00:00:00', '2014-09-12 11:19:01', '0000-00-00 00:00:00', '', 0, 1, '', ''),
(4, 1, '{"joomla_mode":"jc","joomla_articles_mode":"normal","joomla_articles_title":"JOOMLA_ARTICLES","enable_joomla_articles_title":"1","joomla_articles_category_filtering_type":"1","joomla_articles_catid":[""],"joomla_articles_show_child_category_articles":"1","joomla_articles_levels":"1","joomla_articles_author_filtering_type":"1","joomla_articles_created_by":[""],"joomla_articles_author_alias_filtering_type":"1","joomla_articles_created_by_alias":[""],"joomla_articles_date_filtering":"off","joomla_articles_date_field":"a.created","joomla_articles_start_date_range":"","joomla_articles_end_date_range":"","joomla_articles_relative_date":"30","joomla_articles_show_front":"show","joomla_articles_excluded_articles":"","joomla_articles_article_ordering":"a.title","joomla_articles_article_ordering_direction":"ASC","enable_joomla_article_photo":"1","joomla_article_image_type":"introtext","joomla_article_crop_images":"0","joomla_article_crop_width":"400","joomla_article_crop_height":"300","enable_joomla_article_introtext":"1","joomla_article_introtext_limit":"15","enable_joomla_article_category":"1","enable_joomla_article_author":"1","enable_joomla_article_date":"1","joomla_article_date_field":"created","joomla_article_date_format":"F d, Y","joomla_categories_title":"JOOMLA_CATEGORIES","enable_joomla_categories_title":"1","joomla_categories_include_categories":"8","joomla_categories_search_categories_children":"1","enable_joomla_category_photo":"1","joomla_category_crop_images":"0","joomla_category_crop_width":"400","joomla_category_crop_height":"300","enable_joomla_category_description":"1","joomla_category_description_limit":"15","enable_joomla_category_items_count":"1","joomla_categories_ordering":"alpha"}', '', '', 194, 'Magazine Categories', 'magazine-categories', '', 1, '2014-09-12 12:22:31', 400, '', '2014-09-14 22:05:00', 400, 0, '0000-00-00 00:00:00', '2014-09-12 12:22:31', '0000-00-00 00:00:00', '', 0, 1, '', ''),
(5, 1, '{"joomla_mode":"ja","joomla_articles_mode":"normal","joomla_articles_title":"JOOMLA_ARTICLES","enable_joomla_articles_title":"1","joomla_articles_category_filtering_type":"1","joomla_articles_catid":["10"],"joomla_articles_show_child_category_articles":"1","joomla_articles_levels":"1","joomla_articles_author_filtering_type":"1","joomla_articles_created_by":[""],"joomla_articles_author_alias_filtering_type":"1","joomla_articles_created_by_alias":[""],"joomla_articles_date_filtering":"off","joomla_articles_date_field":"a.created","joomla_articles_start_date_range":"","joomla_articles_end_date_range":"","joomla_articles_relative_date":"30","joomla_articles_show_front":"show","joomla_articles_excluded_articles":"","joomla_articles_article_ordering":"a.title","joomla_articles_article_ordering_direction":"ASC","enable_joomla_article_photo":"1","joomla_article_image_type":"introtext","joomla_article_crop_images":"0","joomla_article_crop_width":"400","joomla_article_crop_height":"300","enable_joomla_article_introtext":"1","joomla_article_introtext_limit":"15","enable_joomla_article_category":"1","enable_joomla_article_author":"1","enable_joomla_article_date":"1","joomla_article_date_field":"created","joomla_article_date_format":"F d, Y","joomla_categories_title":"JOOMLA_CATEGORIES","enable_joomla_categories_title":"1","joomla_categories_include_categories":"2","joomla_categories_search_categories_children":"1","enable_joomla_category_photo":"1","joomla_category_crop_images":"0","joomla_category_crop_width":"400","joomla_category_crop_height":"300","enable_joomla_category_description":"1","joomla_category_description_limit":"15","enable_joomla_category_items_count":"1","joomla_categories_ordering":"alpha"}', '', '', 205, 'Audio Solutions - Magazine', 'audio-soloutions-magazine', '', 0, '2014-09-14 19:10:43', 400, '', '2014-09-17 13:49:22', 400, 0, '0000-00-00 00:00:00', '2014-09-14 19:10:43', '0000-00-00 00:00:00', '', 0, 1, '', ''),
(6, 1, '{"joomla_mode":"ja","joomla_articles_mode":"normal","joomla_articles_title":"JOOMLA_ARTICLES","enable_joomla_articles_title":"1","joomla_articles_category_filtering_type":"1","joomla_articles_catid":["9","10","18","19"],"joomla_articles_show_child_category_articles":"1","joomla_articles_levels":"1","joomla_articles_author_filtering_type":"1","joomla_articles_created_by":[""],"joomla_articles_author_alias_filtering_type":"1","joomla_articles_created_by_alias":[""],"joomla_articles_date_filtering":"off","joomla_articles_date_field":"a.created","joomla_articles_start_date_range":"","joomla_articles_end_date_range":"","joomla_articles_relative_date":"30","joomla_articles_show_front":"show","joomla_articles_excluded_articles":"","joomla_articles_article_ordering":"a.title","joomla_articles_article_ordering_direction":"ASC","enable_joomla_article_photo":"1","joomla_article_image_type":"introtext","joomla_article_crop_images":"0","joomla_article_crop_width":"400","joomla_article_crop_height":"300","enable_joomla_article_introtext":"1","joomla_article_introtext_limit":"15","enable_joomla_article_category":"1","enable_joomla_article_author":"1","enable_joomla_article_date":"1","joomla_article_date_field":"created","joomla_article_date_format":"F d, Y","joomla_categories_title":"JOOMLA_CATEGORIES","enable_joomla_categories_title":"1","joomla_categories_include_categories":"2","joomla_categories_search_categories_children":"1","enable_joomla_category_photo":"1","joomla_category_crop_images":"0","joomla_category_crop_width":"400","joomla_category_crop_height":"300","enable_joomla_category_description":"1","joomla_category_description_limit":"15","enable_joomla_category_items_count":"1","joomla_categories_ordering":"alpha"}', '', '', 236, 'Minitek Wall 1', 'minitek-wall-page', '', 1, '2014-09-16 18:38:47', 400, '', '2014-09-17 13:48:54', 400, 0, '0000-00-00 00:00:00', '2014-09-16 18:38:47', '0000-00-00 00:00:00', '', 0, 1, '', ''),
(7, 1, '{"joomla_mode":"ja","joomla_articles_mode":"normal","joomla_articles_title":"JOOMLA_ARTICLES","enable_joomla_articles_title":"1","joomla_articles_category_filtering_type":"1","joomla_articles_catid":["9","10","18","19"],"joomla_articles_show_child_category_articles":"1","joomla_articles_levels":"1","joomla_articles_author_filtering_type":"1","joomla_articles_created_by":[""],"joomla_articles_author_alias_filtering_type":"1","joomla_articles_created_by_alias":[""],"joomla_articles_date_filtering":"off","joomla_articles_date_field":"a.created","joomla_articles_start_date_range":"","joomla_articles_end_date_range":"","joomla_articles_relative_date":"30","joomla_articles_show_front":"show","joomla_articles_excluded_articles":"","joomla_articles_article_ordering":"a.title","joomla_articles_article_ordering_direction":"ASC","enable_joomla_article_photo":"1","joomla_article_image_type":"introtext","joomla_article_crop_images":"0","joomla_article_crop_width":"400","joomla_article_crop_height":"300","enable_joomla_article_introtext":"1","joomla_article_introtext_limit":"15","enable_joomla_article_category":"1","enable_joomla_article_author":"1","enable_joomla_article_date":"1","joomla_article_date_field":"created","joomla_article_date_format":"F d, Y","joomla_categories_title":"JOOMLA_CATEGORIES","enable_joomla_categories_title":"1","joomla_categories_include_categories":"2","joomla_categories_search_categories_children":"1","enable_joomla_category_photo":"1","joomla_category_crop_images":"0","joomla_category_crop_width":"400","joomla_category_crop_height":"300","enable_joomla_category_description":"1","joomla_category_description_limit":"15","enable_joomla_category_items_count":"1","joomla_categories_ordering":"alpha"}', '', '', 237, 'Minitek Wall 2', 'minitek-wall-page-2', '', 1, '2014-09-16 18:39:03', 400, '', '2014-09-17 13:49:10', 400, 0, '0000-00-00 00:00:00', '2014-09-16 18:39:03', '0000-00-00 00:00:00', '', 0, 1, '', '');

DROP TABLE IF EXISTS `#__minitek_wall_modules`;
CREATE TABLE IF NOT EXISTS `#__minitek_wall_modules` (
`id` int(11) unsigned NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `instance_id` int(10) unsigned NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `module_type` text NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

INSERT INTO `#__minitek_wall_modules` (`id`, `asset_id`, `name`, `instance_id`, `description`, `module_type`, `published`, `checked_out`, `checked_out_time`) VALUES
(1, 170, 'Our Work - Business', 1, '', '{"grid":"98o","mas_cols":"2","gutter":"20","themeType":"2","detailBox":"0","detailBoxBackground":"#ffffff","detailBoxBackgroundOpacity":"0.75","detailBoxTextColor":"1","detailBoxTitle":"0","detailBoxCategory":"0","detailBoxType":"0","detailBoxAuthor":"0","detailBoxDate":"0","detailBoxIntrotext":"0","detailBoxCount":"0","hoverBox":"1","hoverBoxEffect":"1","hoverBoxEffectSpeed":"0.4","hoverBoxContentEffect":"1","hoverBoxContentEffectSpeed":"0.4","hoverBoxTheme":"black","hoverBoxTextColor":"2","hoverBoxTitle":"1","hoverBoxCategory":"0","hoverBoxType":"0","hoverBoxAuthor":"0","hoverBoxDate":"0","hoverBoxIntrotext":"0","hoverBoxLinkButton":"1","hoverBoxFancyButton":"1","pagination":"0","starting_limit":"4","filter_type":"1","category_filters":"1","tag_filters":"0"}', 1, 0, '0000-00-00 00:00:00'),
(2, 185, 'This is Our Portfolio', 2, '', '{"grid":"5","mas_cols":"3","gutter":"10","themeType":"2","detailBox":"0","detailBoxBackground":"#ffffff","detailBoxBackgroundOpacity":"0.75","detailBoxTextColor":"1","detailBoxTitle":"0","detailBoxCategory":"0","detailBoxType":"0","detailBoxAuthor":"0","detailBoxDate":"0","detailBoxIntrotext":"0","detailBoxCount":"0","hoverBox":"1","hoverBoxEffect":"1","hoverBoxEffectSpeed":"0.4","hoverBoxContentEffect":"1","hoverBoxContentEffectSpeed":"0.4","hoverBoxTheme":"black","hoverBoxTextColor":"2","hoverBoxTitle":"1","hoverBoxCategory":"0","hoverBoxType":"0","hoverBoxAuthor":"0","hoverBoxDate":"0","hoverBoxIntrotext":"0","hoverBoxLinkButton":"1","hoverBoxFancyButton":"1","pagination":"0","starting_limit":"5","filter_type":"1","category_filters":"1","tag_filters":"0"}', 1, 0, '0000-00-00 00:00:00'),
(4, 195, 'Magazine Categories', 4, '', '{"grid":"3a","mas_cols":"3","gutter":"15","themeType":"2","detailBox":"1","detailBoxBackground":"#ffffff","detailBoxBackgroundOpacity":"0.75","detailBoxTextColor":"1","detailBoxTitle":"1","detailBoxCategory":"0","detailBoxType":"0","detailBoxAuthor":"0","detailBoxDate":"0","detailBoxIntrotext":"0","detailBoxCount":"0","hoverBox":"1","hoverBoxEffect":"1","hoverBoxEffectSpeed":"0.4","hoverBoxContentEffect":"1","hoverBoxContentEffectSpeed":"0.4","hoverBoxTheme":"black","hoverBoxTextColor":"2","hoverBoxTitle":"1","hoverBoxCategory":"1","hoverBoxType":"0","hoverBoxAuthor":"0","hoverBoxDate":"0","hoverBoxIntrotext":"0","hoverBoxLinkButton":"1","hoverBoxFancyButton":"1","pagination":"0","starting_limit":"3","filter_type":"1","category_filters":"0","tag_filters":"0"}', 1, 0, '0000-00-00 00:00:00'),
(6, 238, 'Minitek Wall 1', 6, '', '{"grid":"5","mas_cols":"4","gutter":"5","themeType":"2","detailBox":"1","detailBoxBackground":"#000000","detailBoxBackgroundOpacity":"0.75","detailBoxTextColor":"2","detailBoxTitle":"0","detailBoxCategory":"1","detailBoxType":"0","detailBoxAuthor":"0","detailBoxDate":"0","detailBoxIntrotext":"0","detailBoxCount":"0","hoverBox":"1","hoverBoxEffect":"1","hoverBoxEffectSpeed":"0.4","hoverBoxContentEffect":"1","hoverBoxContentEffectSpeed":"0.4","hoverBoxTheme":"black","hoverBoxTextColor":"2","hoverBoxTitle":"1","hoverBoxCategory":"1","hoverBoxType":"0","hoverBoxAuthor":"0","hoverBoxDate":"0","hoverBoxIntrotext":"0","hoverBoxLinkButton":"1","hoverBoxFancyButton":"1","pagination":"0","starting_limit":"10","filter_type":"1","category_filters":"1","tag_filters":"0"}', 1, 0, '0000-00-00 00:00:00'),
(7, 239, 'Minitek Wall 2', 7, '', '{"grid":"98o","mas_cols":"3","gutter":"10","themeType":"2","detailBox":"1","detailBoxBackground":"#000000","detailBoxBackgroundOpacity":"0.75","detailBoxTextColor":"2","detailBoxTitle":"1","detailBoxCategory":"0","detailBoxType":"0","detailBoxAuthor":"0","detailBoxDate":"0","detailBoxIntrotext":"0","detailBoxCount":"0","hoverBox":"1","hoverBoxEffect":"1","hoverBoxEffectSpeed":"0.4","hoverBoxContentEffect":"1","hoverBoxContentEffectSpeed":"0.4","hoverBoxTheme":"black","hoverBoxTextColor":"2","hoverBoxTitle":"1","hoverBoxCategory":"1","hoverBoxType":"0","hoverBoxAuthor":"0","hoverBoxDate":"0","hoverBoxIntrotext":"0","hoverBoxLinkButton":"1","hoverBoxFancyButton":"1","pagination":"0","starting_limit":"12","filter_type":"1","category_filters":"1","tag_filters":"0"}', 1, 0, '0000-00-00 00:00:00');

DROP TABLE IF EXISTS `#__minitek_wall_types`;
CREATE TABLE IF NOT EXISTS `#__minitek_wall_types` (
  `id` int(10) unsigned NOT NULL,
  `value` varchar(200) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__minitek_wall_types` (`id`, `value`) VALUES
(1, 'Joomla'),
(2, 'K2'),
(3, 'Jomsocial');

DROP TABLE IF EXISTS `#__modules`;
CREATE TABLE IF NOT EXISTS `#__modules` (
`id` int(11) NOT NULL,
  `asset_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(100) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `position` varchar(50) NOT NULL DEFAULT '',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `module` varchar(50) DEFAULT NULL,
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `showtitle` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `params` text NOT NULL,
  `client_id` tinyint(4) NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=182 ;

INSERT INTO `#__modules` (`id`, `asset_id`, `title`, `note`, `content`, `ordering`, `position`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `published`, `module`, `access`, `showtitle`, `params`, `client_id`, `language`) VALUES
(2, 56, 'Login', '', '', 1, 'login', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '', 1, '*'),
(3, 57, 'Popular Articles', '', '', 3, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_popular', 3, 1, '{"count":"5","catid":"","user_id":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(4, 58, 'Recently Added Articles', '', '', 4, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_latest', 3, 1, '{"count":"5","ordering":"c_dsc","catid":"","user_id":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(8, 59, 'Toolbar', '', '', 1, 'toolbar', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_toolbar', 3, 1, '', 1, '*'),
(9, 60, 'Quick Icons', '', '', 1, 'icon', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_quickicon', 3, 1, '', 1, '*'),
(10, 61, 'Logged-in Users', '', '', 2, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_logged', 3, 1, '{"count":"5","name":"1","layout":"_:default","moduleclass_sfx":"","cache":"0","automatic_title":"1"}', 1, '*'),
(12, 62, 'Admin Menu', '', '', 1, 'menu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 3, 1, '{"layout":"","moduleclass_sfx":"","shownew":"1","showhelp":"1","cache":"0"}', 1, '*'),
(13, 63, 'Admin Submenu', '', '', 1, 'submenu', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_submenu', 3, 1, '', 1, '*'),
(14, 64, 'User Status', '', '', 2, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_status', 3, 1, '', 1, '*'),
(15, 65, 'Title', '', '', 1, 'title', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_title', 3, 1, '', 1, '*'),
(79, 68, 'Multilanguage status', '', '', 1, 'status', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, 'mod_multilangstatus', 3, 1, '{"layout":"_:default","moduleclass_sfx":"","cache":"0"}', 1, '*'),
(86, 69, 'Joomla Version', '', '', 1, 'footer', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_version', 3, 1, '{"format":"short","product":"1","layout":"_:default","moduleclass_sfx":"","cache":"0"}', 1, '*'),
(92, 60, 'K2 Quick Icons (admin)', '', '', 0, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_quickicons', 1, 1, '', 1, '*'),
(93, 61, 'K2 Stats (admin)', '', '', 0, 'cpanel', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_stats', 1, 1, '', 1, '*'),
(94, 82, 'Off Canvas Menu', '', '', 1, 'off-canvas', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 0, '{"menutype":"mainmenu","base":"","startLevel":"1","endLevel":"2","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(95, 91, 'Latest Articles', '', '', 1, 'sidebar-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_content', 1, 1, '{"moduleclass_sfx":" mn-module-dark","getTemplate":"minitek","source":"specific","catfilter":"0","getChildren":"0","itemCount":"3","itemsOrdering":"","FeaturedItems":"1","popularityRange":"","videosOnly":"0","item":"0","items":["3","2","1"],"itemTitle":"1","itemAuthor":"0","itemAuthorAvatar":"0","itemAuthorAvatarWidthSelect":"inherit","itemAuthorAvatarWidth":"50","userDescription":"0","itemIntroText":"1","itemIntroTextWordLimit":"6","itemImage":"1","itemImgSize":"XSmall","itemVideo":"0","itemVideoCaption":"0","itemVideoCredits":"0","itemAttachments":"0","itemTags":"0","itemCategory":"0","itemDateCreated":"0","itemHits":"0","itemReadMore":"0","itemExtraFields":"0","itemCommentsCounter":"0","feed":"0","itemPreText":"","itemCustomLink":"0","itemCustomLinkTitle":"","itemCustomLinkURL":"http:\\/\\/","itemCustomLinkMenuItem":"150","K2Plugins":"1","JPlugins":"1","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(96, 92, 'Copyright', '', '<div class="col-md-9">\r\n  <small>Copyright &copy; 2014 Minitek. All Rights Reserved. Designed by <a title="Visit Minitek.gr!" href="http://www.minitek.gr/">minitek.gr</a>.</small>\r\n<small><a href="http://www.joomla.org">Joomla!</a> is Free Software released under the <a href="http://www.gnu.org/licenses/gpl-2.0.html">GNU General Public License.</a></small>\r\n</div>\r\n\r\n<div class="col-md-3 poweredby">\r\n  <a class="t3-logo t3-logo-light" href="http://t3-framework.org" target="_blank"></a>\r\n</div>\r\n', 1, 'Copyright', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(97, 93, 'Our Services', '', '', 1, 'footer-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"our-services","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(98, 94, 'About us', '', '', 1, 'footer-3', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_menu', 1, 1, '{"menutype":"about-us","base":"","startLevel":"1","endLevel":"0","showAllChildren":"1","tag_id":"","class_sfx":"","window_open":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(119, 115, 'Login', '', '', 1, 'login-popup', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '{"pretext":"","posttext":"","login":"","logout":"","greeting":"1","name":"0","usesecure":"0","usetext":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(120, 116, 'Search', '', '', 1, 'search-popup', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_search', 1, 1, '{"label":"","width":"20","text":"","button":"1","button_pos":"left","imagebutton":"0","button_text":"","opensearch":"0","opensearch_title":"","set_itemid":"0","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(121, 117, 'Categories', '', '', 1, 'sidebar-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_tools', 1, 1, '{"moduleclass_sfx":" mn-module-dark","module_usage":"4","archiveItemsCounter":"1","archiveCategory":"0","authors_module_category":"0","authorItemsCounter":"1","authorAvatar":"1","authorAvatarWidthSelect":"custom","authorAvatarWidth":"50","authorLatestItem":"1","calendarCategory":"0","home":"","seperator":"","root_id":"1","end_level":"","categoriesListOrdering":"","categoriesListItemsCounter":"0","root_id2":"0","catfilter":"0","getChildren":"0","liveSearch":"","width":"20","text":"","button":"","imagebutton":"","button_text":"","min_size":"75","max_size":"300","cloud_limit":"30","cloud_category":["0"],"cloud_category_recursive":"0","customCode":"","parsePhp":"0","K2Plugins":"0","JPlugins":"0","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(122, 118, 'Tags', '', '', 1, 'sidebar-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_tools', 1, 1, '{"moduleclass_sfx":" mn-module-dark","module_usage":"7","archiveItemsCounter":"1","archiveCategory":"0","authors_module_category":"0","authorItemsCounter":"1","authorAvatar":"1","authorAvatarWidthSelect":"custom","authorAvatarWidth":"50","authorLatestItem":"1","calendarCategory":"0","home":"","seperator":"","root_id":"0","end_level":"","categoriesListOrdering":"","categoriesListItemsCounter":"1","root_id2":"0","catfilter":"0","getChildren":"0","liveSearch":"","width":"20","text":"","button":"","imagebutton":"","button_text":"","min_size":"75","max_size":"300","cloud_limit":"30","cloud_category":["0"],"cloud_category_recursive":"0","customCode":"","parsePhp":"0","K2Plugins":"0","JPlugins":"0","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(123, 119, 'Latest Comments', '', '', 1, 'sidebar-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_comments', 1, 1, '{"moduleclass_sfx":" mn-module-dark","module_usage":"0","catfilter":"0","comments_limit":"2","comments_word_limit":"8","commenterName":"1","commentAvatar":"1","commentAvatarWidthSelect":"custom","commentAvatarWidth":"50","commentDate":"0","commentDateFormat":"absolute","commentLink":"1","itemTitle":"0","itemCategory":"0","feed":"0","commenters_limit":"5","commenterNameOrUsername":"1","commenterAvatar":"1","commenterAvatarWidthSelect":"custom","commenterAvatarWidth":"50","commenterLink":"1","commenterCommentsCounter":"1","commenterLatestComment":"1","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(133, 138, 'Off-canvas Social', '', '<ul class="social-media-icons">\r\n  <li class="facebook">\r\n    <a class="facebook" href="#"><i class="fa fa-facebook"></i></a>\r\n  </li>\r\n  <li class="twitter">\r\n    <a class="twitter" href="#"><i class="fa fa-twitter"></i></a>\r\n  </li>\r\n  <li class="google-plus">\r\n    <a class="google-plus" href="#"><i class="fa fa-google-plus"></i></a>\r\n  </li>\r\n  <li class="linkedin">\r\n    <a class="linkedin" href="#"><i class="fa fa-linkedin"></i></a>\r\n  </li>\r\n  <li class="pinterest">\r\n    <a class="pinterest" href="#"><i class="fa fa-pinterest"></i></a>\r\n  </li>\r\n</ul>', 1, 'off-canvas', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(134, 147, 'Blog Categories', '', '', 1, 'sidebar-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_categories', 1, 1, '{"parent":"8","show_description":"0","numitems":"0","show_children":"0","count":"0","maxlevel":"0","layout":"_:default","item_heading":"4","moduleclass_sfx":" mn-module-dark","owncache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(135, 148, 'Category Articles', '', '', 1, 'sidebar-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_category', 1, 1, '{"mode":"dynamic","show_on_article_page":"1","show_front":"show","count":"0","category_filtering_type":"1","catid":[""],"show_child_category_articles":"0","levels":"1","author_filtering_type":"1","created_by":[""],"author_alias_filtering_type":"1","created_by_alias":[""],"excluded_articles":"","date_filtering":"off","date_field":"a.created","start_date_range":"","end_date_range":"","relative_date":"30","article_ordering":"a.title","article_ordering_direction":"ASC","article_grouping":"none","article_grouping_direction":"ksort","month_year_format":"F Y","link_titles":"1","show_date":"0","show_date_field":"created","show_date_format":"Y-m-d H:i:s","show_category":"0","show_hits":"0","show_author":"0","show_introtext":"0","introtext_limit":"100","show_readmore":"0","show_readmore_title":"1","readmore_limit":"15","layout":"_:default","moduleclass_sfx":" mn-module-dark","owncache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(136, 149, 'mod_dark', '', '', 1, 'position-37', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_tools', 1, 1, '{"moduleclass_sfx":" mod_dark formatModule","module_usage":"4","archiveItemsCounter":"1","archiveCategory":"0","authors_module_category":"0","authorItemsCounter":"1","authorAvatar":"1","authorAvatarWidthSelect":"custom","authorAvatarWidth":"50","authorLatestItem":"1","calendarCategory":"0","home":"","seperator":"","root_id":"0","end_level":"","categoriesListOrdering":"","categoriesListItemsCounter":"1","root_id2":"0","catfilter":"0","getChildren":"0","liveSearch":"","width":"20","text":"","button":"","imagebutton":"","button_text":"","min_size":"75","max_size":"300","cloud_limit":"30","cloud_category":["0"],"cloud_category_recursive":"0","customCode":"","parsePhp":"0","K2Plugins":"0","JPlugins":"0","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(137, 150, 'mod_blue', '', '', 1, 'position-38', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_tools', 1, 1, '{"moduleclass_sfx":" mod_blue formatModule","module_usage":"4","archiveItemsCounter":"1","archiveCategory":"0","authors_module_category":"0","authorItemsCounter":"1","authorAvatar":"1","authorAvatarWidthSelect":"custom","authorAvatarWidth":"50","authorLatestItem":"1","calendarCategory":"0","home":"","seperator":"","root_id":"0","end_level":"","categoriesListOrdering":"","categoriesListItemsCounter":"1","root_id2":"0","catfilter":"0","getChildren":"0","liveSearch":"","width":"20","text":"","button":"","imagebutton":"","button_text":"","min_size":"75","max_size":"300","cloud_limit":"30","cloud_category":["0"],"cloud_category_recursive":"0","customCode":"","parsePhp":"0","K2Plugins":"0","JPlugins":"0","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(138, 151, 'mod_orange', '', '', 1, 'position-37', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_tools', 1, 1, '{"moduleclass_sfx":" mod_orange formatModule","module_usage":"4","archiveItemsCounter":"1","archiveCategory":"0","authors_module_category":"0","authorItemsCounter":"1","authorAvatar":"1","authorAvatarWidthSelect":"custom","authorAvatarWidth":"50","authorLatestItem":"1","calendarCategory":"0","home":"","seperator":"","root_id":"0","end_level":"","categoriesListOrdering":"","categoriesListItemsCounter":"1","root_id2":"0","catfilter":"0","getChildren":"0","liveSearch":"","width":"20","text":"","button":"","imagebutton":"","button_text":"","min_size":"75","max_size":"300","cloud_limit":"30","cloud_category":["0"],"cloud_category_recursive":"0","customCode":"","parsePhp":"0","K2Plugins":"0","JPlugins":"0","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(139, 152, 'mod_red', '', '', 1, 'position-39', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_tools', 1, 1, '{"moduleclass_sfx":" mod_red formatModule","module_usage":"4","archiveItemsCounter":"1","archiveCategory":"0","authors_module_category":"0","authorItemsCounter":"1","authorAvatar":"1","authorAvatarWidthSelect":"custom","authorAvatarWidth":"50","authorLatestItem":"1","calendarCategory":"0","home":"","seperator":"","root_id":"0","end_level":"","categoriesListOrdering":"","categoriesListItemsCounter":"1","root_id2":"0","catfilter":"0","getChildren":"0","liveSearch":"","width":"20","text":"","button":"","imagebutton":"","button_text":"","min_size":"75","max_size":"300","cloud_limit":"30","cloud_category":["0"],"cloud_category_recursive":"0","customCode":"","parsePhp":"0","K2Plugins":"0","JPlugins":"0","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(142, 156, 'mod_green', '', '', 1, 'position-38', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_tools', 1, 1, '{"moduleclass_sfx":" mod_green formatModule","module_usage":"4","archiveItemsCounter":"1","archiveCategory":"0","authors_module_category":"0","authorItemsCounter":"1","authorAvatar":"1","authorAvatarWidthSelect":"custom","authorAvatarWidth":"50","authorLatestItem":"1","calendarCategory":"0","home":"","seperator":"","root_id":"0","end_level":"","categoriesListOrdering":"","categoriesListItemsCounter":"1","root_id2":"0","catfilter":"0","getChildren":"0","liveSearch":"","width":"20","text":"","button":"","imagebutton":"","button_text":"","min_size":"75","max_size":"300","cloud_limit":"30","cloud_category":["0"],"cloud_category_recursive":"0","customCode":"","parsePhp":"0","K2Plugins":"0","JPlugins":"0","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(143, 157, 'mn-module-light', '', '', 1, 'position-39', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_tools', 1, 1, '{"moduleclass_sfx":" mn-module-light","module_usage":"4","archiveItemsCounter":"1","archiveCategory":"0","authors_module_category":"0","authorItemsCounter":"1","authorAvatar":"1","authorAvatarWidthSelect":"custom","authorAvatarWidth":"50","authorLatestItem":"1","calendarCategory":"0","home":"","seperator":"","root_id":"0","end_level":"","categoriesListOrdering":"","categoriesListItemsCounter":"1","root_id2":"0","catfilter":"0","getChildren":"0","liveSearch":"","width":"20","text":"","button":"","imagebutton":"","button_text":"","min_size":"75","max_size":"300","cloud_limit":"30","cloud_category":["0"],"cloud_category_recursive":"0","customCode":"","parsePhp":"0","K2Plugins":"0","JPlugins":"0","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(146, 160, 'Our Services', '', '<div class="mn-mod-header mn-mod-header-features">\r\n	<div class="mn-title">\r\n		<h2>Our Services</h2>\r\n		<h3>Solutions for all Kinds of Media and Events</h3>\r\n      <hr>\r\n	</div>\r\n</div>\r\n<div class="col-xs-12 col-md-4 mn-features text-center">\r\n	<div class="mn-features-inner">\r\n		<div class="mn-features-ico"> <img src="images/echo/features/feature1.png" border="0" alt="Testimonials1"> </div>\r\n		<div class="mn-features-title"><h4>Audio Post Production</h4></div>\r\n		<div class="mn-features-desc text-center">\r\n			<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. </p>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class="col-xs-12 col-md-4 mn-features text-center">\r\n	<div class="mn-features-inner">\r\n		<div class="mn-features-ico"><img src="images/echo/features/feature2.png" border="0" alt="Testimonials2"> </div>\r\n		<div class="mn-features-title"><h4>Radio Production</h4></div>\r\n		<div class="mn-features-desc text-center">\r\n			<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. </p>\r\n		</div>\r\n	</div>\r\n</div>\r\n<div class="col-xs-12 col-md-4 mn-features text-center">\r\n	<div class="mn-features-inner">\r\n		<div class="mn-features-ico"><img src="images/echo/features/feature3.png" border="0" alt="Testimonials3"> </div>\r\n		<div class="mn-features-title"><h4>Video Commercials</h4></div>\r\n		<div class="mn-features-desc text-center">\r\n			<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. </p>\r\n		</div>\r\n	</div>\r\n</div>\r\n', 1, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(147, 161, 'Our Facilities', '', '<div class="mn-parallax-background">\r\n<div class="container mn-title-parallax">\r\n  <h3>Our Facilities Are Located in the Heart of <mark>Media’s</mark> City but Actually Our <mark>Media Production</mark> Offices are All Around the World</h3>\r\n</div>\r\n</div>', 1, 'mn-parallax1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"images\\/echo\\/parallax\\/parallax1.jpg","layout":"_:default","moduleclass_sfx":" mn-parallax","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(148, 162, 'Our Comprehensive Stuff', '', '<div class="mn-parallax-background">\r\n<div class="container mn-title-parallax">\r\n  <h3>Our Comprehensive Stuff Can Litteraly Create Everything <hr> From Post Production to Sound Design and Commercials</h3>\r\n</div>\r\n</div>', 1, 'mn-parallax2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"images\\/echo\\/parallax\\/parallax2.jpg","layout":"_:default","moduleclass_sfx":" mn-parallax","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(150, 164, 'More Features', '', '<div class="mn-mod-header mn-mod-header-features">\r\n	<div class="mn-title">\r\n		<h2>More Features</h2>\r\n		<h3>Explore More and Dive into a New Dreamy World of Media Creation</h3>\r\n      <hr>\r\n	</div>\r\n</div>\r\n\r\n<div class="col-xs-12 col-md-6 mn-features text-center">\r\n	<div class="mn-features-inner">\r\n		<div class="mn-features-ico"> <img src="images/echo/features/morefeature1.png" border="0" alt="Testimonials1"> </div>\r\n		<div class="mn-features-title"><h4>Audio Solutions You Can Trust</h4></div>\r\n	</div>\r\n</div>\r\n<div class="col-xs-12 col-md-6 mn-features text-center">\r\n	<div class="mn-features-inner">\r\n		<div class="mn-features-ico"><img src="images/echo/features/morefeature2.png" border="0" alt="Testimonials2"> </div>\r\n		<div class="mn-features-title"><h4>Commercial Services with Outstanding Results</h4></div>\r\n	</div>\r\n</div>\r\n<div class="col-xs-12 col-md-6 mn-features text-center">\r\n	<div class="mn-features-inner">\r\n		<div class="mn-features-ico"> <img src="images/echo/features/morefeature3.png" border="0" alt="Testimonials1"> </div>\r\n		<div class="mn-features-title"><h4>Complete Services of Post Production</h4></div>\r\n	</div>\r\n</div>\r\n<div class="col-xs-12 col-md-6 mn-features text-center">\r\n	<div class="mn-features-inner">\r\n		<div class="mn-features-ico"><img src="images/echo/features/morefeature4.png" border="0" alt="Testimonials2"> </div>\r\n		<div class="mn-features-title"><h4>Impressive Events Management</h4></div>\r\n	</div>\r\n</div>', 1, 'position-13', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(151, 165, 'Footer Logo', '', '<div class="logo-text"> <a href="/development/echo" title="Echo"> <span><span class="mn-logo-ico"><i class="fa fa-rotate-right"></i></span><span class="mn-logo-text">Echo</span></span> </a> <small class="site-slogan"></small> </div>\r\n<p>Lorem Ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor</p>\r\n\r\n\r\n<div class="footer-social-icons">\r\n					\r\n\r\n\r\n	<ul class="social-media-icons">\r\n  <li class="facebook">\r\n    <a class="facebook" href="#"><i class="fa fa-facebook"></i></a>\r\n  </li>\r\n  <li class="twitter">\r\n    <a class="twitter" href="#"><i class="fa fa-twitter"></i></a>\r\n  </li>\r\n  <li class="google-plus">\r\n    <a class="google-plus" href="#"><i class="fa fa-google-plus"></i></a>\r\n  </li> \r\n</ul>\r\n\r\n</div>', 1, 'footer-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(153, 171, 'Our Work', '', '', 4, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_minitekwall', 1, 0, '{"moduleclass_sfx":"","auto_module_id":"1","custom_module_id":"","module_id":"1","load_jquery":"0","load_fontawesome":"1","load_fancybox":"1","enable_cache":"0","cache_time":"30","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(154, 172, 'Our Work Title', '', '<div class="mn-mod-header mn-mod-header-features">\r\n	<div class="mn-title">\r\n		<h2>Our Work</h2>\r\n		<h3>These are Only a Few of Our Hard Working Projects</h3>\r\n		<hr>\r\n	</div>\r\n</div>\r\n', 3, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(156, 179, 'This is Our Portfolio Title', '', '<div class="mn-mod-header mn-mod-header-features">\r\n	<div class="mn-title">\r\n		<h2>This is Our Portfolio</h2>\r\n		<h3>A Small Taste from Some of Our Latest Works</h3>\r\n		<hr>\r\n	</div>\r\n</div>\r\n', 2, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(157, 186, 'This is Our Portfolio', '', '', 3, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_minitekwall', 1, 0, '{"moduleclass_sfx":"","auto_module_id":"1","custom_module_id":"","module_id":"2","load_jquery":"0","load_fontawesome":"1","load_fancybox":"1","enable_cache":"0","cache_time":"30","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(159, 192, 'Innovative Ideas', '', '<div class="mn-parallax-background">\r\n<div class="container mn-title-parallax">\r\n  <h3>Innovative Ideas and Great Quality Production <hr>Are Our Basic Principles</h3>\r\n</div>\r\n</div>', 1, 'mn-parallax1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"images\\/echo\\/parallax\\/parallax3.jpg","layout":"_:default","moduleclass_sfx":" mn-parallax","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(160, 193, 'Testimonials', '', '<div class="mn-mod-header mn-mod-header-features">\r\n	<div class="mn-title">\r\n		<h2>Testimonials</h2>\r\n		<h3>This is What Other People and Some of Our Greatest Customers Say</h3>\r\n      <hr>\r\n	</div>\r\n</div>\r\n<div class="col-xs-12 col-sm-4 col-md-4 mn-features text-center">\r\n	<div class="mn-features-inner">\r\n		<div class="mn-features-img"> <img src="images/echo/features/testimonials.jpg" class="img-circle" border="0" alt="Testimonials1"> </div>\r\n		<div class="mn-features-desc text-center">\r\n			<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. </p>\r\n		</div>\r\n		<div class="mn-features-title"><h4>Music Band</h4></div>\r\n	</div>\r\n</div>\r\n<div class="col-xs-12 col-sm-4 col-md-4 mn-features text-center">\r\n	<div class="mn-features-inner">\r\n		<div class="mn-features-img"><img src="images/echo/features/testimonials.jpg" class="img-circle" border="0" alt="Testimonials2"> </div>\r\n		<div class="mn-features-desc text-center">\r\n			<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. </p>\r\n		</div>\r\n		<div class="mn-features-title"><h4>Singer</h4></div>\r\n	</div>\r\n</div>\r\n<div class="col-xs-12 col-sm-4 col-md-4 mn-features text-center">\r\n	<div class="mn-features-inner">\r\n		<div class="mn-features-img"><img src="images/echo/features/testimonials.jpg" class="img-circle" border="0" alt="Testimonials3"> </div>\r\n		<div class="mn-features-desc text-center">\r\n			<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. </p>\r\n		</div>\r\n		<div class="mn-features-title"><h4>Groups</h4></div>\r\n	</div>\r\n</div>\r\n', 1, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(161, 196, 'Magazine Categories', '', '', 3, 'position-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_minitekwall', 1, 0, '{"moduleclass_sfx":"","auto_module_id":"1","custom_module_id":"","module_id":"4","load_jquery":"0","load_fontawesome":"1","load_fancybox":"1","enable_cache":"0","cache_time":"30","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(162, 199, 'AUDIO SOLUTIONS', '', '', 1, 'position-7', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_content', 1, 1, '{"moduleclass_sfx":" mn-module-light","getTemplate":"minitek2","source":"filter","catfilter":"1","category_id":["2"],"getChildren":"0","itemCount":"2","itemsOrdering":"","FeaturedItems":"1","popularityRange":"","videosOnly":"0","item":"0","itemTitle":"1","itemAuthor":"0","itemAuthorAvatar":"0","itemAuthorAvatarWidthSelect":"custom","itemAuthorAvatarWidth":"50","userDescription":"0","itemIntroText":"1","itemIntroTextWordLimit":"25","itemImage":"1","itemImgSize":"Small","itemVideo":"0","itemVideoCaption":"0","itemVideoCredits":"0","itemAttachments":"0","itemTags":"0","itemCategory":"0","itemDateCreated":"0","itemHits":"0","itemReadMore":"0","itemExtraFields":"0","itemCommentsCounter":"0","feed":"0","itemPreText":"","itemCustomLink":"0","itemCustomLinkTitle":"","itemCustomLinkURL":"http:\\/\\/","itemCustomLinkMenuItem":"162","K2Plugins":"1","JPlugins":"1","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(164, 208, 'POPULAR POSTS', '', '', 1, 'position-8', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_content', 1, 1, '{"moduleclass_sfx":" mn-module-light","getTemplate":"minitek","source":"filter","catfilter":"0","getChildren":"0","itemCount":"3","itemsOrdering":"hits","FeaturedItems":"1","popularityRange":"","videosOnly":"0","item":"0","itemTitle":"1","itemAuthor":"0","itemAuthorAvatar":"0","itemAuthorAvatarWidthSelect":"custom","itemAuthorAvatarWidth":"50","userDescription":"0","itemIntroText":"1","itemIntroTextWordLimit":"8","itemImage":"1","itemImgSize":"XSmall","itemVideo":"0","itemVideoCaption":"0","itemVideoCredits":"0","itemAttachments":"0","itemTags":"0","itemCategory":"0","itemDateCreated":"0","itemHits":"0","itemReadMore":"0","itemExtraFields":"0","itemCommentsCounter":"0","feed":"0","itemPreText":"","itemCustomLink":"0","itemCustomLinkTitle":"","itemCustomLinkURL":"http:\\/\\/","itemCustomLinkMenuItem":"162","K2Plugins":"1","JPlugins":"1","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(165, 209, 'COMMERCIAL SERVICES', '', '', 1, 'position-13', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_content', 1, 1, '{"moduleclass_sfx":" mn-module-light","getTemplate":"minitek2","source":"filter","catfilter":"1","category_id":["3"],"getChildren":"0","itemCount":"2","itemsOrdering":"","FeaturedItems":"1","popularityRange":"","videosOnly":"0","item":"0","itemTitle":"1","itemAuthor":"0","itemAuthorAvatar":"0","itemAuthorAvatarWidthSelect":"custom","itemAuthorAvatarWidth":"50","userDescription":"0","itemIntroText":"1","itemIntroTextWordLimit":"25","itemImage":"1","itemImgSize":"Small","itemVideo":"0","itemVideoCaption":"0","itemVideoCredits":"0","itemAttachments":"0","itemTags":"0","itemCategory":"0","itemDateCreated":"0","itemHits":"0","itemReadMore":"0","itemExtraFields":"0","itemCommentsCounter":"0","feed":"0","itemPreText":"","itemCustomLink":"0","itemCustomLinkTitle":"","itemCustomLinkURL":"http:\\/\\/","itemCustomLinkMenuItem":"162","K2Plugins":"1","JPlugins":"1","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(167, 211, 'LATEST REVIEWS', '', '', 1, 'position-14', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_content', 1, 1, '{"moduleclass_sfx":" mn-module-light","getTemplate":"minitek","source":"filter","catfilter":"1","category_id":["5"],"getChildren":"0","itemCount":"4","itemsOrdering":"hits","FeaturedItems":"1","popularityRange":"","videosOnly":"0","item":"0","itemTitle":"1","itemAuthor":"0","itemAuthorAvatar":"0","itemAuthorAvatarWidthSelect":"custom","itemAuthorAvatarWidth":"50","userDescription":"0","itemIntroText":"1","itemIntroTextWordLimit":"8","itemImage":"1","itemImgSize":"XSmall","itemVideo":"0","itemVideoCaption":"0","itemVideoCredits":"0","itemAttachments":"0","itemTags":"0","itemCategory":"0","itemDateCreated":"0","itemHits":"0","itemReadMore":"0","itemExtraFields":"0","itemCommentsCounter":"0","feed":"0","itemPreText":"","itemCustomLink":"0","itemCustomLinkTitle":"","itemCustomLinkURL":"http:\\/\\/","itemCustomLinkMenuItem":"162","K2Plugins":"1","JPlugins":"1","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(168, 212, 'VIDEO AND MUSIC PRODUCTION', '', '', 1, 'position-19', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_content', 1, 1, '{"moduleclass_sfx":" mn-module-light","getTemplate":"minitek3","source":"filter","catfilter":"1","category_id":["5"],"getChildren":"0","itemCount":"3","itemsOrdering":"","FeaturedItems":"1","popularityRange":"","videosOnly":"0","item":"0","itemTitle":"1","itemAuthor":"0","itemAuthorAvatar":"0","itemAuthorAvatarWidthSelect":"custom","itemAuthorAvatarWidth":"50","userDescription":"0","itemIntroText":"1","itemIntroTextWordLimit":"25","itemImage":"1","itemImgSize":"Small","itemVideo":"0","itemVideoCaption":"0","itemVideoCredits":"0","itemAttachments":"0","itemTags":"0","itemCategory":"0","itemDateCreated":"0","itemHits":"0","itemReadMore":"0","itemExtraFields":"0","itemCommentsCounter":"0","feed":"0","itemPreText":"","itemCustomLink":"0","itemCustomLinkTitle":"","itemCustomLinkURL":"http:\\/\\/","itemCustomLinkMenuItem":"162","K2Plugins":"1","JPlugins":"1","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(169, 213, 'Tags', '', '', 1, 'sidebar-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_tools', 1, 1, '{"moduleclass_sfx":" mn-module-dark","module_usage":"7","archiveItemsCounter":"1","archiveCategory":"0","authors_module_category":"0","authorItemsCounter":"1","authorAvatar":"1","authorAvatarWidthSelect":"custom","authorAvatarWidth":"50","authorLatestItem":"1","calendarCategory":"0","home":"","seperator":"","root_id":"0","end_level":"","categoriesListOrdering":"","categoriesListItemsCounter":"1","root_id2":"0","catfilter":"0","getChildren":"0","liveSearch":"","width":"20","text":"","button":"","imagebutton":"","button_text":"","min_size":"75","max_size":"300","cloud_limit":"30","cloud_category":["0"],"cloud_category_recursive":"0","customCode":"","parsePhp":"0","K2Plugins":"0","JPlugins":"0","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(170, 214, 'Categories', '', '', 1, 'sidebar-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_tools', 1, 1, '{"moduleclass_sfx":" mn-module-dark","module_usage":"4","archiveItemsCounter":"1","archiveCategory":"0","authors_module_category":"0","authorItemsCounter":"1","authorAvatar":"1","authorAvatarWidthSelect":"custom","authorAvatarWidth":"50","authorLatestItem":"1","calendarCategory":"0","home":"","seperator":"","root_id":"1","end_level":"","categoriesListOrdering":"","categoriesListItemsCounter":"0","root_id2":"0","catfilter":"0","getChildren":"0","liveSearch":"","width":"20","text":"","button":"","imagebutton":"","button_text":"","min_size":"75","max_size":"300","cloud_limit":"30","cloud_category":["0"],"cloud_category_recursive":"0","customCode":"","parsePhp":"0","K2Plugins":"0","JPlugins":"0","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(171, 215, 'Latest Comments', '', '', 1, 'sidebar-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_k2_comments', 1, 1, '{"moduleclass_sfx":" mn-module-dark","module_usage":"0","catfilter":"0","comments_limit":"2","comments_word_limit":"8","commenterName":"1","commentAvatar":"1","commentAvatarWidthSelect":"custom","commentAvatarWidth":"50","commentDate":"0","commentDateFormat":"absolute","commentLink":"1","itemTitle":"0","itemCategory":"0","feed":"0","commenters_limit":"5","commenterNameOrUsername":"1","commenterAvatar":"1","commenterAvatarWidthSelect":"custom","commenterAvatarWidth":"50","commenterLink":"1","commenterCommentsCounter":"1","commenterLatestComment":"1","cache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(173, 217, 'Login', '', '', 1, 'sidebar-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '{"pretext":"","posttext":"","login":"","logout":"","greeting":"1","name":"0","usesecure":"0","usetext":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(175, 219, 'Article Categories', '', '', 1, 'sidebar-1', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_categories', 1, 1, '{"parent":"8","show_description":"0","numitems":"0","show_children":"0","count":"0","maxlevel":"0","layout":"_:default","item_heading":"4","moduleclass_sfx":"","owncache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(176, 220, 'Article Categories', '', '', 1, 'sidebar-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_articles_categories', 1, 1, '{"parent":"8","show_description":"0","numitems":"0","show_children":"0","count":"0","maxlevel":"0","layout":"_:default","item_heading":"4","moduleclass_sfx":"","owncache":"1","cache_time":"900","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(177, 221, 'Login', '', '', 1, 'sidebar-2', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_login', 1, 1, '{"pretext":"","posttext":"","login":"","logout":"","greeting":"1","name":"0","usesecure":"0","usetext":"0","layout":"_:default","moduleclass_sfx":"","cache":"0","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(179, 223, 'Scroll Button', '', '<div class="scroll-top"><i class="fa fa-angle-up"></i></div>', 1, 'scroll-button', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 1, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(180, 240, 'Minitek Wall Page', '', '<div class="mn-mod-header">\r\n	<div class="mn-title">\r\n		<h2>Minitek Wall</h2>\r\n	</div>\r\n	<div class="mn-description">\r\n		<h4>Minitek Wall is the most powerful and robust Grid system for Joomla!</h4>\r\n	</div>\r\n</div>\r\n', 1, 'position-19', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_custom', 1, 0, '{"prepare_content":"0","backgroundimage":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"static","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*'),
(181, 241, 'Breadcrumbs', '', '', 1, 'navhelper', 0, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 1, 'mod_breadcrumbs', 1, 1, '{"showHere":"1","showHome":"1","homeText":"","showLast":"1","separator":"","layout":"_:default","moduleclass_sfx":"","cache":"1","cache_time":"900","cachemode":"itemid","module_tag":"div","bootstrap_size":"0","header_tag":"h3","header_class":"","style":"0"}', 0, '*');

DROP TABLE IF EXISTS `#__modules_menu`;
CREATE TABLE IF NOT EXISTS `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT '0',
  `menuid` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__modules_menu` (`moduleid`, `menuid`) VALUES
(2, 0),
(3, 0),
(4, 0),
(6, 0),
(7, 0),
(8, 0),
(9, 0),
(10, 0),
(12, 0),
(13, 0),
(14, 0),
(15, 0),
(79, 0),
(86, 0),
(92, 0),
(93, 0),
(94, 0),
(95, 128),
(95, 130),
(95, 133),
(95, 150),
(95, 152),
(95, 154),
(95, 155),
(95, 156),
(96, 0),
(97, 0),
(98, 0),
(99, 0),
(100, 0),
(119, 0),
(120, 0),
(121, 150),
(121, 152),
(121, 154),
(121, 155),
(121, 156),
(121, 297),
(121, 300),
(122, 150),
(122, 152),
(122, 154),
(122, 155),
(122, 156),
(122, 297),
(122, 300),
(123, 150),
(123, 152),
(123, 154),
(123, 155),
(123, 156),
(123, 297),
(123, 300),
(133, 0),
(134, 128),
(134, 130),
(134, 133),
(134, 303),
(134, 304),
(134, 305),
(134, 306),
(134, 307),
(134, 308),
(135, 128),
(135, 130),
(135, 133),
(135, 303),
(135, 304),
(135, 305),
(135, 306),
(135, 307),
(135, 308),
(136, 122),
(137, 122),
(138, 122),
(139, 122),
(142, 122),
(143, 122),
(146, 101),
(147, 101),
(148, 101),
(150, 101),
(151, 0),
(153, 101),
(154, 101),
(156, 286),
(157, 286),
(159, 286),
(160, 286),
(161, 287),
(162, 287),
(164, 287),
(165, 287),
(167, 287),
(168, 287),
(169, 298),
(169, 301),
(170, 298),
(170, 301),
(171, 298),
(171, 301),
(173, 300),
(175, 300),
(176, 301),
(177, 301),
(179, 0),
(180, 309),
(180, 310),
(181, 128),
(181, 130),
(181, 131),
(181, 132),
(181, 133),
(181, 134),
(181, 150),
(181, 151),
(181, 152),
(181, 153),
(181, 154),
(181, 155),
(181, 156),
(181, 157),
(181, 297),
(181, 298),
(181, 300),
(181, 301),
(181, 302),
(181, 305),
(181, 306),
(181, 307),
(181, 308);

DROP TABLE IF EXISTS `#__newsfeeds`;
CREATE TABLE IF NOT EXISTS `#__newsfeeds` (
  `catid` int(11) NOT NULL DEFAULT '0',
`id` int(10) unsigned NOT NULL,
  `name` varchar(100) NOT NULL DEFAULT '',
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `link` varchar(200) NOT NULL DEFAULT '',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `numarticles` int(10) unsigned NOT NULL DEFAULT '1',
  `cache_time` int(10) unsigned NOT NULL DEFAULT '3600',
  `checked_out` int(10) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `rtl` tinyint(4) NOT NULL DEFAULT '0',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by` int(10) unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_by` int(10) unsigned NOT NULL DEFAULT '0',
  `metakey` text NOT NULL,
  `metadesc` text NOT NULL,
  `metadata` text NOT NULL,
  `xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` text NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `images` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__overrider`;
CREATE TABLE IF NOT EXISTS `#__overrider` (
`id` int(10) NOT NULL COMMENT 'Primary Key',
  `constant` varchar(255) NOT NULL,
  `string` text NOT NULL,
  `file` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__postinstall_messages`;
CREATE TABLE IF NOT EXISTS `#__postinstall_messages` (
`postinstall_message_id` bigint(20) unsigned NOT NULL,
  `extension_id` bigint(20) NOT NULL DEFAULT '700' COMMENT 'FK to #__extensions',
  `title_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'Lang key for the title',
  `description_key` varchar(255) NOT NULL DEFAULT '' COMMENT 'Lang key for description',
  `action_key` varchar(255) NOT NULL DEFAULT '',
  `language_extension` varchar(255) NOT NULL DEFAULT 'com_postinstall' COMMENT 'Extension holding lang keys',
  `language_client_id` tinyint(3) NOT NULL DEFAULT '1',
  `type` varchar(10) NOT NULL DEFAULT 'link' COMMENT 'Message type - message, link, action',
  `action_file` varchar(255) DEFAULT '' COMMENT 'RAD URI to the PHP file containing action method',
  `action` varchar(255) DEFAULT '' COMMENT 'Action method name or URL',
  `condition_file` varchar(255) DEFAULT NULL COMMENT 'RAD URI to file holding display condition method',
  `condition_method` varchar(255) DEFAULT NULL COMMENT 'Display condition method, must return boolean',
  `version_introduced` varchar(50) NOT NULL DEFAULT '3.2.0' COMMENT 'Version when this message was introduced',
  `enabled` tinyint(3) NOT NULL DEFAULT '1'
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

INSERT INTO `#__postinstall_messages` (`postinstall_message_id`, `extension_id`, `title_key`, `description_key`, `action_key`, `language_extension`, `language_client_id`, `type`, `action_file`, `action`, `condition_file`, `condition_method`, `version_introduced`, `enabled`) VALUES
(1, 700, 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_TITLE', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_BODY', 'PLG_TWOFACTORAUTH_TOTP_POSTINSTALL_ACTION', 'plg_twofactorauth_totp', 1, 'action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_action', 'site://plugins/twofactorauth/totp/postinstall/actions.php', 'twofactorauth_postinstall_condition', '3.2.0', 1),
(2, 700, 'COM_CPANEL_MSG_EACCELERATOR_TITLE', 'COM_CPANEL_MSG_EACCELERATOR_BODY', 'COM_CPANEL_MSG_EACCELERATOR_BUTTON', 'com_cpanel', 1, 'action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_action', 'admin://components/com_admin/postinstall/eaccelerator.php', 'admin_postinstall_eaccelerator_condition', '3.2.0', 1),
(3, 700, 'COM_CPANEL_WELCOME_BEGINNERS_TITLE', 'COM_CPANEL_WELCOME_BEGINNERS_MESSAGE', '', 'com_cpanel', 1, 'message', '', '', '', '', '3.2.0', 1),
(4, 700, 'COM_CPANEL_MSG_PHPVERSION_TITLE', 'COM_CPANEL_MSG_PHPVERSION_BODY', '', 'com_cpanel', 1, 'message', '', '', 'admin://components/com_admin/postinstall/phpversion.php', 'admin_postinstall_phpversion_condition', '3.2.2', 1),
(5, 10025, 'AKEEBA_POSTSETUP_LBL_CONFWIZ', 'AKEEBA_POSTSETUP_DESC_CONFWIZ', 'AKEEBA_POSTSETUP_BTN_RUN_CONFWIZ', 'com_akeeba', 1, 'action', 'admin://components/com_akeeba/helpers/postinstall.php', 'com_akeeba_postinstall_confwiz_action', 'admin://components/com_akeeba/helpers/postinstall.php', 'com_akeeba_postinstall_confwiz_condition', '4.0.0', 1),
(6, 10025, 'AKEEBA_POSTSETUP_LBL_ANGIEUPGRADE', 'AKEEBA_POSTSETUP_DESC_ANGIEUPGRADE', 'AKEEBA_POSTSETUP_BTN_ANGIEUPGRADE', 'com_akeeba', 1, 'action', 'admin://components/com_akeeba/helpers/postinstall.php', 'com_akeeba_postinstall_angie_action', 'admin://components/com_akeeba/helpers/postinstall.php', 'com_akeeba_postinstall_angie_condition', '4.0.0', 1),
(7, 10025, 'AKEEBA_POSTSETUP_LBL_ACCEPTLICENSE', 'AKEEBA_POSTSETUP_DESC_ACCEPTLICENSE', 'AKEEBA_POSTSETUP_BTN_I_CONFIRM_THIS', 'com_akeeba', 1, 'message', '', '', '', '', '4.0.0', 1),
(8, 10025, 'AKEEBA_POSTSETUP_LBL_ACCEPTSUPPORT', 'AKEEBA_POSTSETUP_DESC_ACCEPTSUPPORT', 'AKEEBA_POSTSETUP_BTN_I_CONFIRM_THIS', 'com_akeeba', 1, 'message', '', '', '', '', '4.0.0', 1),
(9, 10025, 'AKEEBA_POSTSETUP_LBL_ACCEPTBACKUPTEST', 'AKEEBA_POSTSETUP_DESC_ACCEPTBACKUPTEST', 'AKEEBA_POSTSETUP_BTN_I_CONFIRM_THIS', 'com_akeeba', 1, 'message', '', '', '', '', '4.0.0', 1);

DROP TABLE IF EXISTS `#__redirect_links`;
CREATE TABLE IF NOT EXISTS `#__redirect_links` (
`id` int(10) unsigned NOT NULL,
  `old_url` varchar(255) NOT NULL,
  `new_url` varchar(255) NOT NULL,
  `referer` varchar(150) NOT NULL,
  `comment` varchar(255) NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL,
  `created_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__schemas`;
CREATE TABLE IF NOT EXISTS `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__schemas` (`extension_id`, `version_id`) VALUES
(700, '3.3.0-2014-04-02'),
(10027, '0.0.6');

DROP TABLE IF EXISTS `#__session`;
CREATE TABLE IF NOT EXISTS `#__session` (
  `session_id` varchar(200) NOT NULL DEFAULT '',
  `client_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `guest` tinyint(4) unsigned DEFAULT '1',
  `time` varchar(14) DEFAULT '',
  `data` mediumtext,
  `userid` int(11) DEFAULT '0',
  `username` varchar(150) DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `#__session` (`session_id`, `client_id`, `guest`, `time`, `data`, `userid`, `username`) VALUES
('9bffv52bcevintuodtaoq0o073', 1, 0, '1411330984', '__default|a:8:{s:15:"session.counter";i:15;s:19:"session.timer.start";i:1411330669;s:18:"session.timer.last";i:1411330974;s:17:"session.timer.now";i:1411330977;s:22:"session.client.browser";s:109:"Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2062.120 Safari/537.36";s:8:"registry";O:24:"Joomla\\Registry\\Registry":1:{s:7:"\\0\\0\\0data";O:8:"stdClass":4:{s:11:"application";O:8:"stdClass":1:{s:4:"lang";s:5:"en-GB";}s:13:"com_installer";O:8:"stdClass":3:{s:7:"message";s:0:"";s:17:"extension_message";s:0:"";s:6:"manage";O:8:"stdClass":4:{s:6:"filter";O:8:"stdClass":5:{s:6:"search";s:6:"akeeba";s:9:"client_id";s:0:"";s:6:"status";s:0:"";s:4:"type";s:0:"";s:5:"group";s:0:"";}s:8:"ordercol";s:4:"name";s:9:"orderdirn";s:3:"asc";s:10:"limitstart";i:0;}}s:6:"global";O:8:"stdClass":1:{s:4:"list";O:8:"stdClass":1:{s:5:"limit";i:20;}}s:11:"com_checkin";O:8:"stdClass":1:{s:7:"checkin";O:8:"stdClass":1:{s:8:"ordercol";s:5:"table";}}}}s:4:"user";O:5:"JUser":28:{s:9:"\\0\\0\\0isRoot";b:1;s:2:"id";s:3:"400";s:4:"name";s:10:"Super User";s:8:"username";s:5:"admin";s:5:"email";s:15:"info@minitek.gr";s:8:"password";s:60:"$2y$10$mN12k5FFcHGuo97kh56Bbe8QX6.MxZepvligzRVO3clNQG5sY5XtG";s:14:"password_clear";s:0:"";s:5:"block";s:1:"0";s:9:"sendEmail";s:1:"1";s:12:"registerDate";s:19:"2014-09-09 18:14:26";s:13:"lastvisitDate";s:19:"2014-09-21 19:47:02";s:10:"activation";s:1:"0";s:6:"params";s:0:"";s:6:"groups";a:1:{i:8;s:1:"8";}s:5:"guest";i:0;s:13:"lastResetTime";s:19:"0000-00-00 00:00:00";s:10:"resetCount";s:1:"0";s:12:"requireReset";s:1:"0";s:10:"\\0\\0\\0_params";O:24:"Joomla\\Registry\\Registry":1:{s:7:"\\0\\0\\0data";O:8:"stdClass":0:{}}s:14:"\\0\\0\\0_authGroups";a:2:{i:0;i:1;i:1;i:8;}s:14:"\\0\\0\\0_authLevels";a:5:{i:0;i:1;i:1;i:1;i:2;i:2;i:3;i:3;i:4;i:6;}s:15:"\\0\\0\\0_authActions";N;s:12:"\\0\\0\\0_errorMsg";N;s:10:"\\0\\0\\0_errors";a:0:{}s:3:"aid";i:0;s:6:"otpKey";s:0:"";s:4:"otep";s:0:"";s:3:"gid";i:1000;}s:13:"session.token";s:32:"5824a5b14979d4c1fced9c055149843d";}', 400, 'admin'),
('rn6g1hjukd6fs3ts2f8m6o20t5', 0, 1, '1411330986', '__default|a:9:{s:15:"session.counter";i:159;s:19:"session.timer.start";i:1411327291;s:18:"session.timer.last";i:1411330983;s:17:"session.timer.now";i:1411330985;s:22:"session.client.browser";s:109:"Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2062.120 Safari/537.36";s:8:"registry";O:24:"Joomla\\Registry\\Registry":1:{s:7:"\\0\\0\\0data";O:8:"stdClass":3:{s:13:"current_theme";N;s:17:"current_direction";s:3:"ltr";s:17:"current_key_sufix";s:5:"__ltr";}}s:4:"user";O:5:"JUser":26:{s:9:"\\0\\0\\0isRoot";b:0;s:2:"id";i:0;s:4:"name";N;s:8:"username";N;s:5:"email";N;s:8:"password";N;s:14:"password_clear";s:0:"";s:5:"block";N;s:9:"sendEmail";i:0;s:12:"registerDate";N;s:13:"lastvisitDate";N;s:10:"activation";N;s:6:"params";N;s:6:"groups";a:1:{i:0;s:1:"9";}s:5:"guest";i:1;s:13:"lastResetTime";N;s:10:"resetCount";N;s:12:"requireReset";N;s:10:"\\0\\0\\0_params";O:24:"Joomla\\Registry\\Registry":1:{s:7:"\\0\\0\\0data";O:8:"stdClass":0:{}}s:14:"\\0\\0\\0_authGroups";a:2:{i:0;i:1;i:1;i:9;}s:14:"\\0\\0\\0_authLevels";a:3:{i:0;i:1;i:1;i:1;i:2;i:5;}s:15:"\\0\\0\\0_authActions";N;s:12:"\\0\\0\\0_errorMsg";N;s:10:"\\0\\0\\0_errors";a:0:{}s:3:"aid";i:0;s:3:"gid";i:1;}s:16:"com_mailto.links";a:25:{s:40:"7a13d6ceaba07e12371bd1c8063b0a9714624d43";O:8:"stdClass":2:{s:4:"link";s:101:"http://localhost/development/echo/joomla/content/category-blog/2-make-your-red-background-work-better";s:6:"expiry";i:1411330985;}s:40:"8b3b20c34eea9e49529c413b5e0280785be37080";O:8:"stdClass":2:{s:4:"link";s:63:"http://localhost/development/echo/joomla/content/single-article";s:6:"expiry";i:1411330985;}s:40:"b2f8318e2ca85e6f4104375e9cd5bd83782107ed";O:8:"stdClass":2:{s:4:"link";s:118:"http://localhost/development/echo/joomla/content/joomla-categories/video-and-music-production/46-cloudy-and-impressive";s:6:"expiry";i:1411330985;}s:40:"ad01ad8407b4867c788ae194942c8a3ae39776d9";O:8:"stdClass":2:{s:4:"link";s:121:"http://localhost/development/echo/joomla/content/joomla-categories/video-and-music-production/45-flying-on-cloudy-weather";s:6:"expiry";i:1411330985;}s:40:"bc68b203e9e780f3935350efda4bff654f3f3934";O:8:"stdClass":2:{s:4:"link";s:85:"http://localhost/development/echo/joomla/content/category-list/20-colors-and-melodies";s:6:"expiry";i:1411329735;}s:40:"021f59bac5b9be9144082cca71bcad5251c945ff";O:8:"stdClass":2:{s:4:"link";s:84:"http://localhost/development/echo/joomla/content/category-list/34-the-mysterious-man";s:6:"expiry";i:1411329735;}s:40:"ce264eb94d111c66260bf00e37912efd215f1bb7";O:8:"stdClass":2:{s:4:"link";s:89:"http://localhost/development/echo/joomla/content/category-list/21-a-modern-sound-approach";s:6:"expiry";i:1411329735;}s:40:"69bc174ab12738fca3045df1b3fe8cf22bb4d742";O:8:"stdClass":2:{s:4:"link";s:82:"http://localhost/development/echo/joomla/content/category-list/33-old-school-audio";s:6:"expiry";i:1411329735;}s:40:"4ea911c595fe4b1324d0d3f3bdc864a72356a6aa";O:8:"stdClass":2:{s:4:"link";s:82:"http://localhost/development/echo/joomla/content/category-blog/3-eastern-reverence";s:6:"expiry";i:1411330433;}s:40:"9accfa10c486a4a533484480f70819882ff92b32";O:8:"stdClass":2:{s:4:"link";s:84:"http://localhost/development/echo/joomla/content/category-blog/36-university-luggage";s:6:"expiry";i:1411330433;}s:40:"9f871f6d33b4b8a900ef356036e89f9f02ab6ffb";O:8:"stdClass":2:{s:4:"link";s:95:"http://localhost/development/echo/joomla/content/category-blog/4-city-photography-and-direction";s:6:"expiry";i:1411330434;}s:40:"5fd2f6757e4836c5bc38a251ae458752d8308f54";O:8:"stdClass":2:{s:4:"link";s:106:"http://localhost/development/echo/joomla/content/category-blog/35-why-this-commercial-became-so-successful";s:6:"expiry";i:1411329883;}s:40:"c73d1d4f9fa0be892dfa5eaa2532b683c35a75e9";O:8:"stdClass":2:{s:4:"link";s:113:"http://localhost/development/echo/joomla/content/joomla-categories/event-management/37-the-amazing-balloons-event";s:6:"expiry";i:1411329988;}s:40:"4b177f76a6665519c56bdc9a2f81c4ba5ddfd4ba";O:8:"stdClass":2:{s:4:"link";s:106:"http://localhost/development/echo/joomla/content/joomla-categories/event-management/40-colors-and-melodies";s:6:"expiry";i:1411329988;}s:40:"2a1735cbd24e38a51567ccaa8227e08449cc8c08";O:8:"stdClass":2:{s:4:"link";s:112:"http://localhost/development/echo/joomla/content/joomla-categories/event-management/38-managing-the-next-success";s:6:"expiry";i:1411329988;}s:40:"fff428302ff03aabafeac73400dd7afb5441c56c";O:8:"stdClass":2:{s:4:"link";s:115:"http://localhost/development/echo/joomla/content/joomla-categories/event-management/39-creating-an-event-experience";s:6:"expiry";i:1411329988;}s:40:"a55bc18c2c7015a1844e43d8f5974aa2b66228f4";O:8:"stdClass":2:{s:4:"link";s:122:"http://localhost/development/echo/joomla/content/joomla-categories/video-and-music-production/42-the-shipwreck-documentary";s:6:"expiry";i:1411330124;}s:40:"99bad5ac4d6832d494458b44edc5a4c923ffd138";O:8:"stdClass":2:{s:4:"link";s:115:"http://localhost/development/echo/joomla/content/joomla-categories/video-and-music-production/43-the-city-in-motion";s:6:"expiry";i:1411330124;}s:40:"f8ce0bbd7b41273a4a759a9082776a0639e37a37";O:8:"stdClass":2:{s:4:"link";s:130:"http://localhost/development/echo/joomla/content/joomla-categories/video-and-music-production/41-the-strange-formations-music-clip";s:6:"expiry";i:1411330124;}s:40:"0c9ac2746f263cbeeebf0a831012aaa954c16cfb";O:8:"stdClass":2:{s:4:"link";s:115:"http://localhost/development/echo/joomla/content/joomla-categories/video-and-music-production/44-lost-in-music-land";s:6:"expiry";i:1411330124;}s:40:"ed10947519fc666bf240d3dc8e50b9db30db7248";O:8:"stdClass":2:{s:4:"link";s:70:"http://localhost/development/echo/home/layouts/content-1-sidebar-right";s:6:"expiry";i:1411330327;}s:40:"53e20bab1a7a7c83712b04bdd80bbcdf1a0e3a36";O:8:"stdClass":2:{s:4:"link";s:69:"http://localhost/development/echo/home/layouts/content-1-sidebar-left";s:6:"expiry";i:1411330334;}s:40:"e43f3100ba3f76e22cf84742033447d62bd7cceb";O:8:"stdClass":2:{s:4:"link";s:69:"http://localhost/development/echo/home/layouts/content-2-sidebar-left";s:6:"expiry";i:1411330338;}s:40:"04c076c7c4fb513b9cbd3c693558f041c3bd35b2";O:8:"stdClass":2:{s:4:"link";s:70:"http://localhost/development/echo/home/layouts/content-2-sidebar-right";s:6:"expiry";i:1411330345;}s:40:"1a115eea440c11a19afd14d26d41f1012b460736";O:8:"stdClass":2:{s:4:"link";s:41:"http://localhost/development/echo/k2/item";s:6:"expiry";i:1411330394;}}s:13:"session.token";s:32:"b3335f62338c8015a51052ad2a0ebcd7";}', 0, '');

DROP TABLE IF EXISTS `#__tags`;
CREATE TABLE IF NOT EXISTS `#__tags` (
`id` int(10) unsigned NOT NULL,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  `path` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL,
  `alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(11) unsigned NOT NULL DEFAULT '0',
  `checked_out_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access` int(10) unsigned NOT NULL DEFAULT '0',
  `params` text NOT NULL,
  `metadesc` varchar(1024) NOT NULL COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) NOT NULL COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `images` text NOT NULL,
  `urls` text NOT NULL,
  `hits` int(10) unsigned NOT NULL DEFAULT '0',
  `language` char(7) NOT NULL,
  `version` int(10) unsigned NOT NULL DEFAULT '1',
  `publish_up` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `publish_down` datetime NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `#__tags` (`id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `created_by_alias`, `modified_user_id`, `modified_time`, `images`, `urls`, `hits`, `language`, `version`, `publish_up`, `publish_down`) VALUES
(1, 0, 0, 1, 0, '', 'ROOT', 'root', '', '', 1, 0, '0000-00-00 00:00:00', 1, '', '', '', '', 400, '2011-01-01 00:00:01', '', 0, '0000-00-00 00:00:00', '', '', 0, '*', 1, '0000-00-00 00:00:00', '0000-00-00 00:00:00');

DROP TABLE IF EXISTS `#__template_styles`;
CREATE TABLE IF NOT EXISTS `#__template_styles` (
`id` int(10) unsigned NOT NULL,
  `template` varchar(50) NOT NULL DEFAULT '',
  `client_id` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `home` char(7) NOT NULL DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `params` text NOT NULL
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=21 ;

INSERT INTO `#__template_styles` (`id`, `template`, `client_id`, `home`, `title`, `params`) VALUES
(4, 'beez3', 0, '0', 'Beez3 - Default', '{"wrapperSmall":"53","wrapperLarge":"72","logo":"images\\/joomla_black.gif","sitetitle":"Joomla!","sitedescription":"Open Source Content Management","navposition":"left","templatecolor":"personal","html5":"0"}'),
(5, 'hathor', 1, '0', 'Hathor - Default', '{"showSiteName":"0","colourChoice":"","boldText":"0"}'),
(7, 'protostar', 0, '0', 'protostar - Default', '{"templateColor":"","logoFile":"","googleFont":"1","googleFontName":"Open+Sans","fluidContainer":"0"}'),
(8, 'isis', 1, '1', 'isis - Default', '{"templateColor":"","logoFile":""}'),
(14, 'echo', 0, '1', 'Echo - Default', '{"slider-caption":"0","slider_image":"","slider-caption-ico":"","slider-caption-tilte":"","slider-caption-btn-text":"","slider-caption-btn-link":"","t3_template":"1","devmode":"0","themermode":"1","legacy_css":"0","responsive":"1","non_responsive_width":"970px","build_rtl":"0","t3-assets":"t3-assets","t3-rmvlogo":"1","minify":"0","minify_js":"0","minify_js_tool":"jsmin","minify_exclude":null,"link_titles":null,"theme":"","logotype":"text","sitename":"<span class=\\"mn-logo-ico\\"><i class=\\"fa fa-rotate-right\\"><\\/i><\\/span><span class=\\"mn-logo-text\\">Echo<\\/span>","slogan":"","logoimage":"","enable_logoimage_sm":"0","logoimage_sm":"","mainlayout":"default","mm_type":"mainmenu","navigation_trigger":"hover","navigation_type":"megamenu","navigation_animation":"slide","navigation_animation_duration":"400","mm_config":"{\\"mainmenu\\":{\\"item-101\\":{\\"sub\\":{\\"width\\":700,\\"rows\\":[[{\\"item\\":299,\\"width\\":6},{\\"item\\":296,\\"width\\":6}]]}},\\"item-299\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":288,\\"width\\":12}]]},\\"group\\":1},\\"item-296\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":297,\\"width\\":12}]]},\\"group\\":1},\\"item-113\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":309,\\"width\\":12}]]}},\\"item-118\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":117,\\"width\\":12}]]}},\\"item-117\\":{\\"sub\\":{\\"width\\":270,\\"rows\\":[[{\\"item\\":150,\\"width\\":12}]]}},\\"item-121\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":120,\\"width\\":12}]]}},\\"item-127\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":129,\\"width\\":12}]]}},\\"item-129\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":128,\\"width\\":12}]]}},\\"item-302\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":306,\\"width\\":12}]]}},\\"item-136\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":135,\\"width\\":12}]]}},\\"item-141\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":142,\\"width\\":12}]]}},\\"item-146\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":147,\\"width\\":12}]]}}}}","navigation_collapse_enable":"0","addon_offcanvas_enable":"1","addon_offcanvas_effect":"off-canvas-effect-2","snippet_open_head":null,"snippet_close_head":null,"snippet_open_body":null,"snippet_close_body":null,"snippet_debug":"0","theme_extras_k2":["-1"],"theme_extras_minitek-typo":["-1"],"theme_extras_minitek":["-1"],"theme_extras_typography":["119"],"mm_config_needupdate":""}'),
(15, 'echo', 0, '0', 'Echo - Business', '{"slider-caption":"1","slider_image":"images\\/echo\\/header\\/business.jpg","slider-caption-ico":"fa fa-headphones","slider-caption-tilte":"WE ARE A WORLD CLASS COMPANY SPECIALIZED IN AUDIO, VIDEO AND GENERAL MEDIA PRODUCTION","slider-caption-btn-text":"READ MORE","slider-caption-btn-link":"#","t3_template":"1","devmode":"0","themermode":"1","legacy_css":"0","responsive":"1","non_responsive_width":"970px","build_rtl":"0","t3-assets":"t3-assets","t3-rmvlogo":"1","minify":"0","minify_js":"0","minify_js_tool":"jsmin","minify_exclude":null,"link_titles":null,"theme":"","logotype":"text","sitename":"<span class=\\"mn-logo-ico\\"><i class=\\"fa fa-rotate-right\\"><\\/i><\\/span><span class=\\"mn-logo-text\\">Echo<\\/span>","slogan":"","logoimage":"","enable_logoimage_sm":"0","logoimage_sm":"","mainlayout":"business","mm_type":"mainmenu","navigation_trigger":"hover","navigation_type":"megamenu","navigation_animation":"slide","navigation_animation_duration":"400","mm_config":"{\\"mainmenu\\":{\\"item-101\\":{\\"sub\\":{\\"width\\":700,\\"rows\\":[[{\\"item\\":299,\\"width\\":6},{\\"item\\":296,\\"width\\":6}]]}},\\"item-299\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":288,\\"width\\":12}]]},\\"group\\":1},\\"item-296\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":297,\\"width\\":12}]]},\\"group\\":1},\\"item-113\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":309,\\"width\\":12}]]}},\\"item-118\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":117,\\"width\\":12}]]}},\\"item-117\\":{\\"sub\\":{\\"width\\":270,\\"rows\\":[[{\\"item\\":150,\\"width\\":12}]]}},\\"item-121\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":120,\\"width\\":12}]]}},\\"item-127\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":129,\\"width\\":12}]]}},\\"item-129\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":128,\\"width\\":12}]]}},\\"item-302\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":306,\\"width\\":12}]]}},\\"item-136\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":135,\\"width\\":12}]]}},\\"item-141\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":142,\\"width\\":12}]]}},\\"item-146\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":147,\\"width\\":12}]]}}}}","navigation_collapse_enable":"0","addon_offcanvas_enable":"1","addon_offcanvas_effect":"off-canvas-effect-2","snippet_open_head":null,"snippet_close_head":null,"snippet_open_body":null,"snippet_close_body":null,"snippet_debug":"0","theme_extras_k2":["-1"],"theme_extras_minitek-typo":["-1"],"theme_extras_minitek":["-1"],"theme_extras_typography":["119"],"mm_config_needupdate":""}'),
(16, 'echo', 0, '0', 'Echo - Portfolio', '{"slider-caption":"1","slider_image":"images\\/echo\\/header\\/portfolio.jpg","slider-caption-ico":"fa fa-group","slider-caption-tilte":"OUR MISSION IS TO FIGURE OUT OUR CUSTOMERS VALUE THEN WE USE THE BEST CONCEPT AND TECHNOLOGY TO DELIVER IT","slider-caption-btn-text":"READ MORE","slider-caption-btn-link":"#","t3_template":"1","devmode":"0","themermode":"1","legacy_css":"0","responsive":"1","non_responsive_width":"970px","build_rtl":"0","t3-assets":"t3-assets","t3-rmvlogo":"1","minify":"0","minify_js":"0","minify_js_tool":"jsmin","minify_exclude":"","link_titles":"","theme":"","logotype":"text","sitename":"<span class=\\"mn-logo-ico\\"><i class=\\"fa fa-rotate-right\\"><\\/i><\\/span><span class=\\"mn-logo-text\\">Echo<\\/span>","slogan":"","logoimage":"","enable_logoimage_sm":"0","logoimage_sm":"","mainlayout":"portfolio","mm_type":"mainmenu","navigation_trigger":"hover","navigation_type":"megamenu","navigation_animation":"slide","navigation_animation_duration":"400","mm_config":"{\\"mainmenu\\":{\\"item-101\\":{\\"sub\\":{\\"width\\":700,\\"rows\\":[[{\\"item\\":299,\\"width\\":6},{\\"item\\":296,\\"width\\":6}]]}},\\"item-299\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":288,\\"width\\":12}]]},\\"group\\":1},\\"item-296\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":297,\\"width\\":12}]]},\\"group\\":1},\\"item-113\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":309,\\"width\\":12}]]}},\\"item-118\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":117,\\"width\\":12}]]}},\\"item-117\\":{\\"sub\\":{\\"width\\":270,\\"rows\\":[[{\\"item\\":150,\\"width\\":12}]]}},\\"item-121\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":120,\\"width\\":12}]]}},\\"item-127\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":129,\\"width\\":12}]]}},\\"item-129\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":128,\\"width\\":12}]]}},\\"item-302\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":306,\\"width\\":12}]]}},\\"item-136\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":135,\\"width\\":12}]]}},\\"item-141\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":142,\\"width\\":12}]]}},\\"item-146\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":147,\\"width\\":12}]]}}}}","navigation_collapse_enable":"0","addon_offcanvas_enable":"1","addon_offcanvas_effect":"off-canvas-effect-2","snippet_open_head":"","snippet_close_head":"","snippet_open_body":"","snippet_close_body":"","snippet_debug":"0","theme_extras_k2":["-1"],"theme_extras_minitek-typo":["-1"],"theme_extras_minitek":["-1"],"theme_extras_typography":["119"],"mm_config_needupdate":""}'),
(17, 'echo', 0, '0', 'Echo - Magazine', '{"slider-caption":"0","slider_image":"","slider-caption-ico":"","slider-caption-tilte":"","slider-caption-btn-text":"","slider-caption-btn-link":"","t3_template":"1","devmode":"0","themermode":"1","legacy_css":"0","responsive":"1","non_responsive_width":"970px","build_rtl":"0","t3-assets":"t3-assets","t3-rmvlogo":"1","minify":"0","minify_js":"0","minify_js_tool":"jsmin","minify_exclude":null,"link_titles":null,"theme":"","logotype":"text","sitename":"<span class=\\"mn-logo-ico\\"><i class=\\"fa fa-rotate-right\\"><\\/i><\\/span><span class=\\"mn-logo-text\\">Echo<\\/span>","slogan":"","logoimage":"","enable_logoimage_sm":"0","logoimage_sm":"","mainlayout":"magazine","mm_type":"mainmenu","navigation_trigger":"hover","navigation_type":"megamenu","navigation_animation":"slide","navigation_animation_duration":"400","mm_config":"{\\"mainmenu\\":{\\"item-101\\":{\\"sub\\":{\\"width\\":700,\\"rows\\":[[{\\"item\\":299,\\"width\\":6},{\\"item\\":296,\\"width\\":6}]]}},\\"item-299\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":288,\\"width\\":12}]]},\\"group\\":1},\\"item-296\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":297,\\"width\\":12}]]},\\"group\\":1},\\"item-113\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":309,\\"width\\":12}]]}},\\"item-118\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":117,\\"width\\":12}]]}},\\"item-117\\":{\\"sub\\":{\\"width\\":270,\\"rows\\":[[{\\"item\\":150,\\"width\\":12}]]}},\\"item-121\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":120,\\"width\\":12}]]}},\\"item-127\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":129,\\"width\\":12}]]}},\\"item-129\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":128,\\"width\\":12}]]}},\\"item-302\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":306,\\"width\\":12}]]}},\\"item-136\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":135,\\"width\\":12}]]}},\\"item-141\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":142,\\"width\\":12}]]}},\\"item-146\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":147,\\"width\\":12}]]}}}}","navigation_collapse_enable":"0","addon_offcanvas_enable":"1","addon_offcanvas_effect":"off-canvas-effect-2","snippet_open_head":null,"snippet_close_head":null,"snippet_open_body":null,"snippet_close_body":null,"snippet_debug":"0","theme_extras_k2":["-1"],"theme_extras_minitek-typo":["-1"],"theme_extras_minitek":["-1"],"theme_extras_typography":["119"],"mm_config_needupdate":""}'),
(18, 'echo', 0, '0', 'Echo - Default - Content Left', '{"slider-caption":"0","slider_image":"","slider-caption-ico":"","slider-caption-tilte":"","slider-caption-btn-text":"","slider-caption-btn-link":"","t3_template":"1","devmode":"0","themermode":"1","legacy_css":"0","responsive":"1","non_responsive_width":"970px","build_rtl":"0","t3-assets":"t3-assets","t3-rmvlogo":"1","minify":"0","minify_js":"0","minify_js_tool":"jsmin","minify_exclude":null,"link_titles":null,"theme":"","logotype":"text","sitename":"<span class=\\"mn-logo-ico\\"><i class=\\"fa fa-rotate-right\\"><\\/i><\\/span><span class=\\"mn-logo-text\\">Echo<\\/span>","slogan":"","logoimage":"","enable_logoimage_sm":"0","logoimage_sm":"","mainlayout":"default-content-left","mm_type":"mainmenu","navigation_trigger":"hover","navigation_type":"megamenu","navigation_animation":"slide","navigation_animation_duration":"400","mm_config":"{\\"mainmenu\\":{\\"item-101\\":{\\"sub\\":{\\"width\\":700,\\"rows\\":[[{\\"item\\":299,\\"width\\":6},{\\"item\\":296,\\"width\\":6}]]}},\\"item-299\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":288,\\"width\\":12}]]},\\"group\\":1},\\"item-296\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":297,\\"width\\":12}]]},\\"group\\":1},\\"item-113\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":309,\\"width\\":12}]]}},\\"item-118\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":117,\\"width\\":12}]]}},\\"item-117\\":{\\"sub\\":{\\"width\\":270,\\"rows\\":[[{\\"item\\":150,\\"width\\":12}]]}},\\"item-121\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":120,\\"width\\":12}]]}},\\"item-127\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":129,\\"width\\":12}]]}},\\"item-129\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":128,\\"width\\":12}]]}},\\"item-302\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":306,\\"width\\":12}]]}},\\"item-136\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":135,\\"width\\":12}]]}},\\"item-141\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":142,\\"width\\":12}]]}},\\"item-146\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":147,\\"width\\":12}]]}}}}","navigation_collapse_enable":"0","addon_offcanvas_enable":"1","addon_offcanvas_effect":"off-canvas-effect-2","snippet_open_head":null,"snippet_close_head":null,"snippet_open_body":null,"snippet_close_body":null,"snippet_debug":"0","theme_extras_k2":["-1"],"theme_extras_minitek-typo":["-1"],"theme_extras_minitek":["-1"],"theme_extras_typography":["119"],"mm_config_needupdate":""}'),
(19, 'echo', 0, '0', 'Echo - Default - Content Right', '{"slider-caption":"0","slider_image":"","slider-caption-ico":"","slider-caption-tilte":"","slider-caption-btn-text":"","slider-caption-btn-link":"","t3_template":"1","devmode":"0","themermode":"1","legacy_css":"0","responsive":"1","non_responsive_width":"970px","build_rtl":"0","t3-assets":"t3-assets","t3-rmvlogo":"1","minify":"0","minify_js":"0","minify_js_tool":"jsmin","minify_exclude":null,"link_titles":null,"theme":"","logotype":"text","sitename":"<span class=\\"mn-logo-ico\\"><i class=\\"fa fa-rotate-right\\"><\\/i><\\/span><span class=\\"mn-logo-text\\">Echo<\\/span>","slogan":"","logoimage":"","enable_logoimage_sm":"0","logoimage_sm":"","mainlayout":"default-content-right","mm_type":"mainmenu","navigation_trigger":"hover","navigation_type":"megamenu","navigation_animation":"slide","navigation_animation_duration":"400","mm_config":"{\\"mainmenu\\":{\\"item-101\\":{\\"sub\\":{\\"width\\":700,\\"rows\\":[[{\\"item\\":299,\\"width\\":6},{\\"item\\":296,\\"width\\":6}]]}},\\"item-299\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":288,\\"width\\":12}]]},\\"group\\":1},\\"item-296\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":297,\\"width\\":12}]]},\\"group\\":1},\\"item-113\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":309,\\"width\\":12}]]}},\\"item-118\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":117,\\"width\\":12}]]}},\\"item-117\\":{\\"sub\\":{\\"width\\":270,\\"rows\\":[[{\\"item\\":150,\\"width\\":12}]]}},\\"item-121\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":120,\\"width\\":12}]]}},\\"item-127\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":129,\\"width\\":12}]]}},\\"item-129\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":128,\\"width\\":12}]]}},\\"item-302\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":306,\\"width\\":12}]]}},\\"item-136\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":135,\\"width\\":12}]]}},\\"item-141\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":142,\\"width\\":12}]]}},\\"item-146\\":{\\"sub\\":{\\"rows\\":[[{\\"item\\":147,\\"width\\":12}]]}}}}","navigation_collapse_enable":"0","addon_offcanvas_enable":"1","addon_offcanvas_effect":"off-canvas-effect-2","snippet_open_head":null,"snippet_close_head":null,"snippet_open_body":null,"snippet_close_body":null,"snippet_debug":"0","theme_extras_k2":["-1"],"theme_extras_minitek-typo":["-1"],"theme_extras_minitek":["-1"],"theme_extras_typography":["119"],"mm_config_needupdate":""}');

DROP TABLE IF EXISTS `#__ucm_base`;
CREATE TABLE IF NOT EXISTS `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `#__ucm_content`;
CREATE TABLE IF NOT EXISTS `#__ucm_content` (
`core_content_id` int(10) unsigned NOT NULL,
  `core_type_alias` varchar(255) NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(255) NOT NULL,
  `core_alias` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL DEFAULT '',
  `core_body` mediumtext NOT NULL,
  `core_state` tinyint(1) NOT NULL DEFAULT '0',
  `core_checked_out_time` varchar(255) NOT NULL DEFAULT '',
  `core_checked_out_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_access` int(10) unsigned NOT NULL DEFAULT '0',
  `core_params` text NOT NULL,
  `core_featured` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `core_metadata` varchar(2048) NOT NULL COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `core_created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `core_language` char(7) NOT NULL,
  `core_publish_up` datetime NOT NULL,
  `core_publish_down` datetime NOT NULL,
  `core_content_item_id` int(10) unsigned DEFAULT NULL COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned DEFAULT NULL COMMENT 'FK to the #__assets table.',
  `core_images` text NOT NULL,
  `core_urls` text NOT NULL,
  `core_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `core_version` int(10) unsigned NOT NULL DEFAULT '1',
  `core_ordering` int(11) NOT NULL DEFAULT '0',
  `core_metakey` text NOT NULL,
  `core_metadesc` text NOT NULL,
  `core_catid` int(10) unsigned NOT NULL DEFAULT '0',
  `core_xreference` varchar(50) NOT NULL COMMENT 'A reference to enable linkages to external data sets.',
  `core_type_id` int(10) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Contains core content data in name spaced fields' AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `#__ucm_history`;
CREATE TABLE IF NOT EXISTS `#__ucm_history` (
`version_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(10) unsigned NOT NULL,
  `ucm_type_id` int(10) unsigned NOT NULL,
  `version_note` varchar(255) NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `editor_user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `character_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` mediumtext NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0=auto delete; 1=keep'
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=208 ;

INSERT INTO `#__ucm_history` (`version_id`, `ucm_item_id`, `ucm_type_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(1, 8, 6, '', '2014-07-28 13:17:41', 400, 757, '4d5fcb40883f5923f9cbfe77f8c63276e5f31ac3', '{"id":8,"asset_id":62,"parent_id":"1","lft":"13","rgt":14,"level":1,"path":null,"extension":"com_content","title":"Articles","alias":"articles","note":"","description":"<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<\\/p>","published":"1","checked_out":null,"checked_out_time":null,"access":"1","params":"{\\"category_layout\\":\\"\\",\\"image\\":\\"\\"}","metadesc":"","metakey":"","metadata":"{\\"author\\":\\"\\",\\"robots\\":\\"\\"}","created_user_id":"444","created_time":"2014-07-28 13:17:41","modified_user_id":null,"modified_time":null,"hits":"0","language":"*","version":null}', 0),
(2, 9, 6, '', '2014-07-28 13:18:52', 400, 761, '10cd609e78577b13879111bf032024558531fcc6', '{"id":9,"asset_id":63,"parent_id":"8","lft":"14","rgt":15,"level":2,"path":null,"extension":"com_content","title":"Category I","alias":"category-i","note":"","description":"<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<\\/p>","published":"1","checked_out":null,"checked_out_time":null,"access":"1","params":"{\\"category_layout\\":\\"\\",\\"image\\":\\"\\"}","metadesc":"","metakey":"","metadata":"{\\"author\\":\\"\\",\\"robots\\":\\"\\"}","created_user_id":"444","created_time":"2014-07-28 13:18:52","modified_user_id":null,"modified_time":null,"hits":"0","language":"*","version":null}', 0),
(3, 10, 6, '', '2014-07-28 13:19:24', 400, 764, 'cb989300a445b460d21c9ef0e8613b788e21609b', '{"id":10,"asset_id":64,"parent_id":"8","lft":"16","rgt":17,"level":2,"path":null,"extension":"com_content","title":"Category II","alias":"category-ii","note":"","description":"<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<\\/p>","published":"1","checked_out":null,"checked_out_time":null,"access":"1","params":"{\\"category_layout\\":\\"\\",\\"image\\":\\"\\"}","metadesc":"","metakey":"","metadata":"{\\"author\\":\\"\\",\\"robots\\":\\"\\"}","created_user_id":"444","created_time":"2014-07-28 13:19:24","modified_user_id":null,"modified_time":null,"hits":"0","language":"*","version":null}', 0),
(4, 11, 6, '', '2014-07-28 13:19:40', 400, 508, '4c7eb56f57e2357f937006aeeaca96c8d63c628d', '{"id":11,"asset_id":65,"parent_id":"1","lft":"19","rgt":20,"level":1,"path":null,"extension":"com_content","title":"FAQ","alias":"faq","note":"","description":"","published":"1","checked_out":null,"checked_out_time":null,"access":"1","params":"{\\"category_layout\\":\\"\\",\\"image\\":\\"\\"}","metadesc":"","metakey":"","metadata":"{\\"author\\":\\"\\",\\"robots\\":\\"\\"}","created_user_id":"444","created_time":"2014-07-28 13:19:40","modified_user_id":null,"modified_time":null,"hits":"0","language":"*","version":null}', 0),
(5, 1, 1, '', '2014-07-28 13:20:56', 400, 2629, 'd5c6ce724a34154c988469cf7417a5ed7db9d2b5', '{"id":1,"asset_id":66,"title":"Article1","alias":"article1","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"9","created":"2014-07-28 13:20:56","created_by":"444","created_by_alias":"","modified":"","modified_by":null,"checked_out":null,"checked_out_time":null,"publish_up":"2014-07-28 13:20:56","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":1,"ordering":null,"metakey":"","metadesc":"","access":"1","hits":null,"metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(6, 2, 1, '', '2014-07-28 13:21:13', 400, 2629, '30fb293ce8fa59c65f70a2983d4c6f12213f6310', '{"id":2,"asset_id":67,"title":"Article2","alias":"article2","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"9","created":"2014-07-28 13:21:13","created_by":"444","created_by_alias":"","modified":"","modified_by":null,"checked_out":null,"checked_out_time":null,"publish_up":"2014-07-28 13:21:13","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":1,"ordering":null,"metakey":"","metadesc":"","access":"1","hits":null,"metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(7, 3, 1, '', '2014-07-28 13:21:34', 400, 2630, '158ff409c643e9a762193e86b2d44e9777a89393', '{"id":3,"asset_id":68,"title":"Article3","alias":"article3","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"10","created":"2014-07-28 13:21:34","created_by":"444","created_by_alias":"","modified":"","modified_by":null,"checked_out":null,"checked_out_time":null,"publish_up":"2014-07-28 13:21:34","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":1,"ordering":null,"metakey":"","metadesc":"","access":"1","hits":null,"metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(8, 4, 1, '', '2014-07-28 13:21:47', 400, 2630, '59cd6ff1dd5b750bcdd73316f24c6c76420706b9', '{"id":4,"asset_id":69,"title":"Article4","alias":"article4","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"10","created":"2014-07-28 13:21:47","created_by":"444","created_by_alias":"","modified":"","modified_by":null,"checked_out":null,"checked_out_time":null,"publish_up":"2014-07-28 13:21:47","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":1,"ordering":null,"metakey":"","metadesc":"","access":"1","hits":null,"metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(9, 5, 1, '', '2014-07-28 13:22:20', 400, 12155, '9af60ff5d6777202bf31702c97310e0e9587184a', '{"id":5,"asset_id":70,"title":"FAQ","alias":"faq","introtext":"  <div class=\\"mn-mod-header\\">\\r\\n    <div class=\\"mn-title\\">\\r\\n      <h2>Frequently Asked Questions<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"mn-description\\">\\r\\n      <h4>Welcome to our FAQ section. Below you will find a selection<br>of the questions we get asked most. Simply click the question to reveal the answer.<\\/h4>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"panel-group\\" id=\\"accordion\\">\\r\\n  <div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\">\\r\\n      <h4 class=\\"panel-title\\">\\r\\n        <a data-toggle=\\"collapse\\" data-parent=\\"#accordion\\" href=\\"#collapse1\\">\\r\\n            Lorem ipsum dolor sit amet consectetur adipiscing elit?\\r\\n        <\\/a>\\r\\n      <\\/h4>\\r\\n    <\\/div>\\r\\n    <div id=\\"collapse1\\" class=\\"panel-collapse collapse in\\">\\r\\n      <div class=\\"panel-body\\">\\r\\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n  <div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\">\\r\\n      <h4 class=\\"panel-title\\">\\r\\n        <a data-toggle=\\"collapse\\" data-parent=\\"#accordion\\" href=\\"#collapse2\\">\\r\\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\\r\\n        <\\/a>\\r\\n      <\\/h4>\\r\\n    <\\/div>\\r\\n    <div id=\\"collapse2\\" class=\\"panel-collapse collapse\\">\\r\\n      <div class=\\"panel-body\\">\\r\\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n  <div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\">\\r\\n      <h4 class=\\"panel-title\\">\\r\\n        <a data-toggle=\\"collapse\\" data-parent=\\"#accordion\\" href=\\"#collapse3\\">\\r\\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\\r\\n        <\\/a>\\r\\n      <\\/h4>\\r\\n    <\\/div>\\r\\n    <div id=\\"collapse3\\" class=\\"panel-collapse collapse\\">\\r\\n      <div class=\\"panel-body\\">\\r\\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n    <div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\">\\r\\n      <h4 class=\\"panel-title\\">\\r\\n        <a data-toggle=\\"collapse\\" data-parent=\\"#accordion\\" href=\\"#collapse4\\">\\r\\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\\r\\n        <\\/a>\\r\\n      <\\/h4>\\r\\n    <\\/div>\\r\\n    <div id=\\"collapse4\\" class=\\"panel-collapse collapse\\">\\r\\n      <div class=\\"panel-body\\">\\r\\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n  <div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\">\\r\\n      <h4 class=\\"panel-title\\">\\r\\n        <a data-toggle=\\"collapse\\" data-parent=\\"#accordion\\" href=\\"#collapse5\\">\\r\\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\\r\\n        <\\/a>\\r\\n      <\\/h4>\\r\\n    <\\/div>\\r\\n    <div id=\\"collapse5\\" class=\\"panel-collapse collapse\\">\\r\\n      <div class=\\"panel-body\\">\\r\\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n  <div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\">\\r\\n      <h4 class=\\"panel-title\\">\\r\\n        <a data-toggle=\\"collapse\\" data-parent=\\"#accordion\\" href=\\"#collapse6\\">\\r\\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\\r\\n        <\\/a>\\r\\n      <\\/h4>\\r\\n    <\\/div>\\r\\n    <div id=\\"collapse6\\" class=\\"panel-collapse collapse\\">\\r\\n      <div class=\\"panel-body\\">\\r\\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n  <div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\">\\r\\n      <h4 class=\\"panel-title\\">\\r\\n        <a data-toggle=\\"collapse\\" data-parent=\\"#accordion\\" href=\\"#collapse7\\">\\r\\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\\r\\n        <\\/a>\\r\\n      <\\/h4>\\r\\n    <\\/div>\\r\\n    <div id=\\"collapse7\\" class=\\"panel-collapse collapse\\">\\r\\n      <div class=\\"panel-body\\">\\r\\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n  <div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\">\\r\\n      <h4 class=\\"panel-title\\">\\r\\n        <a data-toggle=\\"collapse\\" data-parent=\\"#accordion\\" href=\\"#collapse8\\">\\r\\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\\r\\n        <\\/a>\\r\\n      <\\/h4>\\r\\n    <\\/div>\\r\\n    <div id=\\"collapse8\\" class=\\"panel-collapse collapse\\">\\r\\n      <div class=\\"panel-body\\">\\r\\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n  <div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\">\\r\\n      <h4 class=\\"panel-title\\">\\r\\n        <a data-toggle=\\"collapse\\" data-parent=\\"#accordion\\" href=\\"#collapse9\\">\\r\\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\\r\\n        <\\/a>\\r\\n      <\\/h4>\\r\\n    <\\/div>\\r\\n    <div id=\\"collapse9\\" class=\\"panel-collapse collapse\\">\\r\\n      <div class=\\"panel-body\\">\\r\\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n  <div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\">\\r\\n      <h4 class=\\"panel-title\\">\\r\\n        <a data-toggle=\\"collapse\\" data-parent=\\"#accordion\\" href=\\"#collapse10\\">\\r\\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\\r\\n        <\\/a>\\r\\n      <\\/h4>\\r\\n    <\\/div>\\r\\n    <div id=\\"collapse10\\" class=\\"panel-collapse collapse\\">\\r\\n      <div class=\\"panel-body\\">\\r\\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n  <div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\">\\r\\n      <h4 class=\\"panel-title\\">\\r\\n        <a data-toggle=\\"collapse\\" data-parent=\\"#accordion\\" href=\\"#collapse11\\">\\r\\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\\r\\n        <\\/a>\\r\\n      <\\/h4>\\r\\n    <\\/div>\\r\\n    <div id=\\"collapse11\\" class=\\"panel-collapse collapse\\">\\r\\n      <div class=\\"panel-body\\">\\r\\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n  <div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\">\\r\\n      <h4 class=\\"panel-title\\">\\r\\n        <a data-toggle=\\"collapse\\" data-parent=\\"#accordion\\" href=\\"#collapse12\\">\\r\\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\\r\\n        <\\/a>\\r\\n      <\\/h4>\\r\\n    <\\/div>\\r\\n    <div id=\\"collapse12\\" class=\\"panel-collapse collapse\\">\\r\\n      <div class=\\"panel-body\\">\\r\\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n    <div class=\\"panel panel-default\\">\\r\\n    <div class=\\"panel-heading\\">\\r\\n      <h4 class=\\"panel-title\\">\\r\\n        <a data-toggle=\\"collapse\\" data-parent=\\"#accordion\\" href=\\"#collapse13\\">\\r\\n          Lorem ipsum dolor sit amet consectetur adipiscing elit?\\r\\n        <\\/a>\\r\\n      <\\/h4>\\r\\n    <\\/div>\\r\\n    <div id=\\"collapse13\\" class=\\"panel-collapse collapse\\">\\r\\n      <div class=\\"panel-body\\">\\r\\nLorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam id ultricies nibh, vitae hendrerit odio. Nulla non hendrerit velit, eu ullamcorper diam. Duis viverra id libero ut consequat. Vivamus convallis lorem urna, ut ullamcorper est euismod vel. Lorem ipsum dolor sit amet, consectetur adipiscing elit. \\r\\n      <\\/div>\\r\\n    <\\/div>\\r\\n  <\\/div>\\r\\n\\r\\n\\r\\n<\\/div>\\r\\n","fulltext":"","state":1,"catid":"11","created":"2014-07-28 13:22:20","created_by":"444","created_by_alias":"","modified":"","modified_by":null,"checked_out":null,"checked_out_time":null,"publish_up":"2014-07-28 13:22:20","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":1,"ordering":null,"metakey":"","metadesc":"","access":"1","hits":null,"metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(11, 7, 1, '', '2014-07-28 13:23:49', 400, 7748, '7a13d666a641a51ed29e6a259f5c1c78649b5a24', '{"id":7,"asset_id":72,"title":"Page Breaks","alias":"page-breaks","introtext":"","fulltext":"\\r\\n<p>Ut dignissim aliquet nibh tristique hendrerit. Donec ullamcorper nulla quis metus vulputate id placerat augue eleifend. Aenean venenatis consectetur orci, sit amet ultricies magna sagittis vel. Nulla non diam nisi, ut ultrices massa. Pellentesque sed nisl metus. Praesent a mi vel ante molestie venenatis.<\\/p>\\r\\n<p>Donec sed odio dui. Cras mattis consectetur purus sit amet fermentum. Nullam quis risus eget urna mollis ornare vel eu leo. Donec id elit non mi porta gravida at eget metus. Etiam porta sem malesuada magna mollis euismod. Cras justo odio, dapibus ac facilisis in, egestas eget quam.<\\/p>\\r\\n<p>Mauris justo metus, ultrices id lobortis et, euismod sit amet metus. Maecenas sed nisl a arcu ultricies consectetur. Integer ut mollis elit. Nulla ultrices scelerisque mauris id commodo. Integer congue lectus et justo pellentesque sed semper lacus facilisis. Nunc tristique placerat odio eget rutrum.<\\/p>\\r\\n<p>Ut viverra erat id augue bibendum rutrum. Nam aliquet feugiat molestie. Maecenas tempus scelerisque tellus eu mattis. Aliquam dignissim aliquam posuere. Sed dignissim, ipsum sed sodales aliquam, erat dolor varius eros, in semper sem metus vel metus. Nullam est mauris, laoreet condimentum hendrerit et, euismod quis dolor. Nunc eleifend lacinia libero eget scelerisque. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae.<\\/p>\\r\\n<p>Nulla vitae elit libero, a pharetra augue. Donec ullamcorper nulla non metus auctor fringilla. Nulla vitae elit libero, a pharetra augue. Aenean lacinia bibendum nulla sed consectetur. Donec id elit non mi porta gravida at eget metus.<\\/p>\\r\\n<p>Vivamus eget est urna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Vivamus mauris justo, fermentum quis mattis vel, auctor vitae metus. Maecenas non dolor ac risus faucibus luctus non id turpis. Morbi ante nibh, suscipit non adipiscing in, ornare in ipsum.<\\/p>\\r\\n<hr title=\\"Second page\\" alt=\\"second-page\\" class=\\"system-pagebreak\\" \\/>\\r\\n<p>Nullam ac odio orci, sed pretium velit. Integer sit amet justo faucibus lorem imperdiet sagittis. Proin egestas, risus in faucibus sodales, tortor turpis feugiat risus, varius laoreet dui turpis ac dolor. Nullam suscipit fringilla augue non rhoncus. Nullam ac nibh eu ipsum tristique ullamcorper. Nunc porttitor lorem id orci dapibus lacinia. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas.<\\/p>\\r\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed posuere consectetur est at lobortis. Vestibulum id ligula porta felis euismod semper. Donec id elit non mi porta gravida at eget metus. Integer posuere erat a ante venenatis dapibus posuere velit aliquet.<\\/p>\\r\\n<p>Etiam porta sem malesuada magna mollis euismod. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Maecenas sed diam eget risus varius blandit sit amet non magna. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.<\\/p>\\r\\n<hr title=\\"Third page\\" alt=\\"third-page\\" class=\\"system-pagebreak\\" \\/>\\r\\n<p> <\\/p>\\r\\n<p>Donec sed odio dui. Cras mattis consectetur purus sit amet fermentum. Nullam quis risus eget urna mollis ornare vel eu leo. Donec id elit non mi porta gravida at eget metus. Etiam porta sem malesuada magna mollis euismod. Cras justo odio, dapibus ac facilisis in, egestas eget quam.<\\/p>\\r\\n<p>Etiam porta sem malesuada magna mollis euismod. Aenean eu leo quam. Pellentesque ornare sem lacinia quam venenatis vestibulum. Maecenas sed diam eget risus varius blandit sit amet non magna. Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.<\\/p>\\r\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed posuere consectetur est at lobortis. Vestibulum id ligula porta felis euismod semper. Donec id elit non mi porta gravida at eget metus. Integer posuere erat a ante venenatis dapibus posuere velit aliquet.<\\/p>\\r\\n<p>Nulla vitae elit libero, a pharetra augue. Donec ullamcorper nulla non metus auctor fringilla. Nulla vitae elit libero, a pharetra augue. Aenean lacinia bibendum nulla sed consectetur. Donec id elit non mi porta gravida at eget metus.<\\/p>\\r\\n<hr title=\\"Fourth page\\" alt=\\"fourth-page\\" class=\\"system-pagebreak\\" \\/>\\r\\n<p>Maecenas faucibus mollis interdum. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Donec id elit non mi porta gravida at eget metus. Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem nec elit. Praesent commodo cursus magna, vel scelerisque nisl consectetur et.<\\/p>\\r\\n<p>Fusce id enim id erat sodales auctor. Duis tortor nisl, condimentum vel feugiat vel, venenatis ut dolor. Donec interdum ornare ligula, vitae adipiscing diam imperdiet at. Donec facilisis, nunc sit amet ultricies adipiscing, ligula justo congue lectus, sit amet vehicula enim lorem in neque. In ultrices bibendum justo ac vehicula. Nam tincidunt blandit consequat.<\\/p>\\r\\n<p>Vestibulum id ligula porta felis euismod semper. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Donec id elit non mi porta gravida at eget metus.<\\/p>\\r\\n<hr title=\\"Fifth page\\" alt=\\"fifth-page\\" class=\\"system-pagebreak\\" \\/>\\r\\n<p>Nullam quis risus eget urna mollis ornare vel eu leo. Sed posuere consectetur est at lobortis. Aenean lacinia bibendum nulla sed consectetur. Maecenas sed diam eget risus varius blandit sit amet non magna. Etiam porta sem malesuada magna mollis euismod.<\\/p>\\r\\n<p>Nullam quis risus eget urna mollis ornare vel eu leo. Donec id elit non mi porta gravida at eget metus. Aenean lacinia bibendum nulla sed consectetur.<\\/p>\\r\\n<p>Vestibulum id ligula porta felis euismod semper. Donec ullamcorper nulla non metus auctor fringilla. Curabitur blandit tempus porttitor. Donec id elit non mi porta gravida at eget metus. Cras justo odio, dapibus ac facilisis in, egestas eget quam.<\\/p>\\r\\n<p> <\\/p>","state":1,"catid":"2","created":"2014-07-28 13:23:49","created_by":"444","created_by_alias":"","modified":"","modified_by":null,"checked_out":null,"checked_out_time":null,"publish_up":"2014-07-28 13:23:49","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":1,"ordering":null,"metakey":"","metadesc":"","access":"1","hits":null,"metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0);
INSERT INTO `#__ucm_history` (`version_id`, `ucm_item_id`, `ucm_type_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(12, 8, 1, '', '2014-07-28 13:24:18', 400, 81692, '17e08e0dc55aa4a4c8f03e0d08dde44173e7bff6', '{"id":8,"asset_id":73,"title":"Typography","alias":"typography","introtext":"     <div class=\\"page-header col-xs-12\\">\\r\\n        <h2 id=\\"headings\\">ALERTS<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n  <div class=\\"col-xs-12 col-sm-6\\">  \\r\\n        <div class=\\"alert alert-success\\">\\r\\n            <strong>Success!<\\/strong> You successfully read this important alert message.\\r\\n            <button class=\\"close\\" type=\\"button\\" data-dismiss=\\"alert\\">\\u00d7<\\/button>\\r\\n        <\\/div>\\r\\n        \\r\\n        <div class=\\"alert alert-info\\">\\r\\n            <strong>Info!<\\/strong> This alert needs your attention, but it''s not super important.\\r\\n            <button class=\\"close\\" type=\\"button\\" data-dismiss=\\"alert\\">\\u00d7<\\/button>\\r\\n        <\\/div>\\r\\n  <\\/div>\\r\\n    \\r\\n  <div class=\\"col-xs-12 col-sm-6\\"> \\r\\n        <div class=\\"alert alert-warning\\">\\r\\n            <strong>Warning!<\\/strong> Best check yo self, you''re not looking too good.\\r\\n            <button class=\\"close\\" type=\\"button\\" data-dismiss=\\"alert\\">\\u00d7<\\/button>\\r\\n        <\\/div>\\r\\n        \\r\\n        <div class=\\"alert alert-error fade in\\">\\r\\n            <button class=\\"close\\" type=\\"button\\" data-dismiss=\\"alert\\">\\u00d7<\\/button>\\r\\n            <strong>Error!<\\/strong> Empty password not allowed\\r\\n        <\\/div>\\r\\n  <\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-sm-12\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">HEADINGS<\\/h2>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"bs-example bs-example-type\\">\\r\\n          <table class=\\"table\\">\\r\\n            <tbody>\\r\\n              <tr>\\r\\n                <td><h1>h1. Heading <small>Secondary text<\\/small><\\/h1><\\/td>\\r\\n              <\\/tr>\\r\\n              <tr>\\r\\n                <td><h2>h2. Heading <small>Secondary text<\\/small><\\/h2><\\/td>\\r\\n              <\\/tr>\\r\\n              <tr>\\r\\n                <td><h3>h3. Heading <small>Secondary text<\\/small><\\/h3><\\/td>\\r\\n              <\\/tr>\\r\\n              <tr>\\r\\n                <td><h4>h4. Heading <small>Secondary text<\\/small><\\/h4><\\/td>\\r\\n              <\\/tr>\\r\\n              <tr>\\r\\n                <td><h5>h5. Heading <small>Secondary text<\\/small><\\/h5><\\/td>\\r\\n              <\\/tr>\\r\\n              <tr>\\r\\n                <td><h6>h6. Heading <small>Secondary text<\\/small><\\/h6><\\/td>\\r\\n              <\\/tr>\\r\\n            <\\/tbody>\\r\\n          <\\/table>\\r\\n    <\\/div>\\r\\n<div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;h1&gt;<\\/span>h1. Bootstrap heading <span class=\\"nt\\">&lt;small&gt;<\\/span>Secondary text<span class=\\"nt\\">&lt;\\/small&gt;&lt;\\/h1&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;h2&gt;<\\/span>h2. heading <span class=\\"nt\\">&lt;small&gt;<\\/span>Secondary text<span class=\\"nt\\">&lt;\\/small&gt;&lt;\\/h2&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;h3&gt;<\\/span>h3. heading <span class=\\"nt\\">&lt;small&gt;<\\/span>Secondary text<span class=\\"nt\\">&lt;\\/small&gt;&lt;\\/h3&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;h4&gt;<\\/span>h4. heading <span class=\\"nt\\">&lt;small&gt;<\\/span>Secondary text<span class=\\"nt\\">&lt;\\/small&gt;&lt;\\/h4&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;h5&gt;<\\/span>h5. heading <span class=\\"nt\\">&lt;small&gt;<\\/span>Secondary text<span class=\\"nt\\">&lt;\\/small&gt;&lt;\\/h5&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;h6&gt;<\\/span>h6. heading <span class=\\"nt\\">&lt;small&gt;<\\/span>Secondary text<span class=\\"nt\\">&lt;\\/small&gt;&lt;\\/h6&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Body Text<\\/h2>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"bs-example\\">\\r\\n        <p>Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nullam id dolor id nibh ultricies vehicula.<\\/p>\\r\\n    <\\/div>\\r\\n    \\r\\n<div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;p&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Lead Body Text<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\"bs-example\\">\\r\\n          <p class=\\"lead\\">Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Duis mollis, est non commodo luctus.<\\/p>\\r\\n    <\\/div>\\r\\n<div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;p<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"lead\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Abbreviations<\\/h2>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"bs-example\\">\\r\\n      <p>An abbreviation of the word attribute is <abbr title=\\"attribute\\">attr<\\/abbr>.<\\/p>\\r\\n    <\\/div>\\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;abbr<\\/span> <span class=\\"na\\">title=<\\/span><span class=\\"s\\">\\"attribute\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>attr<span class=\\"nt\\">&lt;\\/abbr&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Initialism<\\/h2>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"bs-example\\">\\r\\n      <p><abbr title=\\"HyperText Markup Language\\" class=\\"initialism\\">HTML<\\/abbr> is the best thing since sliced bread.<\\/p>\\r\\n    <\\/div>\\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;abbr<\\/span> <span class=\\"na\\">title=<\\/span><span class=\\"s\\">\\"HyperText Markup Language\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"initialism\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>HTML<span class=\\"nt\\">&lt;\\/abbr&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Labels<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n        <div class=\\"bs-example\\">\\r\\n          <span class=\\"label label-default\\">Default<\\/span>\\r\\n          <span class=\\"label label-primary\\">Primary<\\/span>\\r\\n          <span class=\\"label label-success\\">Success<\\/span>\\r\\n          <span class=\\"label label-info\\">Info<\\/span>\\r\\n          <span class=\\"label label-warning\\">Warning<\\/span>\\r\\n          <span class=\\"label label-danger\\">Danger<\\/span>\\r\\n        <\\/div>\\r\\n        \\r\\n        <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;span<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"label label-default\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Default<span class=\\"nt\\">&lt;\\/span&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;span<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"label label-primary\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Primary<span class=\\"nt\\">&lt;\\/span&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;span<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"label label-success\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Success<span class=\\"nt\\">&lt;\\/span&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;span<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"label label-info\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Info<span class=\\"nt\\">&lt;\\/span&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;span<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"label label-warning\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Warning<span class=\\"nt\\">&lt;\\/span&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;span<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"label label-danger\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Danger<span class=\\"nt\\">&lt;\\/span&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Badges<\\/h2>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"bs-example\\">\\r\\n      <a href=\\"#\\">Inbox <span class=\\"badge\\">42<\\/span><\\/a>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;a<\\/span> <span class=\\"na\\">href=<\\/span><span class=\\"s\\">\\"#\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Inbox <span class=\\"nt\\">&lt;span<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"badge\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>42<span class=\\"nt\\">&lt;\\/span&gt;&lt;\\/a&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n\\r\\n\\r\\n<div class=\\"page-header col-xs-12\\">\\r\\n    <h2 id=\\"headings\\">BLOCKQUOTES<\\/h2>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Default blockquote<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <blockquote>\\r\\n        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.<\\/p>\\r\\n      <\\/blockquote>\\r\\n    <\\/div> \\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;blockquote&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;p&gt;<\\/span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/blockquote&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>   \\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Blockquote options<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <blockquote>\\r\\n        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.<\\/p>\\r\\n        <small>Someone famous in <cite title=\\"Source Title\\">Source Title<\\/cite><\\/small>\\r\\n      <\\/blockquote>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;blockquote&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;p&gt;<\\/span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;small&gt;<\\/span>Someone famous in <span class=\\"nt\\">&lt;cite<\\/span> <span class=\\"na\\">title=<\\/span><span class=\\"s\\">\\"Source Title\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Source Title<span class=\\"nt\\">&lt;\\/cite&gt;&lt;\\/small&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/blockquote&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>    \\r\\n    \\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"col-xs-12\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Alternate blockquote display<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\" style=\\"overflow: hidden;\\">\\r\\n      <blockquote class=\\"pull-right\\">\\r\\n        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.<\\/p>\\r\\n        <small>Someone famous in <cite title=\\"Source Title\\">Source Title<\\/cite><\\/small>\\r\\n      <\\/blockquote>\\r\\n    <\\/div> \\r\\n    \\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;blockquote<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"pull-right\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>\\r\\n  ...\\r\\n<span class=\\"nt\\">&lt;\\/blockquote&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>   \\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"page-header col-xs-12\\">\\r\\n    <h2 id=\\"headings\\">LISTS<\\/h2>\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Unordered<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <ul>\\r\\n        <li>Lorem ipsum dolor sit amet<\\/li>\\r\\n        <li>Consectetur adipiscing elit<\\/li>\\r\\n        <li>Nulla volutpat aliquam velit\\r\\n          <ul>\\r\\n            <li>Phasellus iaculis neque<\\/li>\\r\\n            <li>Purus sodales ultricies<\\/li>\\r\\n            <li>Vestibulum laoreet porttitor sem<\\/li>\\r\\n            <li>Ac tristique libero volutpat at<\\/li>\\r\\n          <\\/ul>\\r\\n        <\\/li>\\r\\n        <li>Faucibus porta lacus fringilla vel<\\/li>\\r\\n      <\\/ul>\\r\\n    <\\/div>\\r\\n<div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;ul&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;li&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/li&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/ul&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>    \\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Ordered<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <ol>\\r\\n        <li>Lorem ipsum dolor sit amet<\\/li>\\r\\n        <li>Consectetur adipiscing elit<\\/li>\\r\\n        <li>Integer molestie lorem at massa<\\/li>\\r\\n        <li>Facilisis in pretium nisl aliquet<\\/li>\\r\\n        <li>Nulla volutpat aliquam velit<\\/li>\\r\\n        <li>Faucibus porta lacus fringilla vel<\\/li>\\r\\n        <li>Aenean sit amet erat nunc<\\/li>\\r\\n        <li>Eget porttitor lorem<\\/li>\\r\\n      <\\/ol>\\r\\n    <\\/div>\\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;ol&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;li&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/li&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/ol&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n    \\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Unstyled<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <ul class=\\"list-unstyled\\">\\r\\n        <li>Lorem ipsum dolor sit amet<\\/li>          \\r\\n        <li>Nulla volutpat aliquam velit\\r\\n          <ul>\\r\\n            <li>Phasellus iaculis neque<\\/li>\\r\\n            <li>Purus sodales ultricies<\\/li>\\r\\n            <li>Vestibulum laoreet porttitor sem<\\/li>\\r\\n            <li>Ac tristique libero volutpat at<\\/li>\\r\\n          <\\/ul>\\r\\n        <\\/li>\\r\\n        <li>Faucibus porta lacus fringilla vel<\\/li>\\r\\n      <\\/ul>\\r\\n    <\\/div>\\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;ul<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"list-unstyled\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;li&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/li&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/ul&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n    \\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Inline<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <ul class=\\"list-inline\\">\\r\\n        <li>Lorem ipsum<\\/li>\\r\\n        <li>Phasellus iaculis<\\/li>\\r\\n        <li>Nulla volutpat<\\/li>\\r\\n      <\\/ul>\\r\\n    <\\/div>\\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;ul<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"list-inline\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;li&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/li&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/ul&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n    \\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Description<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <dl>\\r\\n        <dt>Description lists<\\/dt>\\r\\n        <dd>A description list is perfect for defining terms.<\\/dd>\\r\\n        <dt>Euismod<\\/dt>\\r\\n        <dd>Vestibulum id ligula porta felis euismod semper eget lacinia odio sem nec elit.<\\/dd>\\r\\n        <dd>Donec id elit non mi porta gravida at eget metus.<\\/dd>\\r\\n        <dt>Malesuada porta<\\/dt>\\r\\n        <dd>Etiam porta sem malesuada magna mollis euismod.<\\/dd>\\r\\n      <\\/dl>\\r\\n    <\\/div>\\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;dl&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;dt&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/dt&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;dd&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/dd&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/dl&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n    \\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Horizontal description<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <dl class=\\"dl-horizontal\\">\\r\\n        <dt>Description lists<\\/dt>\\r\\n        <dd>A description list is perfect for defining terms.<\\/dd>\\r\\n        <dt>Euismod<\\/dt>\\r\\n        <dd>Vestibulum id ligula porta felis euismod semper eget lacinia odio sem nec elit.<\\/dd>\\r\\n        <dt>Malesuada porta<\\/dt>\\r\\n        <dd>Etiam porta sem malesuada magna mollis euismod.<\\/dd>\\r\\n        <dt>Felis euismod semper eget lacinia<\\/dt>\\r\\n        <dd>Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.<\\/dd>\\r\\n      <\\/dl>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;dl<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"dl-horizontal\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;dt&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/dt&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;dd&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/dd&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/dl&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n    \\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">BUTTONS<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <button type=\\"button\\" class=\\"btn btn-default\\">Default<\\/button>\\r\\n      <button type=\\"button\\" class=\\"btn btn-primary\\">Primary<\\/button>\\r\\n      <button type=\\"button\\" class=\\"btn btn-success\\">Success<\\/button>\\r\\n      <button type=\\"button\\" class=\\"btn btn-info\\">Info<\\/button>\\r\\n      <button type=\\"button\\" class=\\"btn btn-warning\\">Warning<\\/button>\\r\\n      <button type=\\"button\\" class=\\"btn btn-danger\\">Danger<\\/button>\\r\\n      <button type=\\"button\\" class=\\"btn btn-link\\">Link<\\/button>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"c\\">&lt;!-- Standard button --&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-default\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Default<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n\\r\\n<span class=\\"c\\">&lt;!-- Provides extra visual weight and identifies the primary action in a set of buttons --&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-primary\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Primary<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n\\r\\n<span class=\\"c\\">&lt;!-- Indicates a successful or positive action --&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-success\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Success<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n\\r\\n<span class=\\"c\\">&lt;!-- Contextual button for informational alert messages --&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-info\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Info<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n\\r\\n<span class=\\"c\\">&lt;!-- Indicates caution should be taken with this action --&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-warning\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Warning<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n\\r\\n<span class=\\"c\\">&lt;!-- Indicates a dangerous or potentially negative action --&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-danger\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Danger<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n\\r\\n<span class=\\"c\\">&lt;!-- Deemphasize a button by making it look like a link while maintaining button behavior --&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-link\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Link<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Sizes<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <p>\\r\\n        <button type=\\"button\\" class=\\"btn btn-primary btn-lg\\">Large button<\\/button>\\r\\n        <button type=\\"button\\" class=\\"btn btn-default btn-lg\\">Large button<\\/button>\\r\\n      <\\/p>\\r\\n      <p>\\r\\n        <button type=\\"button\\" class=\\"btn btn-primary\\">Default button<\\/button>\\r\\n        <button type=\\"button\\" class=\\"btn btn-default\\">Default button<\\/button>\\r\\n      <\\/p>\\r\\n      <p>\\r\\n        <button type=\\"button\\" class=\\"btn btn-primary btn-sm\\">Small button<\\/button>\\r\\n        <button type=\\"button\\" class=\\"btn btn-default btn-sm\\">Small button<\\/button>\\r\\n      <\\/p>\\r\\n      <p>\\r\\n        <button type=\\"button\\" class=\\"btn btn-primary btn-xs\\">Extra small button<\\/button>\\r\\n        <button type=\\"button\\" class=\\"btn btn-default btn-xs\\">Extra small button<\\/button>\\r\\n      <\\/p>\\r\\n    <\\/div>    \\r\\n<div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;p&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-primary btn-lg\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Large button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-default btn-lg\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Large button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;p&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-primary\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Default button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-default\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Default button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;p&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-primary btn-sm\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Small button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-default btn-sm\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Small button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;p&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-primary btn-xs\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Extra small button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-default btn-xs\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Extra small button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>    \\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">JUMBOTRON<\\/h2>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"bs-example\\">\\r\\n      <div class=\\"jumbotron\\">\\r\\n        <h1>Hello, world!<\\/h1>\\r\\n        <p>This is a simple hero unit, a simple jumbotron-style component for calling extra attention to featured content or information.<\\/p>\\r\\n        <p><a class=\\"btn btn-primary btn-lg\\" role=\\"button\\">Learn more<\\/a><\\/p>\\r\\n      <\\/div>\\r\\n    <\\/div>   \\r\\n    \\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;div<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"jumbotron\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;h1&gt;<\\/span>Hello, world!<span class=\\"nt\\">&lt;\\/h1&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;p&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;p&gt;&lt;a<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-primary btn-lg\\"<\\/span> <span class=\\"na\\">role=<\\/span><span class=\\"s\\">\\"button\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Learn more<span class=\\"nt\\">&lt;\\/a&gt;&lt;\\/p&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/div&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div> \\r\\n    \\r\\n    \\r\\n<\\/div>\\r\\n\\r\\n\\r\\n\\r\\n\\r\\n  <div class=\\"page-header col-xs-12\\">\\r\\n    <h2 id=\\"headings\\">ICONS<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"col-xs-12\\">\\r\\n\\r\\n\\r\\n  <div id=\\"new\\">\\r\\n  \\r\\n  <div class=\\"page-header\\">\\r\\n    <h2 id=\\"headings\\">New Icons<\\/h2>\\r\\n<\\/div>\\r\\n\\r\\n  \\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rub\\"><\\/i> fa-rub<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-ruble\\"><\\/i> fa-ruble<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rouble\\"><\\/i> fa-rouble<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pagelines\\"><\\/i> fa-pagelines<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-stack-exchange\\"><\\/i> fa-stack-exchange<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-o-right\\"><\\/i> fa-arrow-circle-o-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-o-left\\"><\\/i> fa-arrow-circle-o-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-left\\"><\\/i> fa-caret-square-o-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-left\\"><\\/i> fa-toggle-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dot-circle-o\\"><\\/i> fa-dot-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-wheelchair\\"><\\/i> fa-wheelchair<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-vimeo-square\\"><\\/i> fa-vimeo-square><\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-try\\"><\\/i> fa-try<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-turkish-lira\\"><\\/i> fa-turkish-lira<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus-square-o\\"><\\/i> fa-plus-square-o<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n\\r\\n<\\/div>\\r\\n<br>\\r\\n  <section id=\\"web-application\\">\\r\\n  \\r\\n    <div class=\\"page-header\\">\\r\\n    <h2 id=\\"headings\\">Web Application Icons<\\/h2>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-adjust\\"><\\/i> fa-adjust<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-anchor\\"><\\/i> fa-anchor<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-archive\\"><\\/i> fa-archive<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows\\"><\\/i> fa-arrows<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows-h\\"><\\/i> fa-arrows-h<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows-v\\"><\\/i> fa-arrows-v<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-asterisk\\"><\\/i> fa-asterisk<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-ban\\"><\\/i> fa-ban<\\/a><\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bar-chart-o\\"><\\/i> fa-bar-chart-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-barcode\\"><\\/i> fa-barcode<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bars\\"><\\/i> fa-bars<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-beer\\"><\\/i> fa-beer<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bell\\"><\\/i> fa-bell<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bell-o\\"><\\/i> fa-bell-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bolt\\"><\\/i> fa-bolt<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-book\\"><\\/i> fa-book<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bookmark\\"><\\/i> fa-bookmark<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bookmark-o\\"><\\/i> fa-bookmark-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-briefcase\\"><\\/i> fa-briefcase<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bug\\"><\\/i> fa-bug<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-building-o\\"><\\/i> fa-building-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bullhorn\\"><\\/i> fa-bullhorn<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bullseye\\"><\\/i> fa-bullseye<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-calendar\\"><\\/i> fa-calendar<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-calendar-o\\"><\\/i> fa-calendar-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-camera\\"><\\/i> fa-camera<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-camera-retro\\"><\\/i> fa-camera-retro<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-down\\"><\\/i> fa-caret-square-o-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-left\\"><\\/i> fa-caret-square-o-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-right\\"><\\/i> fa-caret-square-o-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-up\\"><\\/i> fa-caret-square-o-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-certificate\\"><\\/i> fa-certificate<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-check\\"><\\/i> fa-check<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-check-circle\\"><\\/i> fa-check-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-check-circle-o\\"><\\/i> fa-check-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-check-square\\"><\\/i> fa-check-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-check-square-o\\"><\\/i> fa-check-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-circle\\"><\\/i> fa-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-circle-o\\"><\\/i> fa-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-clock-o\\"><\\/i> fa-clock-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cloud\\"><\\/i> fa-cloud<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cloud-download\\"><\\/i> fa-cloud-download<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cloud-upload\\"><\\/i> fa-cloud-upload<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-code\\"><\\/i> fa-code<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-code-fork\\"><\\/i> fa-code-fork<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-coffee\\"><\\/i> fa-coffee<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cog\\"><\\/i> fa-cog<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cogs\\"><\\/i> fa-cogs<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-comment\\"><\\/i> fa-comment<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-comment-o\\"><\\/i> fa-comment-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-comments\\"><\\/i> fa-comments<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-comments-o\\"><\\/i> fa-comments-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-compass\\"><\\/i> fa-compass<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-credit-card\\"><\\/i> fa-credit-card<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-crop\\"><\\/i> fa-crop<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-crosshairs\\"><\\/i> fa-crosshairs<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cutlery\\"><\\/i> fa-cutlery<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dashboard\\"><\\/i> fa-dashboard<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-desktop\\"><\\/i> fa-desktop<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dot-circle-o\\"><\\/i> fa-dot-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-download\\"><\\/i> fa-download<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-edit\\"><\\/i> fa-edit<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-ellipsis-h\\"><\\/i> fa-ellipsis-h<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-ellipsis-v\\"><\\/i> fa-ellipsis-v<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-envelope\\"><\\/i> fa-envelope<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-envelope-o\\"><\\/i> fa-envelope-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-eraser\\"><\\/i> fa-eraser<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-exchange\\"><\\/i> fa-exchange<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-exclamation\\"><\\/i> fa-exclamation<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-exclamation-circle\\"><\\/i> fa-exclamation-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-exclamation-triangle\\"><\\/i> fa-exclamation-triangle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-external-link\\"><\\/i> fa-external-link<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-external-link-square\\"><\\/i> fa-external-link-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-eye\\"><\\/i> fa-eye<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-eye-slash\\"><\\/i> fa-eye-slash<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-female\\"><\\/i> fa-female<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-fighter-jet\\"><\\/i> fa-fighter-jet<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-film\\"><\\/i> fa-film<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-filter\\"><\\/i> fa-filter<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-fire\\"><\\/i> fa-fire<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-fire-extinguisher\\"><\\/i> fa-fire-extinguisher<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-flag\\"><\\/i> fa-flag<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-flag-checkered\\"><\\/i> fa-flag-checkered<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-flag-o\\"><\\/i> fa-flag-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-flash\\"><\\/i> fa-flash<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-flask\\"><\\/i> fa-flask<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-folder\\"><\\/i> fa-folder<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-folder-o\\"><\\/i> fa-folder-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-folder-open\\"><\\/i> fa-folder-open<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-folder-open-o\\"><\\/i> fa-folder-open-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-frown-o\\"><\\/i> fa-frown-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-gamepad\\"><\\/i> fa-gamepad<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-gavel\\"><\\/i> fa-gavel<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-gear\\"><\\/i> fa-gear<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-gears\\"><\\/i> fa-gears<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-gift\\"><\\/i> fa-gift<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-glass\\"><\\/i> fa-glass<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-globe\\"><\\/i> fa-globe<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-group\\"><\\/i> fa-group<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-hdd-o\\"><\\/i> fa-hdd-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-headphones\\"><\\/i> fa-headphones<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-heart\\"><\\/i> fa-heart<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-heart-o\\"><\\/i> fa-heart-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-home\\"><\\/i> fa-home<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-inbox\\"><\\/i> fa-inbox<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-info\\"><\\/i> fa-info<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-info-circle\\"><\\/i> fa-info-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-key\\"><\\/i> fa-key<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-keyboard-o\\"><\\/i> fa-keyboard-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-laptop\\"><\\/i> fa-laptop<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-leaf\\"><\\/i> fa-leaf<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-legal\\"><\\/i> fa-legal<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-lemon-o\\"><\\/i> fa-lemon-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-level-down\\"><\\/i> fa-level-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-level-up\\"><\\/i> fa-level-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-lightbulb-o\\"><\\/i> fa-lightbulb-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-location-arrow\\"><\\/i> fa-location-arrow<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-lock\\"><\\/i> fa-lock<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-magic\\"><\\/i> fa-magic<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-magnet\\"><\\/i> fa-magnet<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-mail-forward\\"><\\/i> fa-mail-forward<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-mail-reply\\"><\\/i> fa-mail-reply<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-mail-reply-all\\"><\\/i> fa-mail-reply-all<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-male\\"><\\/i> fa-male<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-map-marker\\"><\\/i> fa-map-marker<\\/a><\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-meh-o\\"><\\/i> fa-meh-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-microphone\\"><\\/i> fa-microphone<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-microphone-slash\\"><\\/i> fa-microphone-slash<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-minus\\"><\\/i> fa-minus<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-minus-circle\\"><\\/i> fa-minus-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-minus-square\\"><\\/i> fa-minus-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-minus-square-o\\"><\\/i> fa-minus-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-mobile\\"><\\/i> fa-mobile<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-mobile-phone\\"><\\/i> fa-mobile-phone<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-money\\"><\\/i> fa-money<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-moon-o\\"><\\/i> fa-moon-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-music\\"><\\/i> fa-music<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pencil\\"><\\/i> fa-pencil<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pencil-square\\"><\\/i> fa-pencil-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pencil-square-o\\"><\\/i> fa-pencil-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-phone\\"><\\/i> fa-phone<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-phone-square\\"><\\/i> fa-phone-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-picture-o\\"><\\/i> fa-picture-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plane\\"><\\/i> fa-plane<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus\\"><\\/i> fa-plus<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus-circle\\"><\\/i> fa-plus-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus-square\\"><\\/i> fa-plus-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus-square-o\\"><\\/i> fa-plus-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-power-off\\"><\\/i> fa-power-off<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-print\\"><\\/i> fa-print<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-puzzle-piece\\"><\\/i> fa-puzzle-piece<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-qrcode\\"><\\/i> fa-qrcode<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-question\\"><\\/i> fa-question<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-question-circle\\"><\\/i> fa-question-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-quote-left\\"><\\/i> fa-quote-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-quote-right\\"><\\/i> fa-quote-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-random\\"><\\/i> fa-random<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-refresh\\"><\\/i> fa-refresh<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-reply\\"><\\/i> fa-reply<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-reply-all\\"><\\/i> fa-reply-all<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-retweet\\"><\\/i> fa-retweet<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-road\\"><\\/i> fa-road<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rocket\\"><\\/i> fa-rocket<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rss\\"><\\/i> fa-rss<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rss-square\\"><\\/i> fa-rss-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-search\\"><\\/i> fa-search<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-search-minus\\"><\\/i> fa-search-minus<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-search-plus\\"><\\/i> fa-search-plus<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-share\\"><\\/i> fa-share<\\/a><\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-share-square\\"><\\/i> fa-share-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-share-square-o\\"><\\/i> fa-share-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-shield\\"><\\/i> fa-shield<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-shopping-cart\\"><\\/i> fa-shopping-cart<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sign-in\\"><\\/i> fa-sign-in<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sign-out\\"><\\/i> fa-sign-out<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-signal\\"><\\/i> fa-signal<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sitemap\\"><\\/i> fa-sitemap<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-smile-o\\"><\\/i> fa-smile-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort\\"><\\/i> fa-sort<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-alpha-asc\\"><\\/i> fa-sort-alpha-asc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-alpha-desc\\"><\\/i> fa-sort-alpha-desc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-amount-asc\\"><\\/i> fa-sort-amount-asc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-amount-desc\\"><\\/i> fa-sort-amount-desc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-asc\\"><\\/i> fa-sort-asc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-desc\\"><\\/i> fa-sort-desc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-down\\"><\\/i> fa-sort-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-numeric-asc\\"><\\/i> fa-sort-numeric-asc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-numeric-desc\\"><\\/i> fa-sort-numeric-desc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-up\\"><\\/i> fa-sort-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-spinner\\"><\\/i> fa-spinner<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-square\\"><\\/i> fa-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-square-o\\"><\\/i> fa-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-star\\"><\\/i> fa-star<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-star-half\\"><\\/i> fa-star-half<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-star-half-empty\\"><\\/i> fa-star-half-empty<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-star-half-full\\"><\\/i> fa-star-half-full<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-star-half-o\\"><\\/i> fa-star-half-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-star-o\\"><\\/i> fa-star-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-subscript\\"><\\/i> fa-subscript<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-suitcase\\"><\\/i> fa-suitcase<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sun-o\\"><\\/i> fa-sun-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-superscript\\"><\\/i> fa-superscript<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tablet\\"><\\/i> fa-tablet<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tachometer\\"><\\/i> fa-tachometer<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tag\\"><\\/i> fa-tag<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tags\\"><\\/i> fa-tags<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tasks\\"><\\/i> fa-tasks<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-terminal\\"><\\/i> fa-terminal<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-thumb-tack\\"><\\/i> fa-thumb-tack<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-thumbs-down\\"><\\/i> fa-thumbs-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-thumbs-o-down\\"><\\/i> fa-thumbs-o-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-thumbs-o-up\\"><\\/i> fa-thumbs-o-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-thumbs-up\\"><\\/i> fa-thumbs-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-ticket\\"><\\/i> fa-ticket<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-times\\"><\\/i> fa-times<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-times-circle\\"><\\/i> fa-times-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-times-circle-o\\"><\\/i> fa-times-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tint\\"><\\/i> fa-tint<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-down\\"><\\/i> fa-toggle-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-left\\"><\\/i> fa-toggle-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-right\\"><\\/i> fa-toggle-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-up\\"><\\/i> fa-toggle-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-trash-o\\"><\\/i> fa-trash-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-trophy\\"><\\/i> fa-trophy<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-truck\\"><\\/i> fa-truck<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-umbrella\\"><\\/i> fa-umbrella<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-unlock\\"><\\/i> fa-unlock<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-unlock-alt\\"><\\/i> fa-unlock-alt<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-unsorted\\"><\\/i> fa-unsorted<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-upload\\"><\\/i> fa-upload<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-user\\"><\\/i> fa-user<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-users\\"><\\/i> fa-users<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-video-camera\\"><\\/i> fa-video-camera<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-volume-down\\"><\\/i> fa-volume-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-volume-off\\"><\\/i> fa-volume-off<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-volume-up\\"><\\/i> fa-volume-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-warning\\"><\\/i> fa-warning<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-wheelchair\\"><\\/i> fa-wheelchair<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-wrench\\"><\\/i> fa-wrench<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n\\r\\n<\\/section>\\r\\n<br>\\r\\n  <section id=\\"form-control\\">\\r\\n  \\r\\n      <div class=\\"page-header\\">\\r\\n    <h2 id=\\"headings\\">Form Control Icons<\\/h2>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-check-square\\"><\\/i> fa-check-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-check-square-o\\"><\\/i> fa-check-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-circle\\"><\\/i> fa-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-circle-o\\"><\\/i> fa-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dot-circle-o\\"><\\/i> fa-dot-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-minus-square\\"><\\/i> fa-minus-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-minus-square-o\\"><\\/i> fa-minus-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus-square\\"><\\/i> fa-plus-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus-square-o\\"><\\/i> fa-plus-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-square\\"><\\/i> fa-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-square-o\\"><\\/i> fa-square-o<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n<\\/section>\\r\\n<br>\\r\\n  <section id=\\"currency\\">\\r\\n  \\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Currency Icons<\\/h2>\\r\\n    <\\/div>\\r\\n  \\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bitcoin\\"><\\/i> fa-bitcoin<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-btc\\"><\\/i> fa-btc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cny\\"><\\/i> fa-cny<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dollar\\"><\\/i> fa-dollar<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-eur\\"><\\/i> fa-eur<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-euro\\"><\\/i> fa-euro<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-gbp\\"><\\/i> fa-gbp<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-inr\\"><\\/i> fa-inr<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-jpy\\"><\\/i> fa-jpy<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-krw\\"><\\/i> fa-krw<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-money\\"><\\/i> fa-money<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rmb\\"><\\/i> fa-rmb<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rouble\\"><\\/i> fa-rouble<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rub\\"><\\/i> fa-rub<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-ruble\\"><\\/i> fa-ruble<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rupee\\"><\\/i> fa-rupee<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-try\\"><\\/i> fa-try<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-turkish-lira\\"><\\/i> fa-turkish-lira<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-usd\\"><\\/i> fa-usd<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-won\\"><\\/i> fa-won<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-yen\\"><\\/i> fa-yen<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n\\r\\n<\\/section>\\r\\n<br>\\r\\n  <section id=\\"text-editor\\">\\r\\n      <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Text Editor Icons<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n  \\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-align-center\\"><\\/i> fa-align-center<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-align-justify\\"><\\/i> fa-align-justify<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-align-left\\"><\\/i> fa-align-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-align-right\\"><\\/i> fa-align-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bold\\"><\\/i> fa-bold<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chain\\"><\\/i> fa-chain<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chain-broken\\"><\\/i> fa-chain-broken<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-clipboard\\"><\\/i> fa-clipboard<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-columns\\"><\\/i> fa-columns<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-copy\\"><\\/i> fa-copy<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cut\\"><\\/i> fa-cut<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dedent\\"><\\/i> fa-dedent<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-eraser\\"><\\/i> fa-eraser<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-file\\"><\\/i> fa-file<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-file-o\\"><\\/i> fa-file-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-file-text\\"><\\/i> fa-file-text<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-file-text-o\\"><\\/i> fa-file-text-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-files-o\\"><\\/i> fa-files-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-floppy-o\\"><\\/i> fa-floppy-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-font\\"><\\/i> fa-font<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-indent\\"><\\/i> fa-indent<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-italic\\"><\\/i> fa-italic<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-link\\"><\\/i> fa-link<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-list\\"><\\/i> fa-list<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-list-alt\\"><\\/i> fa-list-alt<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-list-ol\\"><\\/i> fa-list-ol<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-list-ul\\"><\\/i> fa-list-ul<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-outdent\\"><\\/i> fa-outdent<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-paperclip\\"><\\/i> fa-paperclip<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-paste\\"><\\/i> fa-paste<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-repeat\\"><\\/i> fa-repeat<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rotate-left\\"><\\/i> fa-rotate-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rotate-right\\"><\\/i> fa-rotate-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-save\\"><\\/i> fa-save<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-scissors\\"><\\/i> fa-scissors<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-strikethrough\\"><\\/i> fa-strikethrough<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-table\\"><\\/i> fa-table<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-text-height\\"><\\/i> fa-text-height<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-text-width\\"><\\/i> fa-text-width<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-th\\"><\\/i> fa-th<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-th-large\\"><\\/i> fa-th-large<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-th-list\\"><\\/i> fa-th-list<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-underline\\"><\\/i> fa-underline<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-undo\\"><\\/i> fa-undo<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-unlink\\"><\\/i> fa-unlink<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n\\r\\n<\\/section>\\r\\n<br>\\r\\n  <section id=\\"directional\\">\\r\\n  \\r\\n        <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Directional Icons<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-double-down\\"><\\/i> fa-angle-double-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-double-left\\"><\\/i> fa-angle-double-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-double-right\\"><\\/i> fa-angle-double-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-double-up\\"><\\/i> fa-angle-double-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-down\\"><\\/i> fa-angle-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-left\\"><\\/i> fa-angle-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-right\\"><\\/i> fa-angle-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-up\\"><\\/i> fa-angle-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-down\\"><\\/i> fa-arrow-circle-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-left\\"><\\/i> fa-arrow-circle-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-o-down\\"><\\/i> fa-arrow-circle-o-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-o-left\\"><\\/i> fa-arrow-circle-o-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-o-right\\"><\\/i> fa-arrow-circle-o-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-o-up\\"><\\/i> fa-arrow-circle-o-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-right\\"><\\/i> fa-arrow-circle-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-up\\"><\\/i> fa-arrow-circle-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-down\\"><\\/i> fa-arrow-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-left\\"><\\/i> fa-arrow-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-right\\"><\\/i> fa-arrow-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-up\\"><\\/i> fa-arrow-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows\\"><\\/i> fa-arrows<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows-alt\\"><\\/i> fa-arrows-alt<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows-h\\"><\\/i> fa-arrows-h<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows-v\\"><\\/i> fa-arrows-v<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-down\\"><\\/i> fa-caret-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-left\\"><\\/i> fa-caret-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-right\\"><\\/i> fa-caret-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-down\\"><\\/i> fa-caret-square-o-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-left\\"><\\/i> fa-caret-square-o-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-right\\"><\\/i> fa-caret-square-o-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-up\\"><\\/i> fa-caret-square-o-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-up\\"><\\/i> fa-caret-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-circle-down\\"><\\/i> fa-chevron-circle-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-circle-left\\"><\\/i> fa-chevron-circle-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-circle-right\\"><\\/i> fa-chevron-circle-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-circle-up\\"><\\/i> fa-chevron-circle-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-down\\"><\\/i> fa-chevron-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-left\\"><\\/i> fa-chevron-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-right\\"><\\/i> fa-chevron-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-up\\"><\\/i> fa-chevron-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-hand-o-down\\"><\\/i> fa-hand-o-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-hand-o-left\\"><\\/i> fa-hand-o-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-hand-o-right\\"><\\/i> fa-hand-o-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-hand-o-up\\"><\\/i> fa-hand-o-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-long-arrow-down\\"><\\/i> fa-long-arrow-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-long-arrow-left\\"><\\/i> fa-long-arrow-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-long-arrow-right\\"><\\/i> fa-long-arrow-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-long-arrow-up\\"><\\/i> fa-long-arrow-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-down\\"><\\/i> fa-toggle-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-left\\"><\\/i> fa-toggle-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-right\\"><\\/i> fa-toggle-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-up\\"><\\/i> fa-toggle-up<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n\\r\\n<\\/section>\\r\\n\\r\\n<br>\\r\\n  <section id=\\"video-player\\">\\r\\n  \\r\\n          <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Video Player Icons<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows-alt\\"><\\/i> fa-arrows-alt<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-backward\\"><\\/i> fa-backward<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-compress\\"><\\/i> fa-compress<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-eject\\"><\\/i> fa-eject<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-expand\\"><\\/i> fa-expand<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-fast-backward\\"><\\/i> fa-fast-backward<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-fast-forward\\"><\\/i> fa-fast-forward<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-forward\\"><\\/i> fa-forward<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pause\\"><\\/i> fa-pause<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-play\\"><\\/i> fa-play<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-play-circle\\"><\\/i> fa-play-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-play-circle-o\\"><\\/i> fa-play-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-step-backward\\"><\\/i> fa-step-backward<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-step-forward\\"><\\/i> fa-step-forward<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-stop\\"><\\/i> fa-stop<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-youtube-play\\"><\\/i> fa-youtube-play<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n\\r\\n<\\/section>\\r\\n<br>\\r\\n  <section id=\\"brand\\">\\r\\n  \\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Brand Icons<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n\\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-adn\\"><\\/i> fa-adn<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-android\\"><\\/i> fa-android<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-apple\\"><\\/i> fa-apple<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bitbucket\\"><\\/i> fa-bitbucket<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bitbucket-square\\"><\\/i> fa-bitbucket-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bitcoin\\"><\\/i> fa-bitcoin<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-btc\\"><\\/i> fa-btc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-css3\\"><\\/i> fa-css3<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dribbble\\"><\\/i> fa-dribbble<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dropbox\\"><\\/i> fa-dropbox<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-facebook\\"><\\/i> fa-facebook<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-facebook-square\\"><\\/i> fa-facebook-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-flickr\\"><\\/i> fa-flickr<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-foursquare\\"><\\/i> fa-foursquare<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-github\\"><\\/i> fa-github<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-github-alt\\"><\\/i> fa-github-alt<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-github-square\\"><\\/i> fa-github-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-gittip\\"><\\/i> fa-gittip<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-google-plus\\"><\\/i> fa-google-plus<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-google-plus-square\\"><\\/i> fa-google-plus-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-html5\\"><\\/i> fa-html5<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-instagram\\"><\\/i> fa-instagram<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-linkedin\\"><\\/i> fa-linkedin<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-linkedin-square\\"><\\/i> fa-linkedin-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-linux\\"><\\/i> fa-linux<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-maxcdn\\"><\\/i> fa-maxcdn<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pagelines\\"><\\/i> fa-pagelines<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pinterest\\"><\\/i> fa-pinterest<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pinterest-square\\"><\\/i> fa-pinterest-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-renren\\"><\\/i> fa-renren<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-skype\\"><\\/i> fa-skype<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-stack-exchange\\"><\\/i> fa-stack-exchange<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-stack-overflow\\"><\\/i> fa-stack-overflow<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-trello\\"><\\/i> fa-trello<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tumblr\\"><\\/i> fa-tumblr<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tumblr-square\\"><\\/i> fa-tumblr-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-twitter\\"><\\/i> fa-twitter<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-twitter-square\\"><\\/i> fa-twitter-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-vimeo-square\\"><\\/i> fa-vimeo-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-vk\\"><\\/i> fa-vk<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-weibo\\"><\\/i> fa-weibo<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-windows\\"><\\/i> fa-windows<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-xing\\"><\\/i> fa-xing<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-xing-square\\"><\\/i> fa-xing-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-youtube\\"><\\/i> fa-youtube<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-youtube-play\\"><\\/i> fa-youtube-play<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-youtube-square\\"><\\/i> fa-youtube-square<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n<\\/section>\\r\\n<br>\\r\\n  <section id=\\"medical\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Medical Icons<\\/h2>\\r\\n    <\\/div>\\r\\n  \\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-ambulance\\"><\\/i> fa-ambulance<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-h-square\\"><\\/i> fa-h-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-hospital-o\\"><\\/i> fa-hospital-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-medkit\\"><\\/i> fa-medkit<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus-square\\"><\\/i> fa-plus-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-stethoscope\\"><\\/i> fa-stethoscope<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-user-md\\"><\\/i> fa-user-md<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-wheelchair\\"><\\/i> fa-wheelchair<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n\\r\\n<\\/section>\\r\\n\\r\\n<\\/div>","fulltext":"","state":1,"catid":"2","created":"2014-07-28 13:24:18","created_by":"444","created_by_alias":"","modified":"","modified_by":null,"checked_out":null,"checked_out_time":null,"publish_up":"2014-07-28 13:24:18","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":1,"ordering":null,"metakey":"","metadesc":"","access":"1","hits":null,"metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0);
INSERT INTO `#__ucm_history` (`version_id`, `ucm_item_id`, `ucm_type_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(14, 12, 6, '', '2014-07-28 13:25:19', 400, 756, '94a8afa45791aa913cabcf278b102f4bfbfab537', '{"id":12,"asset_id":75,"parent_id":"1","lft":"21","rgt":22,"level":1,"path":null,"extension":"com_content","title":"Explore","alias":"explore","note":"","description":"<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<\\/p>","published":"1","checked_out":null,"checked_out_time":null,"access":"1","params":"{\\"category_layout\\":\\"\\",\\"image\\":\\"\\"}","metadesc":"","metakey":"","metadata":"{\\"author\\":\\"\\",\\"robots\\":\\"\\"}","created_user_id":"444","created_time":"2014-07-28 13:25:19","modified_user_id":null,"modified_time":null,"hits":"0","language":"*","version":null}', 0),
(15, 13, 6, '', '2014-07-28 13:25:40', 400, 773, '056cc83d1589825c9671024c3d58224789833d2a', '{"id":13,"asset_id":76,"parent_id":"12","lft":"22","rgt":23,"level":2,"path":null,"extension":"com_content","title":"Template themes","alias":"template-themes","note":"","description":"<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.<\\/p>","published":"1","checked_out":null,"checked_out_time":null,"access":"1","params":"{\\"category_layout\\":\\"\\",\\"image\\":\\"\\"}","metadesc":"","metakey":"","metadata":"{\\"author\\":\\"\\",\\"robots\\":\\"\\"}","created_user_id":"444","created_time":"2014-07-28 13:25:40","modified_user_id":null,"modified_time":null,"hits":"0","language":"*","version":null}', 0);
INSERT INTO `#__ucm_history` (`version_id`, `ucm_item_id`, `ucm_type_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(16, 8, 1, '', '2014-07-28 13:26:40', 400, 81731, '1e77db009dfe83036703f2cccd255f6e07eff7a3', '{"id":8,"asset_id":"73","title":"Typography","alias":"typography","introtext":"     <div class=\\"page-header col-xs-12\\">\\r\\n        <h2 id=\\"headings\\">ALERTS<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n  <div class=\\"col-xs-12 col-sm-6\\">  \\r\\n        <div class=\\"alert alert-success\\">\\r\\n            <strong>Success!<\\/strong> You successfully read this important alert message.\\r\\n            <button class=\\"close\\" type=\\"button\\" data-dismiss=\\"alert\\">\\u00d7<\\/button>\\r\\n        <\\/div>\\r\\n        \\r\\n        <div class=\\"alert alert-info\\">\\r\\n            <strong>Info!<\\/strong> This alert needs your attention, but it''s not super important.\\r\\n            <button class=\\"close\\" type=\\"button\\" data-dismiss=\\"alert\\">\\u00d7<\\/button>\\r\\n        <\\/div>\\r\\n  <\\/div>\\r\\n    \\r\\n  <div class=\\"col-xs-12 col-sm-6\\"> \\r\\n        <div class=\\"alert alert-warning\\">\\r\\n            <strong>Warning!<\\/strong> Best check yo self, you''re not looking too good.\\r\\n            <button class=\\"close\\" type=\\"button\\" data-dismiss=\\"alert\\">\\u00d7<\\/button>\\r\\n        <\\/div>\\r\\n        \\r\\n        <div class=\\"alert alert-error fade in\\">\\r\\n            <button class=\\"close\\" type=\\"button\\" data-dismiss=\\"alert\\">\\u00d7<\\/button>\\r\\n            <strong>Error!<\\/strong> Empty password not allowed\\r\\n        <\\/div>\\r\\n  <\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-sm-12\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">HEADINGS<\\/h2>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"bs-example bs-example-type\\">\\r\\n          <table class=\\"table\\">\\r\\n            <tbody>\\r\\n              <tr>\\r\\n                <td><h1>h1. Heading <small>Secondary text<\\/small><\\/h1><\\/td>\\r\\n              <\\/tr>\\r\\n              <tr>\\r\\n                <td><h2>h2. Heading <small>Secondary text<\\/small><\\/h2><\\/td>\\r\\n              <\\/tr>\\r\\n              <tr>\\r\\n                <td><h3>h3. Heading <small>Secondary text<\\/small><\\/h3><\\/td>\\r\\n              <\\/tr>\\r\\n              <tr>\\r\\n                <td><h4>h4. Heading <small>Secondary text<\\/small><\\/h4><\\/td>\\r\\n              <\\/tr>\\r\\n              <tr>\\r\\n                <td><h5>h5. Heading <small>Secondary text<\\/small><\\/h5><\\/td>\\r\\n              <\\/tr>\\r\\n              <tr>\\r\\n                <td><h6>h6. Heading <small>Secondary text<\\/small><\\/h6><\\/td>\\r\\n              <\\/tr>\\r\\n            <\\/tbody>\\r\\n          <\\/table>\\r\\n    <\\/div>\\r\\n<div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;h1&gt;<\\/span>h1. Bootstrap heading <span class=\\"nt\\">&lt;small&gt;<\\/span>Secondary text<span class=\\"nt\\">&lt;\\/small&gt;&lt;\\/h1&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;h2&gt;<\\/span>h2. heading <span class=\\"nt\\">&lt;small&gt;<\\/span>Secondary text<span class=\\"nt\\">&lt;\\/small&gt;&lt;\\/h2&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;h3&gt;<\\/span>h3. heading <span class=\\"nt\\">&lt;small&gt;<\\/span>Secondary text<span class=\\"nt\\">&lt;\\/small&gt;&lt;\\/h3&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;h4&gt;<\\/span>h4. heading <span class=\\"nt\\">&lt;small&gt;<\\/span>Secondary text<span class=\\"nt\\">&lt;\\/small&gt;&lt;\\/h4&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;h5&gt;<\\/span>h5. heading <span class=\\"nt\\">&lt;small&gt;<\\/span>Secondary text<span class=\\"nt\\">&lt;\\/small&gt;&lt;\\/h5&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;h6&gt;<\\/span>h6. heading <span class=\\"nt\\">&lt;small&gt;<\\/span>Secondary text<span class=\\"nt\\">&lt;\\/small&gt;&lt;\\/h6&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Body Text<\\/h2>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"bs-example\\">\\r\\n        <p>Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nullam id dolor id nibh ultricies vehicula.<\\/p>\\r\\n    <\\/div>\\r\\n    \\r\\n<div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;p&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Lead Body Text<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n    <div class=\\"bs-example\\">\\r\\n          <p class=\\"lead\\">Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Duis mollis, est non commodo luctus.<\\/p>\\r\\n    <\\/div>\\r\\n<div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;p<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"lead\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Abbreviations<\\/h2>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"bs-example\\">\\r\\n      <p>An abbreviation of the word attribute is <abbr title=\\"attribute\\">attr<\\/abbr>.<\\/p>\\r\\n    <\\/div>\\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;abbr<\\/span> <span class=\\"na\\">title=<\\/span><span class=\\"s\\">\\"attribute\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>attr<span class=\\"nt\\">&lt;\\/abbr&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Initialism<\\/h2>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"bs-example\\">\\r\\n      <p><abbr title=\\"HyperText Markup Language\\" class=\\"initialism\\">HTML<\\/abbr> is the best thing since sliced bread.<\\/p>\\r\\n    <\\/div>\\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;abbr<\\/span> <span class=\\"na\\">title=<\\/span><span class=\\"s\\">\\"HyperText Markup Language\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"initialism\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>HTML<span class=\\"nt\\">&lt;\\/abbr&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Labels<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n        <div class=\\"bs-example\\">\\r\\n          <span class=\\"label label-default\\">Default<\\/span>\\r\\n          <span class=\\"label label-primary\\">Primary<\\/span>\\r\\n          <span class=\\"label label-success\\">Success<\\/span>\\r\\n          <span class=\\"label label-info\\">Info<\\/span>\\r\\n          <span class=\\"label label-warning\\">Warning<\\/span>\\r\\n          <span class=\\"label label-danger\\">Danger<\\/span>\\r\\n        <\\/div>\\r\\n        \\r\\n        <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;span<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"label label-default\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Default<span class=\\"nt\\">&lt;\\/span&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;span<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"label label-primary\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Primary<span class=\\"nt\\">&lt;\\/span&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;span<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"label label-success\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Success<span class=\\"nt\\">&lt;\\/span&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;span<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"label label-info\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Info<span class=\\"nt\\">&lt;\\/span&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;span<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"label label-warning\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Warning<span class=\\"nt\\">&lt;\\/span&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;span<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"label label-danger\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Danger<span class=\\"nt\\">&lt;\\/span&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Badges<\\/h2>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"bs-example\\">\\r\\n      <a href=\\"#\\">Inbox <span class=\\"badge\\">42<\\/span><\\/a>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;a<\\/span> <span class=\\"na\\">href=<\\/span><span class=\\"s\\">\\"#\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Inbox <span class=\\"nt\\">&lt;span<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"badge\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>42<span class=\\"nt\\">&lt;\\/span&gt;&lt;\\/a&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n\\r\\n\\r\\n<div class=\\"page-header col-xs-12\\">\\r\\n    <h2 id=\\"headings\\">BLOCKQUOTES<\\/h2>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Default blockquote<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <blockquote>\\r\\n        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.<\\/p>\\r\\n      <\\/blockquote>\\r\\n    <\\/div> \\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;blockquote&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;p&gt;<\\/span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/blockquote&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>   \\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Blockquote options<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <blockquote>\\r\\n        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.<\\/p>\\r\\n        <small>Someone famous in <cite title=\\"Source Title\\">Source Title<\\/cite><\\/small>\\r\\n      <\\/blockquote>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;blockquote&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;p&gt;<\\/span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;small&gt;<\\/span>Someone famous in <span class=\\"nt\\">&lt;cite<\\/span> <span class=\\"na\\">title=<\\/span><span class=\\"s\\">\\"Source Title\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Source Title<span class=\\"nt\\">&lt;\\/cite&gt;&lt;\\/small&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/blockquote&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>    \\r\\n    \\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"col-xs-12\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Alternate blockquote display<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\" style=\\"overflow: hidden;\\">\\r\\n      <blockquote class=\\"pull-right\\">\\r\\n        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.<\\/p>\\r\\n        <small>Someone famous in <cite title=\\"Source Title\\">Source Title<\\/cite><\\/small>\\r\\n      <\\/blockquote>\\r\\n    <\\/div> \\r\\n    \\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;blockquote<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"pull-right\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>\\r\\n  ...\\r\\n<span class=\\"nt\\">&lt;\\/blockquote&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>   \\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"page-header col-xs-12\\">\\r\\n    <h2 id=\\"headings\\">LISTS<\\/h2>\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Unordered<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <ul>\\r\\n        <li>Lorem ipsum dolor sit amet<\\/li>\\r\\n        <li>Consectetur adipiscing elit<\\/li>\\r\\n        <li>Nulla volutpat aliquam velit\\r\\n          <ul>\\r\\n            <li>Phasellus iaculis neque<\\/li>\\r\\n            <li>Purus sodales ultricies<\\/li>\\r\\n            <li>Vestibulum laoreet porttitor sem<\\/li>\\r\\n            <li>Ac tristique libero volutpat at<\\/li>\\r\\n          <\\/ul>\\r\\n        <\\/li>\\r\\n        <li>Faucibus porta lacus fringilla vel<\\/li>\\r\\n      <\\/ul>\\r\\n    <\\/div>\\r\\n<div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;ul&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;li&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/li&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/ul&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>    \\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Ordered<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <ol>\\r\\n        <li>Lorem ipsum dolor sit amet<\\/li>\\r\\n        <li>Consectetur adipiscing elit<\\/li>\\r\\n        <li>Integer molestie lorem at massa<\\/li>\\r\\n        <li>Facilisis in pretium nisl aliquet<\\/li>\\r\\n        <li>Nulla volutpat aliquam velit<\\/li>\\r\\n        <li>Faucibus porta lacus fringilla vel<\\/li>\\r\\n        <li>Aenean sit amet erat nunc<\\/li>\\r\\n        <li>Eget porttitor lorem<\\/li>\\r\\n      <\\/ol>\\r\\n    <\\/div>\\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;ol&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;li&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/li&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/ol&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n    \\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Unstyled<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <ul class=\\"list-unstyled\\">\\r\\n        <li>Lorem ipsum dolor sit amet<\\/li>          \\r\\n        <li>Nulla volutpat aliquam velit\\r\\n          <ul>\\r\\n            <li>Phasellus iaculis neque<\\/li>\\r\\n            <li>Purus sodales ultricies<\\/li>\\r\\n            <li>Vestibulum laoreet porttitor sem<\\/li>\\r\\n            <li>Ac tristique libero volutpat at<\\/li>\\r\\n          <\\/ul>\\r\\n        <\\/li>\\r\\n        <li>Faucibus porta lacus fringilla vel<\\/li>\\r\\n      <\\/ul>\\r\\n    <\\/div>\\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;ul<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"list-unstyled\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;li&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/li&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/ul&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n    \\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Inline<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <ul class=\\"list-inline\\">\\r\\n        <li>Lorem ipsum<\\/li>\\r\\n        <li>Phasellus iaculis<\\/li>\\r\\n        <li>Nulla volutpat<\\/li>\\r\\n      <\\/ul>\\r\\n    <\\/div>\\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;ul<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"list-inline\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;li&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/li&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/ul&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n    \\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Description<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <dl>\\r\\n        <dt>Description lists<\\/dt>\\r\\n        <dd>A description list is perfect for defining terms.<\\/dd>\\r\\n        <dt>Euismod<\\/dt>\\r\\n        <dd>Vestibulum id ligula porta felis euismod semper eget lacinia odio sem nec elit.<\\/dd>\\r\\n        <dd>Donec id elit non mi porta gravida at eget metus.<\\/dd>\\r\\n        <dt>Malesuada porta<\\/dt>\\r\\n        <dd>Etiam porta sem malesuada magna mollis euismod.<\\/dd>\\r\\n      <\\/dl>\\r\\n    <\\/div>\\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;dl&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;dt&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/dt&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;dd&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/dd&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/dl&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n    \\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12 col-md-6\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Horizontal description<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <dl class=\\"dl-horizontal\\">\\r\\n        <dt>Description lists<\\/dt>\\r\\n        <dd>A description list is perfect for defining terms.<\\/dd>\\r\\n        <dt>Euismod<\\/dt>\\r\\n        <dd>Vestibulum id ligula porta felis euismod semper eget lacinia odio sem nec elit.<\\/dd>\\r\\n        <dt>Malesuada porta<\\/dt>\\r\\n        <dd>Etiam porta sem malesuada magna mollis euismod.<\\/dd>\\r\\n        <dt>Felis euismod semper eget lacinia<\\/dt>\\r\\n        <dd>Fusce dapibus, tellus ac cursus commodo, tortor mauris condimentum nibh, ut fermentum massa justo sit amet risus.<\\/dd>\\r\\n      <\\/dl>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;dl<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"dl-horizontal\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;dt&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/dt&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;dd&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/dd&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/dl&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n    \\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">BUTTONS<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <button type=\\"button\\" class=\\"btn btn-default\\">Default<\\/button>\\r\\n      <button type=\\"button\\" class=\\"btn btn-primary\\">Primary<\\/button>\\r\\n      <button type=\\"button\\" class=\\"btn btn-success\\">Success<\\/button>\\r\\n      <button type=\\"button\\" class=\\"btn btn-info\\">Info<\\/button>\\r\\n      <button type=\\"button\\" class=\\"btn btn-warning\\">Warning<\\/button>\\r\\n      <button type=\\"button\\" class=\\"btn btn-danger\\">Danger<\\/button>\\r\\n      <button type=\\"button\\" class=\\"btn btn-link\\">Link<\\/button>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"c\\">&lt;!-- Standard button --&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-default\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Default<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n\\r\\n<span class=\\"c\\">&lt;!-- Provides extra visual weight and identifies the primary action in a set of buttons --&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-primary\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Primary<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n\\r\\n<span class=\\"c\\">&lt;!-- Indicates a successful or positive action --&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-success\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Success<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n\\r\\n<span class=\\"c\\">&lt;!-- Contextual button for informational alert messages --&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-info\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Info<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n\\r\\n<span class=\\"c\\">&lt;!-- Indicates caution should be taken with this action --&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-warning\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Warning<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n\\r\\n<span class=\\"c\\">&lt;!-- Indicates a dangerous or potentially negative action --&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-danger\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Danger<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n\\r\\n<span class=\\"c\\">&lt;!-- Deemphasize a button by making it look like a link while maintaining button behavior --&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-link\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Link<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>\\r\\n\\r\\n<\\/div>\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Sizes<\\/h2>\\r\\n    <\\/div>\\r\\n    <div class=\\"bs-example\\">\\r\\n      <p>\\r\\n        <button type=\\"button\\" class=\\"btn btn-primary btn-lg\\">Large button<\\/button>\\r\\n        <button type=\\"button\\" class=\\"btn btn-default btn-lg\\">Large button<\\/button>\\r\\n      <\\/p>\\r\\n      <p>\\r\\n        <button type=\\"button\\" class=\\"btn btn-primary\\">Default button<\\/button>\\r\\n        <button type=\\"button\\" class=\\"btn btn-default\\">Default button<\\/button>\\r\\n      <\\/p>\\r\\n      <p>\\r\\n        <button type=\\"button\\" class=\\"btn btn-primary btn-sm\\">Small button<\\/button>\\r\\n        <button type=\\"button\\" class=\\"btn btn-default btn-sm\\">Small button<\\/button>\\r\\n      <\\/p>\\r\\n      <p>\\r\\n        <button type=\\"button\\" class=\\"btn btn-primary btn-xs\\">Extra small button<\\/button>\\r\\n        <button type=\\"button\\" class=\\"btn btn-default btn-xs\\">Extra small button<\\/button>\\r\\n      <\\/p>\\r\\n    <\\/div>    \\r\\n<div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;p&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-primary btn-lg\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Large button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-default btn-lg\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Large button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;p&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-primary\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Default button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-default\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Default button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;p&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-primary btn-sm\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Small button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-default btn-sm\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Small button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;p&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-primary btn-xs\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Extra small button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;button<\\/span> <span class=\\"na\\">type=<\\/span><span class=\\"s\\">\\"button\\"<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-default btn-xs\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Extra small button<span class=\\"nt\\">&lt;\\/button&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div>    \\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n<div class=\\"col-xs-12\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">JUMBOTRON<\\/h2>\\r\\n    <\\/div>\\r\\n    \\r\\n    <div class=\\"bs-example\\">\\r\\n      <div class=\\"jumbotron\\">\\r\\n        <h1>Hello, world!<\\/h1>\\r\\n        <p>This is a simple hero unit, a simple jumbotron-style component for calling extra attention to featured content or information.<\\/p>\\r\\n        <p><a class=\\"btn btn-primary btn-lg\\" role=\\"button\\">Learn more<\\/a><\\/p>\\r\\n      <\\/div>\\r\\n    <\\/div>   \\r\\n    \\r\\n    <div class=\\"highlight\\"><pre><code class=\\"html\\"><span class=\\"nt\\">&lt;div<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"jumbotron\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;h1&gt;<\\/span>Hello, world!<span class=\\"nt\\">&lt;\\/h1&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;p&gt;<\\/span>...<span class=\\"nt\\">&lt;\\/p&gt;<\\/span>\\r\\n  <span class=\\"nt\\">&lt;p&gt;&lt;a<\\/span> <span class=\\"na\\">class=<\\/span><span class=\\"s\\">\\"btn btn-primary btn-lg\\"<\\/span> <span class=\\"na\\">role=<\\/span><span class=\\"s\\">\\"button\\"<\\/span><span class=\\"nt\\">&gt;<\\/span>Learn more<span class=\\"nt\\">&lt;\\/a&gt;&lt;\\/p&gt;<\\/span>\\r\\n<span class=\\"nt\\">&lt;\\/div&gt;<\\/span>\\r\\n<\\/code><\\/pre><\\/div> \\r\\n    \\r\\n    \\r\\n<\\/div>\\r\\n\\r\\n\\r\\n\\r\\n\\r\\n  <div class=\\"page-header col-xs-12\\">\\r\\n    <h2 id=\\"headings\\">ICONS<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n\\r\\n<div class=\\"col-xs-12\\">\\r\\n\\r\\n\\r\\n  <div id=\\"new\\">\\r\\n  \\r\\n  <div class=\\"page-header\\">\\r\\n    <h2 id=\\"headings\\">New Icons<\\/h2>\\r\\n<\\/div>\\r\\n\\r\\n  \\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rub\\"><\\/i> fa-rub<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-ruble\\"><\\/i> fa-ruble<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rouble\\"><\\/i> fa-rouble<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pagelines\\"><\\/i> fa-pagelines<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-stack-exchange\\"><\\/i> fa-stack-exchange<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-o-right\\"><\\/i> fa-arrow-circle-o-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-o-left\\"><\\/i> fa-arrow-circle-o-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-left\\"><\\/i> fa-caret-square-o-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-left\\"><\\/i> fa-toggle-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dot-circle-o\\"><\\/i> fa-dot-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-wheelchair\\"><\\/i> fa-wheelchair<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-vimeo-square\\"><\\/i> fa-vimeo-square><\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-try\\"><\\/i> fa-try<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-turkish-lira\\"><\\/i> fa-turkish-lira<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus-square-o\\"><\\/i> fa-plus-square-o<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n\\r\\n<\\/div>\\r\\n<br>\\r\\n  <section id=\\"web-application\\">\\r\\n  \\r\\n    <div class=\\"page-header\\">\\r\\n    <h2 id=\\"headings\\">Web Application Icons<\\/h2>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-adjust\\"><\\/i> fa-adjust<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-anchor\\"><\\/i> fa-anchor<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-archive\\"><\\/i> fa-archive<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows\\"><\\/i> fa-arrows<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows-h\\"><\\/i> fa-arrows-h<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows-v\\"><\\/i> fa-arrows-v<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-asterisk\\"><\\/i> fa-asterisk<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-ban\\"><\\/i> fa-ban<\\/a><\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bar-chart-o\\"><\\/i> fa-bar-chart-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-barcode\\"><\\/i> fa-barcode<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bars\\"><\\/i> fa-bars<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-beer\\"><\\/i> fa-beer<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bell\\"><\\/i> fa-bell<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bell-o\\"><\\/i> fa-bell-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bolt\\"><\\/i> fa-bolt<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-book\\"><\\/i> fa-book<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bookmark\\"><\\/i> fa-bookmark<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bookmark-o\\"><\\/i> fa-bookmark-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-briefcase\\"><\\/i> fa-briefcase<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bug\\"><\\/i> fa-bug<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-building-o\\"><\\/i> fa-building-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bullhorn\\"><\\/i> fa-bullhorn<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bullseye\\"><\\/i> fa-bullseye<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-calendar\\"><\\/i> fa-calendar<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-calendar-o\\"><\\/i> fa-calendar-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-camera\\"><\\/i> fa-camera<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-camera-retro\\"><\\/i> fa-camera-retro<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-down\\"><\\/i> fa-caret-square-o-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-left\\"><\\/i> fa-caret-square-o-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-right\\"><\\/i> fa-caret-square-o-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-up\\"><\\/i> fa-caret-square-o-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-certificate\\"><\\/i> fa-certificate<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-check\\"><\\/i> fa-check<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-check-circle\\"><\\/i> fa-check-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-check-circle-o\\"><\\/i> fa-check-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-check-square\\"><\\/i> fa-check-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-check-square-o\\"><\\/i> fa-check-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-circle\\"><\\/i> fa-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-circle-o\\"><\\/i> fa-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-clock-o\\"><\\/i> fa-clock-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cloud\\"><\\/i> fa-cloud<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cloud-download\\"><\\/i> fa-cloud-download<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cloud-upload\\"><\\/i> fa-cloud-upload<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-code\\"><\\/i> fa-code<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-code-fork\\"><\\/i> fa-code-fork<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-coffee\\"><\\/i> fa-coffee<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cog\\"><\\/i> fa-cog<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cogs\\"><\\/i> fa-cogs<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-comment\\"><\\/i> fa-comment<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-comment-o\\"><\\/i> fa-comment-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-comments\\"><\\/i> fa-comments<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-comments-o\\"><\\/i> fa-comments-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-compass\\"><\\/i> fa-compass<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-credit-card\\"><\\/i> fa-credit-card<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-crop\\"><\\/i> fa-crop<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-crosshairs\\"><\\/i> fa-crosshairs<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cutlery\\"><\\/i> fa-cutlery<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dashboard\\"><\\/i> fa-dashboard<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-desktop\\"><\\/i> fa-desktop<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dot-circle-o\\"><\\/i> fa-dot-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-download\\"><\\/i> fa-download<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-edit\\"><\\/i> fa-edit<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-ellipsis-h\\"><\\/i> fa-ellipsis-h<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-ellipsis-v\\"><\\/i> fa-ellipsis-v<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-envelope\\"><\\/i> fa-envelope<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-envelope-o\\"><\\/i> fa-envelope-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-eraser\\"><\\/i> fa-eraser<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-exchange\\"><\\/i> fa-exchange<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-exclamation\\"><\\/i> fa-exclamation<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-exclamation-circle\\"><\\/i> fa-exclamation-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-exclamation-triangle\\"><\\/i> fa-exclamation-triangle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-external-link\\"><\\/i> fa-external-link<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-external-link-square\\"><\\/i> fa-external-link-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-eye\\"><\\/i> fa-eye<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-eye-slash\\"><\\/i> fa-eye-slash<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-female\\"><\\/i> fa-female<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-fighter-jet\\"><\\/i> fa-fighter-jet<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-film\\"><\\/i> fa-film<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-filter\\"><\\/i> fa-filter<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-fire\\"><\\/i> fa-fire<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-fire-extinguisher\\"><\\/i> fa-fire-extinguisher<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-flag\\"><\\/i> fa-flag<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-flag-checkered\\"><\\/i> fa-flag-checkered<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-flag-o\\"><\\/i> fa-flag-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-flash\\"><\\/i> fa-flash<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-flask\\"><\\/i> fa-flask<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-folder\\"><\\/i> fa-folder<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-folder-o\\"><\\/i> fa-folder-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-folder-open\\"><\\/i> fa-folder-open<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-folder-open-o\\"><\\/i> fa-folder-open-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-frown-o\\"><\\/i> fa-frown-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-gamepad\\"><\\/i> fa-gamepad<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-gavel\\"><\\/i> fa-gavel<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-gear\\"><\\/i> fa-gear<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-gears\\"><\\/i> fa-gears<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-gift\\"><\\/i> fa-gift<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-glass\\"><\\/i> fa-glass<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-globe\\"><\\/i> fa-globe<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-group\\"><\\/i> fa-group<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-hdd-o\\"><\\/i> fa-hdd-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-headphones\\"><\\/i> fa-headphones<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-heart\\"><\\/i> fa-heart<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-heart-o\\"><\\/i> fa-heart-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-home\\"><\\/i> fa-home<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-inbox\\"><\\/i> fa-inbox<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-info\\"><\\/i> fa-info<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-info-circle\\"><\\/i> fa-info-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-key\\"><\\/i> fa-key<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-keyboard-o\\"><\\/i> fa-keyboard-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-laptop\\"><\\/i> fa-laptop<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-leaf\\"><\\/i> fa-leaf<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-legal\\"><\\/i> fa-legal<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-lemon-o\\"><\\/i> fa-lemon-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-level-down\\"><\\/i> fa-level-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-level-up\\"><\\/i> fa-level-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-lightbulb-o\\"><\\/i> fa-lightbulb-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-location-arrow\\"><\\/i> fa-location-arrow<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-lock\\"><\\/i> fa-lock<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-magic\\"><\\/i> fa-magic<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-magnet\\"><\\/i> fa-magnet<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-mail-forward\\"><\\/i> fa-mail-forward<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-mail-reply\\"><\\/i> fa-mail-reply<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-mail-reply-all\\"><\\/i> fa-mail-reply-all<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-male\\"><\\/i> fa-male<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-map-marker\\"><\\/i> fa-map-marker<\\/a><\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-meh-o\\"><\\/i> fa-meh-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-microphone\\"><\\/i> fa-microphone<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-microphone-slash\\"><\\/i> fa-microphone-slash<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-minus\\"><\\/i> fa-minus<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-minus-circle\\"><\\/i> fa-minus-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-minus-square\\"><\\/i> fa-minus-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-minus-square-o\\"><\\/i> fa-minus-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-mobile\\"><\\/i> fa-mobile<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-mobile-phone\\"><\\/i> fa-mobile-phone<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-money\\"><\\/i> fa-money<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-moon-o\\"><\\/i> fa-moon-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-music\\"><\\/i> fa-music<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pencil\\"><\\/i> fa-pencil<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pencil-square\\"><\\/i> fa-pencil-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pencil-square-o\\"><\\/i> fa-pencil-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-phone\\"><\\/i> fa-phone<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-phone-square\\"><\\/i> fa-phone-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-picture-o\\"><\\/i> fa-picture-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plane\\"><\\/i> fa-plane<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus\\"><\\/i> fa-plus<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus-circle\\"><\\/i> fa-plus-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus-square\\"><\\/i> fa-plus-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus-square-o\\"><\\/i> fa-plus-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-power-off\\"><\\/i> fa-power-off<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-print\\"><\\/i> fa-print<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-puzzle-piece\\"><\\/i> fa-puzzle-piece<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-qrcode\\"><\\/i> fa-qrcode<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-question\\"><\\/i> fa-question<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-question-circle\\"><\\/i> fa-question-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-quote-left\\"><\\/i> fa-quote-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-quote-right\\"><\\/i> fa-quote-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-random\\"><\\/i> fa-random<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-refresh\\"><\\/i> fa-refresh<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-reply\\"><\\/i> fa-reply<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-reply-all\\"><\\/i> fa-reply-all<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-retweet\\"><\\/i> fa-retweet<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-road\\"><\\/i> fa-road<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rocket\\"><\\/i> fa-rocket<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rss\\"><\\/i> fa-rss<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rss-square\\"><\\/i> fa-rss-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-search\\"><\\/i> fa-search<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-search-minus\\"><\\/i> fa-search-minus<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-search-plus\\"><\\/i> fa-search-plus<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-share\\"><\\/i> fa-share<\\/a><\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-share-square\\"><\\/i> fa-share-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-share-square-o\\"><\\/i> fa-share-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-shield\\"><\\/i> fa-shield<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-shopping-cart\\"><\\/i> fa-shopping-cart<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sign-in\\"><\\/i> fa-sign-in<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sign-out\\"><\\/i> fa-sign-out<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-signal\\"><\\/i> fa-signal<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sitemap\\"><\\/i> fa-sitemap<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-smile-o\\"><\\/i> fa-smile-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort\\"><\\/i> fa-sort<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-alpha-asc\\"><\\/i> fa-sort-alpha-asc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-alpha-desc\\"><\\/i> fa-sort-alpha-desc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-amount-asc\\"><\\/i> fa-sort-amount-asc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-amount-desc\\"><\\/i> fa-sort-amount-desc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-asc\\"><\\/i> fa-sort-asc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-desc\\"><\\/i> fa-sort-desc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-down\\"><\\/i> fa-sort-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-numeric-asc\\"><\\/i> fa-sort-numeric-asc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-numeric-desc\\"><\\/i> fa-sort-numeric-desc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sort-up\\"><\\/i> fa-sort-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-spinner\\"><\\/i> fa-spinner<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-square\\"><\\/i> fa-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-square-o\\"><\\/i> fa-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-star\\"><\\/i> fa-star<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-star-half\\"><\\/i> fa-star-half<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-star-half-empty\\"><\\/i> fa-star-half-empty<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-star-half-full\\"><\\/i> fa-star-half-full<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-star-half-o\\"><\\/i> fa-star-half-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-star-o\\"><\\/i> fa-star-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-subscript\\"><\\/i> fa-subscript<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-suitcase\\"><\\/i> fa-suitcase<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-sun-o\\"><\\/i> fa-sun-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-superscript\\"><\\/i> fa-superscript<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tablet\\"><\\/i> fa-tablet<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tachometer\\"><\\/i> fa-tachometer<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tag\\"><\\/i> fa-tag<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tags\\"><\\/i> fa-tags<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tasks\\"><\\/i> fa-tasks<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-terminal\\"><\\/i> fa-terminal<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-thumb-tack\\"><\\/i> fa-thumb-tack<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-thumbs-down\\"><\\/i> fa-thumbs-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-thumbs-o-down\\"><\\/i> fa-thumbs-o-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-thumbs-o-up\\"><\\/i> fa-thumbs-o-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-thumbs-up\\"><\\/i> fa-thumbs-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-ticket\\"><\\/i> fa-ticket<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-times\\"><\\/i> fa-times<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-times-circle\\"><\\/i> fa-times-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-times-circle-o\\"><\\/i> fa-times-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tint\\"><\\/i> fa-tint<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-down\\"><\\/i> fa-toggle-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-left\\"><\\/i> fa-toggle-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-right\\"><\\/i> fa-toggle-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-up\\"><\\/i> fa-toggle-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-trash-o\\"><\\/i> fa-trash-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-trophy\\"><\\/i> fa-trophy<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-truck\\"><\\/i> fa-truck<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-umbrella\\"><\\/i> fa-umbrella<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-unlock\\"><\\/i> fa-unlock<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-unlock-alt\\"><\\/i> fa-unlock-alt<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-unsorted\\"><\\/i> fa-unsorted<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-upload\\"><\\/i> fa-upload<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-user\\"><\\/i> fa-user<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-users\\"><\\/i> fa-users<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-video-camera\\"><\\/i> fa-video-camera<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-volume-down\\"><\\/i> fa-volume-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-volume-off\\"><\\/i> fa-volume-off<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-volume-up\\"><\\/i> fa-volume-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-warning\\"><\\/i> fa-warning<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-wheelchair\\"><\\/i> fa-wheelchair<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-wrench\\"><\\/i> fa-wrench<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n\\r\\n<\\/section>\\r\\n<br>\\r\\n  <section id=\\"form-control\\">\\r\\n  \\r\\n      <div class=\\"page-header\\">\\r\\n    <h2 id=\\"headings\\">Form Control Icons<\\/h2>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-check-square\\"><\\/i> fa-check-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-check-square-o\\"><\\/i> fa-check-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-circle\\"><\\/i> fa-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-circle-o\\"><\\/i> fa-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dot-circle-o\\"><\\/i> fa-dot-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-minus-square\\"><\\/i> fa-minus-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-minus-square-o\\"><\\/i> fa-minus-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus-square\\"><\\/i> fa-plus-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus-square-o\\"><\\/i> fa-plus-square-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-square\\"><\\/i> fa-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-square-o\\"><\\/i> fa-square-o<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n<\\/section>\\r\\n<br>\\r\\n  <section id=\\"currency\\">\\r\\n  \\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Currency Icons<\\/h2>\\r\\n    <\\/div>\\r\\n  \\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bitcoin\\"><\\/i> fa-bitcoin<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-btc\\"><\\/i> fa-btc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cny\\"><\\/i> fa-cny<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dollar\\"><\\/i> fa-dollar<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-eur\\"><\\/i> fa-eur<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-euro\\"><\\/i> fa-euro<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-gbp\\"><\\/i> fa-gbp<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-inr\\"><\\/i> fa-inr<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-jpy\\"><\\/i> fa-jpy<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-krw\\"><\\/i> fa-krw<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-money\\"><\\/i> fa-money<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rmb\\"><\\/i> fa-rmb<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rouble\\"><\\/i> fa-rouble<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rub\\"><\\/i> fa-rub<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-ruble\\"><\\/i> fa-ruble<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rupee\\"><\\/i> fa-rupee<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-try\\"><\\/i> fa-try<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-turkish-lira\\"><\\/i> fa-turkish-lira<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-usd\\"><\\/i> fa-usd<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-won\\"><\\/i> fa-won<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-yen\\"><\\/i> fa-yen<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n\\r\\n<\\/section>\\r\\n<br>\\r\\n  <section id=\\"text-editor\\">\\r\\n      <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Text Editor Icons<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n  \\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-align-center\\"><\\/i> fa-align-center<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-align-justify\\"><\\/i> fa-align-justify<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-align-left\\"><\\/i> fa-align-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-align-right\\"><\\/i> fa-align-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bold\\"><\\/i> fa-bold<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chain\\"><\\/i> fa-chain<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chain-broken\\"><\\/i> fa-chain-broken<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-clipboard\\"><\\/i> fa-clipboard<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-columns\\"><\\/i> fa-columns<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-copy\\"><\\/i> fa-copy<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-cut\\"><\\/i> fa-cut<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dedent\\"><\\/i> fa-dedent<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-eraser\\"><\\/i> fa-eraser<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-file\\"><\\/i> fa-file<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-file-o\\"><\\/i> fa-file-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-file-text\\"><\\/i> fa-file-text<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-file-text-o\\"><\\/i> fa-file-text-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-files-o\\"><\\/i> fa-files-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-floppy-o\\"><\\/i> fa-floppy-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-font\\"><\\/i> fa-font<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-indent\\"><\\/i> fa-indent<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-italic\\"><\\/i> fa-italic<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-link\\"><\\/i> fa-link<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-list\\"><\\/i> fa-list<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-list-alt\\"><\\/i> fa-list-alt<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-list-ol\\"><\\/i> fa-list-ol<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-list-ul\\"><\\/i> fa-list-ul<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-outdent\\"><\\/i> fa-outdent<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-paperclip\\"><\\/i> fa-paperclip<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-paste\\"><\\/i> fa-paste<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-repeat\\"><\\/i> fa-repeat<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rotate-left\\"><\\/i> fa-rotate-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-rotate-right\\"><\\/i> fa-rotate-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-save\\"><\\/i> fa-save<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-scissors\\"><\\/i> fa-scissors<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-strikethrough\\"><\\/i> fa-strikethrough<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-table\\"><\\/i> fa-table<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-text-height\\"><\\/i> fa-text-height<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-text-width\\"><\\/i> fa-text-width<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-th\\"><\\/i> fa-th<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-th-large\\"><\\/i> fa-th-large<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-th-list\\"><\\/i> fa-th-list<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-underline\\"><\\/i> fa-underline<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-undo\\"><\\/i> fa-undo<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-unlink\\"><\\/i> fa-unlink<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n\\r\\n<\\/section>\\r\\n<br>\\r\\n  <section id=\\"directional\\">\\r\\n  \\r\\n        <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Directional Icons<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-double-down\\"><\\/i> fa-angle-double-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-double-left\\"><\\/i> fa-angle-double-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-double-right\\"><\\/i> fa-angle-double-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-double-up\\"><\\/i> fa-angle-double-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-down\\"><\\/i> fa-angle-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-left\\"><\\/i> fa-angle-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-right\\"><\\/i> fa-angle-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-angle-up\\"><\\/i> fa-angle-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-down\\"><\\/i> fa-arrow-circle-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-left\\"><\\/i> fa-arrow-circle-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-o-down\\"><\\/i> fa-arrow-circle-o-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-o-left\\"><\\/i> fa-arrow-circle-o-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-o-right\\"><\\/i> fa-arrow-circle-o-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-o-up\\"><\\/i> fa-arrow-circle-o-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-right\\"><\\/i> fa-arrow-circle-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-circle-up\\"><\\/i> fa-arrow-circle-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-down\\"><\\/i> fa-arrow-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-left\\"><\\/i> fa-arrow-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-right\\"><\\/i> fa-arrow-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrow-up\\"><\\/i> fa-arrow-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows\\"><\\/i> fa-arrows<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows-alt\\"><\\/i> fa-arrows-alt<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows-h\\"><\\/i> fa-arrows-h<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows-v\\"><\\/i> fa-arrows-v<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-down\\"><\\/i> fa-caret-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-left\\"><\\/i> fa-caret-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-right\\"><\\/i> fa-caret-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-down\\"><\\/i> fa-caret-square-o-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-left\\"><\\/i> fa-caret-square-o-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-right\\"><\\/i> fa-caret-square-o-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-square-o-up\\"><\\/i> fa-caret-square-o-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-caret-up\\"><\\/i> fa-caret-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-circle-down\\"><\\/i> fa-chevron-circle-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-circle-left\\"><\\/i> fa-chevron-circle-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-circle-right\\"><\\/i> fa-chevron-circle-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-circle-up\\"><\\/i> fa-chevron-circle-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-down\\"><\\/i> fa-chevron-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-left\\"><\\/i> fa-chevron-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-right\\"><\\/i> fa-chevron-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-chevron-up\\"><\\/i> fa-chevron-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-hand-o-down\\"><\\/i> fa-hand-o-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-hand-o-left\\"><\\/i> fa-hand-o-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-hand-o-right\\"><\\/i> fa-hand-o-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-hand-o-up\\"><\\/i> fa-hand-o-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-long-arrow-down\\"><\\/i> fa-long-arrow-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-long-arrow-left\\"><\\/i> fa-long-arrow-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-long-arrow-right\\"><\\/i> fa-long-arrow-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-long-arrow-up\\"><\\/i> fa-long-arrow-up<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-down\\"><\\/i> fa-toggle-down<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-left\\"><\\/i> fa-toggle-left<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-right\\"><\\/i> fa-toggle-right<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-toggle-up\\"><\\/i> fa-toggle-up<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n\\r\\n<\\/section>\\r\\n\\r\\n<br>\\r\\n  <section id=\\"video-player\\">\\r\\n  \\r\\n          <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Video Player Icons<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-arrows-alt\\"><\\/i> fa-arrows-alt<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-backward\\"><\\/i> fa-backward<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-compress\\"><\\/i> fa-compress<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-eject\\"><\\/i> fa-eject<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-expand\\"><\\/i> fa-expand<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-fast-backward\\"><\\/i> fa-fast-backward<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-fast-forward\\"><\\/i> fa-fast-forward<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-forward\\"><\\/i> fa-forward<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pause\\"><\\/i> fa-pause<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-play\\"><\\/i> fa-play<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-play-circle\\"><\\/i> fa-play-circle<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-play-circle-o\\"><\\/i> fa-play-circle-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-step-backward\\"><\\/i> fa-step-backward<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-step-forward\\"><\\/i> fa-step-forward<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-stop\\"><\\/i> fa-stop<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-youtube-play\\"><\\/i> fa-youtube-play<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n\\r\\n<\\/section>\\r\\n<br>\\r\\n  <section id=\\"brand\\">\\r\\n  \\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Brand Icons<\\/h2>\\r\\n    <\\/div>\\r\\n\\r\\n\\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-adn\\"><\\/i> fa-adn<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-android\\"><\\/i> fa-android<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-apple\\"><\\/i> fa-apple<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bitbucket\\"><\\/i> fa-bitbucket<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bitbucket-square\\"><\\/i> fa-bitbucket-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-bitcoin\\"><\\/i> fa-bitcoin<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-btc\\"><\\/i> fa-btc<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-css3\\"><\\/i> fa-css3<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dribbble\\"><\\/i> fa-dribbble<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-dropbox\\"><\\/i> fa-dropbox<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-facebook\\"><\\/i> fa-facebook<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-facebook-square\\"><\\/i> fa-facebook-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-flickr\\"><\\/i> fa-flickr<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-foursquare\\"><\\/i> fa-foursquare<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-github\\"><\\/i> fa-github<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-github-alt\\"><\\/i> fa-github-alt<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-github-square\\"><\\/i> fa-github-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-gittip\\"><\\/i> fa-gittip<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-google-plus\\"><\\/i> fa-google-plus<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-google-plus-square\\"><\\/i> fa-google-plus-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-html5\\"><\\/i> fa-html5<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-instagram\\"><\\/i> fa-instagram<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-linkedin\\"><\\/i> fa-linkedin<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-linkedin-square\\"><\\/i> fa-linkedin-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-linux\\"><\\/i> fa-linux<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-maxcdn\\"><\\/i> fa-maxcdn<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pagelines\\"><\\/i> fa-pagelines<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pinterest\\"><\\/i> fa-pinterest<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-pinterest-square\\"><\\/i> fa-pinterest-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-renren\\"><\\/i> fa-renren<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-skype\\"><\\/i> fa-skype<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-stack-exchange\\"><\\/i> fa-stack-exchange<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-stack-overflow\\"><\\/i> fa-stack-overflow<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-trello\\"><\\/i> fa-trello<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tumblr\\"><\\/i> fa-tumblr<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-tumblr-square\\"><\\/i> fa-tumblr-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-twitter\\"><\\/i> fa-twitter<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-twitter-square\\"><\\/i> fa-twitter-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-vimeo-square\\"><\\/i> fa-vimeo-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-vk\\"><\\/i> fa-vk<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-weibo\\"><\\/i> fa-weibo<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-windows\\"><\\/i> fa-windows<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-xing\\"><\\/i> fa-xing<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-xing-square\\"><\\/i> fa-xing-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-youtube\\"><\\/i> fa-youtube<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-youtube-play\\"><\\/i> fa-youtube-play<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-youtube-square\\"><\\/i> fa-youtube-square<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n<\\/section>\\r\\n<br>\\r\\n  <section id=\\"medical\\">\\r\\n    <div class=\\"page-header\\">\\r\\n        <h2 id=\\"headings\\">Medical Icons<\\/h2>\\r\\n    <\\/div>\\r\\n  \\r\\n\\r\\n  <div class=\\"row fontawesome-icon-list\\">\\r\\n    \\r\\n\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-ambulance\\"><\\/i> fa-ambulance<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-h-square\\"><\\/i> fa-h-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-hospital-o\\"><\\/i> fa-hospital-o<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-medkit\\"><\\/i> fa-medkit<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-plus-square\\"><\\/i> fa-plus-square<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-stethoscope\\"><\\/i> fa-stethoscope<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-user-md\\"><\\/i> fa-user-md<\\/div>\\r\\n    \\r\\n      <div class=\\"fa-hover col-md-3 col-sm-4\\"><i class=\\"fa fa-wheelchair\\"><\\/i> fa-wheelchair<\\/div>\\r\\n    \\r\\n  <\\/div>\\r\\n\\r\\n<\\/section>\\r\\n\\r\\n<\\/div>","fulltext":"","state":1,"catid":"12","created":"2014-07-28 13:24:18","created_by":"444","created_by_alias":"","modified":"2014-07-28 13:26:40","modified_by":"444","checked_out":"444","checked_out_time":"2014-07-28 13:26:31","publish_up":"2014-07-28 13:24:18","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":2,"ordering":"1","metakey":"","metadesc":"","access":"1","hits":"0","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0);
INSERT INTO `#__ucm_history` (`version_id`, `ucm_item_id`, `ucm_type_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(18, 10, 1, '', '2014-07-28 13:27:54', 400, 7718, '3c2801452fa385b6aa3d5ae1f7f9b0606bafa0f6', '{"id":10,"asset_id":77,"title":"Module positions","alias":"module-positions","introtext":"<div>\\r\\n\\t<div class=\\"col-sm-2 bordered\\">\\r\\n\\t\\t<p class=\\"alert-info\\">Logo<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-sm-6 bordered\\">\\r\\n\\t\\t<p>mainnav<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-sm-2 bordered\\">\\r\\n\\t\\t<p>search-popup<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-sm-2 bordered\\">\\r\\n\\t\\t<p>login-popup<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-12 bordered\\">\\r\\n\\t\\t<p>mn-slider<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-1<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-2<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-3<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-4<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-5<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-6<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-12 bordered\\">\\r\\n\\t\\t<p>mn-grid<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-7<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-8<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-9<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-10<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-11<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-12<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 bordered\\">\\r\\n\\t\\t<p>mn-parallax1<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-13<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-14<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-15<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-16<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-17<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-18<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 bordered\\">\\r\\n\\t\\t<p>mn-parallax2<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-19<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-20<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-21<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-22<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-23<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-24<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-25<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-26<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-27<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-28<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-29<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-30<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-31<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-32<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-33<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-34<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-35<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-36<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 bordered\\">\\r\\n\\t\\t<p>mn-parallax3<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-8 no-padding\\">\\r\\n\\t\\t<div class=\\"bordered\\">\\r\\n\\t\\t\\t<p>message<\\/p>\\r\\n\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\"bordered\\">\\r\\n\\t\\t\\t<p class=\\"alert-info\\">component<\\/p>\\r\\n\\t\\t<\\/div>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-4 no-padding\\">\\r\\n\\t\\t<div class=\\"bordered\\">\\r\\n\\t\\t\\t<p>sidebar-2<\\/p>\\r\\n\\t\\t<\\/div>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-37<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-38<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-39<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-40<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-41<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-42<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 bordered\\">\\r\\n\\t\\t<p>navhelper<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-1<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-2<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-3<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-4<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-5<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-6<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 bordered\\">\\r\\n\\t\\t<p>footer-social<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 bordered\\">\\r\\n\\t\\t<p>Copyright<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n","fulltext":"","state":1,"catid":"12","created":"2014-07-28 13:27:54","created_by":"444","created_by_alias":"","modified":"","modified_by":null,"checked_out":null,"checked_out_time":null,"publish_up":"2014-07-28 13:27:54","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":1,"ordering":null,"metakey":"","metadesc":"","access":"1","hits":null,"metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(19, 14, 7, '', '2014-07-28 13:29:17', 400, 540, 'b947f1537ead1fd4629254646f47c31d589e5e31', '{"id":14,"asset_id":78,"parent_id":"1","lft":"25","rgt":26,"level":1,"path":null,"extension":"com_contact","title":"Contacts category I","alias":"contacts-category-i","note":"","description":"","published":"1","checked_out":null,"checked_out_time":null,"access":"1","params":"{\\"category_layout\\":\\"\\",\\"image\\":\\"\\"}","metadesc":"","metakey":"","metadata":"{\\"author\\":\\"\\",\\"robots\\":\\"\\"}","created_user_id":"444","created_time":"2014-07-28 13:29:17","modified_user_id":null,"modified_time":null,"hits":"0","language":"*","version":null}', 0),
(20, 1, 3, '', '2014-07-28 13:30:42', 400, 1681, '40733b59ac17864ecf1dbd45f07a9fa680208534', '{"id":1,"name":"John Doe","alias":"john-doe","con_position":"","address":"2411 Any Street","suburb":"Any Town","state":"","country":"United Kingdom","postcode":"","telephone":"Q+123 456 7890","fax":"fax","misc":"","image":"","email_to":"info@youremail.you","default_con":0,"published":"1","checked_out":null,"checked_out_time":null,"ordering":1,"params":"{\\"show_contact_category\\":\\"\\",\\"show_contact_list\\":\\"\\",\\"presentation_style\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_name\\":\\"\\",\\"show_position\\":\\"\\",\\"show_email\\":\\"\\",\\"show_street_address\\":\\"\\",\\"show_suburb\\":\\"\\",\\"show_state\\":\\"\\",\\"show_postcode\\":\\"\\",\\"show_country\\":\\"\\",\\"show_telephone\\":\\"\\",\\"show_mobile\\":\\"\\",\\"show_fax\\":\\"\\",\\"show_webpage\\":\\"\\",\\"show_misc\\":\\"\\",\\"show_image\\":\\"\\",\\"allow_vcard\\":\\"\\",\\"show_articles\\":\\"\\",\\"show_profile\\":\\"\\",\\"show_links\\":\\"\\",\\"linka_name\\":\\"\\",\\"linka\\":false,\\"linkb_name\\":\\"\\",\\"linkb\\":false,\\"linkc_name\\":\\"\\",\\"linkc\\":false,\\"linkd_name\\":\\"\\",\\"linkd\\":false,\\"linke_name\\":\\"\\",\\"linke\\":\\"\\",\\"contact_layout\\":\\"\\",\\"show_email_form\\":\\"\\",\\"show_email_copy\\":\\"\\",\\"banned_email\\":\\"\\",\\"banned_subject\\":\\"\\",\\"banned_text\\":\\"\\",\\"validate_session\\":\\"\\",\\"custom_reply\\":\\"\\",\\"redirect\\":\\"\\"}","user_id":"","catid":"14","access":"1","mobile":"Q+999 456 7890","webpage":"","sortname1":"","sortname2":"","sortname3":"","language":"*","created":"2014-07-28 13:30:42","created_by":"444","created_by_alias":"","modified":"","modified_by":null,"metakey":"","metadesc":"","metadata":"{\\"robots\\":\\"\\",\\"rights\\":\\"\\"}","featured":"1","xreference":"","publish_up":"0000-00-00 00:00:00","publish_down":"0000-00-00 00:00:00","version":1,"hits":null}', 0),
(21, 1, 3, '', '2014-07-28 13:30:54', 400, 1721, '95e65919ded845775496687355e43a0c8991d535', '{"id":1,"name":"John Doe","alias":"john-doe","con_position":"","address":"2411 Any Street","suburb":"Any Town","state":"","country":"United Kingdom","postcode":"","telephone":"Q+123 456 7890","fax":"fax","misc":"","image":"","email_to":"info@youremail.you","default_con":0,"published":"1","checked_out":"444","checked_out_time":"2014-07-28 13:30:42","ordering":"1","params":"{\\"show_contact_category\\":\\"\\",\\"show_contact_list\\":\\"\\",\\"presentation_style\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_name\\":\\"\\",\\"show_position\\":\\"\\",\\"show_email\\":\\"\\",\\"show_street_address\\":\\"\\",\\"show_suburb\\":\\"\\",\\"show_state\\":\\"\\",\\"show_postcode\\":\\"\\",\\"show_country\\":\\"\\",\\"show_telephone\\":\\"\\",\\"show_mobile\\":\\"\\",\\"show_fax\\":\\"\\",\\"show_webpage\\":\\"\\",\\"show_misc\\":\\"\\",\\"show_image\\":\\"\\",\\"allow_vcard\\":\\"\\",\\"show_articles\\":\\"\\",\\"show_profile\\":\\"\\",\\"show_links\\":\\"\\",\\"linka_name\\":\\"\\",\\"linka\\":false,\\"linkb_name\\":\\"\\",\\"linkb\\":false,\\"linkc_name\\":\\"\\",\\"linkc\\":false,\\"linkd_name\\":\\"\\",\\"linkd\\":false,\\"linke_name\\":\\"\\",\\"linke\\":\\"\\",\\"contact_layout\\":\\"\\",\\"show_email_form\\":\\"\\",\\"show_email_copy\\":\\"\\",\\"banned_email\\":\\"\\",\\"banned_subject\\":\\"\\",\\"banned_text\\":\\"\\",\\"validate_session\\":\\"\\",\\"custom_reply\\":\\"\\",\\"redirect\\":\\"\\"}","user_id":"0","catid":"14","access":"1","mobile":"Q+999 456 7890","webpage":"","sortname1":"","sortname2":"","sortname3":"","language":"*","created":"2014-07-28 13:30:42","created_by":"444","created_by_alias":"","modified":"2014-07-28 13:30:54","modified_by":"444","metakey":"","metadesc":"","metadata":"{\\"robots\\":\\"\\",\\"rights\\":\\"\\"}","featured":"1","xreference":"","publish_up":"0000-00-00 00:00:00","publish_down":"0000-00-00 00:00:00","version":2,"hits":"0"}', 0),
(22, 1, 3, '', '2014-07-28 13:31:20', 400, 1759, '421354c08327465342cb6f63b3912c5420c8a989', '{"id":1,"name":"John Doe","alias":"john-doe","con_position":"","address":"2411 Any Street","suburb":"Any Town","state":"","country":"United Kingdom","postcode":"","telephone":"Q+123 456 7890","fax":"fax","misc":"","image":"images\\/techjungle\\/contact\\/map.jpg","email_to":"info@youremail.you","default_con":0,"published":"1","checked_out":"444","checked_out_time":"2014-07-28 13:30:54","ordering":"1","params":"{\\"show_contact_category\\":\\"\\",\\"show_contact_list\\":\\"\\",\\"presentation_style\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_name\\":\\"\\",\\"show_position\\":\\"\\",\\"show_email\\":\\"\\",\\"show_street_address\\":\\"\\",\\"show_suburb\\":\\"\\",\\"show_state\\":\\"\\",\\"show_postcode\\":\\"\\",\\"show_country\\":\\"\\",\\"show_telephone\\":\\"\\",\\"show_mobile\\":\\"\\",\\"show_fax\\":\\"\\",\\"show_webpage\\":\\"\\",\\"show_misc\\":\\"\\",\\"show_image\\":\\"\\",\\"allow_vcard\\":\\"\\",\\"show_articles\\":\\"\\",\\"show_profile\\":\\"\\",\\"show_links\\":\\"\\",\\"linka_name\\":\\"\\",\\"linka\\":false,\\"linkb_name\\":\\"\\",\\"linkb\\":false,\\"linkc_name\\":\\"\\",\\"linkc\\":false,\\"linkd_name\\":\\"\\",\\"linkd\\":false,\\"linke_name\\":\\"\\",\\"linke\\":\\"\\",\\"contact_layout\\":\\"\\",\\"show_email_form\\":\\"\\",\\"show_email_copy\\":\\"\\",\\"banned_email\\":\\"\\",\\"banned_subject\\":\\"\\",\\"banned_text\\":\\"\\",\\"validate_session\\":\\"\\",\\"custom_reply\\":\\"\\",\\"redirect\\":\\"\\"}","user_id":"445","catid":"14","access":"1","mobile":"Q+999 456 7890","webpage":"","sortname1":"","sortname2":"","sortname3":"","language":"*","created":"2014-07-28 13:30:42","created_by":"444","created_by_alias":"","modified":"2014-07-28 13:31:20","modified_by":"444","metakey":"","metadesc":"","metadata":"{\\"robots\\":\\"\\",\\"rights\\":\\"\\"}","featured":"1","xreference":"","publish_up":"0000-00-00 00:00:00","publish_down":"0000-00-00 00:00:00","version":3,"hits":"0"}', 0),
(23, 11, 1, '', '2014-07-28 14:19:45', 400, 1658, '5cf935f9d5412accc99a9416af8a6ec182ac44fe', '{"id":11,"asset_id":79,"title":"Archived Article I","alias":"archived-article-i","introtext":"","fulltext":"","state":1,"catid":"2","created":"2014-07-28 14:19:45","created_by":"444","created_by_alias":"","modified":"","modified_by":null,"checked_out":null,"checked_out_time":null,"publish_up":"2014-07-28 14:19:45","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":1,"ordering":null,"metakey":"","metadesc":"","access":"1","hits":null,"metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(24, 11, 1, '', '2014-07-28 14:20:09', 400, 2688, '7a78e0d603dde9ed0f53dc5babbe56afd4524875', '{"id":11,"asset_id":"79","title":"Archived Article I","alias":"archived-article-i","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"2","created":"2014-07-28 14:19:45","created_by":"444","created_by_alias":"","modified":"2014-07-28 14:20:09","modified_by":"444","checked_out":"444","checked_out_time":"2014-07-28 14:19:45","publish_up":"2014-07-28 14:19:45","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":2,"ordering":"0","metakey":"","metadesc":"","access":"1","hits":"0","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(25, 12, 1, '', '2014-07-28 14:20:13', 400, 2656, '19574bfb67e666d348cbf00d811c8327d9eb6e0e', '{"id":12,"asset_id":80,"title":"Archived Article I (2)","alias":"archived-article-i-2","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":0,"catid":"2","created":"2014-07-28 14:19:45","created_by":"444","created_by_alias":"","modified":"2014-07-28 14:20:09","modified_by":null,"checked_out":null,"checked_out_time":null,"publish_up":"2014-07-28 14:19:45","publish_down":"","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":1,"ordering":null,"metakey":"","metadesc":"","access":"1","hits":null,"metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(26, 12, 1, '', '2014-07-28 14:20:27', 400, 2671, '0260b6e62607f04f9c6fa8f8a3a6f0bc77fbb40f', '{"id":12,"asset_id":"80","title":"Archived Article II","alias":"archived-article-ii","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":0,"catid":"2","created":"2014-07-28 14:19:45","created_by":"444","created_by_alias":"","modified":"2014-07-28 14:20:27","modified_by":"444","checked_out":"444","checked_out_time":"2014-07-28 14:20:13","publish_up":"2014-07-28 14:19:45","publish_down":"","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":2,"ordering":"0","metakey":"","metadesc":"","access":"1","hits":"0","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(27, 12, 1, '', '2014-07-28 14:20:34', 400, 2690, 'baba4033c6fa1f7c13e38f5c8858499f30f10d63', '{"id":12,"asset_id":"80","title":"Archived Article II","alias":"archived-article-ii","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"2","created":"2014-07-28 14:19:45","created_by":"444","created_by_alias":"","modified":"2014-07-28 14:20:34","modified_by":"444","checked_out":"444","checked_out_time":"2014-07-28 14:20:27","publish_up":"2014-07-28 14:19:45","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":3,"ordering":"0","metakey":"","metadesc":"","access":"1","hits":"0","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(28, 13, 1, '', '2014-07-28 14:20:37', 400, 2658, '90e141963b50544cb07a995c9e19124f59f04f7b', '{"id":13,"asset_id":81,"title":"Archived Article II (2)","alias":"archived-article-ii-2","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":0,"catid":"2","created":"2014-07-28 14:19:45","created_by":"444","created_by_alias":"","modified":"2014-07-28 14:20:34","modified_by":null,"checked_out":null,"checked_out_time":null,"publish_up":"2014-07-28 14:19:45","publish_down":"","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":1,"ordering":null,"metakey":"","metadesc":"","access":"1","hits":null,"metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(29, 13, 1, '', '2014-07-28 14:21:08', 400, 2692, '1c2534f56f14f4fa508f8084d5cbba62f3dc8705', '{"id":13,"asset_id":"81","title":"Archived Article III","alias":"archived-article-iii","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"2","created":"2014-07-28 14:19:45","created_by":"444","created_by_alias":"","modified":"2014-07-28 14:21:08","modified_by":"444","checked_out":"444","checked_out_time":"2014-07-28 14:20:56","publish_up":"2014-07-28 14:19:45","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":2,"ordering":"0","metakey":"","metadesc":"","access":"1","hits":"0","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(34, 6, 1, '', '2014-08-04 19:37:42', 400, 12259, '0e969b70b0ef5775fed1b4c7d79f3a4e65b0d2f1', '{"id":6,"asset_id":"71","title":"About us","alias":"about-us","introtext":"        <div class=\\"row\\">\\r\\n        \\r\\n            <div class=\\"mn-mod-header\\">\\r\\n                <div class=\\"mn-title\\">\\r\\n                    <h2>A Little About Us<\\/h2>\\r\\n                <\\/div>\\r\\n                <div class=\\"mn-description\\">\\r\\n                    <h4>We are the most popular web source<br>for movies and TV news<\\/h4>\\r\\n                <\\/div>\\r\\n\\r\\n            <\\/div>\\r\\n                        \\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/aboutus.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>John Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/clapboard\\/about\\/about2.jpg\\" alt=\\"about2\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Jane Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/clapboard\\/about\\/about3.jpg\\" alt=\\"about3\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Nick Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n            \\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/clapboard\\/about\\/about4.jpg\\" alt=\\"about41\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Susan Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/clapboard\\/about\\/about5.jpg\\" alt=\\"about5\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Mike Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/clapboard\\/about\\/about6.jpg\\" alt=\\"about6\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Helen Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n        <\\/div>\\r\\n   \\r\\n","fulltext":"","state":1,"catid":"2","created":"2014-07-28 13:23:15","created_by":"444","created_by_alias":"","modified":"2014-08-04 19:37:42","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-04 19:37:20","publish_up":"2014-07-28 13:23:15","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":7,"ordering":"4","metakey":"","metadesc":"","access":"1","hits":"18","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0);
INSERT INTO `#__ucm_history` (`version_id`, `ucm_item_id`, `ucm_type_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(35, 6, 1, '', '2014-08-04 19:40:10', 400, 12278, 'a0d99fc6c19cab5888021923531f1f1d303688dc', '{"id":6,"asset_id":"71","title":"About us","alias":"about-us","introtext":"        <div class=\\"row\\">\\r\\n        \\r\\n            <div class=\\"mn-mod-header\\">\\r\\n                <div class=\\"mn-title\\">\\r\\n                    <h2>A Little About Us<\\/h2>\\r\\n                <\\/div>\\r\\n                <div class=\\"mn-description\\">\\r\\n                    <h4>We are the most popular web source<br>for movies and TV news<\\/h4>\\r\\n                <\\/div>\\r\\n\\r\\n            <\\/div>\\r\\n                        \\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/aboutus.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>John Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/aboutus.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Jane Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/aboutus.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Nick Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n            \\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/aboutus.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Susan Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/aboutus.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Mike Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/aboutus.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Helen Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n        <\\/div>\\r\\n   \\r\\n","fulltext":"","state":1,"catid":"2","created":"2014-07-28 13:23:15","created_by":"444","created_by_alias":"","modified":"2014-08-04 19:40:10","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-04 19:37:42","publish_up":"2014-07-28 13:23:15","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":8,"ordering":"4","metakey":"","metadesc":"","access":"1","hits":"20","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(36, 1, 3, '', '2014-08-04 19:49:58', 400, 1770, '63ad2e78815f12ec27b1321a0d127aa493346a71', '{"id":1,"name":"John Doe","alias":"john-doe","con_position":"","address":"2411 Any Street","suburb":"Any Town","state":"","country":"United Kingdom","postcode":"","telephone":"Q+123 456 7890","fax":"fax","misc":"xcvxvxcvxcv","image":"images\\/techjungle\\/contact\\/map.jpg","email_to":"info@youremail.you","default_con":0,"published":"1","checked_out":"444","checked_out_time":"2014-08-04 19:48:02","ordering":"1","params":"{\\"show_contact_category\\":\\"\\",\\"show_contact_list\\":\\"\\",\\"presentation_style\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_name\\":\\"\\",\\"show_position\\":\\"\\",\\"show_email\\":\\"\\",\\"show_street_address\\":\\"\\",\\"show_suburb\\":\\"\\",\\"show_state\\":\\"\\",\\"show_postcode\\":\\"\\",\\"show_country\\":\\"\\",\\"show_telephone\\":\\"\\",\\"show_mobile\\":\\"\\",\\"show_fax\\":\\"\\",\\"show_webpage\\":\\"\\",\\"show_misc\\":\\"\\",\\"show_image\\":\\"\\",\\"allow_vcard\\":\\"\\",\\"show_articles\\":\\"\\",\\"show_profile\\":\\"\\",\\"show_links\\":\\"\\",\\"linka_name\\":\\"\\",\\"linka\\":false,\\"linkb_name\\":\\"\\",\\"linkb\\":false,\\"linkc_name\\":\\"\\",\\"linkc\\":false,\\"linkd_name\\":\\"\\",\\"linkd\\":false,\\"linke_name\\":\\"\\",\\"linke\\":\\"\\",\\"contact_layout\\":\\"\\",\\"show_email_form\\":\\"\\",\\"show_email_copy\\":\\"\\",\\"banned_email\\":\\"\\",\\"banned_subject\\":\\"\\",\\"banned_text\\":\\"\\",\\"validate_session\\":\\"\\",\\"custom_reply\\":\\"\\",\\"redirect\\":\\"\\"}","user_id":"445","catid":"14","access":"1","mobile":"Q+999 456 7890","webpage":"","sortname1":"","sortname2":"","sortname3":"","language":"*","created":"2014-07-28 13:30:42","created_by":"444","created_by_alias":"","modified":"2014-08-04 19:49:58","modified_by":"444","metakey":"","metadesc":"","metadata":"{\\"robots\\":\\"\\",\\"rights\\":\\"\\"}","featured":"1","xreference":"","publish_up":"0000-00-00 00:00:00","publish_down":"0000-00-00 00:00:00","version":4,"hits":"7"}', 0),
(37, 1, 3, '', '2014-08-04 19:50:14', 400, 1866, 'e7266084ce5a951e14d924813865de086b00579f', '{"id":1,"name":"John Doe","alias":"john-doe","con_position":"","address":"2411 Any Street","suburb":"Any Town","state":"","country":"United Kingdom","postcode":"","telephone":"Q+123 456 7890","fax":"fax","misc":"If you have any enquiry then you may simply get in touch\\r\\nand we will get back to you as soon as possible","image":"images\\/techjungle\\/contact\\/map.jpg","email_to":"info@youremail.you","default_con":0,"published":"1","checked_out":"444","checked_out_time":"2014-08-04 19:49:58","ordering":"1","params":"{\\"show_contact_category\\":\\"\\",\\"show_contact_list\\":\\"\\",\\"presentation_style\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_name\\":\\"\\",\\"show_position\\":\\"\\",\\"show_email\\":\\"\\",\\"show_street_address\\":\\"\\",\\"show_suburb\\":\\"\\",\\"show_state\\":\\"\\",\\"show_postcode\\":\\"\\",\\"show_country\\":\\"\\",\\"show_telephone\\":\\"\\",\\"show_mobile\\":\\"\\",\\"show_fax\\":\\"\\",\\"show_webpage\\":\\"\\",\\"show_misc\\":\\"\\",\\"show_image\\":\\"\\",\\"allow_vcard\\":\\"\\",\\"show_articles\\":\\"\\",\\"show_profile\\":\\"\\",\\"show_links\\":\\"\\",\\"linka_name\\":\\"\\",\\"linka\\":false,\\"linkb_name\\":\\"\\",\\"linkb\\":false,\\"linkc_name\\":\\"\\",\\"linkc\\":false,\\"linkd_name\\":\\"\\",\\"linkd\\":false,\\"linke_name\\":\\"\\",\\"linke\\":\\"\\",\\"contact_layout\\":\\"\\",\\"show_email_form\\":\\"\\",\\"show_email_copy\\":\\"\\",\\"banned_email\\":\\"\\",\\"banned_subject\\":\\"\\",\\"banned_text\\":\\"\\",\\"validate_session\\":\\"\\",\\"custom_reply\\":\\"\\",\\"redirect\\":\\"\\"}","user_id":"445","catid":"14","access":"1","mobile":"Q+999 456 7890","webpage":"","sortname1":"","sortname2":"","sortname3":"","language":"*","created":"2014-07-28 13:30:42","created_by":"444","created_by_alias":"","modified":"2014-08-04 19:50:14","modified_by":"444","metakey":"","metadesc":"","metadata":"{\\"robots\\":\\"\\",\\"rights\\":\\"\\"}","featured":"1","xreference":"","publish_up":"0000-00-00 00:00:00","publish_down":"0000-00-00 00:00:00","version":5,"hits":"8"}', 0),
(38, 1, 3, '', '2014-08-04 19:50:41', 400, 1871, '05a3d0a33e8066e131ce907b5478211759cea1a3', '{"id":1,"name":"John Doe","alias":"john-doe","con_position":"","address":"2411 Any Street","suburb":"Any Town","state":"","country":"United Kingdom","postcode":"","telephone":"Q+123 456 7890","fax":"fax","misc":"If you have any enquiry then you may simply get in touch<br>\\r\\nand we will get back to you as soon as possible ","image":"images\\/techjungle\\/contact\\/map.jpg","email_to":"info@youremail.you","default_con":0,"published":"1","checked_out":"444","checked_out_time":"2014-08-04 19:50:14","ordering":"1","params":"{\\"show_contact_category\\":\\"\\",\\"show_contact_list\\":\\"\\",\\"presentation_style\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_name\\":\\"\\",\\"show_position\\":\\"\\",\\"show_email\\":\\"\\",\\"show_street_address\\":\\"\\",\\"show_suburb\\":\\"\\",\\"show_state\\":\\"\\",\\"show_postcode\\":\\"\\",\\"show_country\\":\\"\\",\\"show_telephone\\":\\"\\",\\"show_mobile\\":\\"\\",\\"show_fax\\":\\"\\",\\"show_webpage\\":\\"\\",\\"show_misc\\":\\"\\",\\"show_image\\":\\"\\",\\"allow_vcard\\":\\"\\",\\"show_articles\\":\\"\\",\\"show_profile\\":\\"\\",\\"show_links\\":\\"\\",\\"linka_name\\":\\"\\",\\"linka\\":false,\\"linkb_name\\":\\"\\",\\"linkb\\":false,\\"linkc_name\\":\\"\\",\\"linkc\\":false,\\"linkd_name\\":\\"\\",\\"linkd\\":false,\\"linke_name\\":\\"\\",\\"linke\\":\\"\\",\\"contact_layout\\":\\"\\",\\"show_email_form\\":\\"\\",\\"show_email_copy\\":\\"\\",\\"banned_email\\":\\"\\",\\"banned_subject\\":\\"\\",\\"banned_text\\":\\"\\",\\"validate_session\\":\\"\\",\\"custom_reply\\":\\"\\",\\"redirect\\":\\"\\"}","user_id":"445","catid":"14","access":"1","mobile":"Q+999 456 7890","webpage":"","sortname1":"","sortname2":"","sortname3":"","language":"*","created":"2014-07-28 13:30:42","created_by":"444","created_by_alias":"","modified":"2014-08-04 19:50:41","modified_by":"444","metakey":"","metadesc":"","metadata":"{\\"robots\\":\\"\\",\\"rights\\":\\"\\"}","featured":"1","xreference":"","publish_up":"0000-00-00 00:00:00","publish_down":"0000-00-00 00:00:00","version":6,"hits":"9"}', 0),
(43, 3, 1, '', '2014-08-04 20:40:16', 400, 2667, '25548025812db7a7f825bc0e749461c8aefaf8e1', '{"id":3,"asset_id":"68","title":"Article3","alias":"article3","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"9","created":"2014-07-28 13:21:34","created_by":"444","created_by_alias":"","modified":"2014-08-04 20:40:16","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-04 20:40:12","publish_up":"2014-07-28 13:21:34","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":2,"ordering":"1","metakey":"","metadesc":"","access":"1","hits":"0","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(44, 4, 1, '', '2014-08-04 20:40:25', 400, 2667, '635df629b5a0289164c5cdee9afc7026b36cceb0', '{"id":4,"asset_id":"69","title":"Article4","alias":"article4","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"9","created":"2014-07-28 13:21:47","created_by":"444","created_by_alias":"","modified":"2014-08-04 20:40:25","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-04 20:40:20","publish_up":"2014-07-28 13:21:47","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":2,"ordering":"0","metakey":"","metadesc":"","access":"1","hits":"0","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(48, 21, 1, '', '2014-08-04 20:40:40', 400, 2668, 'e8662566d483f26bb88bec9cf24f71f85d1342a1', '{"id":21,"asset_id":90,"title":"Article1","alias":"article1","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":"1","catid":10,"created":"2014-07-28 13:20:56","created_by":"444","created_by_alias":"","modified":"2014-07-28 13:21:00","modified_by":"444","checked_out":"0","checked_out_time":"0000-00-00 00:00:00","publish_up":"2014-07-28 13:20:56","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":"2","ordering":"1","metakey":"","metadesc":"","access":"1","hits":"16","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"1","language":"*","xreference":""}', 0),
(49, 21, 1, '', '2014-08-04 20:40:57', 400, 2670, '080e0ed74352dcfd4e6c2a2a72fcfb6a392b9f2c', '{"id":21,"asset_id":"90","title":"Article5","alias":"article5","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"10","created":"2014-07-28 13:20:56","created_by":"444","created_by_alias":"","modified":"2014-08-04 20:40:57","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-04 20:40:47","publish_up":"2014-07-28 13:20:56","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":3,"ordering":"1","metakey":"","metadesc":"","access":"1","hits":"16","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"1","language":"*","xreference":""}', 0),
(53, 6, 1, '', '2014-08-22 09:34:56', 400, 12272, 'e6cb44cbb1d4f09df131f11a4368ee26fce1e5bf', '{"id":6,"asset_id":"71","title":"About us","alias":"about-us","introtext":"        <div class=\\"row\\">\\r\\n        \\r\\n            <div class=\\"mn-mod-header\\">\\r\\n                <div class=\\"mn-title\\">\\r\\n                    <h2>A Little About Us<\\/h2>\\r\\n                <\\/div>\\r\\n                <div class=\\"mn-description\\">\\r\\n                    <h4>We are the most popular web source<br>for movies and TV news<\\/h4>\\r\\n                <\\/div>\\r\\n\\r\\n            <\\/div>\\r\\n                        \\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/about1.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>John Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/about2.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Jane Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/about3.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Nick Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n            \\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/about4.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Susan Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/about5.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Mike Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/about6.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Helen Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n        <\\/div>\\r\\n   \\r\\n","fulltext":"","state":1,"catid":"2","created":"2014-07-28 13:23:15","created_by":"444","created_by_alias":"","modified":"2014-08-22 09:34:56","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-22 09:34:10","publish_up":"2014-07-28 13:23:15","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":9,"ordering":"4","metakey":"","metadesc":"","access":"1","hits":"48","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(54, 1, 1, '', '2014-08-22 12:20:45', 400, 2796, 'a6afcdd3884751901229ec5b669ddd441cd0b896', '{"id":1,"asset_id":"66","title":"Article1","alias":"article1","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"9","created":"2014-07-28 13:20:56","created_by":"444","created_by_alias":"","modified":"2014-08-22 12:20:45","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-22 12:20:24","publish_up":"2014-07-28 13:20:56","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/the_best_laptop_for_2014.jpg\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/the_best_laptop_for_2014.jpg\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":3,"ordering":"1","metakey":"","metadesc":"","access":"1","hits":"34","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"1","language":"*","xreference":""}', 0);
INSERT INTO `#__ucm_history` (`version_id`, `ucm_item_id`, `ucm_type_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(55, 1, 1, '', '2014-08-22 12:24:17', 400, 2851, 'e5e4f45a9ecd7a0774280197047a4886c8de2a2c', '{"id":1,"asset_id":"66","title":"A gaming laptop more powerful than desktops","alias":"a-gaming-laptop-more-powerful-than-desktops","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"9","created":"2014-07-28 13:20:56","created_by":"444","created_by_alias":"","modified":"2014-08-22 12:24:17","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-22 12:20:45","publish_up":"2014-07-28 13:20:56","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/article01.jpg\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/the_best_laptop_for_2014.jpg\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":4,"ordering":"1","metakey":"","metadesc":"","access":"1","hits":"35","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"1","language":"*","xreference":""}', 0),
(56, 2, 1, '', '2014-08-22 12:25:31', 400, 2798, '1f94416d1db7ef2340168f238df8fa18ed42d922', '{"id":2,"asset_id":"67","title":"THE BEST LAPTOP FOR 2014","alias":"the-best-laptop-for-2014","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"9","created":"2014-07-28 13:21:13","created_by":"444","created_by_alias":"","modified":"2014-08-22 12:25:31","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-22 12:24:37","publish_up":"2014-07-28 13:21:13","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/article02.jpg\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/article02.jpg\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":3,"ordering":"0","metakey":"","metadesc":"","access":"1","hits":"15","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"1","language":"*","xreference":""}', 0),
(57, 3, 1, '', '2014-08-22 12:26:44', 400, 2817, '947c770b4e6f1530f37cae9d51ec38b92760c0f5', '{"id":3,"asset_id":"68","title":"A business tablet to replace books","alias":"a-business-tablet-to-replace-books","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"9","created":"2014-07-28 13:21:34","created_by":"444","created_by_alias":"","modified":"2014-08-22 12:26:44","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-22 12:26:04","publish_up":"2014-07-28 13:21:34","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/article03.jpg\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/article03.jpg\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":3,"ordering":"1","metakey":"","metadesc":"","access":"1","hits":"2","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(58, 2, 1, '', '2014-08-22 12:27:22', 400, 2798, 'b64fb93ce1098fe74aee718bde21221ee29a07cd', '{"id":2,"asset_id":"67","title":"The best laptop for 2014","alias":"the-best-laptop-for-2014","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"9","created":"2014-07-28 13:21:13","created_by":"444","created_by_alias":"","modified":"2014-08-22 12:27:22","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-22 12:27:15","publish_up":"2014-07-28 13:21:13","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/article02.jpg\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/article02.jpg\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":6,"ordering":"0","metakey":"","metadesc":"","access":"1","hits":"15","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"1","language":"*","xreference":""}', 0),
(59, 4, 1, '', '2014-08-22 12:28:37', 400, 2855, 'cdc8e980d768899a0a9708972b8149a5d8e36866', '{"id":4,"asset_id":"69","title":"A cheap and smart way to communicate in public places","alias":"a-cheap-and-smart-way-to-communicate-in-public-places","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"9","created":"2014-07-28 13:21:47","created_by":"444","created_by_alias":"","modified":"2014-08-22 12:28:37","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-22 12:27:54","publish_up":"2014-07-28 13:21:47","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/article04.jpg\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/article04.jpg\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":3,"ordering":"0","metakey":"","metadesc":"","access":"1","hits":"0","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(60, 21, 1, '', '2014-08-22 12:31:41', 400, 2810, 'fab0121bd567849f656123c22314717f4b2b08d5', '{"id":21,"asset_id":"90","title":"Speed boost and image quality","alias":"speed-boost-and-image-quality","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"10","created":"2014-07-28 13:20:56","created_by":"444","created_by_alias":"","modified":"2014-08-22 12:31:41","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-22 12:30:52","publish_up":"2014-07-28 13:20:56","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/article05.jpg\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/article05.jpg\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":4,"ordering":"1","metakey":"","metadesc":"","access":"1","hits":"17","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"1","language":"*","xreference":""}', 0),
(64, 1, 1, '', '2014-08-22 12:35:06', 400, 2836, '8730bf7188b5588d267f5a3fa5b55cc07b04ce33', '{"id":1,"asset_id":"66","title":"A gaming laptop more powerful than desktops","alias":"a-gaming-laptop-more-powerful-than-desktops","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"9","created":"2014-07-28 13:20:56","created_by":"444","created_by_alias":"","modified":"2014-08-22 12:35:06","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-22 12:34:41","publish_up":"2014-07-28 13:20:56","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/article01.jpg\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/article01.jpg\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":5,"ordering":"1","metakey":"","metadesc":"","access":"1","hits":"38","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"1","language":"*","xreference":""}', 0),
(65, 10, 1, '', '2014-08-22 12:48:48', 400, 7462, '80aa38e3cc8ae660f195050d3c892e2e6d45e8c7', '{"id":10,"asset_id":"77","title":"Module positions","alias":"module-positions","introtext":"<div>\\r\\n\\t<div class=\\"col-sm-4 bordered\\">\\r\\n\\t\\t<p class=\\"alert-info\\">Logo<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-sm-2 bordered\\">\\r\\n\\t\\t<p>search-popup<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t\\t<div class=\\"col-sm-4 bordered\\">\\r\\n\\t\\t<p>dynamic-search<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-sm-2 bordered\\">\\r\\n\\t\\t<p>login-popup<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-12 bordered\\">\\r\\n\\t\\t<p>mainnav<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-1<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-2<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-3<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-4<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-5<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-6<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-7<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-8<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-9<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-10<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-11<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-12<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-13<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-14<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-15<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-16<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-17<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-18<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-19<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-20<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-21<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-22<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-23<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-24<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-25<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-26<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-27<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-28<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-29<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-30<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 bordered\\">\\r\\n\\t\\t<p>mn-parallax1<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-31<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-32<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-33<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-34<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-35<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-36<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-8 no-padding\\">\\r\\n\\t\\t<div class=\\"bordered\\">\\r\\n\\t\\t\\t<p>message<\\/p>\\r\\n\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\"bordered\\">\\r\\n\\t\\t\\t<p class=\\"alert-info\\">component<\\/p>\\r\\n\\t\\t<\\/div>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-4 no-padding\\">\\r\\n\\t\\t<div class=\\"bordered\\">\\r\\n\\t\\t\\t<p>sidebar-2<\\/p>\\r\\n\\t\\t<\\/div>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 bordered\\">\\r\\n\\t\\t<p>navhelper<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-top-1<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-top-2<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-top-3<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-top-4<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-top-5<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-top-6<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-1<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-2<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-3<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-4<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-5<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-6<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 bordered\\">\\r\\n\\t\\t<p>footer-social<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 bordered\\">\\r\\n\\t\\t<p>Copyright<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n","fulltext":"","state":1,"catid":"12","created":"2014-07-28 13:27:54","created_by":"444","created_by_alias":"","modified":"2014-08-22 12:48:48","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-22 12:42:08","publish_up":"2014-07-28 13:27:54","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":3,"ordering":"0","metakey":"","metadesc":"","access":"1","hits":"33","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(66, 10, 1, '', '2014-08-22 12:51:05', 400, 8016, '713b1145dd8edf2aa64385cbba7c9b630d95ba8e', '{"id":10,"asset_id":"77","title":"Module positions","alias":"module-positions","introtext":"<div>\\r\\n\\t<div class=\\"col-sm-4 bordered\\">\\r\\n\\t\\t<p class=\\"alert-info\\">Logo<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-sm-2 bordered\\">\\r\\n\\t\\t<p>search-popup<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t\\t<div class=\\"col-sm-4 bordered\\">\\r\\n\\t\\t<p>dynamic-search<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-sm-2 bordered\\">\\r\\n\\t\\t<p>login-popup<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-12 bordered\\">\\r\\n\\t\\t<p>mainnav<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-1<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-2<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-3<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-4<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-5<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-6<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-7<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-8<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-9<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-10<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-11<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-12<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-13<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-14<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-15<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-16<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-17<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-18<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-19<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-20<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-21<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-22<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-23<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-24<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-25<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-26<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-27<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-28<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-29<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-30<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 bordered\\">\\r\\n\\t\\t<p>mn-parallax1<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-31<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-32<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-33<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-34<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-35<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-36<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-8 no-padding\\">\\r\\n\\t\\t<div class=\\"bordered\\">\\r\\n\\t\\t\\t<p>message<\\/p>\\r\\n\\t\\t<\\/div>\\r\\n\\t\\t<div class=\\"bordered\\">\\r\\n\\t\\t\\t<p class=\\"alert-info\\">component<\\/p>\\r\\n\\t\\t<\\/div>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-4 no-padding\\">\\r\\n\\t\\t<div class=\\"bordered\\">\\r\\n\\t\\t\\t<p>sidebar-2<\\/p>\\r\\n\\t\\t<\\/div>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n<div class=\\"clearfix\\"><\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-37<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-38<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-39<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-40<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-41<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>position-42<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 bordered\\">\\r\\n\\t\\t<p>navhelper<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-top-1<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-top-2<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-top-3<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-top-4<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-top-5<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-top-6<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-1<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-2<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-3<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-4<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-5<\\/p>\\r\\n\\t<\\/div>\\r\\n\\t<div class=\\"col-xs-12 col-sm-2 bordered\\">\\r\\n\\t\\t<p>footer-6<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 bordered\\">\\r\\n\\t\\t<p>footer-social<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n\\r\\n<div>\\r\\n\\t<div class=\\"col-xs-12 bordered\\">\\r\\n\\t\\t<p>Copyright<\\/p>\\r\\n\\t<\\/div>\\r\\n<\\/div>\\r\\n","fulltext":"","state":1,"catid":"12","created":"2014-07-28 13:27:54","created_by":"444","created_by_alias":"","modified":"2014-08-22 12:51:05","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-22 12:48:48","publish_up":"2014-07-28 13:27:54","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":4,"ordering":"0","metakey":"","metadesc":"","access":"1","hits":"34","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(67, 1, 3, '', '2014-08-22 15:51:30', 400, 1876, 'a3a0dff3cc43c798b3ebe1229ae6fb9bf93337ad', '{"id":1,"name":"John Doe","alias":"john-doe","con_position":"","address":"2411 Any Street","suburb":"Any Town","state":"","country":"United Kingdom","postcode":"","telephone":"Q+123 456 7890","fax":"fax","misc":"If you have any enquiry then you may simply get in touch<br>\\r\\nand we will get back to you as soon as possible ","image":"images\\/techjungle\\/contact\\/contact.jpg","email_to":"info@youremail.you","default_con":0,"published":"1","checked_out":"444","checked_out_time":"2014-08-22 15:51:19","ordering":"1","params":"{\\"show_contact_category\\":\\"\\",\\"show_contact_list\\":\\"\\",\\"presentation_style\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_name\\":\\"\\",\\"show_position\\":\\"\\",\\"show_email\\":\\"\\",\\"show_street_address\\":\\"\\",\\"show_suburb\\":\\"\\",\\"show_state\\":\\"\\",\\"show_postcode\\":\\"\\",\\"show_country\\":\\"\\",\\"show_telephone\\":\\"\\",\\"show_mobile\\":\\"\\",\\"show_fax\\":\\"\\",\\"show_webpage\\":\\"\\",\\"show_misc\\":\\"\\",\\"show_image\\":\\"\\",\\"allow_vcard\\":\\"\\",\\"show_articles\\":\\"\\",\\"show_profile\\":\\"\\",\\"show_links\\":\\"\\",\\"linka_name\\":\\"\\",\\"linka\\":false,\\"linkb_name\\":\\"\\",\\"linkb\\":false,\\"linkc_name\\":\\"\\",\\"linkc\\":false,\\"linkd_name\\":\\"\\",\\"linkd\\":false,\\"linke_name\\":\\"\\",\\"linke\\":\\"\\",\\"contact_layout\\":\\"\\",\\"show_email_form\\":\\"\\",\\"show_email_copy\\":\\"\\",\\"banned_email\\":\\"\\",\\"banned_subject\\":\\"\\",\\"banned_text\\":\\"\\",\\"validate_session\\":\\"\\",\\"custom_reply\\":\\"\\",\\"redirect\\":\\"\\"}","user_id":"445","catid":"14","access":"1","mobile":"Q+999 456 7890","webpage":"","sortname1":"","sortname2":"","sortname3":"","language":"*","created":"2014-07-28 13:30:42","created_by":"444","created_by_alias":"","modified":"2014-08-22 15:51:30","modified_by":"444","metakey":"","metadesc":"","metadata":"{\\"robots\\":\\"\\",\\"rights\\":\\"\\"}","featured":"1","xreference":"","publish_up":"0000-00-00 00:00:00","publish_down":"0000-00-00 00:00:00","version":9,"hits":"42"}', 0);
INSERT INTO `#__ucm_history` (`version_id`, `ucm_item_id`, `ucm_type_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(68, 6, 1, '', '2014-08-22 18:26:20', 400, 12270, '563659647c1f9b829aeed0041951ef0ab5563138', '{"id":6,"asset_id":"71","title":"About us","alias":"about-us","introtext":"        <div class=\\"row\\">\\r\\n        \\r\\n            <div class=\\"mn-mod-header\\">\\r\\n                <div class=\\"mn-title\\">\\r\\n                    <h2>A Little About Us<\\/h2>\\r\\n                <\\/div>\\r\\n                <div class=\\"mn-description\\">\\r\\n                    <h4>We are the most popular web source<br>for technology news<\\/h4>\\r\\n                <\\/div>\\r\\n\\r\\n            <\\/div>\\r\\n                        \\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/about1.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>John Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/about2.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Jane Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/about3.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Nick Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n            \\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/about4.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Susan Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/about5.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Mike Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/about6.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Helen Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n        <\\/div>\\r\\n   \\r\\n","fulltext":"","state":1,"catid":"2","created":"2014-07-28 13:23:15","created_by":"444","created_by_alias":"","modified":"2014-08-22 18:26:20","modified_by":"444","checked_out":"444","checked_out_time":"2014-08-22 18:25:37","publish_up":"2014-07-28 13:23:15","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":10,"ordering":"4","metakey":"","metadesc":"","access":"1","hits":"62","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(71, 6, 1, '', '2014-08-25 16:08:58', 400, 12276, '0e8cc2d50479623194af89e9f6df4a5d523e894a', '{"id":6,"asset_id":"71","title":"About us","alias":"about-us","introtext":"        <div class=\\"row\\">\\r\\n        \\r\\n            <div class=\\"mn-mod-header\\">\\r\\n                <div class=\\"mn-title\\">\\r\\n                    <h2>A Little About Us<\\/h2>\\r\\n                <\\/div>\\r\\n                <div class=\\"mn-description\\">\\r\\n                    <h4>We are the most popular web source<br>for technology news<\\/h4>\\r\\n                <\\/div>\\r\\n\\r\\n            <\\/div>\\r\\n                        \\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/aboutus.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>John Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/aboutus.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Jane Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/aboutus.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Nick Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n            \\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/aboutus.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Susan Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/aboutus.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Mike Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n             <div class=\\"col-xs-12 col-md-4 mn-about text-center\\">\\r\\n                <div class=\\"mn-about-inner\\">\\r\\n                \\r\\n                    <div class=\\"mn-about-img\\">\\r\\n                        <img src=\\"images\\/techjungle\\/aboutus\\/aboutus.jpg\\" alt=\\"about1\\" class=\\"img-circle\\">\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-title\\">\\r\\n                        <p>Helen Doe<\\/p>\\r\\n                    <\\/div>\\r\\n                    \\r\\n                    <div class=\\"mn-about-desc\\">\\r\\n                        <p>Dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\/p>\\r\\n                    <\\/div>\\r\\n\\r\\n                    <div class=\\"mn-about-social\\">\\r\\n                    \\r\\n                        <ul class=\\"social-media-icons\\">\\r\\n                            <li class=\\"facebook\\">\\r\\n                                <a class=\\"facebook\\" href=\\"#\\"><i class=\\"fa fa-facebook\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"twitter\\">\\r\\n                                <a class=\\"twitter\\" href=\\"#\\"><i class=\\"fa fa-twitter\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                            <li class=\\"google-plus\\">\\r\\n                                <a class=\\"google-plus\\" href=\\"#\\"><i class=\\"fa fa-google-plus\\"><\\/i><\\/a>\\r\\n                            <\\/li>\\r\\n                        <\\/ul>                    \\r\\n                    \\r\\n                    <\\/div>\\r\\n                    \\r\\n                <\\/div>\\r\\n            <\\/div>\\r\\n\\r\\n        <\\/div>\\r\\n   \\r\\n","fulltext":"","state":1,"catid":"2","created":"2014-07-28 13:23:15","created_by":"444","created_by_alias":"","modified":"2014-08-25 16:08:58","modified_by":"445","checked_out":"445","checked_out_time":"2014-08-25 16:08:05","publish_up":"2014-07-28 13:23:15","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":12,"ordering":"4","metakey":"","metadesc":"","access":"1","hits":"70","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(72, 21, 1, '', '2014-08-25 16:10:47', 400, 2818, 'f30b5862f7a327157dcae4077d76c126dea9ca86', '{"id":21,"asset_id":"90","title":"Speed boost and image quality","alias":"speed-boost-and-image-quality","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"10","created":"2014-07-28 13:20:56","created_by":"444","created_by_alias":"","modified":"2014-08-25 16:10:47","modified_by":"445","checked_out":"445","checked_out_time":"2014-08-25 16:10:18","publish_up":"2014-07-28 13:20:56","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/minitek_water.jpg\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/minitek_water.jpg\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":5,"ordering":"1","metakey":"","metadesc":"","access":"1","hits":"17","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"1","language":"*","xreference":""}', 0),
(76, 4, 1, '', '2014-08-25 16:14:17', 400, 2863, '3ed4562ea37f908fa5a8e4ed05df1ecce85e23d2', '{"id":4,"asset_id":"69","title":"A cheap and smart way to communicate in public places","alias":"a-cheap-and-smart-way-to-communicate-in-public-places","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"9","created":"2014-07-28 13:21:47","created_by":"444","created_by_alias":"","modified":"2014-08-25 16:14:17","modified_by":"445","checked_out":"445","checked_out_time":"2014-08-25 16:13:56","publish_up":"2014-07-28 13:21:47","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/minitek_water.jpg\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/minitek_water.jpg\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":4,"ordering":"0","metakey":"","metadesc":"","access":"1","hits":"1","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(77, 3, 1, '', '2014-08-25 16:14:32', 400, 2825, 'f230c7517f1f978c468820bcd79bf3900ab28ab3', '{"id":3,"asset_id":"68","title":"A business tablet to replace books","alias":"a-business-tablet-to-replace-books","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"9","created":"2014-07-28 13:21:34","created_by":"444","created_by_alias":"","modified":"2014-08-25 16:14:32","modified_by":"445","checked_out":"445","checked_out_time":"2014-08-25 16:13:58","publish_up":"2014-07-28 13:21:34","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/minitek_water.jpg\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/minitek_water.jpg\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":5,"ordering":"1","metakey":"","metadesc":"","access":"1","hits":"4","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"0","language":"*","xreference":""}', 0),
(78, 2, 1, '', '2014-08-25 16:14:48', 400, 2806, 'd5e37403604f0f08140bd5f76652c3cd0da58c10', '{"id":2,"asset_id":"67","title":"The best laptop for 2014","alias":"the-best-laptop-for-2014","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"9","created":"2014-07-28 13:21:13","created_by":"444","created_by_alias":"","modified":"2014-08-25 16:14:48","modified_by":"445","checked_out":"445","checked_out_time":"2014-08-25 16:13:59","publish_up":"2014-07-28 13:21:13","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/minitek_water.jpg\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/minitek_water.jpg\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":7,"ordering":"0","metakey":"","metadesc":"","access":"1","hits":"19","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"1","language":"*","xreference":""}', 0),
(79, 1, 1, '', '2014-08-25 16:15:03', 400, 2844, '56d760c11835f3d5a6c4161b0616ca66c50a3283', '{"id":1,"asset_id":"66","title":"A gaming laptop more powerful than desktops","alias":"a-gaming-laptop-more-powerful-than-desktops","introtext":"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent rutrum consequat turpis, quis malesuada urna porta nec. Suspendisse ipsum odio, auctor sit amet lectus sed, pellentesque pulvinar magna. Cras tincidunt arcu lectus, nec iaculis orci hendrerit bibendum. Nullam et dui ut erat aliquet mattis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.<\\/p>\\r\\n","fulltext":"\\r\\n<p>Donec dui risus, auctor ut libero in, vestibulum dignissim lacus. Proin imperdiet nulla sit amet nunc rhoncus euismod. Duis at neque vel ligula adipiscing congue. Nullam lectus ligula, dapibus at risus sed, egestas vehicula neque. Quisque dapibus eros in nunc pharetra dapibus. In mattis odio enim, vel vulputate augue sagittis sit amet. Aenean dictum mi ante, quis tristique dui varius a. Morbi scelerisque sodales nibh. Phasellus convallis sem et purus ornare pellentesque. Donec tempor lacus sed massa tempus auctor. Morbi at eros tempus, mattis ante lacinia, dapibus felis.<\\/p>","state":1,"catid":"9","created":"2014-07-28 13:20:56","created_by":"444","created_by_alias":"","modified":"2014-08-25 16:15:03","modified_by":"445","checked_out":"445","checked_out_time":"2014-08-25 16:14:00","publish_up":"2014-07-28 13:20:56","publish_down":"0000-00-00 00:00:00","images":"{\\"image_intro\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/minitek_water.jpg\\",\\"float_intro\\":\\"\\",\\"image_intro_alt\\":\\"\\",\\"image_intro_caption\\":\\"\\",\\"image_fulltext\\":\\"images\\\\\\/techjungle\\\\\\/articles\\\\\\/minitek_water.jpg\\",\\"float_fulltext\\":\\"\\",\\"image_fulltext_alt\\":\\"\\",\\"image_fulltext_caption\\":\\"\\"}","urls":"{\\"urla\\":false,\\"urlatext\\":\\"\\",\\"targeta\\":\\"\\",\\"urlb\\":false,\\"urlbtext\\":\\"\\",\\"targetb\\":\\"\\",\\"urlc\\":false,\\"urlctext\\":\\"\\",\\"targetc\\":\\"\\"}","attribs":"{\\"show_title\\":\\"\\",\\"link_titles\\":\\"\\",\\"show_tags\\":\\"\\",\\"show_intro\\":\\"\\",\\"info_block_position\\":\\"\\",\\"show_category\\":\\"\\",\\"link_category\\":\\"\\",\\"show_parent_category\\":\\"\\",\\"link_parent_category\\":\\"\\",\\"show_author\\":\\"\\",\\"link_author\\":\\"\\",\\"show_create_date\\":\\"\\",\\"show_modify_date\\":\\"\\",\\"show_publish_date\\":\\"\\",\\"show_item_navigation\\":\\"\\",\\"show_icons\\":\\"\\",\\"show_print_icon\\":\\"\\",\\"show_email_icon\\":\\"\\",\\"show_vote\\":\\"\\",\\"show_hits\\":\\"\\",\\"show_noauth\\":\\"\\",\\"urls_position\\":\\"\\",\\"alternative_readmore\\":\\"\\",\\"article_layout\\":\\"\\",\\"show_publishing_options\\":\\"\\",\\"show_article_options\\":\\"\\",\\"show_urls_images_backend\\":\\"\\",\\"show_urls_images_frontend\\":\\"\\"}","version":6,"ordering":"1","metakey":"","metadesc":"","access":"1","hits":"49","metadata":"{\\"robots\\":\\"\\",\\"author\\":\\"\\",\\"rights\\":\\"\\",\\"xreference\\":\\"\\"}","featured":"1","language":"*","xreference":""}', 0),
(81, 9, 6, '', '2014-09-12 10:45:54', 400, 820, '0070e4